/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ManagerStartupMessage
extends PooledDistributionMessage {
    private int alertLevel;

    public static ManagerStartupMessage create(int alertLevel) {
        return new ManagerStartupMessage(alertLevel);
    }

    public ManagerStartupMessage() {
    }

    private ManagerStartupMessage(int alertLevel) {
        this.alertLevel = alertLevel;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        if (this.alertLevel != Integer.MAX_VALUE) {
            dm.getAlertingService().addAlertListener(this.getSender(), AlertLevel.find(this.alertLevel));
        }
    }

    public int getDSFID() {
        return 2149;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.alertLevel);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.alertLevel = in.readInt();
    }

    @Override
    public String toString() {
        return "ManagerStartupMessage from " + String.valueOf(this.getSender()) + " alertLevel=" + this.alertLevel;
    }
}

