/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.Assert;

public class StoppableCountDownLatch {
    static final String RETRY_TIME_MILLIS_PROPERTY = "gemfire.stoppable-retry-interval";
    static final long RETRY_TIME_MILLIS_DEFAULT = 2000L;
    static final long RETRY_TIME_NANOS = TimeUnit.MILLISECONDS.toNanos(Long.getLong("gemfire.stoppable-retry-interval", 2000L));
    private final CountDownLatch delegate;
    private final CancelCriterion stopper;
    private final long retryIntervalNanos;
    private final NanoTimer nanoTimer;

    public StoppableCountDownLatch(CancelCriterion stopper, int count) {
        this(stopper, count, RETRY_TIME_NANOS, System::nanoTime);
    }

    StoppableCountDownLatch(CancelCriterion stopper, int count, long retryIntervalNanos, NanoTimer nanoTimer) {
        Assert.assertTrue(stopper != null);
        this.delegate = new CountDownLatch(count);
        this.stopper = stopper;
        this.retryIntervalNanos = retryIntervalNanos;
        this.nanoTimer = nanoTimer;
    }

    public void await() throws InterruptedException {
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!this.delegate.await(this.retryIntervalNanos, TimeUnit.NANOSECONDS));
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        long timeoutNanos = unit.toNanos(timeout);
        if (timeoutNanos > this.retryIntervalNanos) {
            return this.awaitWithCheck(timeoutNanos);
        }
        return this.delegate.await(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        if (timeoutNanos > this.retryIntervalNanos) {
            return this.awaitWithCheck(timeoutNanos);
        }
        return this.delegate.await(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void countDown() {
        this.delegate.countDown();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public String toString() {
        return "(Stoppable) " + String.valueOf(this.delegate);
    }

    long retryIntervalNanos() {
        return this.retryIntervalNanos;
    }

    private boolean awaitWithCheck(long timeoutNanos) throws InterruptedException {
        boolean unlatched;
        long startNanos = this.nanoTimer.nanoTime();
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!(unlatched = this.delegate.await(this.retryIntervalNanos, TimeUnit.NANOSECONDS)) && this.nanoTimer.nanoTime() - startNanos < timeoutNanos);
        return unlatched;
    }

    @FunctionalInterface
    static interface NanoTimer {
        public long nanoTime();
    }
}

