/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class LogFileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + String.valueOf(destFile) + "' exists but is a directory");
        }
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                LogFileUtils.copy(input, output);
            }
            finally {
                LogFileUtils.close(output);
            }
        }
        finally {
            LogFileUtils.close(input);
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + String.valueOf(srcFile) + "' to '" + String.valueOf(destFile) + "'");
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static void close(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean renameAggressively(File oldFile, File newFile) {
        boolean renameOK = oldFile.renameTo(newFile.getAbsoluteFile());
        if (!renameOK) {
            try {
                boolean noDelete;
                LogFileUtils.copyFile(oldFile, newFile.getAbsoluteFile());
                long timeStop = System.currentTimeMillis() + 600000L;
                boolean bl = noDelete = !oldFile.delete();
                if (noDelete) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(oldFile, "rws");
                        raf.setLength(0L);
                        raf.close();
                        noDelete = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (noDelete) {
                    LogFileUtils.delete(newFile.getAbsoluteFile());
                    renameOK = false;
                } else {
                    renameOK = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return renameOK;
    }
}

