/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.LogWriter;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.VersionedDataInputStream;

public class MsgDestreamer {
    private Throwable failure;
    private DistributionMessage result;
    private int RPid;
    private final DestreamerThread t;
    private int size;
    final CancelCriterion stopper;
    final KnownVersion version;

    public MsgDestreamer(DMStats stats, CancelCriterion stopper, KnownVersion v) {
        this.stopper = stopper;
        this.t = new DestreamerThread(stats, stopper);
        this.version = v;
        this.init();
    }

    private void init() {
        this.t.start();
    }

    public void close() {
        this.reset();
        this.t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        MsgDestreamer msgDestreamer = this;
        synchronized (msgDestreamer) {
            this.failure = null;
            this.result = null;
        }
        this.size = 0;
        this.t.setName("IDLE p2pDestreamer");
    }

    public void setName(String name) {
        this.t.setName("p2pDestreamer for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDone() throws InterruptedException {
        if (this.t.isClosed() || Thread.interrupted()) {
            throw new InterruptedException();
        }
        MsgDestreamer msgDestreamer = this;
        synchronized (msgDestreamer) {
            while (this.failure == null && this.result == null) {
                if (this.t.isClosed() || Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.wait();
            }
        }
    }

    public void addChunk(ByteBuffer bb, int length) throws IOException {
        if (this.failure == null && length > 0) {
            this.t.addChunk(bb, length);
            this.size += length;
        }
    }

    public int size() {
        return this.size;
    }

    public DistributionMessage getMessage() throws InterruptedException, IOException, ClassNotFoundException {
        this.waitUntilDone();
        if (this.failure != null) {
            if (this.failure instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)this.failure;
            }
            if (this.failure instanceof IOException) {
                throw (IOException)this.failure;
            }
            IOException io = new IOException("failure during message deserialization", this.failure);
            throw io;
        }
        return this.result;
    }

    public int getRPid() {
        return this.RPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFailure(Throwable ex, int RPid) {
        MsgDestreamer msgDestreamer = this;
        synchronized (msgDestreamer) {
            this.failure = ex;
            this.RPid = RPid;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(DistributionMessage msg) {
        MsgDestreamer msgDestreamer = this;
        synchronized (msgDestreamer) {
            this.result = msg;
            this.RPid = 0;
            this.notify();
        }
    }

    private static LogWriter getLogger() {
        LogWriter result = null;
        InternalDistributedSystem ids = InternalDistributedSystem.unsafeGetConnectedInstance();
        if (ids != null) {
            result = ids.getLogWriter();
        }
        return result;
    }

    private class DestreamerThread
    extends Thread {
        private volatile boolean closed = false;
        final DestreamerIS is;
        final DMStats stats;

        public DestreamerThread(DMStats stats, CancelCriterion stopper) {
            this.setDaemon(true);
            super.setName("IDLE p2pDestreamer");
            this.is = new DestreamerIS(this, stopper);
            this.stats = stats;
        }

        public void addChunk(ByteBuffer chunk, int bbLength) throws IOException {
            ByteBuffer bb = chunk.slice();
            bb.limit(bbLength);
            this.is.addChunk(bb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isClosed()) {
                try {
                    ReplyProcessor21.initMessageRPId();
                    KnownVersion v = MsgDestreamer.this.version;
                    DataInputStream dis = v == null ? new DataInputStream(this.is) : new VersionedDataInputStream((InputStream)this.is, v);
                    long startSer = this.stats.startMsgDeserialization();
                    MsgDestreamer.this.setResult((DistributionMessage)InternalDataSerializer.readDSFID(dis));
                    this.stats.endMsgDeserialization(startSer);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    MsgDestreamer.this.setFailure(ex, ReplyProcessor21.getMessageRPId());
                    continue;
                }
                finally {
                    this.is.close();
                    ReplyProcessor21.clearMessageRPId();
                    continue;
                }
                break;
            }
            return;
        }

        public void close() {
            this.closed = true;
            this.interrupt();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    private static class DestreamerIS
    extends InputStream {
        final Object dataMon = new Object();
        final Object doneMon = new Object();
        ByteBuffer data;
        final DestreamerThread owner;
        final CancelCriterion stopper;

        public DestreamerIS(DestreamerThread t, CancelCriterion stopper) {
            this.owner = t;
            this.data = null;
            this.stopper = new Stopper(stopper);
        }

        private boolean isClosed() {
            return this.owner.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer waitForData() throws InterruptedException {
            if (this.isClosed() || Thread.interrupted()) {
                throw new InterruptedException();
            }
            Object object = this.dataMon;
            synchronized (object) {
                ByteBuffer result = this.data;
                while (result == null) {
                    if (this.isClosed() || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.dataMon.wait();
                    if (this.isClosed() || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    result = this.data;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provideData(ByteBuffer bb) {
            Object object = this.dataMon;
            synchronized (object) {
                this.data = bb;
                this.dataMon.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilDone() throws InterruptedException {
            if (this.isClosed() || Thread.interrupted()) {
                throw new InterruptedException();
            }
            Object object = this.doneMon;
            synchronized (object) {
                while (this.data != null) {
                    if (this.isClosed() || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.doneMon.wait();
                    if (!this.isClosed() && !Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalDone() {
            Object object = this.doneMon;
            synchronized (object) {
                this.data = null;
                this.doneMon.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChunk(ByteBuffer bb) throws IOException {
            this.provideData(bb);
            while (true) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.waitUntilDone();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer waitForAvailableData() throws IOException {
            ByteBuffer myData;
            boolean available = false;
            do {
                int remaining;
                if ((myData = this.data) == null) {
                    while (true) {
                        if (this.isClosed()) {
                            throw new IOException("owner closed");
                        }
                        this.stopper.checkCancelInProgress(null);
                        boolean interrupted = Thread.interrupted();
                        try {
                            myData = this.waitForData();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                    if (myData == null) {
                        this.stopper.checkCancelInProgress(null);
                        throw new InternalGemFireError("bug 37230, please report to support");
                    }
                }
                if ((remaining = myData.remaining()) <= 0) {
                    this.signalDone();
                    continue;
                }
                available = true;
            } while (!available);
            return myData;
        }

        @Override
        public void close() {
            this.signalDone();
        }

        @Override
        public int read() throws IOException {
            ByteBuffer bb = this.waitForAvailableData();
            return bb.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = this.waitForAvailableData();
            int remaining = bb.remaining();
            int bytesToRead = len;
            if (remaining < len) {
                bytesToRead = remaining;
            }
            bb.get(b, off, bytesToRead);
            return bytesToRead;
        }

        @Override
        public int available() throws IOException {
            ByteBuffer bb = this.data;
            if (bb == null) {
                return 0;
            }
            return bb.remaining();
        }

        private class Stopper
        extends CancelCriterion {
            private final CancelCriterion stopper;

            Stopper(CancelCriterion stopper) {
                this.stopper = stopper;
            }

            @Override
            public String cancelInProgress() {
                String reason = this.stopper.cancelInProgress();
                if (reason != null) {
                    return reason;
                }
                if (DestreamerIS.this.owner.isClosed()) {
                    return "owner is closed";
                }
                return null;
            }

            @Override
            public RuntimeException generateCancelledException(Throwable e) {
                String reason = this.cancelInProgress();
                if (reason == null) {
                    return null;
                }
                RuntimeException result = this.stopper.generateCancelledException(e);
                if (result != null) {
                    return result;
                }
                return new DistributedSystemDisconnectedException("owner is closed");
            }
        }
    }
}

