/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.geode.internal.ByteBufferWriter;
import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.StoredObject;

public class ByteBufferInputStream
extends InputStream
implements DataInput,
Externalizable {
    private ByteSource buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferInputStream() {
    }

    protected ByteBufferInputStream(ByteBufferInputStream copy) {
        this.buffer = copy.buffer.duplicate();
    }

    public ByteBufferInputStream(StoredObject blob) {
        this.buffer = ByteSourceFactory.create(blob);
    }

    public void setBuffer(ByteSource buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this.buffer = buffer;
    }

    public void setBuffer(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException();
        }
        this.setBuffer(ByteSourceFactory.create(bb));
    }

    @Override
    public int read() {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= Integer.MAX_VALUE) {
            return this.skipBytes((int)n);
        }
        return super.skip(n);
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public boolean readBoolean(int pos) {
        return this.buffer.get(pos) != 0;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    public byte readByte(int pos) {
        return this.buffer.get(pos);
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    public char readChar(int pos) {
        return this.buffer.getChar(pos);
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    public double readDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    public float readFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    @Override
    public void readFully(byte[] b) {
        this.buffer.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.buffer.get(b, off, len);
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    public int readInt(int pos) {
        return this.buffer.getInt(pos);
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    public long readLong(int pos) {
        return this.buffer.getLong(pos);
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    public short readShort(int pos) {
        return this.buffer.getShort(pos);
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.get() & 0xFF;
    }

    public int readUnsignedByte(int pos) {
        return this.buffer.get(pos) & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int readUnsignedShort(int pos) {
        return this.buffer.getShort(pos) & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) {
        int newPosition = this.buffer.position() + n;
        if (newPosition > this.buffer.limit()) {
            newPosition = this.buffer.limit();
            n = newPosition - this.buffer.position();
        }
        this.buffer.position(newPosition);
        return n;
    }

    public int size() {
        return this.buffer.limit();
    }

    public byte get(int idx) {
        return this.buffer.get(idx);
    }

    public short getShort(int idx) {
        return this.buffer.getShort(idx);
    }

    public int getInt(int idx) {
        return this.buffer.getInt(idx);
    }

    public void position(int absPos) {
        this.buffer.position(absPos);
    }

    public void sendTo(DataOutput out) throws IOException {
        this.buffer.position(0);
        this.buffer.sendTo(out);
    }

    public void sendTo(ByteBuffer out) {
        this.buffer.position(0);
        this.buffer.sendTo(out);
    }

    public ByteSource slice(int length) {
        return this.buffer.slice(length);
    }

    public ByteSource slice(int startOffset, int endOffset) {
        return this.buffer.slice(startOffset, endOffset);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            out.writeInt(this.buffer.capacity());
            out.writeInt(this.buffer.limit());
            out.writeInt(this.buffer.position());
            for (int i = 0; i < this.buffer.capacity(); ++i) {
                out.write(this.buffer.get(i));
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasBuffer = in.readBoolean();
        if (hasBuffer) {
            int capacity = in.readInt();
            int limit = in.readInt();
            int position = in.readInt();
            byte[] bytes = new byte[capacity];
            int bytesRead = in.read(bytes);
            if (bytesRead != capacity) {
                throw new IOException("Expected to read " + capacity + " bytes but only read " + bytesRead + " bytes.");
            }
            this.setBuffer(ByteBuffer.wrap(bytes, position, limit - position));
        } else {
            this.buffer = null;
        }
    }

    public ByteSource getBuffer() {
        return this.buffer;
    }

    public static interface ByteSource {
        public int position();

        public int limit();

        public int capacity();

        public int remaining();

        public void position(int var1);

        public void limit(int var1);

        public void get(byte[] var1);

        public void get(byte[] var1, int var2, int var3);

        public byte get();

        public byte get(int var1);

        public short getShort();

        public short getShort(int var1);

        public char getChar();

        public char getChar(int var1);

        public int getInt();

        public int getInt(int var1);

        public long getLong();

        public long getLong(int var1);

        public float getFloat();

        public float getFloat(int var1);

        public double getDouble();

        public double getDouble(int var1);

        public boolean hasArray();

        public byte[] array();

        public int arrayOffset();

        public ByteSource duplicate();

        public ByteSource slice(int var1);

        public ByteSource slice(int var1, int var2);

        public ByteBuffer getBackingByteBuffer();

        public void sendTo(ByteBuffer var1);

        public void sendTo(DataOutput var1) throws IOException;
    }

    public static class ByteSourceFactory {
        public static ByteSource wrap(byte[] bytes) {
            return new ByteBufferByteSource(ByteBuffer.wrap(bytes));
        }

        public static ByteSource create(ByteBuffer bb) {
            return new ByteBufferByteSource(bb);
        }

        public static ByteSource create(StoredObject so) {
            ByteBuffer bb = so.createDirectByteBuffer();
            if (bb != null) {
                return ByteSourceFactory.create(bb);
            }
            return new OffHeapByteSource(so);
        }
    }

    public static class OffHeapByteSource
    implements ByteSource {
        private int position;
        private int limit;
        private final StoredObject chunk;
        private static final boolean unaligned = OffHeapByteSource.determineUnaligned(System.getProperty("os.arch"));

        public OffHeapByteSource(StoredObject so) {
            this.chunk = so;
            this.position = 0;
            this.limit = this.capacity();
        }

        private OffHeapByteSource(OffHeapByteSource other) {
            this.chunk = other.chunk;
            this.position = other.position;
            this.limit = other.limit;
        }

        public int hashCode() {
            int h = 1;
            int p = this.position();
            for (int i = this.limit() - 1; i >= p; --i) {
                h = 31 * h + this.get(i);
            }
            return h;
        }

        public boolean equals(Object ob) {
            if (this == ob) {
                return true;
            }
            if (!(ob instanceof ByteSource)) {
                return false;
            }
            ByteSource that = (ByteSource)ob;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                if (this.get(i) != that.get(j)) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }

        @Override
        public int remaining() {
            return this.limit - this.position;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public int limit() {
            return this.limit;
        }

        @Override
        public void position(int newPosition) {
            if (newPosition > this.limit || newPosition < 0) {
                throw new IllegalArgumentException();
            }
            this.position = newPosition;
        }

        @Override
        public void limit(int newLimit) {
            if (newLimit > this.capacity() || newLimit < 0) {
                throw new IllegalArgumentException();
            }
            this.limit = newLimit;
            if (this.position > this.limit) {
                this.position = this.limit;
            }
        }

        @Override
        public int capacity() {
            return this.chunk.getDataSize();
        }

        private int nextGetIndex() {
            int p;
            if ((p = this.position++) >= this.limit) {
                throw new BufferUnderflowException();
            }
            return p;
        }

        private int nextGetIndex(int nb) {
            int p = this.position;
            if (this.limit - p < nb) {
                throw new BufferUnderflowException();
            }
            this.position += nb;
            return p;
        }

        private void checkIndex(int i) {
            if (i < 0 || i >= this.limit) {
                throw new IndexOutOfBoundsException();
            }
        }

        private void checkIndex(int i, int nb) {
            if (i < 0 || nb > this.limit - i) {
                throw new IndexOutOfBoundsException();
            }
        }

        private static void checkBounds(int off, int len, int size) {
            if ((off | len | off + len | size - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void get(byte[] b) {
            this.basicGet(b, 0, b.length);
        }

        @Override
        public void get(byte[] dst, int offset, int length) {
            OffHeapByteSource.checkBounds(offset, length, dst.length);
            this.basicGet(dst, offset, length);
        }

        private void basicGet(byte[] dst, int offset, int length) {
            if (length > this.remaining()) {
                throw new BufferUnderflowException();
            }
            int p = this.position;
            this.position += length;
            this.chunk.readDataBytes(p, dst, offset, length);
        }

        @Override
        public byte get() {
            return this.chunk.readDataByte(this.nextGetIndex());
        }

        @Override
        public byte get(int pos) {
            this.checkIndex(pos);
            return this.chunk.readDataByte(pos);
        }

        static boolean determineUnaligned(String arch) {
            if (arch == null) {
                return false;
            }
            return arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64") || arch.equals("ppc64") || arch.equals("ppc64le");
        }

        @Override
        public short getShort() {
            return this.basicGetShort(this.nextGetIndex(2));
        }

        @Override
        public short getShort(int pos) {
            this.checkIndex(pos, 2);
            return this.basicGetShort(pos);
        }

        private short basicGetShort(int pos) {
            long addr = this.chunk.getAddressForReadingData(pos, 2);
            if (unaligned) {
                short result = AddressableMemoryManager.readShort(addr);
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    result = Short.reverseBytes(result);
                }
                return result;
            }
            byte ch1 = AddressableMemoryManager.readByte(addr++);
            byte ch2 = AddressableMemoryManager.readByte(addr);
            return (short)((ch1 << 8) + (ch2 << 0));
        }

        @Override
        public char getChar() {
            return this.basicGetChar(this.nextGetIndex(2));
        }

        @Override
        public char getChar(int pos) {
            this.checkIndex(pos, 2);
            return this.basicGetChar(pos);
        }

        private char basicGetChar(int pos) {
            long addr = this.chunk.getAddressForReadingData(pos, 2);
            if (unaligned) {
                char result = AddressableMemoryManager.readChar(addr);
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    result = Character.reverseBytes(result);
                }
                return result;
            }
            byte ch1 = AddressableMemoryManager.readByte(addr++);
            byte ch2 = AddressableMemoryManager.readByte(addr);
            return (char)((ch1 << 8) + (ch2 << 0));
        }

        @Override
        public int getInt() {
            return this.basicGetInt(this.nextGetIndex(4));
        }

        @Override
        public int getInt(int pos) {
            this.checkIndex(pos, 4);
            return this.basicGetInt(pos);
        }

        private int basicGetInt(int pos) {
            long addr = this.chunk.getAddressForReadingData(pos, 4);
            if (unaligned) {
                int result = AddressableMemoryManager.readInt(addr);
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    result = Integer.reverseBytes(result);
                }
                return result;
            }
            byte b0 = AddressableMemoryManager.readByte(addr++);
            byte b1 = AddressableMemoryManager.readByte(addr++);
            byte b2 = AddressableMemoryManager.readByte(addr++);
            byte b3 = AddressableMemoryManager.readByte(addr);
            return (b0 << 24) + ((b1 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 0);
        }

        @Override
        public long getLong() {
            return this.basicGetLong(this.nextGetIndex(8));
        }

        @Override
        public long getLong(int pos) {
            this.checkIndex(pos, 8);
            return this.basicGetLong(pos);
        }

        private long basicGetLong(int pos) {
            long addr = this.chunk.getAddressForReadingData(pos, 8);
            if (unaligned) {
                long result = AddressableMemoryManager.readLong(addr);
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    result = Long.reverseBytes(result);
                }
                return result;
            }
            byte b0 = AddressableMemoryManager.readByte(addr++);
            byte b1 = AddressableMemoryManager.readByte(addr++);
            byte b2 = AddressableMemoryManager.readByte(addr++);
            byte b3 = AddressableMemoryManager.readByte(addr++);
            byte b4 = AddressableMemoryManager.readByte(addr++);
            byte b5 = AddressableMemoryManager.readByte(addr++);
            byte b6 = AddressableMemoryManager.readByte(addr++);
            byte b7 = AddressableMemoryManager.readByte(addr);
            return ((long)b0 << 56) + ((long)(b1 & 0xFF) << 48) + ((long)(b2 & 0xFF) << 40) + ((long)(b3 & 0xFF) << 32) + ((long)(b4 & 0xFF) << 24) + (long)((b5 & 0xFF) << 16) + (long)((b6 & 0xFF) << 8) + (long)((b7 & 0xFF) << 0);
        }

        @Override
        public float getFloat() {
            return this.basicGetFloat(this.nextGetIndex(4));
        }

        @Override
        public float getFloat(int pos) {
            this.checkIndex(pos, 4);
            return this.basicGetFloat(pos);
        }

        private float basicGetFloat(int pos) {
            return Float.intBitsToFloat(this.basicGetInt(pos));
        }

        @Override
        public double getDouble() {
            return this.basicGetDouble(this.nextGetIndex(8));
        }

        @Override
        public double getDouble(int pos) {
            this.checkIndex(pos, 8);
            return this.basicGetDouble(pos);
        }

        private double basicGetDouble(int pos) {
            return Double.longBitsToDouble(this.basicGetLong(pos));
        }

        @Override
        public boolean hasArray() {
            return false;
        }

        @Override
        public byte[] array() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteSource duplicate() {
            return new OffHeapByteSource(this);
        }

        @Override
        public ByteSource slice(int length) {
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            return this.slice(this.position, this.position + length);
        }

        @Override
        public ByteSource slice(int pos, int limit) {
            if (limit > this.capacity() || limit < 0) {
                throw new IllegalArgumentException();
            }
            if (pos > limit || pos < 0) {
                throw new IllegalArgumentException();
            }
            return new OffHeapByteSource(this.chunk.slice(pos, limit));
        }

        @Override
        public void sendTo(ByteBuffer out) {
            for (int len = this.remaining(); len > 0; --len) {
                out.put(this.get());
            }
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            for (int len = this.remaining(); len > 0; --len) {
                out.writeByte(this.get());
            }
        }

        @Override
        public ByteBuffer getBackingByteBuffer() {
            return null;
        }
    }

    public static class ByteBufferByteSource
    implements ByteSource {
        private final ByteBuffer bb;

        public ByteBufferByteSource(ByteBuffer bb) {
            this.bb = bb;
        }

        public int hashCode() {
            int h = 1;
            int p = this.position();
            for (int i = this.limit() - 1; i >= p; --i) {
                h = 31 * h + this.get(i);
            }
            return h;
        }

        public boolean equals(Object ob) {
            if (this == ob) {
                return true;
            }
            if (!(ob instanceof ByteSource)) {
                return false;
            }
            ByteSource that = (ByteSource)ob;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                if (this.get(i) != that.get(j)) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }

        @Override
        public ByteSource duplicate() {
            return ByteSourceFactory.create(this.bb.duplicate());
        }

        @Override
        public byte get() {
            return this.bb.get();
        }

        @Override
        public void get(byte[] b, int off, int len) {
            this.bb.get(b, off, len);
        }

        @Override
        public int remaining() {
            return this.bb.remaining();
        }

        @Override
        public int position() {
            return this.bb.position();
        }

        @Override
        public byte get(int pos) {
            return this.bb.get(pos);
        }

        @Override
        public char getChar() {
            return this.bb.getChar();
        }

        @Override
        public char getChar(int pos) {
            return this.bb.getChar(pos);
        }

        @Override
        public double getDouble() {
            return this.bb.getDouble();
        }

        @Override
        public double getDouble(int pos) {
            return this.bb.getDouble(pos);
        }

        @Override
        public float getFloat() {
            return this.bb.getFloat();
        }

        @Override
        public float getFloat(int pos) {
            return this.bb.getFloat(pos);
        }

        @Override
        public void get(byte[] b) {
            this.bb.get(b);
        }

        @Override
        public int getInt() {
            return this.bb.getInt();
        }

        @Override
        public int getInt(int pos) {
            return this.bb.getInt(pos);
        }

        @Override
        public long getLong() {
            return this.bb.getLong();
        }

        @Override
        public long getLong(int pos) {
            return this.bb.getLong(pos);
        }

        @Override
        public short getShort() {
            return this.bb.getShort();
        }

        @Override
        public short getShort(int pos) {
            return this.bb.getShort(pos);
        }

        @Override
        public int limit() {
            return this.bb.limit();
        }

        @Override
        public void position(int newPosition) {
            this.bb.position(newPosition);
        }

        @Override
        public boolean hasArray() {
            return this.bb.hasArray();
        }

        @Override
        public byte[] array() {
            return this.bb.array();
        }

        @Override
        public int arrayOffset() {
            return this.bb.arrayOffset();
        }

        @Override
        public void limit(int endOffset) {
            this.bb.limit(endOffset);
        }

        @Override
        public ByteSource slice(int length) {
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            ByteBuffer dup = this.bb.duplicate();
            dup.limit(dup.position() + length);
            return ByteSourceFactory.create(dup.slice());
        }

        @Override
        public ByteSource slice(int pos, int limit) {
            ByteBuffer dup = this.bb.duplicate();
            dup.limit(limit);
            dup.position(pos);
            return ByteSourceFactory.create(dup.slice());
        }

        @Override
        public int capacity() {
            return this.bb.capacity();
        }

        @Override
        public void sendTo(ByteBuffer out) {
            out.put(this.bb);
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            int len = this.remaining();
            if (len == 0) {
                return;
            }
            if (out instanceof ByteBufferWriter) {
                ((ByteBufferWriter)((Object)out)).write(this.bb);
                return;
            }
            if (this.bb.hasArray()) {
                byte[] bytes = this.bb.array();
                int offset = this.bb.arrayOffset() + this.bb.position();
                out.write(bytes, offset, len);
                this.bb.position(this.bb.limit());
            } else {
                while (len > 0) {
                    out.writeByte(this.get());
                    --len;
                }
            }
        }

        @Override
        public ByteBuffer getBackingByteBuffer() {
            return this.bb;
        }
    }
}

