/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.nio.file.Path;
import org.apache.geode.internal.process.ProcessUtils;

public enum ProcessType {
    LOCATOR("LOCATOR", "vf.gf.locator"),
    SERVER("SERVER", "vf.gf.server");

    public static final String PROPERTY_TEST_PREFIX = "gemfire.test.ProcessType.TEST_PREFIX";
    private static final String SUFFIX_PID = "pid";
    private static final String SUFFIX_STOP_REQUEST = "stop.cmd";
    private static final String SUFFIX_STATUS_REQUEST = "status.cmd";
    private static final String SUFFIX_STATUS = "status";
    private final String name;
    private final String fileName;

    private ProcessType(String name, String fileName) {
        this.name = name;
        this.fileName = fileName;
    }

    public String getPidFileName() {
        return System.getProperty(PROPERTY_TEST_PREFIX, "") + this.fileName + ".pid";
    }

    public String getStopRequestFileName() {
        return System.getProperty(PROPERTY_TEST_PREFIX, "") + this.fileName + ".stop.cmd";
    }

    public String getStatusRequestFileName() {
        return System.getProperty(PROPERTY_TEST_PREFIX, "") + this.fileName + ".status.cmd";
    }

    public String getStatusFileName() {
        return System.getProperty(PROPERTY_TEST_PREFIX, "") + this.fileName + ".status";
    }

    public int readPid(Path workingDir) {
        return ProcessUtils.readPid(workingDir.resolve(this.getPidFileName()));
    }

    public String toString() {
        return this.name;
    }
}

