/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.security.KeyStore;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.net.SSLUtil;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.net.SSLParameterExtension;
import org.apache.geode.net.internal.SSLParameterExtensionContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class SSLConfig {
    private final boolean endpointIdentification;
    private final boolean useDefaultSSLContext;
    private final boolean enabled;
    private final String protocols;
    private final String serverProtocols;
    private final String clientProtocols;
    private final String ciphers;
    private final boolean requireAuth;
    private final String keystore;
    private final String keystoreType;
    private final String keystorePassword;
    private final String truststore;
    private final String truststorePassword;
    private final String truststoreType;
    private final String alias;
    @Immutable
    private final SecurableCommunicationChannel securableCommunicationChannel;
    @Immutable
    private final Properties properties;
    @Immutable
    private final SSLParameterExtension sslParameterExtension;

    private SSLConfig(boolean endpointIdentification, boolean useDefaultSSLContext, boolean enabled, @NotNull String protocols, @Nullable String clientProtocols, @Nullable String serverProtocols, String ciphers, boolean requireAuth, String keystore, String keystoreType, String keystorePassword, String truststore, String truststorePassword, String truststoreType, String alias, SecurableCommunicationChannel securableCommunicationChannel, Properties properties, SSLParameterExtension sslParameterExtension) {
        this.endpointIdentification = endpointIdentification;
        this.useDefaultSSLContext = useDefaultSSLContext;
        this.enabled = enabled;
        this.protocols = protocols;
        this.clientProtocols = StringUtils.isEmpty((CharSequence)clientProtocols) ? protocols : clientProtocols;
        this.serverProtocols = StringUtils.isEmpty((CharSequence)serverProtocols) ? protocols : serverProtocols;
        this.ciphers = ciphers;
        this.requireAuth = requireAuth;
        this.keystore = keystore;
        this.keystoreType = keystoreType;
        this.keystorePassword = keystorePassword;
        this.truststore = truststore;
        this.truststorePassword = truststorePassword;
        this.truststoreType = truststoreType;
        this.alias = alias;
        this.securableCommunicationChannel = securableCommunicationChannel;
        this.properties = properties;
        this.sslParameterExtension = sslParameterExtension;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean doEndpointIdentification() {
        return this.endpointIdentification;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean useDefaultSSLContext() {
        return this.useDefaultSSLContext;
    }

    public String getClientProtocols() {
        return this.clientProtocols;
    }

    @NotNull
    public String[] getClientProtocolsAsStringArray() {
        return SSLUtil.split(this.clientProtocols);
    }

    public String getServerProtocols() {
        return this.serverProtocols;
    }

    @NotNull
    public String[] getServerProtocolsAsStringArray() {
        return SSLUtil.split(this.serverProtocols);
    }

    public String getCiphers() {
        return this.ciphers;
    }

    @NotNull
    public String[] getCiphersAsStringArray() {
        return SSLUtil.split(this.ciphers);
    }

    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SecurableCommunicationChannel getSecuredCommunicationChannel() {
        return this.securableCommunicationChannel;
    }

    public SSLParameterExtension getSSLParameterExtension() {
        return this.sslParameterExtension;
    }

    public boolean isAnyCiphers() {
        return SSLConfig.isAnyCiphers(this.ciphers);
    }

    public static boolean isAnyCiphers(String ciphers) {
        return StringUtils.isBlank((CharSequence)ciphers) || "any".equalsIgnoreCase(ciphers);
    }

    public static boolean isAnyCiphers(String ... ciphers) {
        return ArrayUtils.isEmpty((Object[])ciphers) || "any".equalsIgnoreCase(ciphers[0]);
    }

    public static boolean isAnyProtocols(String protocols) {
        return StringUtils.isBlank((CharSequence)protocols) || "any".equalsIgnoreCase(protocols);
    }

    public static boolean isAnyProtocols(String ... protocols) {
        return ArrayUtils.isEmpty((Object[])protocols) || "any".equalsIgnoreCase(protocols[0]);
    }

    public String toString() {
        return "SSLConfig{enabled=" + this.enabled + ", protocols='" + this.protocols + "', clientProtocols='" + this.clientProtocols + "', serverProtocols='" + this.serverProtocols + "', ciphers='" + this.ciphers + "', requireAuth=" + this.requireAuth + ", keystore='" + this.keystore + "', keystoreType='" + this.keystoreType + "', keystorePassword='" + this.keystorePassword + "', truststore='" + this.truststore + "', truststorePassword='" + this.truststorePassword + "', truststoreType='" + this.truststoreType + "', alias='" + this.alias + "', securableCommunicationChannel=" + String.valueOf((Object)this.securableCommunicationChannel) + ", properties=" + String.valueOf(this.properties) + "', sslParameterExtension=" + String.valueOf(this.sslParameterExtension) + "}";
    }

    public void toDSProperties(Properties props) {
        props.setProperty("cluster-ssl-enabled", String.valueOf(this.enabled));
        if (this.enabled) {
            props.setProperty("cluster-ssl-protocols", this.protocols);
            props.setProperty("cluster-ssl-ciphers", this.ciphers);
            props.setProperty("cluster-ssl-require-authentication", String.valueOf(this.requireAuth));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean endpointIdentification;
        private boolean useDefaultSSLContext = false;
        private boolean enabled = false;
        private String protocols = "any";
        private String clientProtocols = "";
        private String serverProtocols = "";
        private String ciphers = "any";
        private boolean requireAuth = true;
        private String keystore = "";
        private String keystoreType = KeyStore.getDefaultType();
        private String keystorePassword = "";
        private String truststore = "";
        private String truststorePassword = "";
        private String truststoreType = KeyStore.getDefaultType();
        private String alias = null;
        private SecurableCommunicationChannel securableCommunicationChannel = null;
        private Properties properties = new Properties();
        private SSLParameterExtension sslParameterExtension = null;

        public SSLConfig build() {
            return new SSLConfig(this.endpointIdentification, this.useDefaultSSLContext, this.enabled, this.protocols, this.clientProtocols, this.serverProtocols, this.ciphers, this.requireAuth, this.keystore, this.keystoreType, this.keystorePassword, this.truststore, this.truststorePassword, this.truststoreType, this.alias, this.securableCommunicationChannel, this.properties, this.sslParameterExtension);
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setEndpointIdentificationEnabled(boolean endpointIdentification) {
            this.endpointIdentification = endpointIdentification;
            return this;
        }

        public Builder setKeystore(String keystore) {
            this.keystore = keystore;
            return this;
        }

        public Builder setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder setTruststore(String truststore) {
            this.truststore = truststore;
            return this;
        }

        public Builder setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setUseDefaultSSLContext(boolean useDefaultSSLContext) {
            this.useDefaultSSLContext = useDefaultSSLContext;
            return this;
        }

        public Builder setProtocols(String protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder setClientProtocols(String clientProtocols) {
            this.clientProtocols = clientProtocols;
            return this;
        }

        public Builder setServerProtocols(String serverProtocols) {
            this.serverProtocols = serverProtocols;
            return this;
        }

        public Builder setCiphers(String ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Builder setRequireAuth(boolean requireAuth) {
            this.requireAuth = requireAuth;
            return this;
        }

        public Builder setTruststoreType(String truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder setProperties(Properties newProps) {
            this.properties = new Properties();
            for (Object o : newProps.keySet()) {
                String key = (String)o;
                this.properties.setProperty(key, newProps.getProperty(key));
            }
            return this;
        }

        public Builder setSecurableCommunicationChannel(SecurableCommunicationChannel securableCommunicationChannel) {
            this.securableCommunicationChannel = securableCommunicationChannel;
            return this;
        }

        public Builder setSSLParameterExtension(String sslParameterExtensionConfig) {
            if (StringUtils.isBlank((CharSequence)sslParameterExtensionConfig)) {
                this.sslParameterExtension = null;
                return this;
            }
            InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
            if (ids == null) {
                this.sslParameterExtension = null;
                return this;
            }
            SSLParameterExtension sslParameterExtension = CallbackInstantiator.getObjectOfTypeFromClassName(sslParameterExtensionConfig, SSLParameterExtension.class);
            sslParameterExtension.init(new SSLParameterExtensionContextImpl(ids.getConfig().getDistributedSystemId()));
            this.sslParameterExtension = sslParameterExtension;
            return this;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public String getKeystoreType() {
            return this.keystoreType;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public String getTruststore() {
            return this.truststore;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public String getTruststoreType() {
            return this.truststoreType;
        }
    }
}

