/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring.executor;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecutor {
    private static final int THREAD_DUMP_DEPTH = 40;
    private static final Logger logger = LogService.getLogger();
    public static final String LOCK_OWNER_THREAD_STACK = "Lock owner thread stack";
    private final long threadID;
    private final String groupName;
    private short numIterationsStuck;
    private volatile long startTime;
    @Immutable
    private static final String INDENT = "  ";
    @Immutable
    private static final String lineSeparator = System.lineSeparator();

    public AbstractExecutor(String groupName) {
        this(groupName, Thread.currentThread().getId());
    }

    protected AbstractExecutor(String groupName, long threadID) {
        this.groupName = groupName;
        this.startTime = 0L;
        this.numIterationsStuck = 0;
        this.threadID = threadID;
    }

    public void handleExpiry(long stuckTime, Map<Long, ThreadInfo> threadInfoMap) {
        this.incNumIterationsStuck();
        logger.warn(this.createThreadReport(stuckTime, threadInfoMap));
    }

    String createThreadReport(long stuckTime, Map<Long, ThreadInfo> threadInfoMap) {
        ThreadInfo lockOwnerThread;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz");
        ThreadInfo thread = threadInfoMap.get(this.threadID);
        boolean logThreadDetails = thread != null;
        StringBuilder stringBuilder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        stringBuilder.append("Thread <").append(this.threadID).append("> (0x").append(Long.toHexString(this.threadID)).append(") that was executed at <").append(dateFormat.format(this.getStartTime())).append("> has been stuck for <").append((float)stuckTime / 1000.0f).append(" seconds> and number of thread monitor iteration <").append(this.numIterationsStuck).append("> ").append(lineSeparator);
        if (logThreadDetails) {
            stringBuilder.append("Thread Name <").append(thread.getThreadName()).append(">").append(" state <").append((Object)thread.getThreadState()).append(">").append(lineSeparator);
            if (thread.getLockName() != null) {
                stringBuilder.append("Waiting on <").append(thread.getLockName()).append(">").append(lineSeparator);
            }
            if (thread.getLockOwnerName() != null) {
                stringBuilder.append("Owned By <").append(thread.getLockOwnerName()).append("> with ID <").append(thread.getLockOwnerId()).append(">").append(lineSeparator);
            }
        }
        stringBuilder.append("Executor Group <").append(this.groupName).append(">").append(lineSeparator).append("Monitored metric <ResourceManagerStats.numThreadsStuck>").append(lineSeparator);
        if (logThreadDetails) {
            this.writeThreadStack(thread, "Thread stack", stringBuilder);
        }
        if (logThreadDetails && thread.getLockOwnerName() != null && (lockOwnerThread = threadInfoMap.get(thread.getLockOwnerId())) != null) {
            this.writeThreadStack(lockOwnerThread, LOCK_OWNER_THREAD_STACK, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void writeThreadStack(ThreadInfo thread, String header, StringBuilder strb) {
        strb.append(header).append(" for \"").append(thread.getThreadName()).append("\" (0x").append(Long.toHexString(thread.getThreadId())).append("):").append(lineSeparator);
        strb.append("java.lang.ThreadState: ").append((Object)thread.getThreadState());
        if (thread.isSuspended()) {
            strb.append(" (suspended)");
        }
        if (thread.isInNative()) {
            strb.append(" (in native)");
        }
        strb.append(lineSeparator);
        MonitorInfo[] lockedMonitors = thread.getLockedMonitors();
        for (int i = 0; i < Integer.min(thread.getStackTrace().length, 40); ++i) {
            String row = thread.getStackTrace()[i].toString();
            strb.append(INDENT).append("at ").append(row).append(lineSeparator);
            this.appendLockedMonitor(strb, i, lockedMonitors);
        }
        strb.append("Locked ownable synchronizers:").append(lineSeparator);
        LockInfo[] lockedSynchronizers = thread.getLockedSynchronizers();
        if (lockedSynchronizers.length == 0) {
            strb.append(INDENT).append("- None").append(lineSeparator);
        } else {
            for (LockInfo lockInfo : lockedSynchronizers) {
                strb.append(INDENT).append("- ").append(lockInfo).append(lineSeparator);
            }
        }
    }

    private void appendLockedMonitor(StringBuilder strb, int stackDepth, MonitorInfo[] lockedMonitors) {
        for (MonitorInfo monitorInfo : lockedMonitors) {
            if (stackDepth != monitorInfo.getLockedStackDepth()) continue;
            strb.append(INDENT).append("  - locked " + String.valueOf(monitorInfo)).append(lineSeparator);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long newTime) {
        this.startTime = newTime;
    }

    public short getNumIterationsStuck() {
        return this.numIterationsStuck;
    }

    public void incNumIterationsStuck() {
        this.numIterationsStuck = (short)(this.numIterationsStuck + 1);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public void suspendMonitoring() {
    }

    public void resumeMonitoring() {
    }

    public boolean isMonitoringSuspended() {
        return false;
    }
}

