/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.logging.LogFileParser;

public class MergeLogFiles {
    @Immutable
    private static final PrintStream out = System.out;
    @Immutable
    private static final PrintStream err = System.err;

    public static boolean mergeLogFiles(Map<String, InputStream> logFiles, PrintWriter mergedFile) {
        HashMap<String, DisplayNameAndFileStream> newMap = new HashMap<String, DisplayNameAndFileStream>();
        for (Map.Entry<String, InputStream> entry : logFiles.entrySet()) {
            newMap.put(entry.getKey(), new DisplayNameAndFileStream(entry.getKey(), entry.getValue()));
        }
        return MergeLogFiles.mergeLogFiles(newMap, mergedFile, false, false, false, new LinkedList<String>());
    }

    public static boolean mergeLogFiles(Map<String, DisplayNameAndFileStream> logFiles, PrintWriter mergedFile, boolean tabOut, boolean suppressBlanks, boolean multithreaded, List<String> patterns) {
        return Sorter.mergeLogFiles(logFiles, mergedFile, tabOut, suppressBlanks, multithreaded, patterns);
    }

    private static void usage(String s) {
        err.println(System.lineSeparator() + "** " + s + System.lineSeparator());
        err.println("Usage: java MergeLogFiles [(directory | logFile)]+");
        err.println("-dirCount n      Number of parent dirs to print");
        err.println("-mergeFile file  File in which to put merged logs");
        err.println("-pids            Search for PIDs in file names and use them to identify files");
        err.println("-align           Align non-timestamped lines with others");
        err.println("-noblanks        Suppress output of blank lines");
        err.println("-threaded        Use multithreading to take advantage of multiple CPUs");
        err.println();
        err.println("Merges multiple GemFire log files and sorts them by timestamp.");
        err.println("The merged log file is written to System.out (or a file).");
        err.println();
        err.println("If a directory is specified, all .log files in that directory are merged.");
        err.println();
        ExitCode.FATAL.doSystemExit();
    }

    static List<File> getLogFiles(String dirName) {
        ArrayList<File> result = new ArrayList<File>();
        File dir = new File(dirName);
        File[] names = dir.listFiles();
        if (names != null) {
            for (File name : names) {
                String path = name.getAbsolutePath();
                if (!path.endsWith(".log") && !path.endsWith(".log.gz")) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static void main(String ... args) throws IOException {
        PrintStream ps;
        File mergeFile = null;
        ArrayList<File> files = new ArrayList<File>();
        int dirCount = 0;
        boolean findPIDs = false;
        boolean tabOut = false;
        boolean suppressBlanks = false;
        boolean multithreaded = false;
        LinkedList<String> patterns = new LinkedList<String>();
        block22: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-align": {
                    tabOut = true;
                    continue block22;
                }
                case "-noblanks": {
                    suppressBlanks = true;
                    continue block22;
                }
                case "-pids": {
                    findPIDs = true;
                    continue block22;
                }
                case "-threaded": {
                    multithreaded = true;
                    continue block22;
                }
                case "-regex": {
                    if (i + 1 >= args.length) {
                        MergeLogFiles.usage("missing pattern for -regex option");
                    }
                    patterns.add(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "-dirCount": {
                    if (++i >= args.length) {
                        MergeLogFiles.usage("Missing number of parent directories");
                    }
                    try {
                        dirCount = Integer.parseInt(args[i]);
                    }
                    catch (NumberFormatException ex) {
                        MergeLogFiles.usage(String.format("Not a number: %s", args[i]));
                    }
                    continue block22;
                }
                case "-mergeFile": {
                    if (++i >= args.length) {
                        MergeLogFiles.usage("Missing merge file name");
                    }
                    mergeFile = new File(args[i]);
                    continue block22;
                }
                default: {
                    File file = new File(args[i]);
                    if (!file.exists()) {
                        MergeLogFiles.usage(String.format("File %s does not exist", file));
                    }
                    files.add(file.getAbsoluteFile());
                }
            }
        }
        if (files.isEmpty()) {
            MergeLogFiles.usage("Missing filename");
        }
        ArrayList<File> expandedFiles = new ArrayList<File>();
        for (File file : files) {
            String path = file.getAbsolutePath();
            if (!file.exists()) {
                MergeLogFiles.usage(String.format("File %s does not exist", path));
            }
            if (file.isFile()) {
                expandedFiles.add(file);
                continue;
            }
            if (file.isDirectory()) {
                List<File> moreFiles = MergeLogFiles.getLogFiles(path);
                expandedFiles.addAll(moreFiles);
                continue;
            }
            MergeLogFiles.usage(String.format("File '%s' is neither a file nor a directory.", path));
        }
        Collections.sort(expandedFiles);
        files = expandedFiles;
        if (mergeFile != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(mergeFile);
            try {
                ps = new PrintStream(fileOutputStream, true);
            }
            catch (Exception ex) {
                fileOutputStream.close();
                throw ex;
            }
        } else {
            ps = out;
        }
        PrintWriter mergedFile = new PrintWriter(ps, true);
        ps.println("Merged files (count = " + expandedFiles.size() + ") input list:");
        for (File expandedFile : expandedFiles) {
            ps.println("  " + String.valueOf(expandedFile));
        }
        ps.println();
        List<String> nickNames = null;
        if (findPIDs) {
            nickNames = MergeLogFiles.findPIDs(files, mergedFile);
        }
        Map<String, DisplayNameAndFileStream> logFiles = MergeLogFiles.getStringDisplayNameAndFileStreamMap(files, dirCount, findPIDs, nickNames);
        MergeLogFiles.mergeLogFiles(logFiles, mergedFile, tabOut, suppressBlanks, multithreaded, patterns);
        ExitCode.NORMAL.doSystemExit();
    }

    static Map<String, DisplayNameAndFileStream> getStringDisplayNameAndFileStreamMap(List<File> files, int dirCount, boolean findPIDs, List nickNames) throws IOException {
        HashMap<String, DisplayNameAndFileStream> logFiles = new HashMap<String, DisplayNameAndFileStream>();
        for (int i = 0; i < files.size(); ++i) {
            Object logFileName;
            File file = files.get(i);
            if (findPIDs && nickNames.get(i) != null) {
                logFileName = file.getCanonicalPath().toLowerCase().endsWith("gz") ? String.valueOf(nickNames.get(i)) + ".gz" : (String)nickNames.get(i);
            } else {
                StringBuilder sb = new StringBuilder();
                File parent = file.getParentFile();
                for (int j = 0; j < dirCount && parent != null; ++j) {
                    String parentName = parent.getName() + "/";
                    if (parentName.equals("./")) {
                        parent = null;
                        continue;
                    }
                    sb.insert(0, parentName);
                    parent = parent.getParentFile();
                }
                sb.append(file.getName());
                logFileName = sb.toString();
            }
            logFiles.put(file.getPath(), new DisplayNameAndFileStream((String)logFileName, new FileInputStream(file)));
        }
        return logFiles;
    }

    private static List<String> findPIDs(Collection<File> files, PrintWriter output) {
        int[] pidTable = new int[files.size()];
        int[] pidTableCounter = new int[pidTable.length];
        ArrayList<String> nickNames = new ArrayList<String>();
        char fileSeparatorChar = File.separatorChar;
        block2: for (File file : files) {
            String slashdotslash;
            String name = file.getPath();
            int startIdx = name.lastIndexOf(slashdotslash = fileSeparatorChar + "." + fileSeparatorChar);
            if (startIdx > 0) {
                name = name.substring(startIdx + slashdotslash.length());
            }
            if ((startIdx = name.lastIndexOf(fileSeparatorChar)) > 0) {
                char c;
                if ('0' > (c = name.charAt(--startIdx)) || c > '9') {
                    startIdx = 0;
                } else {
                    int testIdx;
                    for (testIdx = startIdx - 1; testIdx > 0 && '0' <= name.charAt(testIdx) && name.charAt(testIdx) <= '9'; --testIdx) {
                    }
                    if (testIdx < 1 || name.charAt(testIdx) == '-') {
                        startIdx = 0;
                    }
                }
            }
            if (startIdx <= 0) {
                startIdx = name.length() - 1;
                if (startIdx > 6 && name.charAt(startIdx) == 'z' && name.charAt(startIdx - 1) == 'g' && name.charAt(startIdx - 2) == '.' && name.charAt(startIdx - 3) == 'g' && name.charAt(startIdx - 4) == 'o' && name.charAt(startIdx - 5) == 'l' && name.charAt(startIdx - 6) == '.') {
                    startIdx -= 7;
                } else if (startIdx > 3 && name.charAt(startIdx) == 'g' && name.charAt(startIdx - 1) == 'o' && name.charAt(startIdx - 2) == 'l' && name.charAt(startIdx - 3) == '.') {
                    startIdx -= 4;
                }
            }
            for (int i = startIdx; i >= 0; --i) {
                char c = name.charAt(i);
                if ('0' <= c && c <= '9') continue;
                if (i < name.length() - 1) {
                    String PID = name.substring(i + 1, startIdx + 1);
                    try {
                        int iPID = Integer.parseInt(PID);
                        if (iPID > 0) {
                            int p;
                            for (p = 0; p < pidTable.length; ++p) {
                                if (pidTable[p] == 0) {
                                    pidTable[p] = iPID;
                                    pidTableCounter[p] = 1;
                                    break;
                                }
                                if (pidTable[p] != iPID) continue;
                                int n = p;
                                pidTableCounter[n] = pidTableCounter[n] + 1;
                                break;
                            }
                            Assert.assertTrue(p < pidTableCounter.length);
                            nickNames.add(iPID + "-" + pidTableCounter[p]);
                            output.println("nickname " + iPID + "-" + pidTableCounter[p] + ": " + name);
                            continue block2;
                        }
                        nickNames.add(null);
                    }
                    catch (NumberFormatException nfe) {
                        nickNames.add(null);
                    }
                    continue block2;
                }
                nickNames.add(null);
                continue block2;
            }
        }
        return nickNames;
    }

    static class DisplayNameAndFileStream {
        private final String displayName;
        private final InputStream inputStream;

        public String getDisplayName() {
            return this.displayName;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        DisplayNameAndFileStream(String displayName, InputStream inputStream) {
            this.displayName = displayName;
            this.inputStream = inputStream;
        }
    }

    static class Sorter {
        Sorter() {
        }

        public static boolean mergeLogFiles(Map<String, DisplayNameAndFileStream> logFiles, PrintWriter mergedFile, boolean tabOut, boolean suppressBlanks, boolean multithreaded, Iterable<String> patterns) {
            Iterator<Reader> sortedIt;
            LinkedList<Pattern> compiledPatterns = new LinkedList<Pattern>();
            for (String pattern : patterns) {
                compiledPatterns.add(Pattern.compile(pattern, 2));
            }
            ReaderGroup group = new ReaderGroup("Reader threads");
            ArrayList<Reader> readers = new ArrayList<Reader>(logFiles.size());
            for (DisplayNameAndFileStream nameAndFileStream : logFiles.values()) {
                if (multithreaded) {
                    readers.add(new ThreadedReader(nameAndFileStream.getInputStream(), nameAndFileStream.getDisplayName(), group, tabOut, suppressBlanks, compiledPatterns));
                    continue;
                }
                readers.add(new NonThreadedReader(nameAndFileStream.getInputStream(), nameAndFileStream.getDisplayName(), group, tabOut, suppressBlanks, compiledPatterns));
            }
            Reader lastOldest = null;
            Set<Reader> sorted = Sorter.sortReaders(readers);
            while (!readers.isEmpty() && (sortedIt = sorted.iterator()).hasNext()) {
                LogFileParser.LogEntry entry;
                Reader oldest = sortedIt.next();
                sortedIt.remove();
                String nextReaderTimestamp = null;
                if (sortedIt.hasNext()) {
                    Reader nextInLine = sortedIt.next();
                    nextReaderTimestamp = nextInLine.peek().getTimestamp();
                }
                if (oldest != lastOldest) {
                    mergedFile.println();
                    lastOldest = oldest;
                }
                do {
                    entry = oldest.peek();
                    String timestamp = entry.getTimestamp();
                    if (nextReaderTimestamp != null && nextReaderTimestamp.compareTo(timestamp) < 0) {
                        sorted.add(oldest);
                        entry = null;
                        break;
                    }
                    entry = oldest.poll();
                    entry.writeTo(mergedFile);
                } while (!entry.isLast());
                if (entry == null || !entry.isLast()) continue;
                readers.remove(oldest);
            }
            return group.exceptionOccurred();
        }

        private static Set<Reader> sortReaders(Iterable<Reader> readers) {
            TreeSet<Reader> sorted = new TreeSet<Reader>(new ReaderComparator());
            int uniqueId = 1;
            for (Reader reader : readers) {
                if (reader == null) continue;
                reader.setUniqueId(uniqueId++);
                sorted.add(reader);
            }
            return sorted;
        }
    }

    protected static class ReaderComparator
    implements Comparator<Reader>,
    Serializable {
        protected ReaderComparator() {
        }

        @Override
        public int compare(Reader reader1, Reader reader2) {
            String timestamp2;
            int id1 = reader1.getUniqueId();
            int id2 = reader2.getUniqueId();
            LogFileParser.LogEntry entry1 = reader1.peek();
            LogFileParser.LogEntry entry2 = reader2.peek();
            if (entry1 == null) {
                if (entry2 == null) {
                    return Integer.compare(id1, id2);
                }
                return -1;
            }
            if (entry2 == null) {
                return 1;
            }
            String timestamp1 = entry1.getTimestamp();
            int compare = timestamp1.compareTo(timestamp2 = entry2.getTimestamp());
            if (compare == 0) {
                if (id1 < id2) {
                    return -1;
                }
                return 1;
            }
            return compare;
        }
    }

    static class ReaderGroup
    extends ThreadGroup {
        private boolean exceptionOccurred = false;

        ReaderGroup(String groupName) {
            super(groupName);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((Error)e);
            }
            this.exceptionOccurred = true;
            System.err.println(String.format("Exception in %s", t));
            e.printStackTrace(System.err);
        }

        public boolean exceptionOccurred() {
            return this.exceptionOccurred;
        }
    }

    static class ThreadedReader
    extends Thread
    implements Reader {
        private static final int QUEUE_CAPACITY = 1000;
        private BufferedReader logFile;
        private final String logFileName;
        private final BlockingQueue<LogFileParser.LogEntry> queue;
        private final boolean suppressBlanks;
        private final boolean tabOut;
        private final List<Pattern> patterns;
        private int uniqueId;

        public ThreadedReader(InputStream logFile, String logFileName, ThreadGroup group, boolean tabOut, boolean suppressBlanks, List<Pattern> patterns) {
            super(group, "Log File Reader");
            if (logFileName.endsWith(".gz")) {
                try {
                    this.logFile = new BufferedReader(new InputStreamReader(new GZIPInputStream(logFile)));
                }
                catch (IOException e) {
                    System.err.println(logFileName + " does not appear to be in gzip format");
                    this.logFile = new BufferedReader(new InputStreamReader(logFile));
                }
            } else {
                this.logFile = new BufferedReader(new InputStreamReader(logFile));
            }
            this.logFileName = logFileName;
            this.queue = new LinkedBlockingQueue<LogFileParser.LogEntry>(1000);
            this.suppressBlanks = suppressBlanks;
            this.tabOut = tabOut;
            this.patterns = patterns;
            this.start();
        }

        @Override
        public String getFileName() {
            return this.logFileName;
        }

        @Override
        public void setUniqueId(int id) {
            this.uniqueId = id;
        }

        @Override
        public int getUniqueId() {
            return this.uniqueId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFileParser parser = new LogFileParser(this.logFileName, this.logFile, this.tabOut, this.suppressBlanks);
            try {
                LogFileParser.LogEntry entry;
                do {
                    SystemFailure.checkFailure();
                    entry = parser.getNextEntry();
                    if (!entry.isLast() && !this.patternMatch(entry)) continue;
                    this.queue.put(entry);
                    ThreadedReader threadedReader = this;
                    synchronized (threadedReader) {
                        this.notifyAll();
                    }
                } while (!entry.isLast());
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            finally {
                try {
                    this.logFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }

        private boolean patternMatch(LogFileParser.LogEntry entry) {
            if (this.patterns == null || this.patterns.isEmpty()) {
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(entry.getContents()).matches()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LogFileParser.LogEntry peek() {
            LogFileParser.LogEntry entry = (LogFileParser.LogEntry)this.queue.peek();
            if (entry == null) {
                ThreadedReader threadedReader = this;
                synchronized (threadedReader) {
                    entry = (LogFileParser.LogEntry)this.queue.peek();
                    while (entry == null) {
                        boolean interrupted = Thread.interrupted();
                        try {
                            this.wait();
                            entry = (LogFileParser.LogEntry)this.queue.peek();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            return entry;
        }

        @Override
        public LogFileParser.LogEntry poll() {
            return (LogFileParser.LogEntry)this.queue.poll();
        }
    }

    static class NonThreadedReader
    implements Reader {
        private BufferedReader logFile;
        private final String logFileName;
        private final LogFileParser parser;
        private LogFileParser.LogEntry nextEntry;
        private final List<Pattern> patterns;
        private int uniqueId;

        public NonThreadedReader(InputStream logFile, String logFileName, ThreadGroup group, boolean tabOut, boolean suppressBlanks, List<Pattern> patterns) {
            if (logFileName.endsWith(".gz")) {
                try {
                    this.logFile = new BufferedReader(new InputStreamReader(new GZIPInputStream(logFile)));
                }
                catch (IOException e) {
                    System.err.println(logFileName + " does not appear to be in gzip format");
                    this.logFile = new BufferedReader(new InputStreamReader(logFile));
                }
            } else {
                this.logFile = new BufferedReader(new InputStreamReader(logFile));
            }
            this.logFileName = logFileName;
            this.patterns = patterns;
            this.parser = new LogFileParser(this.logFileName, this.logFile, tabOut, suppressBlanks);
        }

        @Override
        public String getFileName() {
            return this.logFileName;
        }

        @Override
        public void setUniqueId(int id) {
            this.uniqueId = id;
        }

        @Override
        public int getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public synchronized LogFileParser.LogEntry peek() {
            while (this.nextEntry == null) {
                try {
                    this.nextEntry = this.parser.getNextEntry();
                    if (this.nextEntry == null) {
                        return null;
                    }
                    if (!this.nextEntry.isLast() && this.patternMatch(this.nextEntry)) continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
            return this.nextEntry;
        }

        private boolean patternMatch(LogFileParser.LogEntry entry) {
            if (this.patterns == null || this.patterns.isEmpty()) {
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(entry.getContents()).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public LogFileParser.LogEntry poll() {
            LogFileParser.LogEntry returnValue = null;
            if (this.nextEntry != null) {
                returnValue = this.nextEntry;
                this.nextEntry = null;
            } else {
                while (returnValue == null) {
                    try {
                        returnValue = this.parser.getNextEntry();
                        if (returnValue.isLast() || this.patternMatch(returnValue)) continue;
                        returnValue = null;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                        break;
                    }
                }
            }
            return returnValue;
        }
    }

    static interface Reader {
        public LogFileParser.LogEntry peek();

        public LogFileParser.LogEntry poll();

        public String getFileName();

        public void setUniqueId(int var1);

        public int getUniqueId();
    }
}

