/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.logging.ManagerLogWriter;
import org.apache.geode.internal.logging.SecurityManagerLogWriter;
import org.apache.geode.internal.process.ProcessLauncherContext;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.geode.internal.util.LogFileUtils;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class ManagerLogWriterFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final LogFileRolloverDetails logFileRolloverDetails = new LogFileRolloverDetails();
    private boolean security;
    private boolean appendLog;

    public ManagerLogWriterFactory setSecurity(boolean value) {
        this.security = value;
        return this;
    }

    public ManagerLogWriterFactory setAppendLog(boolean value) {
        this.appendLog = value;
        return this;
    }

    public LogFileRolloverDetails getLogFileRolloverDetails() {
        return this.logFileRolloverDetails;
    }

    public ManagerLogWriter create(LogConfig logConfig, StatisticsConfig statsConfig) {
        File logFile = this.getLogFile(logConfig);
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        if (logFile.exists()) {
            boolean useChildLogging = this.useChildLogging(logConfig);
            boolean statArchivesRolling = this.statArchivesRolling(statsConfig);
            if (!this.appendLog || useChildLogging || statArchivesRolling) {
                File oldMain = ManagerLogWriter.getLogNameForOldMainLog(logFile, this.security || useChildLogging || statArchivesRolling);
                boolean succeeded = LogFileUtils.renameAggressively(logFile, oldMain);
                if (succeeded) {
                    this.logFileRolloverDetails.message = String.format("Renamed old log file to %s.", oldMain);
                } else {
                    this.logFileRolloverDetails.warning = true;
                    this.logFileRolloverDetails.message = String.format("Could not rename %s to %s.", logFile, oldMain);
                }
            }
        }
        ManagerLogWriter logWriter = this.newManagerLogWriter(logConfig, this.createPrintStream(logFile));
        logWriter.setConfig(logConfig);
        this.redirectOutput(logConfig);
        return logWriter;
    }

    @VisibleForTesting
    File getLogFile(LogConfig config) {
        if (this.security) {
            return config.getSecurityLogFile();
        }
        return config.getLogFile();
    }

    @VisibleForTesting
    int getLogLevel(LogConfig config) {
        if (this.security) {
            return config.getSecurityLogLevel();
        }
        return config.getLogLevel();
    }

    private boolean useChildLogging(LogConfig config) {
        return config.getLogFile() != null && !config.getLogFile().equals(new File("")) && config.getLogFileSizeLimit() != 0;
    }

    private boolean statArchivesRolling(StatisticsConfig config) {
        return config.getStatisticArchiveFile() != null && !config.getStatisticArchiveFile().equals(new File("")) && config.getArchiveFileSizeLimit() != 0 && config.getStatisticSamplingEnabled();
    }

    private PrintStream createPrintStream(File logFile) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(logFile, true);
        }
        catch (FileNotFoundException e) {
            String message = String.format("Could not open log file %s.", logFile);
            throw new GemFireIOException(message, e);
        }
        return new PrintStream(fos);
    }

    private ManagerLogWriter newManagerLogWriter(LogConfig config, PrintStream printStream) {
        if (this.security) {
            return new SecurityManagerLogWriter(this.getLogLevel(config), printStream, config.getName(), config.isLoner());
        }
        return new ManagerLogWriter(this.getLogLevel(config), printStream, config.getName(), config.isLoner());
    }

    private void redirectOutput(LogConfig config) {
        if (ProcessLauncherContext.isRedirectingOutput()) {
            try {
                OSProcess.redirectOutput((File)config.getLogFile());
            }
            catch (IOException e) {
                LOGGER.error("Unable to redirect output to {}", (Object)config.getLogFile(), (Object)e);
            }
        }
    }

    public static class LogFileRolloverDetails {
        private String message;
        private boolean warning;

        public String getMessage() {
            return this.message;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public boolean exists() {
            return this.message != null;
        }
    }
}

