/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.geode.internal.io.MainWithChildrenRollingFileHandler;
import org.apache.geode.internal.io.RollingFileHandler;
import org.apache.geode.internal.logging.LocalLogWriter;
import org.apache.geode.internal.util.LogFileUtils;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.geode.logging.internal.spi.LogFileDetails;

public class ManagerLogWriter
extends LocalLogWriter
implements LogFileDetails {
    private static final String TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY = "gemfire.logging.test.fileSizeLimitInKB";
    private final boolean fileSizeLimitInKB;
    private final RollingFileHandler rollingFileHandler;
    private LogConfig config;
    private LocalLogWriter mainLogWriter = this;
    private File logDir;
    private int mainLogId = -1;
    private int childId;
    private boolean useChildLogging;
    private boolean rolling;
    private boolean mainLog = true;
    private File activeLogFile;
    private boolean started;
    private final boolean loner;

    public ManagerLogWriter(int level, PrintStream printStream, boolean loner) {
        this(level, printStream, null, loner);
    }

    public ManagerLogWriter(int level, PrintStream printStream, String connectionName, boolean loner) {
        super(level, printStream, connectionName);
        this.fileSizeLimitInKB = Boolean.getBoolean(TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY);
        this.rollingFileHandler = new MainWithChildrenRollingFileHandler();
        this.loner = loner;
    }

    public void setConfig(LogConfig config) {
        this.config = config;
        this.configChanged();
    }

    public LogConfig getConfig() {
        return this.config;
    }

    public void configChanged() {
        this.setLevel(this.config.getLogLevel());
        boolean bl = this.useChildLogging = this.config.getLogFile() != null && !this.config.getLogFile().equals(new File("")) && this.config.getLogFileSizeLimit() != 0;
        if (this.useChildLogging()) {
            this.logDir = this.rollingFileHandler.getParentFile(this.config.getLogFile());
            this.mainLogId = this.rollingFileHandler.calcNextMainId(this.logDir, true);
        }
        if (this.started) {
            if (this.useChildLogging()) {
                if (this.mainLog) {
                    this.rollLog();
                }
            } else {
                this.switchLogs(this.config.getLogFile(), true);
            }
        }
    }

    @Override
    public File getChildLogFile() {
        return this.activeLogFile;
    }

    @Override
    public File getLogDir() {
        return this.logDir;
    }

    @Override
    public int getMainLogId() {
        return this.mainLogId;
    }

    @Override
    public boolean useChildLogging() {
        return this.useChildLogging;
    }

    private File getNextChildLogFile() {
        Object path = this.config.getLogFile().getPath();
        int extIndex = ((String)path).lastIndexOf(46);
        String ext = "";
        if (extIndex != -1) {
            ext = ((String)path).substring(extIndex);
            path = ((String)path).substring(0, extIndex);
        }
        path = (String)path + this.rollingFileHandler.formatId(this.mainLogId) + this.rollingFileHandler.formatId(this.childId) + ext;
        ++this.childId;
        File result = new File((String)path);
        if (result.exists()) {
            return this.getNextChildLogFile();
        }
        return result;
    }

    private long getLogFileSizeLimit() {
        if (this.rolling || this.mainLog) {
            return Long.MAX_VALUE;
        }
        long result = this.config.getLogFileSizeLimit();
        if (result == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.fileSizeLimitInKB) {
            return result * 1024L;
        }
        return result * 0x100000L;
    }

    private long getLogDiskSpaceLimit() {
        long result = this.config.getLogDiskSpaceLimit();
        return result * 0x100000L;
    }

    private String getMetaLogFileName(String baseLogFileName, int mainLogId) {
        Object metaLogFile = null;
        int extIndex = baseLogFileName.lastIndexOf(46);
        String ext = "";
        if (extIndex != -1) {
            ext = baseLogFileName.substring(extIndex);
            metaLogFile = baseLogFileName.substring(0, extIndex);
        }
        String fileName = new File((String)metaLogFile).getName();
        String parent = new File((String)metaLogFile).getParent();
        metaLogFile = "meta-" + fileName + this.rollingFileHandler.formatId(mainLogId) + ext;
        if (parent != null) {
            metaLogFile = parent + File.separator + (String)metaLogFile;
        }
        return metaLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void switchLogs(File newLog, boolean newIsMain) {
        this.rolling = true;
        try {
            try {
                if (!newIsMain) {
                    if (this.mainLog && this.mainLogWriter == this && this.config.getLogFile() != null) {
                        String metaLogFile = this.getMetaLogFileName(this.config.getLogFile().getPath(), this.mainLogId);
                        this.mainLogWriter = new LocalLogWriter(800, new PrintStream(new FileOutputStream(metaLogFile, true), true));
                        if (this.activeLogFile == null) {
                            this.mainLogWriter.info(String.format("Switching to log %s", this.config.getLogFile()));
                        }
                    } else {
                        this.mainLogWriter.info(String.format("Rolling current log to %s", newLog));
                    }
                }
                boolean renameOK = true;
                String oldName = this.config.getLogFile().getAbsolutePath();
                File tempFile = null;
                if (this.activeLogFile != null && !this.activeLogFile.getAbsolutePath().equals(newLog.getAbsolutePath())) {
                    File oldFile;
                    File tempLogDir;
                    PrintStream tempPrintStream;
                    PrintWriter oldPrintWriter;
                    boolean isWindows = false;
                    String os = System.getProperty("os.name");
                    if (os != null && os.contains("Windows")) {
                        isWindows = true;
                    }
                    if (isWindows && (oldPrintWriter = this.setTarget(new PrintWriter(tempPrintStream = OSProcess.redirectOutput((File)(tempFile = File.createTempFile("mlw", null, tempLogDir = this.rollingFileHandler.getParentFile(this.config.getLogFile()))), (!this.loner ? 1 : 0) != 0), true))) != null) {
                        oldPrintWriter.close();
                    }
                    if (!(renameOK = LogFileUtils.renameAggressively(oldFile = this.activeLogFile, newLog.getAbsoluteFile()))) {
                        this.mainLogWriter.warning("Could not delete original file '" + String.valueOf(oldFile) + "' after copying to '" + String.valueOf(newLog.getAbsoluteFile()) + "'. Continuing without rolling.");
                    } else {
                        renameOK = true;
                    }
                }
                this.activeLogFile = new File(oldName);
                PrintStream printStream = OSProcess.redirectOutput((File)this.activeLogFile, (!this.loner ? 1 : 0) != 0);
                PrintWriter oldPrintWriter = this.setTarget(new PrintWriter(printStream, true), this.activeLogFile.length());
                if (oldPrintWriter != null) {
                    oldPrintWriter.close();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                this.mainLog = newIsMain;
                if (this.mainLogWriter == null) {
                    this.mainLogWriter = this;
                }
                if (!renameOK) {
                    this.mainLogWriter.warning("Could not rename \"" + String.valueOf(this.activeLogFile) + "\" to \"" + String.valueOf(newLog) + "\". Continuing without rolling.");
                }
            }
            catch (IOException ex) {
                this.mainLogWriter.warning("Could not open log \"" + String.valueOf(newLog) + "\" because " + String.valueOf(ex));
            }
            this.checkDiskSpace(this.activeLogFile);
        }
        finally {
            this.rolling = false;
        }
    }

    public void closingLogFile() {
        PrintWriter printWriter;
        OutputStream nullOutputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        this.close();
        if (this.mainLogWriter != null) {
            this.mainLogWriter.close();
        }
        if ((printWriter = this.setTarget(new PrintWriter(nullOutputStream, true))) != null) {
            printWriter.close();
        }
    }

    public static File getLogNameForOldMainLog(File log, boolean useOldFile) {
        MainWithChildrenRollingFileHandler rollingFileHandler = new MainWithChildrenRollingFileHandler();
        File dir = rollingFileHandler.getParentFile(log.getAbsoluteFile());
        int previousMainId = rollingFileHandler.calcNextMainId(dir, true);
        if (useOldFile && previousMainId > 0) {
            --previousMainId;
        }
        if (previousMainId == 0) {
            previousMainId = 1;
        }
        int childId = rollingFileHandler.calcNextChildId(log, previousMainId > 0 ? previousMainId : 0);
        StringBuilder sb = new StringBuilder(log.getPath());
        int insertIdx = sb.lastIndexOf(".");
        if (insertIdx == -1) {
            sb.append(rollingFileHandler.formatId(previousMainId)).append(rollingFileHandler.formatId(childId));
        } else {
            sb.insert(insertIdx, rollingFileHandler.formatId(childId));
            sb.insert(insertIdx, rollingFileHandler.formatId(previousMainId));
        }
        return new File(sb.toString());
    }

    private void checkDiskSpace(File newLog) {
        this.rollingFileHandler.checkDiskSpace("log", newLog, this.getLogDiskSpaceLimit(), this.logDir, this.mainLogWriter);
    }

    private void rollLog() {
        this.rollLog(false);
    }

    private void rollLogIfFull() {
        this.rollLog(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollLog(boolean ifFull) {
        if (!this.useChildLogging()) {
            return;
        }
        ManagerLogWriter managerLogWriter = this;
        synchronized (managerLogWriter) {
            if (ifFull && !this.activeLogFull()) {
                return;
            }
            this.switchLogs(this.getNextChildLogFile(), false);
        }
    }

    public void startupComplete() {
        this.started = true;
        this.rollLog();
    }

    public void shuttingDown() {
        if (this.useChildLogging()) {
            this.switchLogs(this.config.getLogFile(), true);
        }
    }

    private boolean activeLogFull() {
        long limit = this.getLogFileSizeLimit();
        if (limit == Long.MAX_VALUE) {
            return false;
        }
        return this.getBytesLogged() >= limit;
    }

    @Override
    public void writeFormattedMessage(String message) {
        this.rollLogIfFull();
        super.writeFormattedMessage(message);
    }
}

