/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jta;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geode.LogWriter;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.jta.TransactionUtils;
import org.apache.geode.internal.jta.XidImpl;

@Deprecated
public class GlobalTransaction {
    @MutableForTesting
    public static boolean DISABLE_TRANSACTION_TIMEOUT_SETTING = false;
    private final byte[] GTid;
    private final Xid xid;
    private int status = 5;
    private final Map resourceMap = Collections.synchronizedMap(new HashMap());
    private final List transactions = Collections.synchronizedList(new ArrayList());
    @MakeNotStatic
    private static long mCounter = 1L;
    private boolean timedOut = false;
    private volatile long expirationTime;
    private static final boolean VERBOSE = Boolean.getBoolean("jta.VERBOSE");
    @MakeNotStatic
    private static String DMid = null;
    @MakeNotStatic
    private static InternalDistributedSystem IdsForId = null;
    private static final Object DmidMutex = new Object();

    public GlobalTransaction() throws SystemException {
        try {
            this.GTid = GlobalTransaction.generateGTid();
            this.xid = XidImpl.createXid(this.GTid);
        }
        catch (Exception e) {
            LogWriter writer = TransactionUtils.getLogWriter();
            if (writer.severeEnabled()) {
                writer.severe(String.format("GlobalTransaction::Constructor::Error while trying to create Xid due to %s", e), e);
            }
            String exception = String.format("GlobalTransaction::Constructor::Error while trying to create Xid due to %s", e);
            throw new SystemException(exception);
        }
    }

    public void addTransaction(Transaction txn) throws SystemException {
        if (txn == null) {
            String exception = "GlobalTransaction::addTransaction::Cannot add a null Transaction";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        this.transactions.add(txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        LogWriter writer = TransactionUtils.getLogWriter();
        try {
            XAResource xar = null;
            XAResource xar1 = null;
            int loop = 0;
            Boolean isActive = Boolean.FALSE;
            Map map = this.resourceMap;
            synchronized (map) {
                Iterator iterator = this.resourceMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        Map.Entry entry = iterator.next();
                        xar = (XAResource)entry.getKey();
                        isActive = (Boolean)entry.getValue();
                        if (loop == 0) {
                            xar1 = xar;
                        }
                        ++loop;
                        if (!isActive.booleanValue()) continue;
                        xar.end(this.xid, 0x4000000);
                        entry.setValue(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        if (!VERBOSE) continue;
                        writer.info("GlobalTransaction::commit:Exception in delisting XAResource", e);
                    }
                }
            }
            if (xar1 != null) {
                xar1.commit(this.xid, true);
            }
            this.status = 3;
            if (VERBOSE) {
                writer.fine("GlobalTransaction::commit:Transaction committed successfully");
            }
        }
        catch (Exception e) {
            this.status = 9;
            try {
                this.rollback();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.status = 4;
                String exception = String.format("GlobalTransaction::commit::Error in committing, but transaction could not be rolled back due to exception: %s", t);
                if (VERBOSE) {
                    writer.fine(exception, t);
                }
                SystemException sysEx = new SystemException(exception);
                sysEx.initCause(t);
                throw sysEx;
            }
            String exception = String.format("GlobalTransaction::commit:Error in committing the transaction. Transaction rolled back.Exception, %s %s", e, " " + (String)(e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            if (VERBOSE) {
                writer.fine(exception, e);
            }
            RollbackException rbEx = new RollbackException(exception);
            rbEx.initCause((Throwable)e);
            throw rbEx;
        }
        finally {
            TransactionManagerImpl.getTransactionManager().cleanGlobalTransactionMap(this.transactions);
            this.transactions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        LogWriter writer = TransactionUtils.getLogWriter();
        try {
            XAResource xar = null;
            XAResource xar1 = null;
            int loop = 0;
            Map map = this.resourceMap;
            synchronized (map) {
                Iterator iterator = this.resourceMap.entrySet().iterator();
                Boolean isActive = Boolean.FALSE;
                while (iterator.hasNext()) {
                    try {
                        Map.Entry entry = iterator.next();
                        xar = (XAResource)entry.getKey();
                        isActive = (Boolean)entry.getValue();
                        if (loop == 0) {
                            xar1 = xar;
                        }
                        ++loop;
                        if (!isActive.booleanValue()) continue;
                        xar.end(this.xid, 0x4000000);
                        entry.setValue(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        if (!VERBOSE) continue;
                        writer.info("GlobalTransaction::rollback:Exception in delisting XAResource", e);
                    }
                }
            }
            if (xar1 != null) {
                xar1.rollback(this.xid);
            }
            this.status = 4;
            if (VERBOSE) {
                writer.fine("Transaction rolled back successfully");
            }
        }
        catch (Exception e) {
            this.status = 4;
            String exception = String.format("GlobalTransaction::rollback:Rollback not successful due to exception %s %s", e, " " + (String)(e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            if (VERBOSE) {
                writer.fine(exception);
            }
            SystemException sysEx = new SystemException(exception);
            sysEx.initCause((Throwable)e);
            throw sysEx;
        }
        finally {
            TransactionManagerImpl.getTransactionManager().cleanGlobalTransactionMap(this.transactions);
            this.transactions.clear();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.setStatus(1);
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        XAResource xar = null;
        try {
            GlobalTransaction globalTransaction = this;
            synchronized (globalTransaction) {
                if (this.status == 1) {
                    String exception = "GlobalTransaction::enlistResource::Cannot enlist resource as the transaction has been marked for rollback";
                    LogWriter writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new RollbackException(exception);
                }
                if (this.status != 0) {
                    String exception = "GlobalTransaction::enlistResource::Cannot enlist a resource to a transaction which is not active";
                    LogWriter writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new IllegalStateException(exception);
                }
                if (this.resourceMap.isEmpty()) {
                    xaRes.start(this.xid, 0);
                    int delay = (int)((this.expirationTime - System.currentTimeMillis()) / 1000L);
                    try {
                        if (!DISABLE_TRANSACTION_TIMEOUT_SETTING) {
                            xaRes.setTransactionTimeout(delay);
                        }
                    }
                    catch (XAException xe) {
                        String exception = String.format("GlobalTransaction::enlistResource:Exception occurred in trying to set XAResource timeout due to %s Error Code, %s", xe, xe.errorCode);
                        LogWriter writer = TransactionUtils.getLogWriter();
                        if (VERBOSE) {
                            writer.fine(exception);
                        }
                        throw new SystemException(exception);
                    }
                    this.resourceMap.put(xaRes, Boolean.TRUE);
                } else {
                    Map delay = this.resourceMap;
                    synchronized (delay) {
                        Iterator iterator = this.resourceMap.keySet().iterator();
                        xar = (XAResource)iterator.next();
                    }
                    if (!xar.isSameRM(xaRes)) {
                        LogWriter writer = TransactionUtils.getLogWriter();
                        if (writer.severeEnabled()) {
                            writer.severe("GlobalTransaction::enlistResource::Only one Resouce Manager supported");
                        }
                        throw new SystemException("GlobalTransaction::enlistResource::Only one Resouce Manager supported");
                    }
                    xaRes.start(this.xid, 0x200000);
                    this.resourceMap.put(xaRes, Boolean.TRUE);
                }
            }
        }
        catch (Exception e) {
            String addon = e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : "";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(String.format("GlobalTransaction::enlistResource::error while enlisting XAResource %s %s", e, addon), e);
            }
            SystemException sysEx = new SystemException(String.format("GlobalTransaction::enlistResource::error while enlisting XAResource %s %s", e, addon));
            sysEx.initCause((Throwable)e);
            throw sysEx;
        }
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        try {
            Boolean isActive;
            if (this.resourceMap.containsKey(xaRes) && (isActive = (Boolean)this.resourceMap.get(xaRes)).booleanValue()) {
                xaRes.end(this.xid, flag);
                this.resourceMap.put(xaRes, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            String exception = String.format("error while delisting XAResource %s %s", e, " " + (String)(e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception, e);
            }
            SystemException se = new SystemException(exception);
            se.initCause((Throwable)e);
        }
        return true;
    }

    public void setStatus(int new_status) {
        this.status = new_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws SystemException {
        XAResource xar = null;
        Map map = this.resourceMap;
        synchronized (map) {
            Iterator iterator = this.resourceMap.entrySet().iterator();
            Boolean isActive = Boolean.FALSE;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                xar = (XAResource)entry.getKey();
                isActive = (Boolean)entry.getValue();
                if (!isActive.booleanValue()) continue;
                try {
                    xar.end(this.xid, 0x2000000);
                    entry.setValue(Boolean.FALSE);
                }
                catch (Exception e) {
                    String exception = String.format("error while delisting XAResource %s %s", e, " " + (String)(e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
                    LogWriter writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new SystemException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws SystemException {
        XAResource xar = null;
        Map map = this.resourceMap;
        synchronized (map) {
            Iterator iterator = this.resourceMap.entrySet().iterator();
            Boolean isActive = Boolean.FALSE;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                xar = (XAResource)entry.getKey();
                isActive = (Boolean)entry.getValue();
                if (isActive.booleanValue()) continue;
                try {
                    xar.start(this.xid, 0x8000000);
                    entry.setValue(Boolean.TRUE);
                }
                catch (Exception e) {
                    String exception = String.format("GlobaTransaction::resume:Resume not succesful due to %s", e);
                    LogWriter writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(exception, e);
                    }
                    throw new SystemException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getId() {
        Object object = DmidMutex;
        synchronized (object) {
            InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
            if (ids == null) {
                throw new DistributedSystemDisconnectedException("No distributed system");
            }
            if (ids == IdsForId) {
                return DMid;
            }
            IdsForId = ids;
            DistributionManager dm = ids.getDistributionManager();
            DMid = dm.getId().toString();
            return DMid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] generateGTid() {
        StringBuilder sbuff = new StringBuilder(GlobalTransaction.getId());
        Class<GlobalTransaction> clazz = GlobalTransaction.class;
        synchronized (GlobalTransaction.class) {
            mCounter = mCounter == 99999L ? 1L : ++mCounter;
            sbuff.append(mCounter);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            sbuff.append('_').append(System.currentTimeMillis());
            byte[] byte_array = sbuff.toString().getBytes();
            return byte_array;
        }
    }

    void expireGTX() {
        block4: {
            if (this.timedOut) {
                return;
            }
            this.timedOut = true;
            LogWriter writer = TransactionUtils.getLogWriter();
            try {
                if (writer.infoEnabled()) {
                    writer.info(String.format("Transaction %s has timed out.", this));
                }
                TransactionManagerImpl.getTransactionManager().removeTranxnMappingsAndRollbackExpiredTransaction(this.transactions);
                this.setStatus(6);
            }
            catch (Exception e) {
                if (!writer.severeEnabled()) break block4;
                writer.severe(String.format("GlobaTransaction::expireGTX:Error occurred while removing transactional mappings %s", e), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long setTransactionTimeoutForXARes(int seconds) throws SystemException {
        XAResource xar = null;
        boolean resetXATimeOut = true;
        Map map = this.resourceMap;
        synchronized (map) {
            Iterator iterator = this.resourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                xar = (XAResource)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                try {
                    resetXATimeOut = xar.setTransactionTimeout(seconds);
                    break;
                }
                catch (XAException e) {
                    String exception = String.format("Exception occurred while trying to set the XAResource TimeOut due to %s Error code, %s", e, e.errorCode);
                    LogWriter writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new SystemException(exception);
                }
            }
        }
        long newExp = System.currentTimeMillis() + (long)seconds * 1000L;
        if (!resetXATimeOut) {
            newExp = -1L;
        }
        return newExp;
    }

    int getResourceMapSize() {
        return this.resourceMap.size();
    }

    List getTransactions() {
        return this.transactions;
    }

    long getExpirationTime() {
        return this.expirationTime;
    }

    void setTimeoutValue(long time) {
        this.expirationTime = time;
    }

    boolean isExpired() {
        return this.timedOut;
    }

    public int compare(GlobalTransaction other) {
        int otherId;
        if (this == other) {
            return 0;
        }
        long compare = this.getExpirationTime() - other.getExpirationTime();
        if (compare < 0L) {
            return -1;
        }
        if (compare > 0L) {
            return 1;
        }
        if (this.GTid.length < other.GTid.length) {
            return -1;
        }
        if (this.GTid.length > other.GTid.length) {
            return 1;
        }
        for (int i = 0; i < this.GTid.length; ++i) {
            if (this.GTid[i] < other.GTid[i]) {
                return -1;
            }
            if (this.GTid[i] <= other.GTid[i]) continue;
            return 1;
        }
        int myId = System.identityHashCode(this);
        if (myId < (otherId = System.identityHashCode(other))) {
            return -1;
        }
        if (myId > otherId) {
            return 1;
        }
        throw new IllegalStateException(String.format("Could not compare %s to %s", this, other));
    }
}

