/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.transaction.TransactionManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.naming.Context;
import org.apache.geode.CancelCriterion;
import org.apache.geode.GemFireIOException;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.QueryConfigurationService;
import org.apache.geode.cache.query.internal.QueryConfigurationServiceException;
import org.apache.geode.cache.query.internal.QueryConfigurationServiceImpl;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.xml.QueryConfigurationServiceCreation;
import org.apache.geode.cache.query.internal.xml.QueryMethodAuthorizerCreation;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.ServerLauncherParameters;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.TXEntryStateFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.backup.BackupService;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.event.EventTrackerExpiryTask;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.eviction.OffHeapEvictor;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.InternalGatewaySenderFactory;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.cache.xmlcache.CacheTransactionManagerCreation;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.FunctionServiceCreation;
import org.apache.geode.internal.cache.xmlcache.IndexCreationData;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.geode.internal.cache.xmlcache.ResourceManagerCreation;
import org.apache.geode.internal.cache.xmlcache.SerializerCreation;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.lang.SystemProperty;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LocalLogWriter;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.SecurityServiceFactory;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class CacheCreation
implements InternalCache {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final RegionAttributes defaults = new AttributesFactory().create();
    @Immutable
    private static final Optional<Boolean> parallelDiskStoreRecovery = SystemProperty.getProductBooleanProperty((String)"parallelDiskStoreRecovery");
    private static final ThreadLocal<PoolManagerImpl> createInProgress = new ThreadLocal();
    private int lockTimeout = GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT;
    private boolean hasLockTimeout;
    private int lockLease = GemFireCacheImpl.DEFAULT_LOCK_LEASE;
    private boolean hasLockLease;
    private int searchTimeout = GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT;
    private boolean hasSearchTimeout;
    private boolean hasMessageSyncInterval;
    protected final Map<String, Region<?, ?>> roots = new LinkedHashMap();
    private DynamicRegionFactory.Config dynamicRegionFactoryConfig;
    private boolean hasDynamicRegionFactory;
    private boolean isServer;
    private boolean hasServer;
    private final List<CacheServer> bridgeServers = new ArrayList<CacheServer>();
    private final Map<Declarable, Properties> declarablePropertiesMap = new HashMap<Declarable, Properties>();
    private final List<DeclarableAndProperties> declarablePropertiesList = new ArrayList<DeclarableAndProperties>();
    private final Set<GatewaySender> gatewaySenders = new HashSet<GatewaySender>();
    private final Set<GatewayReceiver> gatewayReceivers = new HashSet<GatewayReceiver>();
    private final Set<AsyncEventQueue> asyncEventQueues = new HashSet<AsyncEventQueue>();
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean copyOnRead = false;
    private boolean hasCopyOnRead;
    private CacheTransactionManagerCreation cacheTransactionManagerCreation;
    private final Map<String, RegionAttributes<?, ?>> namedRegionAttributes = new HashMap();
    private final List<String> regionAttributesNames = new ArrayList<String>();
    private final Map<String, DiskStore> diskStores = new LinkedHashMap<String, DiskStore>();
    private final List<File> backups = new ArrayList<File>();
    private final CacheConfig cacheConfig = new CacheConfig();
    private final InternalLogWriter logWriter = new LocalLogWriter(LogWriterLevel.ALL.intLevel(), System.out);
    private final InternalLogWriter securityLogWriter = LogWriterFactory.toSecurityLogWriter(this.logWriter);
    private final SimpleExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<CacheCreation>(this, this);
    private final PoolManagerImpl poolManager = new PoolManagerImpl(false);
    private volatile FunctionServiceCreation functionServiceCreation;
    private volatile boolean hasFunctionService;
    private volatile boolean hasResourceManager;
    private volatile ResourceManagerCreation resourceManagerCreation;
    private volatile SerializerCreation serializerCreation;
    private Declarable initializer;
    private Properties initializerProps;
    private final InternalQueryService queryService = this.createInternalQueryService();
    private QueryConfigurationServiceCreation queryConfigurationServiceCreation;

    public CacheCreation() {
        this(false);
    }

    public CacheCreation(boolean forParsing) {
        this.initializeRegionShortcuts();
        if (!forParsing) {
            createInProgress.set(this.poolManager);
        }
    }

    public static void clearThreadLocals() {
        createInProgress.remove();
    }

    void startingGenerate() {
        createInProgress.set(null);
    }

    RegionAttributes getDefaultAttributes() {
        return defaults;
    }

    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeRegionShortcuts(this);
    }

    void addRootRegion(RegionCreation root) throws RegionExistsException {
        String name = root.getName();
        RegionCreation existing = (RegionCreation)this.roots.get(name);
        if (existing != null) {
            throw new RegionExistsException(existing);
        }
        this.roots.put(root.getName(), root);
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.lockTimeout = seconds;
        this.hasLockTimeout = true;
    }

    boolean hasLockTimeout() {
        return this.hasLockTimeout;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        this.lockLease = seconds;
        this.hasLockLease = true;
    }

    boolean hasLockLease() {
        return this.hasLockLease;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        this.searchTimeout = seconds;
        this.hasSearchTimeout = true;
    }

    boolean hasSearchTimeout() {
        return this.hasSearchTimeout;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("The 'message-sync-interval' property for cache cannot be negative");
        }
        HARegionQueue.setMessageSyncInterval(seconds);
        this.hasMessageSyncInterval = true;
    }

    boolean hasMessageSyncInterval() {
        return this.hasMessageSyncInterval;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.roots.values()));
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    public static PoolManagerImpl getCurrentPoolManager() {
        return createInProgress.get();
    }

    void create(InternalCache cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException, QueryConfigurationServiceException {
        QueryMethodAuthorizerCreation authorizerCreation;
        QueryConfigurationServiceImpl queryConfigurationServiceImpl;
        Object factory;
        Map<String, Pool> pools;
        this.extensionPoint.beforeCreate(cache);
        cache.setDeclarativeCacheConfig(this.cacheConfig);
        if (cache.isClient()) {
            throw new IllegalStateException("You must use client-cache in the cache.xml when ClientCacheFactory is used.");
        }
        this.initializeDeclarablesMap(cache);
        if (this.hasFunctionService()) {
            this.getFunctionServiceCreation().create();
        }
        if (this.hasLockLease()) {
            cache.setLockLease(this.lockLease);
        }
        if (this.hasLockTimeout()) {
            cache.setLockTimeout(this.lockTimeout);
        }
        if (this.hasSearchTimeout()) {
            cache.setSearchTimeout(this.searchTimeout);
        }
        if (this.hasMessageSyncInterval()) {
            cache.setMessageSyncInterval(this.getMessageSyncInterval());
        }
        if (this.gatewayConflictResolver != null) {
            cache.setGatewayConflictResolver(this.gatewayConflictResolver);
        }
        if (!(pools = this.getPools()).isEmpty()) {
            for (Pool pool : pools.values()) {
                PoolFactoryImpl poolFactory = (PoolFactoryImpl)PoolManager.createFactory();
                poolFactory.init(pool);
                poolFactory.create(pool.getName());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        this.createDiskStores(cache, pdxRegDSC);
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasServer()) {
            cache.setIsServer(this.isServer);
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.copyOnRead);
        }
        if (this.cacheTransactionManagerCreation != null && this.cacheTransactionManagerCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.cacheTransactionManagerCreation.getListeners());
        }
        if (this.cacheTransactionManagerCreation != null && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().setWriter(this.cacheTransactionManagerCreation.getWriter());
        }
        for (GatewaySender senderCreation : this.getGatewaySenders()) {
            factory = cache.createGatewaySenderFactory();
            ((InternalGatewaySenderFactory)factory).configureGatewaySender(senderCreation);
            GatewaySender gatewaySender = factory.create(senderCreation.getId(), senderCreation.getRemoteDSId());
            if (!gatewaySender.isManualStart()) continue;
            logger.info("{} is not being started since it is configured for manual start", (Object)gatewaySender);
        }
        for (AsyncEventQueue asyncEventQueueCreation : this.getAsyncEventQueues()) {
            AsyncEventQueue asyncEventQueue;
            AsyncEventQueueFactoryImpl asyncQueueFactory = (AsyncEventQueueFactoryImpl)cache.createAsyncEventQueueFactory();
            asyncQueueFactory.configureAsyncEventQueue(asyncEventQueueCreation);
            if (asyncEventQueueCreation.isDispatchingPaused()) {
                asyncQueueFactory.pauseEventDispatching();
            }
            if ((asyncEventQueue = cache.getAsyncEventQueue(asyncEventQueueCreation.getId())) != null) continue;
            asyncQueueFactory.create(asyncEventQueueCreation.getId(), asyncEventQueueCreation.getAsyncEventListener());
        }
        cache.initializePdxRegistry();
        for (String id : this.regionAttributesNames) {
            RegionAttributesCreation creation = (RegionAttributesCreation)this.getRegionAttributes(id);
            creation.inheritAttributes(cache, false);
            AttributesFactory factory2 = new AttributesFactory(creation);
            RegionAttributes attrs = factory2.create();
            cache.setRegionAttributes(id, attrs);
        }
        this.initializeRegions(this.roots, cache);
        cache.readyDynamicRegionFactory();
        this.startCacheServers(this.getCacheServers(), cache, ServerLauncherParameters.INSTANCE);
        for (GatewayReceiver receiverCreation : this.getGatewayReceivers()) {
            factory = cache.createGatewayReceiverFactory();
            factory.setBindAddress(receiverCreation.getBindAddress());
            factory.setMaximumTimeBetweenPings(receiverCreation.getMaximumTimeBetweenPings());
            factory.setStartPort(receiverCreation.getStartPort());
            factory.setEndPort(receiverCreation.getEndPort());
            factory.setSocketBufferSize(receiverCreation.getSocketBufferSize());
            factory.setManualStart(receiverCreation.isManualStart());
            for (GatewayTransportFilter filter : receiverCreation.getGatewayTransportFilters()) {
                factory.addGatewayTransportFilter(filter);
            }
            factory.setHostnameForSenders(receiverCreation.getHostnameForSenders());
            GatewayReceiver receiver = factory.create();
            if (!receiver.isManualStart()) continue;
            logger.info("{} is not being started since it is configured for manual start", (Object)receiver);
        }
        if (this.queryConfigurationServiceCreation != null && (queryConfigurationServiceImpl = (QueryConfigurationServiceImpl)cache.getService(QueryConfigurationService.class)) != null && (authorizerCreation = this.queryConfigurationServiceCreation.getMethodAuthorizerCreation()) != null) {
            queryConfigurationServiceImpl.updateMethodAuthorizer(cache, true, authorizerCreation);
        }
        cache.setBackupFiles(this.backups);
        this.runInitializer(cache);
        cache.setInitializer(this.getInitializer(), this.getInitializerProps());
        this.extensionPoint.fireCreate(cache);
    }

    private void createDiskStores(InternalCache cache, DiskStoreAttributesCreation pdxRegDSC) {
        Stream<DiskStore> diskStoreStream = parallelDiskStoreRecovery.orElse(true) != false ? this.diskStores.values().parallelStream() : this.diskStores.values().stream();
        diskStoreStream.forEach(diskStore -> {
            DiskStoreAttributesCreation creation = (DiskStoreAttributesCreation)diskStore;
            if (creation != pdxRegDSC) {
                this.createDiskStore(creation, cache);
            }
        });
    }

    public void initializeDeclarablesMap(InternalCache cache) {
        for (DeclarableAndProperties struct : this.declarablePropertiesList) {
            Declarable declarable = struct.getDeclarable();
            Properties properties = struct.getProperties();
            try {
                declarable.initialize(cache, properties);
                declarable.init(properties);
            }
            catch (Exception ex) {
                throw new CacheXmlException("Exception while initializing an instance of " + declarable.getClass().getName(), ex);
            }
            this.declarablePropertiesMap.put(declarable, properties);
        }
        cache.addDeclarableProperties(this.declarablePropertiesMap);
    }

    void initializeRegions(Map<String, Region<?, ?>> declarativeRegions, Cache cache) {
        for (Region<?, ?> region : declarativeRegions.values()) {
            RegionCreation regionCreation = (RegionCreation)region;
            regionCreation.createRoot(cache);
        }
    }

    private void reconfigureServer(CacheServerImpl serverImpl, ServerLauncherParameters parameters) {
        if (parameters == null) {
            return;
        }
        if (parameters.getPort() != null && parameters.getPort() != 40404) {
            serverImpl.setPort(parameters.getPort());
        }
        if (parameters.getMaxThreads() != null && parameters.getMaxThreads() != 0) {
            serverImpl.setMaxThreads(parameters.getMaxThreads());
        }
        if (parameters.getMaxConnections() != null && parameters.getMaxConnections() != 800) {
            serverImpl.setMaxConnections(parameters.getMaxConnections());
        }
        if (parameters.getMaxMessageCount() != null && parameters.getMaxMessageCount() != 230000) {
            serverImpl.setMaximumMessageCount(parameters.getMaxMessageCount());
        }
        if (parameters.getSocketBufferSize() != null && parameters.getSocketBufferSize() != 32768) {
            serverImpl.setSocketBufferSize(parameters.getSocketBufferSize());
        }
        if (parameters.getBindAddress() != null && parameters.getBindAddress() != "") {
            serverImpl.setBindAddress(parameters.getBindAddress().trim());
        }
        if (parameters.getMessageTimeToLive() != null && parameters.getMessageTimeToLive() != 180) {
            serverImpl.setMessageTimeToLive(parameters.getMessageTimeToLive());
        }
        if (parameters.getHostnameForClients() != null && parameters.getHostnameForClients() != "") {
            serverImpl.setHostnameForClients(parameters.getHostnameForClients());
        }
    }

    void startCacheServers(List<CacheServer> declarativeCacheServers, Cache cache, ServerLauncherParameters parameters) {
        boolean isDefaultServerDisabled;
        Integer serverPort = null;
        String serverBindAdd = null;
        Boolean disableDefaultServer = null;
        if (parameters != null) {
            serverPort = parameters.getPort();
            serverBindAdd = parameters.getBindAddress();
            disableDefaultServer = parameters.isDisableDefaultServer();
        }
        if (declarativeCacheServers.size() > 1 && (serverPort != null || serverBindAdd != null)) {
            throw new RuntimeException("When using -server-port or -server-bind-address arguments, the cache-xml-file can not have more than one cache-server defined.");
        }
        CacheServerCreation defaultServer = null;
        boolean hasServerPortOrBindAddress = serverPort != null || serverBindAdd != null;
        boolean bl = isDefaultServerDisabled = disableDefaultServer == null || disableDefaultServer == false;
        if (declarativeCacheServers.isEmpty() && hasServerPortOrBindAddress && isDefaultServerDisabled) {
            boolean existingCacheServer = false;
            List<CacheServer> cacheServers = cache.getCacheServers();
            if (cacheServers != null) {
                for (CacheServer cacheServer : cacheServers) {
                    if (serverPort.intValue() != cacheServer.getPort()) continue;
                    existingCacheServer = true;
                }
            }
            if (!existingCacheServer) {
                defaultServer = new CacheServerCreation((InternalCache)cache, false);
                declarativeCacheServers.add(defaultServer);
            }
        }
        for (CacheServer declarativeCacheServer : declarativeCacheServers) {
            CacheServerCreation declaredCacheServer = (CacheServerCreation)declarativeCacheServer;
            boolean startServer = true;
            List<CacheServer> cacheServers = cache.getCacheServers();
            if (cacheServers != null) {
                for (CacheServer cacheServer : cacheServers) {
                    if (declaredCacheServer.getPort() != cacheServer.getPort()) continue;
                    startServer = false;
                }
            }
            if (!startServer) continue;
            CacheServerImpl impl = (CacheServerImpl)cache.addCacheServer();
            impl.configureFrom(declaredCacheServer);
            if (declaredCacheServer == defaultServer) {
                impl.setIsDefaultServer();
            }
            this.reconfigureServer(impl, parameters);
            try {
                if (impl.isRunning()) continue;
                impl.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(String.format("While starting cache server %s", impl), ex);
            }
        }
    }

    DiskStoreAttributesCreation initializePdxDiskStore(InternalCache cache) {
        DiskStoreAttributesCreation pdxRegDSC = null;
        if (TypeRegistry.mayNeedDiskStore(cache)) {
            String pdxRegDsName = cache.getPdxDiskStore();
            if (pdxRegDsName == null) {
                pdxRegDsName = "DEFAULT";
            }
            if ((pdxRegDSC = (DiskStoreAttributesCreation)this.diskStores.get(pdxRegDsName)) == null) {
                if (pdxRegDsName.equals("DEFAULT")) {
                    cache.getOrCreateDefaultDiskStore();
                }
            } else {
                this.createDiskStore(pdxRegDSC, cache);
            }
        }
        return pdxRegDSC;
    }

    protected void createDiskStore(DiskStoreAttributesCreation creation, InternalCache cache) {
        DiskStoreFactory factory = cache.createDiskStoreFactory(creation);
        factory.create(creation.getName());
    }

    public boolean sameAs(Cache other) {
        Pool pool;
        boolean sameConfig;
        boolean bl = sameConfig = other.getLockLease() == this.getLockLease() && other.getLockTimeout() == this.getLockTimeout() && other.getSearchTimeout() == this.getSearchTimeout() && other.getMessageSyncInterval() == this.getMessageSyncInterval() && other.getCopyOnRead() == this.getCopyOnRead() && other.isServer() == this.isServer();
        if (!sameConfig) {
            throw new RuntimeException("!sameConfig");
        }
        DynamicRegionFactory.Config drc1 = this.getDynamicRegionFactoryConfig();
        if (drc1 != null) {
            DynamicRegionFactory.Config drc2 = other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() : DynamicRegionFactory.get().getConfig();
            if (drc2 == null) {
                return false;
            }
            if (!drc1.equals(drc2)) {
                return false;
            }
        } else if (other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() != null : DynamicRegionFactory.get().isOpen()) {
            return false;
        }
        List<CacheServer> myBridges = this.getCacheServers();
        List<CacheServer> otherBridges = other.getCacheServers();
        if (myBridges.size() != otherBridges.size()) {
            throw new RuntimeException("cacheServers size");
        }
        for (CacheServer myBridge1 : myBridges) {
            CacheServerCreation myBridge = (CacheServerCreation)myBridge1;
            boolean found = false;
            for (CacheServer otherBridge : otherBridges) {
                if (!myBridge.sameAs(otherBridge)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException(String.format("cache server %s not found", myBridge));
        }
        Map<String, Pool> connectionPools1 = this.getPools();
        Map<String, Pool> connectionPools2 = other instanceof CacheCreation ? ((CacheCreation)other).getPools() : PoolManager.getAll();
        int connectionPools1Size = connectionPools1.size();
        for (Pool pool2 : connectionPools1.values()) {
            if (!((PoolImpl)pool2).isUsedByGateway()) continue;
            --connectionPools1Size;
        }
        int connectionPools2Size = connectionPools2.size();
        for (Pool connectionPool3 : connectionPools2.values()) {
            if (!((PoolImpl)connectionPool3).isUsedByGateway()) continue;
            --connectionPools2Size;
        }
        if (connectionPools2Size == 1 && (pool = connectionPools2.values().iterator().next()).getName().equals("DEFAULT")) {
            connectionPools2Size = 0;
        }
        if (connectionPools1Size != connectionPools2Size) {
            throw new RuntimeException("pool sizes differ connectionPools1Size=" + connectionPools1Size + " connectionPools2Size=" + connectionPools2Size + " connectionPools1=" + String.valueOf(connectionPools1.values()) + " connectionPools2=" + String.valueOf(connectionPools2.values()));
        }
        if (connectionPools1Size > 0) {
            for (Pool pool3 : connectionPools1.values()) {
                PoolImpl poolImpl = (PoolImpl)pool3;
                if (poolImpl.isUsedByGateway()) continue;
                poolImpl.sameAs(connectionPools2.get(poolImpl.getName()));
            }
        }
        for (DiskStore diskStore : this.diskStores.values()) {
            DiskStoreAttributesCreation dsac = (DiskStoreAttributesCreation)diskStore;
            String string = dsac.getName();
            DiskStore otherDiskStore = other.findDiskStore(string);
            if (otherDiskStore == null) {
                logger.debug("Disk store {} not found.", (Object)string);
                throw new RuntimeException(String.format("Disk store %s not found", string));
            }
            if (dsac.sameAs(otherDiskStore)) continue;
            logger.debug("Attributes for disk store {} do not match", (Object)string);
            throw new RuntimeException(String.format("Attributes for disk store %s do not match", string));
        }
        Map<String, RegionAttributes<?, ?>> map = this.listRegionAttributes();
        Map otherNamedAttributes = other.listRegionAttributes();
        if (map.size() != otherNamedAttributes.size()) {
            throw new RuntimeException("namedAttributes size");
        }
        for (Object e : map.entrySet()) {
            Map.Entry myEntry = (Map.Entry)e;
            String string = (String)myEntry.getKey();
            Assert.assertTrue(myEntry.getValue() instanceof RegionAttributesCreation, "Entry value is a " + myEntry.getValue().getClass().getName());
            RegionAttributesCreation myAttrs = (RegionAttributesCreation)myEntry.getValue();
            RegionAttributes otherAttrs = other.getRegionAttributes(string);
            if (otherAttrs == null) {
                logger.debug("No attributes for {}", (Object)string);
                throw new RuntimeException(String.format("No attributes for %s", string));
            }
            if (myAttrs.sameAs(otherAttrs)) continue;
            logger.debug("Attributes for " + string + " do not match");
            throw new RuntimeException(String.format("Attributes for %s do not match", string));
        }
        Collection<Region<?, ?>> myRoots = this.roots.values();
        Set<Region<?, ?>> set = other.rootRegions();
        if (myRoots.size() != set.size()) {
            throw new RuntimeException("roots size");
        }
        for (Region region : myRoots) {
            RegionCreation rootRegion = (RegionCreation)region;
            Region otherRegion = other.getRegion(rootRegion.getName());
            if (otherRegion == null) {
                throw new RuntimeException(String.format("no root %s", rootRegion.getName()));
            }
            if (rootRegion.sameAs(otherRegion)) continue;
            throw new RuntimeException("regions differ");
        }
        if (this.getCacheTransactionManager() != null) {
            List<TransactionListener> otherTxListeners = Arrays.asList(other.getCacheTransactionManager().getListeners());
            List<TransactionListener> list = Arrays.asList(this.getCacheTransactionManager().getListeners());
            if (!list.equals(otherTxListeners)) {
                throw new RuntimeException("txListener");
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().sameAs(other.getResourceManager());
        }
        return true;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void close(boolean keepAlive) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isReconnecting() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void stopReconnecting() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Cache getReconnectedCache() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public LogWriter getLogger() {
        return this.logWriter;
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.securityLogWriter;
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.logWriter.convertToLogWriterI18n();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.securityLogWriter.convertToLogWriterI18n();
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    public InternalQueryService getInternalQueryService() {
        return this.queryService;
    }

    @Override
    public void lockDiskStore(String diskStoreName) {
    }

    @Override
    public void unlockDiskStore(String diskStoreName) {
    }

    public QueryConfigurationServiceCreation getQueryConfigurationServiceCreation() {
        return this.queryConfigurationServiceCreation;
    }

    public void setQueryConfigurationServiceCreation(QueryConfigurationServiceCreation queryConfigurationServiceCreation) {
        this.queryConfigurationServiceCreation = queryConfigurationServiceCreation;
    }

    @Override
    public JSONFormatter getJsonFormatter() {
        return new JSONFormatter();
    }

    private void throwIfClient() {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut shortcut) {
        this.throwIfClient();
        return new InternalRegionFactory((InternalCache)this, shortcut);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        this.throwIfClient();
        return new InternalRegionFactory(this);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        this.throwIfClient();
        return new InternalRegionFactory((InternalCache)this, regionAttributesId);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        this.throwIfClient();
        return new InternalRegionFactory<K, V>((InternalCache)this, regionAttributes);
    }

    public Region createVMRegion(String name, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, aRegionAttributes);
    }

    public Region createRegion(String name, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        if (aRegionAttributes instanceof RegionAttributesCreation) {
            ((RegionAttributesCreation)aRegionAttributes).inheritAttributes(this);
            ((RegionAttributesCreation)aRegionAttributes).prepareForValidation();
        }
        AttributesFactory.validateAttributes(aRegionAttributes);
        RegionCreation region = new RegionCreation(this, name, null);
        region.setAttributes(aRegionAttributes);
        this.addRootRegion(region);
        return region;
    }

    public Region createRegion(String name, String refid) throws RegionExistsException, TimeoutException {
        RegionCreation region = new RegionCreation(this, name, refid);
        this.addRootRegion(region);
        return region;
    }

    public Region getRegion(String path) {
        if (path.contains("/")) {
            throw new UnsupportedOperationException("Region path '" + path + "' contains '/'");
        }
        return this.roots.get(path);
    }

    @Override
    public CacheServer addCacheServer() {
        CacheServerCreation bridge = new CacheServerCreation((InternalCache)this, false);
        this.bridgeServers.add(bridge);
        return bridge;
    }

    @Override
    public InternalCacheServer addGatewayReceiverServer(GatewayReceiver gatewayReceiver) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public boolean removeCacheServer(CacheServer cacheServer) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean removeGatewayReceiverServer(InternalCacheServer receiverServer) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setReadSerializedForCurrentThread(boolean value) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public void setReadSerializedForTest(boolean value) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean expectDomainClass) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void waitForRegisterInterestsInProgress() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void reLoadClusterConfiguration() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public SecurityService getSecurityService() {
        return SecurityServiceFactory.create();
    }

    void addDeclarableProperties(Declarable declarable, Properties properties) {
        this.declarablePropertiesList.add(new DeclarableAndProperties(declarable, properties));
    }

    @Override
    public List<CacheServer> getCacheServers() {
        return this.bridgeServers;
    }

    @Override
    public void addGatewaySender(GatewaySender sender) {
        this.gatewaySenders.add(sender);
    }

    @Override
    public void addAsyncEventQueue(AsyncEventQueueImpl asyncQueue) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void removeAsyncEventQueue(AsyncEventQueue asyncQueue) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public QueryMonitor getQueryMonitor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void close(String reason, Throwable systemFailureCause, boolean keepAlive, boolean keepDS, boolean skipAwait) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public JmxManagerAdvisor getJmxManagerAdvisor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public List<Properties> getDeclarableProperties(String className) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public long getUpTime() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<Region<?, ?>> rootRegions(boolean includePRAdminRegions) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<InternalRegion> getAllRegions() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DistributedRegion getRegionInDestroy(String path) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DiskStoreMonitor getDiskStoreMonitor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void close(String reason, Throwable optionalCause) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public LocalRegion getRegionByPathForProcessing(String path) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public List<InternalCacheServer> getCacheServersAndGatewayReceiver() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isGlobalRegionInitializing(String fullPath) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isQueryMonitorDisabledForLowMemory() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isRESTServiceRunning() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public InternalLogWriter getInternalLogWriter() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public InternalLogWriter getSecurityInternalLogWriter() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<InternalRegion> getApplicationRegions() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void removeGatewaySender(GatewaySender sender) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DistributedLockService getGatewaySenderLockService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public RestAgent getRestAgent() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Properties getDeclarableProperties(Declarable declarable) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void close(String reason, boolean keepAlive, boolean keepDS) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addGatewayReceiver(GatewayReceiver receiver) {
        this.gatewayReceivers.add(receiver);
    }

    @Override
    public void removeGatewayReceiver(GatewayReceiver receiver) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    public void addAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueues.add(asyncEventQueue);
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> tempSet = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.gatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            tempSet.add(sender);
        }
        return tempSet;
    }

    @Override
    public GatewaySender getGatewaySender(String id) {
        for (GatewaySender sender : this.gatewaySenders) {
            if (!sender.getId().equals(id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.gatewayReceivers;
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.asyncEventQueues;
    }

    @Override
    @VisibleForTesting
    public Set<AsyncEventQueue> getAsyncEventQueues(boolean visibleOnly) {
        return this.asyncEventQueues;
    }

    @Override
    @VisibleForTesting
    public void closeDiskStores() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.asyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    @Override
    public void setIsServer(boolean isServer) {
        this.isServer = isServer;
        this.hasServer = true;
    }

    @Override
    public boolean isServer() {
        return this.isServer || !this.bridgeServers.isEmpty();
    }

    boolean hasServer() {
        return this.hasServer;
    }

    public void setDynamicRegionFactoryConfig(DynamicRegionFactory.Config v) {
        this.dynamicRegionFactoryConfig = v;
        this.hasDynamicRegionFactory = true;
    }

    boolean hasDynamicRegionFactory() {
        return this.hasDynamicRegionFactory;
    }

    DynamicRegionFactory.Config getDynamicRegionFactoryConfig() {
        return this.dynamicRegionFactoryConfig;
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.cacheTransactionManagerCreation;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
        this.hasCopyOnRead = true;
    }

    @Override
    public boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    boolean hasCopyOnRead() {
        return this.hasCopyOnRead;
    }

    public void addCacheTransactionManagerCreation(CacheTransactionManagerCreation cacheTransactionManagerCreation) {
        this.cacheTransactionManagerCreation = cacheTransactionManagerCreation;
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    @Override
    public DiskStore findDiskStore(String name) {
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return this.diskStores.get(name);
    }

    public void addDiskStore(DiskStore ds) {
        this.diskStores.put(ds.getName(), ds);
    }

    @Override
    public Collection<DiskStore> listDiskStores() {
        return this.diskStores.values();
    }

    void setDiskStore(String name, DiskStoreAttributesCreation diskStoreAttributesCreation) {
        this.diskStores.put(name, diskStoreAttributesCreation);
    }

    public RegionAttributes getRegionAttributes(String id) {
        return this.namedRegionAttributes.get(id);
    }

    public void setRegionAttributes(String id, RegionAttributes attrs) {
        RegionAttributes regionAttributes = attrs;
        if (!(regionAttributes instanceof RegionAttributesCreation)) {
            regionAttributes = new RegionAttributesCreation(this, regionAttributes, false);
        }
        this.namedRegionAttributes.put(id, regionAttributes);
        this.regionAttributesNames.add(id);
    }

    public Map<String, RegionAttributes<?, ?>> listRegionAttributes() {
        return Collections.unmodifiableMap(this.namedRegionAttributes);
    }

    @Override
    public void loadCacheXml(InputStream is) throws TimeoutException, CacheWriterException, RegionExistsException {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void readyForEvents() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    public Map<String, Pool> getPools() {
        return this.poolManager.getMap();
    }

    public PoolFactory createPoolFactory() {
        return new PoolFactoryImpl(this.poolManager).setStartDisabled(true);
    }

    boolean hasFunctionService() {
        return this.hasFunctionService;
    }

    public void setFunctionServiceCreation(FunctionServiceCreation functionServiceCreation) {
        this.hasFunctionService = true;
        this.functionServiceCreation = functionServiceCreation;
    }

    FunctionServiceCreation getFunctionServiceCreation() {
        return this.functionServiceCreation;
    }

    public void setResourceManagerCreation(ResourceManagerCreation resourceManagerCreation) {
        this.hasResourceManager = true;
        this.resourceManagerCreation = resourceManagerCreation;
    }

    @Override
    public ResourceManagerCreation getResourceManager() {
        return this.resourceManagerCreation;
    }

    boolean hasResourceManager() {
        return this.hasResourceManager;
    }

    public void setSerializerCreation(SerializerCreation serializerCreation) {
        this.serializerCreation = serializerCreation;
    }

    SerializerCreation getSerializerCreation() {
        return this.serializerCreation;
    }

    public void addBackup(File backup) {
        this.backups.add(backup);
    }

    @Override
    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backups);
    }

    @Override
    public <K, V> Region<K, V> getRegionByPath(String path) {
        return null;
    }

    @Override
    public InternalRegion getInternalRegionByPath(String path) {
        return null;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public InternalDistributedSystem getInternalDistributedSystem() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<PartitionedRegion> getPartitionedRegions() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addRegionListener(RegionListener regionListener) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void removeRegionListener(RegionListener regionListener) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<RegionListener> getRegionListeners() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return WANServiceProvider.createGatewaySenderFactory(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return WANServiceProvider.createGatewayReceiverFactory(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    public void setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
    }

    public void setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
    }

    public void setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
    }

    public void setPdxDiskStore(String diskStore) {
        this.cacheConfig.setPdxDiskStore(diskStore);
    }

    public void setPdxPersistent(boolean persistent) {
        this.cacheConfig.setPdxPersistent(persistent);
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.isPdxReadSerialized();
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.getPdxSerializer();
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.getPdxDiskStore();
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.isPdxPersistent();
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.getPdxIgnoreUnreadFields();
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public boolean getPdxReadSerializedByAnyGemFireServices() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void initializePdxRegistry() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void readyDynamicRegionFactory() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setBackupFiles(List<File> backups) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.emptySet();
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return Collections.emptySet();
    }

    @Override
    public Set<DistributedMember> getMembers(Region region) {
        return Collections.emptySet();
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    @Override
    public void setInitializer(Declarable declarable, Properties props) {
        this.initializer = declarable;
        this.initializerProps = props;
    }

    @Override
    public boolean hasPool() {
        return false;
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return null;
    }

    @Override
    public <K, V> Region<K, V> basicCreateRegion(String name, RegionAttributes<K, V> attrs) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public BackupService getBackupService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public Throwable getDisconnectCause() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addPartitionedRegion(PartitionedRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void removePartitionedRegion(PartitionedRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void addDiskStore(DiskStoreImpl dsi) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TXEntryStateFactory getTXEntryStateFactory() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public EventTrackerExpiryTask getEventTrackerTask() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void removeDiskStore(DiskStoreImpl diskStore) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    void runInitializer(InternalCache cache) {
        Declarable initializer = this.getInitializer();
        if (initializer != null) {
            initializer.initialize(cache, this.getInitializerProps());
            initializer.init(this.getInitializerProps());
        }
    }

    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        this.gatewayConflictResolver = resolver;
    }

    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }

    @Override
    public InternalDistributedMember getMyId() {
        return null;
    }

    @Override
    public Collection<DiskStore> listDiskStoresIncludingRegionOwned() {
        return null;
    }

    @Override
    public CqService getCqService() {
        return null;
    }

    private InternalQueryService createInternalQueryService() {
        return new InternalQueryService(){
            private final Map<String, List<Index>> indexes = new HashMap<String, List<Index>>();

            @Override
            public Query newQuery(String queryString) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public Index createHashIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, UnsupportedOperationException {
                return this.createHashIndex(indexName, indexedExpression, regionPath, "");
            }

            @Override
            public Index createHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, UnsupportedOperationException {
                return this.createIndex(indexName, IndexType.HASH, indexedExpression, regionPath, imports);
            }

            @Override
            public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, UnsupportedOperationException {
                return this.createIndex(indexName, indexType, indexedExpression, fromClause, "");
            }

            @Override
            public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, UnsupportedOperationException {
                IndexCreationData indexData = new IndexCreationData(indexName);
                indexData.setFunctionalIndexData(fromClause, indexedExpression, imports);
                indexData.setIndexType(indexType.toString());
                List<Index> indexesForRegion = this.indexes.get(fromClause);
                if (indexesForRegion == null) {
                    indexesForRegion = new ArrayList<Index>();
                    this.indexes.put(fromClause, indexesForRegion);
                }
                indexesForRegion.add(indexData);
                return indexData;
            }

            @Override
            public Index createIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, UnsupportedOperationException {
                return this.createIndex(indexName, indexedExpression, regionPath, "");
            }

            @Override
            public Index createIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, UnsupportedOperationException {
                return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, regionPath, imports);
            }

            @Override
            public Index createKeyIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, UnsupportedOperationException {
                return this.createIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, regionPath, "");
            }

            @Override
            public Index getIndex(Region<?, ?> region, String indexName) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public Collection<Index> getIndexes() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public Collection<Index> getIndexes(Region<?, ?> region) {
                List<Index> indexes = this.indexes.get(region.getFullPath());
                return indexes != null ? indexes : Collections.emptyList();
            }

            @Override
            public Collection<Index> getIndexes(Region<?, ?> region, IndexType indexType) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void removeIndex(Index index) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void removeIndexes() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void removeIndexes(Region<?, ?> region) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery newCq(String queryString, CqAttributes cqAttr) throws QueryInvalidException {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery newCq(String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery newCq(String name, String queryString, CqAttributes cqAttr) throws QueryInvalidException {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery newCq(String name, String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void closeCqs() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery[] getCqs() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery[] getCqs(String regionName) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqQuery getCq(String cqName) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void executeCqs() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void stopCqs() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void executeCqs(String regionName) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void stopCqs(String regionName) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public List<String> getAllDurableCqsFromServer() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public CqServiceStatistics getCqStatistics() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void defineKeyIndex(String indexName, String indexedExpression, String regionPath) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void defineHashIndex(String indexName, String indexedExpression, String regionPath) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void defineHashIndex(String indexName, String indexedExpression, String regionPath, String imports) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void defineIndex(String indexName, String indexedExpression, String regionPath) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public void defineIndex(String indexName, String indexedExpression, String regionPath, String imports) {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public List<Index> createDefinedIndexes() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public boolean clearDefinedIndexes() {
                throw new UnsupportedOperationException("Should not be invoked");
            }

            @Override
            public MethodInvocationAuthorizer getMethodInvocationAuthorizer() {
                throw new UnsupportedOperationException("Should not be invoked");
            }
        };
    }

    @Override
    public <T extends CacheService> T getService(Class<T> clazz) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public <T extends CacheService> Optional<T> getOptionalService(Class<T> clazz) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Collection<CacheService> getServices() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public SystemTimer getCCPTimer() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void cleanupForClient(CacheClientNotifier cacheClientNotifier, ClientProxyMembershipID client) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void purgeCCPTimer() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public FilterProfile getFilterProfile(String regionName) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    public Region getRegion(String path, boolean returnDestroyedRegion) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public MemoryAllocator getOffHeapStore() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DistributedLockService getPartitionedRegionLockService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public PersistentMemberManager getPersistentMemberManager() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Set<GatewaySender> getAllGatewaySenders() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DistributionManager getDistributionManager() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    public void regionReinitialized(Region region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setRegionByPath(String path, InternalRegion r) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public InternalResourceManager getInternalResourceManager() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public ResourceAdvisor getResourceAdvisor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isCacheAtShutdownAll() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean requiresNotificationFromPR(PartitionedRegion r) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public <K, V> RegionAttributes<K, V> invokeRegionBefore(InternalRegion parent, String name, RegionAttributes<K, V> attrs, InternalRegionArguments internalRegionArgs) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void invokeRegionAfter(InternalRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void invokeBeforeDestroyed(InternalRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void invokeCleanupFailedInitialization(InternalRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TXManagerImpl getTXMgr() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean forcedDisconnect() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public InternalResourceManager getInternalResourceManager(boolean checkCancellationInProgress) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean isCopyOnRead() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TombstoneService getTombstoneService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public QueryService getLocalQueryService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void registerInterestStarted() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void registerInterestCompleted() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void regionReinitializing(String fullPath) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void unregisterReinitializingRegion(String fullPath) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean removeRoot(InternalRegion rootRgn) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Executor getEventThreadPool() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public LocalRegion getReinitializingRegion(String fullPath) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean keepDurableSubscriptionsAlive() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TypeRegistry getPdxRegistry() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public ExpirationScheduler getExpirationScheduler() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TransactionManager getJTATransactionManager() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public TXManagerImpl getTxManager() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void beginDestroy(String path, DistributedRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void endDestroy(String path, DistributedRegion region) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public ClientMetadataService getClientMetadataService() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public long cacheTimeMillis() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public URL getCacheXmlURL() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean hasPersistentRegion() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void shutDownAll() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void invokeRegionEntrySynchronizationListenersAfterSynchronization(InternalDistributedMember sender, InternalRegion region, List<InitialImageOperation.Entry> entriesToSynchronize) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Object convertPdxInstanceIfNeeded(Object obj, boolean preferCD) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Boolean getPdxReadSerializedOverride() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void setPdxReadSerializedOverride(boolean pdxReadSerialized) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void registerPdxMetaData(Object instance) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public InternalCacheForClientAccess getCacheForProcessingClientRequests() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void throwCacheExistsException() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void saveCacheXmlForReconnect() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public HeapEvictor getHeapEvictor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    @VisibleForTesting
    public OffHeapEvictor getOffHeapEvictor() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public StatisticsClock getStatisticsClock() {
        return StatisticsClockFactory.disabledClock();
    }

    CacheTransactionManagerCreation getCacheTransactionManagerCreation() {
        return this.cacheTransactionManagerCreation;
    }

    List<String> getRegionAttributesNames() {
        return this.regionAttributesNames;
    }

    private static class DeclarableAndProperties {
        private final Declarable declarable;
        private final Properties properties;

        private DeclarableAndProperties(Declarable d, Properties p) {
            this.declarable = d;
            this.properties = p;
        }

        public Declarable getDeclarable() {
            return this.declarable;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

