/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.AbstractBucketRegionQueue;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.partitioned.colocation.ColocationLoggerFactory;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AsyncEventQueueConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.BucketRegionQueueUnavailableException;
import org.apache.geode.internal.cache.wan.parallel.ParallelQueueRemovalMessage;
import org.apache.geode.internal.cache.wan.parallel.RREventIDResolver;
import org.apache.geode.internal.size.SingleObjectSizer;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.util.concurrent.StoppableCondition;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBean;
import org.apache.geode.management.internal.beans.GatewaySenderMBean;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderQueue
implements RegionQueue {
    protected static final Logger logger = LogService.getLogger();
    protected final Map<String, PartitionedRegion> userRegionNameToShadowPRMap = new ConcurrentHashMap<String, PartitionedRegion>();
    private static final String SHADOW_BUCKET_PATH_PREFIX = "/__PR/";
    private final Map<String, Map<Integer, List<Object>>> regionToDispatchedKeysMap = new ConcurrentHashMap<String, Map<Integer, List<Object>>>();
    protected final StoppableReentrantLock buckToDispatchLock;
    private final StoppableCondition regionToDispatchedKeysMapEmpty;
    protected final StoppableReentrantLock queueEmptyLock;
    private volatile boolean isQueueEmpty = true;
    private final boolean cleanQueues;
    private final boolean asyncEvent;
    private final StoppableCondition queueEmptyCondition;
    protected final GatewaySenderStats stats;
    protected volatile boolean resetLastPeeked = false;
    private final ConcurrentMap<Integer, BlockingQueue<GatewaySenderEventImpl>> bucketToTempQueueMap = new ConcurrentHashMap<Integer, BlockingQueue<GatewaySenderEventImpl>>();
    public static final int DEFAULT_MESSAGE_SYNC_INTERVAL = 10;
    @MutableForTesting
    protected static volatile int messageSyncInterval = 10;
    private BatchRemovalThread removalThread = null;
    protected BlockingQueue<GatewaySenderEventImpl> peekedEvents = new LinkedBlockingQueue<GatewaySenderEventImpl>();
    private final BlockingQueue<GatewaySenderEventImpl> peekedEventsProcessing = new LinkedBlockingQueue<GatewaySenderEventImpl>();
    private boolean peekedEventsProcessingInProgress = false;
    public final AbstractGatewaySender sender;
    public static final int WAIT_CYCLE_SHADOW_BUCKET_LOAD = 10;
    public static final String QSTRING = "_PARALLEL_GATEWAY_SENDER_QUEUE";
    private ExecutorService conflationExecutor;
    protected final int index;
    protected final int nDispatcher;
    private final MetaRegionFactory metaRegionFactory;
    private int pickBucketId;

    @VisibleForTesting
    boolean getCleanQueues() {
        return this.cleanQueues;
    }

    public ParallelGatewaySenderQueue(AbstractGatewaySender sender, Set<Region<?, ?>> userRegions, int idx, int nDispatcher, boolean cleanQueues) {
        this(sender, userRegions, idx, nDispatcher, new MetaRegionFactory(), cleanQueues);
    }

    ParallelGatewaySenderQueue(AbstractGatewaySender sender, Set<Region<?, ?>> userRegions, int idx, int nDispatcher, MetaRegionFactory metaRegionFactory, boolean cleanQueues) {
        this.metaRegionFactory = metaRegionFactory;
        this.cleanQueues = cleanQueues;
        this.index = idx;
        this.nDispatcher = nDispatcher;
        this.stats = sender.getStatistics();
        this.sender = sender;
        this.asyncEvent = this.sender.getId().contains("AsyncEventQueue_");
        ArrayList listOfRegions = new ArrayList(userRegions);
        Collections.sort(listOfRegions, (o1, o2) -> o1.getFullPath().compareTo(o2.getFullPath()));
        for (Region region : listOfRegions) {
            if (region instanceof PartitionedRegion) {
                this.addShadowPartitionedRegionForUserPR((PartitionedRegion)region);
                if (this.index != 0 || this.getRegion(region.getFullPath()) == null) continue;
                this.stats.incQueueSize(this.getRegion(region.getFullPath()).getLocalSize());
                continue;
            }
            if (this.asyncEvent) {
                throw new AsyncEventQueueConfigurationException(String.format("Parallel Async Event Queue %s can not be used with replicated region %s", AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.sender.getId()), region.getFullPath()));
            }
            throw new GatewaySenderConfigurationException(String.format("Parallel Gateway Sender %s can not be used with replicated region %s", this.sender.getId(), region.getFullPath()));
        }
        this.buckToDispatchLock = new StoppableReentrantLock(sender.getCancelCriterion());
        this.regionToDispatchedKeysMapEmpty = this.buckToDispatchLock.newCondition();
        this.queueEmptyLock = new StoppableReentrantLock(sender.getCancelCriterion());
        this.queueEmptyCondition = this.queueEmptyLock.newCondition();
        if (sender.isBatchConflationEnabled()) {
            this.initializeConflationThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<ParallelGatewaySenderQueue> clazz = ParallelGatewaySenderQueue.class;
        synchronized (ParallelGatewaySenderQueue.class) {
            if (this.removalThread == null) {
                this.removalThread = new BatchRemovalThread(this.sender.getCache(), this);
                this.removalThread.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        block19: {
            PartitionedRegion prQ;
            block17: {
                block18: {
                    this.sender.getLifeCycleLock().writeLock().lock();
                    prQ = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug("addShadowPartitionedRegionForUserRR: Going to create shadowpr for userRegion {}", (Object)userRegion.getFullPath());
                    }
                    String regionName = userRegion.getFullPath();
                    if (!this.userRegionNameToShadowPRMap.containsKey(regionName)) break block17;
                    if (prQ == null) break block18;
                    this.userRegionNameToShadowPRMap.put(userRegion.getFullPath(), prQ);
                }
                this.sender.getLifeCycleLock().writeLock().unlock();
                return;
            }
            try {
                InternalCache cache = this.sender.getCache();
                String prQName = ParallelGatewaySenderQueue.getQueueName(this.sender.getId(), userRegion.getFullPath());
                prQ = (PartitionedRegion)cache.getRegion(prQName);
                if (prQ == null) {
                    InternalRegionFactory fact = cache.createInternalRegionFactory();
                    fact.setConcurrencyChecksEnabled(false);
                    PartitionAttributesFactory pfact = new PartitionAttributesFactory();
                    pfact.setTotalNumBuckets(this.sender.getMaxParallelismForReplicatedRegion());
                    int localMaxMemory = userRegion.getDataPolicy().withStorage() ? this.sender.getMaximumQueueMemory() : 0;
                    pfact.setLocalMaxMemory(localMaxMemory);
                    pfact.setRedundantCopies(3);
                    pfact.setPartitionResolver(new RREventIDResolver());
                    if (this.sender.isPersistenceEnabled()) {
                        fact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    }
                    fact.setDiskStoreName(this.sender.getDiskStoreName());
                    if (this.sender.isPersistenceEnabled()) {
                        fact.setDiskSynchronous(this.sender.isDiskSynchronous());
                    } else {
                        fact.setDiskSynchronous(false);
                    }
                    EvictionAttributes ea = EvictionAttributes.createLIFOMemoryAttributes(this.sender.getMaximumQueueMemory(), EvictionAction.OVERFLOW_TO_DISK);
                    fact.setEvictionAttributes(ea);
                    fact.setPartitionAttributes(pfact.create());
                    RegionAttributes ra = fact.getCreateAttributes();
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Attempting to create queue region: {}", (Object)this, (Object)prQName);
                    }
                    ParallelGatewaySenderQueueMetaRegion meta = new ParallelGatewaySenderQueueMetaRegion(prQName, ra, null, cache, this.sender, this.sender.getStatisticsClock());
                    fact.setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null);
                    prQ = (PartitionedRegion)fact.create(prQName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Region created  : {} partition Attributes : {}", (Object)prQ, (Object)prQ.getPartitionAttributes());
                    }
                    prQ.enableConflation(this.sender.isBatchConflationEnabled());
                    if (prQ.getLocalMaxMemory() != 0) {
                        for (Integer n : prQ.getRegionAdvisor().getBucketSet()) {
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Created queue region: {}", (Object)this, (Object)prQ);
                    }
                } else if (this.index == 0) {
                    this.handleShadowPRExistsScenario(cache, prQ);
                }
                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                    this.sender.enqueueTempEvents();
                }
                if (prQ == null) break block19;
                this.userRegionNameToShadowPRMap.put(userRegion.getFullPath(), prQ);
            }
            catch (Throwable throwable) {
                if (prQ != null) {
                    this.userRegionNameToShadowPRMap.put(userRegion.getFullPath(), prQ);
                }
                this.sender.getLifeCycleLock().writeLock().unlock();
                throw throwable;
            }
        }
        this.sender.getLifeCycleLock().writeLock().unlock();
    }

    private static String convertPathToName(String fullPath) {
        return "";
    }

    public void addShadowPartitionedRegionForUserPR(PartitionedRegion userPR) {
        this.addShadowPartitionedRegionForUserPR(userPR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void addShadowPartitionedRegionForUserPR(PartitionedRegion userPR, PartitionedRegion childPR) {
        block37: {
            block38: {
                block39: {
                    block35: {
                        block36: {
                            block33: {
                                block34: {
                                    block31: {
                                        block32: {
                                            block29: {
                                                block30: {
                                                    if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                                                        ParallelGatewaySenderQueue.logger.debug("{} addShadowPartitionedRegionForUserPR: Attempting to create queue region: {}; child region: {}", (Object)this, (Object)userPR.getDisplayName(), (Object)(childPR == null ? "null" : childPR.getDisplayName()));
                                                    }
                                                    this.sender.getLifeCycleLock().writeLock().lock();
                                                    prQ = null;
                                                    regionName = userPR.getFullPath();
                                                    leaderRegionName = ColocationHelper.getLeaderRegion(userPR).getFullPath();
                                                    if (regionName.equals(leaderRegionName)) break block29;
                                                    if (!this.userRegionNameToShadowPRMap.containsKey(leaderRegionName)) {
                                                        this.addShadowPartitionedRegionForUserPR(ColocationHelper.getLeaderRegion(userPR), userPR);
                                                    }
                                                    if (prQ == null) break block30;
                                                    this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                                                }
                                                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                                    this.sender.enqueueTempEvents();
                                                }
                                                this.afterRegionAdd(userPR);
                                                this.sender.getLifeCycleLock().writeLock().unlock();
                                                return;
                                            }
                                            if (!this.userRegionNameToShadowPRMap.containsKey(regionName)) break block31;
                                            if (prQ == null) break block32;
                                            this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                                        }
                                        if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                            this.sender.enqueueTempEvents();
                                        }
                                        this.afterRegionAdd(userPR);
                                        this.sender.getLifeCycleLock().writeLock().unlock();
                                        return;
                                    }
                                    try {
                                        if ((childPR == null ? userPR : childPR).getDataPolicy().withPersistence() && !this.sender.isPersistenceEnabled()) {
                                            throw new GatewaySenderException(String.format("Non persistent gateway sender %s can not be attached to persistent region %s", new Object[]{this.sender.getId(), userPR.getFullPath()}));
                                        }
                                        cache = this.sender.getCache();
                                        isAccessor = userPR.getLocalMaxMemory() == 0;
                                        prQName = this.sender.getId() + "_PARALLEL_GATEWAY_SENDER_QUEUE" + ParallelGatewaySenderQueue.convertPathToName(userPR.getFullPath());
                                        prQ = (PartitionedRegion)cache.getRegion(prQName, true);
                                        if (prQ != null && prQ.isDestroyed()) {
                                            oldPrQ = prQ;
                                            while (oldPrQ == prQ) {
                                                try {
                                                    Thread.sleep(50L);
                                                }
                                                catch (InterruptedException e) {
                                                    Thread.currentThread().interrupt();
                                                }
                                                if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                                                    ParallelGatewaySenderQueue.logger.debug("wait for destroy to finish");
                                                }
                                                prQ = (PartitionedRegion)cache.getRegion(prQName, true);
                                            }
                                        }
                                        if (prQ != null && this.index == 0 && this.cleanQueues) {
                                            this.cleanOverflowStats(cache);
                                            prQ.destroyRegion(null);
                                            prQ = null;
                                        }
                                        if (prQ != null) ** GOTO lbl142
                                        regionShortcut = this.sender.isPersistenceEnabled() != false && isAccessor == false ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION;
                                        fact = cache.createInternalRegionFactory(regionShortcut);
                                        fact.setConcurrencyChecksEnabled(false);
                                        pfact = new PartitionAttributesFactory<K, V>();
                                        pfact.setTotalNumBuckets(userPR.getTotalNumberOfBuckets());
                                        pfact.setRedundantCopies(userPR.getRedundantCopies());
                                        pfact.setColocatedWith(regionName);
                                        localMaxMemory = isAccessor != false ? 0 : this.sender.getMaximumQueueMemory();
                                        pfact.setLocalMaxMemory(localMaxMemory);
                                        pfact.setStartupRecoveryDelay(userPR.getPartitionAttributes().getStartupRecoveryDelay());
                                        pfact.setRecoveryDelay(userPR.getPartitionAttributes().getRecoveryDelay());
                                        fact.setDiskStoreName(this.sender.getDiskStoreName());
                                        if (this.sender.isPersistenceEnabled()) {
                                            fact.setDiskSynchronous(this.sender.isDiskSynchronous());
                                        } else {
                                            fact.setDiskSynchronous(false);
                                        }
                                        ea = EvictionAttributes.createLIFOMemoryAttributes(this.sender.getMaximumQueueMemory(), EvictionAction.OVERFLOW_TO_DISK);
                                        fact.setEvictionAttributes(ea);
                                        fact.setPartitionAttributes(pfact.create());
                                        ra = fact.getCreateAttributes();
                                        if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                                            ParallelGatewaySenderQueue.logger.debug("{}: Attempting to create queue region: {}", (Object)this, (Object)prQName);
                                        }
                                        meta = this.metaRegionFactory.newMetataRegion(cache, prQName, ra, this.sender);
                                        fact.setInternalMetaRegion(meta);
                                        fact.setDestroyLockFlag(true);
                                        fact.setInternalRegion(true);
                                        fact.setSnapshotInputStream(null);
                                        fact.setImageTarget(null);
                                        prQ = (PartitionedRegion)fact.create(prQName);
                                        if (prQ != null) break block33;
                                        if (prQ == null) break block34;
                                        this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                                    }
                                    catch (Throwable var16_17) {
                                        if (prQ != null) {
                                            this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                                        }
                                        if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                            this.sender.enqueueTempEvents();
                                        }
                                        this.afterRegionAdd(userPR);
                                        this.sender.getLifeCycleLock().writeLock().unlock();
                                        throw var16_17;
                                    }
                                }
                                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                    this.sender.enqueueTempEvents();
                                }
                                this.afterRegionAdd(userPR);
                                this.sender.getLifeCycleLock().writeLock().unlock();
                                return;
                            }
                            prQ.enableConflation(this.sender.isBatchConflationEnabled());
                            if (!isAccessor) break block35;
                            if (prQ == null) break block36;
                            this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                        }
                        if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                            this.sender.enqueueTempEvents();
                        }
                        this.afterRegionAdd(userPR);
                        this.sender.getLifeCycleLock().writeLock().unlock();
                        return;
                    }
                    this.addOverflowStatisticsToMBean(cache, prQ);
                    prQ.shadowPRWaitForBucketRecovery();
                    if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                        ParallelGatewaySenderQueue.logger.debug("{}: Created queue region: {}", (Object)this, (Object)prQ);
                    }
                    break block37;
lbl142:
                    // 1 sources

                    if (!isAccessor) break block38;
                    if (prQ == null) break block39;
                    this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
                }
                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                    this.sender.enqueueTempEvents();
                }
                this.afterRegionAdd(userPR);
                this.sender.getLifeCycleLock().writeLock().unlock();
                return;
            }
            if (this.index != 0) break block37;
            this.handleShadowPRExistsScenario(cache, prQ);
        }
        if (prQ != null) {
            this.userRegionNameToShadowPRMap.put(userPR.getFullPath(), prQ);
        }
        if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
            this.sender.enqueueTempEvents();
        }
        this.afterRegionAdd(userPR);
        this.sender.getLifeCycleLock().writeLock().unlock();
    }

    private void addOverflowStatisticsToMBean(Cache cache, PartitionedRegion prQ) {
        ManagementService service = ManagementService.getManagementService(cache);
        if (this.asyncEvent) {
            AsyncEventQueueMBean bean = (AsyncEventQueueMBean)service.getLocalAsyncEventQueueMXBean(AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.sender.getId()));
            if (bean != null) {
                bean.getBridge().addOverflowStatistics(prQ.getEvictionStatistics());
                bean.getBridge().addOverflowStatistics(prQ.getDiskRegionStats().getStats());
            }
        } else {
            GatewaySenderMBean bean = (GatewaySenderMBean)service.getLocalGatewaySenderMXBean(this.sender.getId());
            if (bean != null) {
                bean.getBridge().addOverflowStatistics(prQ.getEvictionStatistics());
                bean.getBridge().addOverflowStatistics(prQ.getDiskRegionStats().getStats());
            }
        }
    }

    private void cleanOverflowStats(Cache cache) {
        GatewaySenderMBean bean;
        ManagementService service = ManagementService.getManagementService(cache);
        if (!this.asyncEvent && (bean = (GatewaySenderMBean)service.getLocalGatewaySenderMXBean(this.sender.getId())) != null) {
            bean.getBridge().clearOverflowStatistics();
        }
    }

    private void handleShadowPRExistsScenario(Cache cache, PartitionedRegion prQ) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: No need to create the region as the region has been retrieved: {}", (Object)this, (Object)prQ);
        }
    }

    protected void afterRegionAdd(PartitionedRegion userPR) {
    }

    private void initializeConflationThreadPool() {
        int poolSize = Runtime.getRuntime().availableProcessors();
        this.conflationExecutor = LoggingExecutors.newFixedThreadPool((int)poolSize, (String)"WAN Queue Conflation Thread", (boolean)true);
    }

    private void cleanupConflationThreadPool(AbstractGatewaySender sender) {
        if (this.conflationExecutor == null) {
            return;
        }
        this.conflationExecutor.shutdown();
        try {
            if (!this.conflationExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.conflationExecutor.shutdownNow();
                if (!this.conflationExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    logger.warn("Conflation thread pool did not terminate for the GatewaySender : {}", sender == null ? "all" : sender);
                }
            }
        }
        catch (InterruptedException e) {
            this.conflationExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Object object) throws InterruptedException, CacheException {
        boolean putDone;
        block43: {
            boolean isDebugEnabled = logger.isDebugEnabled();
            putDone = false;
            GatewaySenderEventImpl value = (GatewaySenderEventImpl)object;
            boolean isDREvent = this.isDREvent(this.sender.getCache(), value);
            String regionPath = value.getRegionPath();
            if (!isDREvent) {
                Region region = this.sender.getCache().getRegion(regionPath, true);
                regionPath = ColocationHelper.getLeaderRegion((PartitionedRegion)region).getFullPath();
            }
            if (isDebugEnabled) {
                logger.debug("Put is for the region {}", (Object)regionPath);
            }
            if (!this.userRegionNameToShadowPRMap.containsKey(regionPath)) {
                if (isDebugEnabled) {
                    logger.debug("The userRegionNameToshadowPRMap is {}", this.userRegionNameToShadowPRMap);
                }
                logger.warn("GatewaySender: Not queuing the event {}, as the region for which this event originated is not yet configured in the GatewaySender", (Object)value);
                return false;
            }
            PartitionedRegion prQ = this.userRegionNameToShadowPRMap.get(regionPath);
            int bucketId = value.getBucketId();
            Serializable key = null;
            if (!isDREvent) {
                key = value.getShadowKey();
                if ((Long)key == -1L) {
                    if (isDebugEnabled) {
                        logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {}", (Object)key, (Object)value);
                    }
                    return false;
                }
            } else {
                key = value.getEventId();
            }
            if (isDebugEnabled) {
                logger.debug("ParallelGatewaySenderOrderedQueue putting key {} : Value : {}", (Object)key, (Object)value);
            }
            AbstractBucketRegionQueue brq = (AbstractBucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
            try {
                if (brq == null) {
                    String bucketFullPath = SHADOW_BUCKET_PATH_PREFIX + prQ.getBucketName(bucketId);
                    LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.BEFORE_INITIAL_IMAGE);
                    try {
                        brq = (AbstractBucketRegionQueue)prQ.getCache().getInternalRegionByPath(bucketFullPath);
                        if (isDebugEnabled) {
                            logger.debug("ParallelGatewaySenderOrderedQueue : The bucket in the cache is bucketRegionName : {} bucket : {}", (Object)bucketFullPath, (Object)brq);
                        }
                        if (brq != null) {
                            boolean intializingLocked = brq.lockWhenRegionIsInitializing();
                            brq.getInitializationLock().readLock().lock();
                            try {
                                this.putIntoBucketRegionQueue(brq, key, value);
                                putDone = true;
                                break block43;
                            }
                            finally {
                                brq.getInitializationLock().readLock().unlock();
                                if (intializingLocked) {
                                    brq.unlockWhenRegionIsInitializing();
                                }
                            }
                        }
                        if (isDREvent) {
                            break block43;
                        }
                        if (prQ.getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).isShadowBucketDestroyed(bucketFullPath)) {
                            if (isDebugEnabled) {
                                logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {} as shadowPR bucket is destroyed.", (Object)key, (Object)value);
                            }
                            break block43;
                        }
                        LinkedBlockingQueue<GatewaySenderEventImpl> tempQueue = null;
                        Object object2 = this.bucketToTempQueueMap;
                        synchronized (object2) {
                            tempQueue = (LinkedBlockingQueue<GatewaySenderEventImpl>)this.bucketToTempQueueMap.get(bucketId);
                            if (tempQueue == null) {
                                tempQueue = new LinkedBlockingQueue<GatewaySenderEventImpl>();
                                this.bucketToTempQueueMap.put(bucketId, tempQueue);
                            }
                        }
                        object2 = tempQueue;
                        synchronized (object2) {
                            brq = (AbstractBucketRegionQueue)prQ.getCache().getInternalRegionByPath(bucketFullPath);
                            if (brq != null) {
                                boolean intializingLocked = brq.lockWhenRegionIsInitializing();
                                brq.getInitializationLock().readLock().lock();
                                try {
                                    this.putIntoBucketRegionQueue(brq, key, value);
                                    putDone = true;
                                }
                                finally {
                                    brq.getInitializationLock().readLock().unlock();
                                    if (intializingLocked) {
                                        brq.unlockWhenRegionIsInitializing();
                                    }
                                }
                            } else {
                                tempQueue.add(value);
                                putDone = true;
                                if (isDebugEnabled) {
                                    logger.debug("The value {} is enqueued to the tempQueue for the BucketRegionQueue.", (Object)value);
                                }
                            }
                            break block43;
                        }
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                    }
                }
                boolean thisBucketDestroyed = brq.isDestroyed();
                if (!isDREvent) {
                    String bucketFullPath = SHADOW_BUCKET_PATH_PREFIX + prQ.getBucketName(bucketId);
                    thisBucketDestroyed |= prQ.getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).isShadowBucketDestroyed(bucketFullPath);
                }
                if (!thisBucketDestroyed) {
                    this.putIntoBucketRegionQueue(brq, key, value);
                    putDone = true;
                } else if (isDebugEnabled) {
                    logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {} as shadowPR bucket is destroyed.", (Object)key, (Object)value);
                }
            }
            finally {
                this.notifyEventProcessorIfRequired();
            }
        }
        return putDone;
    }

    public void notifyEventProcessorIfRequired() {
        if (this.isQueueEmpty) {
            this.queueEmptyLock.lock();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Going to notify, isQueueEmpty {}", (Object)this.isQueueEmpty);
                }
                if (this.isQueueEmpty) {
                    this.isQueueEmpty = false;
                    this.queueEmptyCondition.signal();
                }
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("Notified!, isQueueEmpty {}", (Object)this.isQueueEmpty);
                }
                this.queueEmptyLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putIntoBucketRegionQueue(AbstractBucketRegionQueue brq, Object key, GatewaySenderEventImpl value) {
        boolean addedValueToQueue = false;
        try {
            if (brq != null) {
                addedValueToQueue = brq.addToQueue(key, value);
            }
        }
        catch (BucketNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("For bucket {} the current bucket redundancy is {}", (Object)brq.getId(), (Object)brq.getPartitionedRegion().getRegionAdvisor().getBucketAdvisor(brq.getId()).getBucketRedundancy());
            }
        }
        catch (ForceReattemptException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("getInitializedBucketForId: Got ForceReattemptException for {} for bucket = {}", (Object)this, (Object)brq.getId());
            }
        }
        finally {
            if (!addedValueToQueue) {
                value.release();
            }
        }
    }

    @Override
    public Region getRegion() {
        return this.userRegionNameToShadowPRMap.size() == 1 ? (Region)this.userRegionNameToShadowPRMap.values().toArray()[0] : null;
    }

    public PartitionedRegion getRegion(String fullpath) {
        return this.userRegionNameToShadowPRMap.get(fullpath);
    }

    public PartitionedRegion removeShadowPR(String fullpath) {
        try {
            this.sender.getLifeCycleLock().writeLock().lock();
            this.sender.setEnqueuedAllTempQueueEvents(false);
            PartitionedRegion partitionedRegion = this.userRegionNameToShadowPRMap.remove(fullpath);
            return partitionedRegion;
        }
        finally {
            this.sender.getLifeCycleLock().writeLock().unlock();
        }
    }

    public ExecutorService getConflationExecutor() {
        return this.conflationExecutor;
    }

    public Set<PartitionedRegion> getRegions() {
        return new HashSet<PartitionedRegion>(this.userRegionNameToShadowPRMap.values());
    }

    protected PartitionedRegion getRandomShadowPR() {
        PartitionedRegion prQ = null;
        if (this.userRegionNameToShadowPRMap.values().size() > 0) {
            int randomIndex = new Random().nextInt(this.userRegionNameToShadowPRMap.size());
            prQ = (PartitionedRegion)this.userRegionNameToShadowPRMap.values().toArray()[randomIndex];
        }
        return prQ;
    }

    boolean isDREvent(InternalCache cache, GatewaySenderEventImpl event) {
        Region region = cache.getRegion(event.getRegionPath());
        return region instanceof DistributedRegion;
    }

    @Override
    public Object take() throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean areLocalBucketQueueRegionsPresent() {
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            if (prQ.getDataStore().getAllLocalBucketRegions().size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected int getRandomPrimaryBucket(PartitionedRegion prQ) {
        if (prQ != null) {
            Set<Map.Entry<Integer, BucketRegion>> allBuckets = prQ.getDataStore().getAllLocalBuckets();
            ArrayList<Integer> thisProcessorBuckets = new ArrayList<Integer>();
            for (Map.Entry<Integer, BucketRegion> bucketEntry : allBuckets) {
                int bId;
                BucketRegion bucket = bucketEntry.getValue();
                if (!bucket.getBucketAdvisor().isPrimary() || (bId = bucket.getId()) % this.nDispatcher != this.index) continue;
                thisProcessorBuckets.add(bId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getRandomPrimaryBucket: total {} for this processor: {}", (Object)allBuckets.size(), (Object)thisProcessorBuckets.size());
            }
            int nTry = thisProcessorBuckets.size();
            while (nTry-- > 0) {
                BucketRegionQueue br;
                if (this.pickBucketId >= thisProcessorBuckets.size()) {
                    this.pickBucketId = 0;
                }
                if ((br = this.getBucketRegionQueueByBucketId(prQ, (Integer)thisProcessorBuckets.get(this.pickBucketId++))) == null || !br.isReadyForPeek()) continue;
                return br.getId();
            }
        }
        return -1;
    }

    @Override
    public List take(int batchSize) throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws CacheException {
        if (!this.peekedEvents.isEmpty()) {
            GatewaySenderEventImpl event = (GatewaySenderEventImpl)this.peekedEvents.remove();
            try {
                PartitionedRegion prQ = null;
                int bucketId = -1;
                Serializable key = null;
                if (event.getRegion() != null) {
                    if (this.isDREvent(this.sender.getCache(), event)) {
                        prQ = this.userRegionNameToShadowPRMap.get(event.getRegion().getFullPath());
                        bucketId = event.getEventId().getBucketID();
                        key = event.getEventId();
                    } else {
                        prQ = this.userRegionNameToShadowPRMap.get(ColocationHelper.getLeaderRegion((PartitionedRegion)event.getRegion()).getFullPath());
                        bucketId = event.getBucketId();
                        key = event.getShadowKey();
                    }
                } else {
                    String regionPath = event.getRegionPath();
                    InternalCache cache = this.sender.getCache();
                    Region region = cache.getRegion(regionPath);
                    if (region != null && !region.isDestroyed()) {
                        if (region instanceof DistributedRegion) {
                            prQ = this.userRegionNameToShadowPRMap.get(region.getFullPath());
                            event.getBucketId();
                            key = event.getEventId();
                        } else {
                            prQ = this.userRegionNameToShadowPRMap.get(ColocationHelper.getLeaderRegion((PartitionedRegion)region).getFullPath());
                            event.getBucketId();
                            key = event.getShadowKey();
                        }
                    }
                }
                if (prQ != null) {
                    this.destroyEventFromQueue(prQ, bucketId, key);
                }
            }
            finally {
                try {
                    event.release();
                }
                catch (IllegalStateException e) {
                    logger.error("Exception caught and logged.  The thread will continue running", (Throwable)e);
                }
            }
        }
    }

    private void destroyEventFromQueue(PartitionedRegion prQ, int bucketId, Object key) {
        block9: {
            BucketRegionQueue brq = this.getBucketRegionQueueByBucketId(prQ, bucketId);
            try {
                if (brq != null) {
                    brq.destroyKey(key);
                }
                this.stats.decQueueSize();
            }
            catch (EntryNotFoundException e) {
                if (!this.sender.isBatchConflationEnabled() && logger.isDebugEnabled()) {
                    logger.debug("ParallelGatewaySenderQueue#remove: Got EntryNotFoundException while removing key {} for {} for bucket = {} for GatewaySender {}", key, (Object)this, (Object)bucketId, (Object)this.sender);
                }
            }
            catch (ForceReattemptException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Bucket :{} moved to other member", (Object)bucketId);
                }
            }
            catch (PrimaryBucketException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Primary bucket :{} moved to other member", (Object)bucketId);
                }
            }
            catch (RegionDestroyedException e) {
                if (!logger.isDebugEnabled()) break block9;
                logger.debug("Caught RegionDestroyedException attempting to remove key {} from bucket {} in {}", key, (Object)bucketId, (Object)prQ.getFullPath());
            }
        }
        this.addRemovedEvent(prQ, bucketId, key);
    }

    public void resetLastPeeked() {
        this.resetLastPeeked = true;
        this.peekedEventsProcessingInProgress = false;
        this.peekedEventsProcessing.clear();
    }

    @Override
    public Object peek() throws InterruptedException, CacheException {
        Object object;
        block4: {
            object = null;
            int bucketId = -1;
            PartitionedRegion prQ = this.getRandomShadowPR();
            if (prQ != null && prQ.getDataStore().getAllLocalBucketRegions().size() > 0 && (bucketId = this.getRandomPrimaryBucket(prQ)) != -1) {
                try {
                    BucketRegionQueue brq = (BucketRegionQueue)prQ.getDataStore().getInitializedBucketForId(null, bucketId);
                    object = brq.peek();
                }
                catch (BucketRegionQueueUnavailableException e) {
                    return object;
                }
                catch (ForceReattemptException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Remove: Got ForceReattemptException for {} for bucke = {}", (Object)this, (Object)bucketId);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvent(PartitionedRegion prQ, int bucketId, Object key) {
        StoppableReentrantLock lock = this.buckToDispatchLock;
        if (lock != null) {
            lock.lock();
            boolean wasEmpty = this.regionToDispatchedKeysMap.isEmpty();
            try {
                Map<Integer, List<Object>> bucketIdToDispatchedKeys = this.regionToDispatchedKeysMap.get(prQ.getFullPath());
                if (bucketIdToDispatchedKeys == null) {
                    bucketIdToDispatchedKeys = new ConcurrentHashMap<Integer, List<Object>>();
                    this.regionToDispatchedKeysMap.put(prQ.getFullPath(), bucketIdToDispatchedKeys);
                }
                this.addRemovedEventToMap(bucketIdToDispatchedKeys, bucketId, key);
                if (wasEmpty) {
                    this.regionToDispatchedKeysMapEmpty.signal();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void sendQueueRemovalMessageForDroppedEvent(PartitionedRegion prQ, int bucketId, Object key) {
        Set<InternalDistributedMember> recipients = this.removalThread.getAllRecipientsForEvent(this.sender.getCache(), prQ.getFullPath(), bucketId);
        if (!recipients.isEmpty()) {
            HashMap<String, Map<Integer, List<Object>>> temp = new HashMap<String, Map<Integer, List<Object>>>();
            ConcurrentHashMap<Integer, List<Object>> bucketIdToDispatchedKeys = new ConcurrentHashMap<Integer, List<Object>>();
            temp.put(prQ.getFullPath(), bucketIdToDispatchedKeys);
            this.addRemovedEventToMap(bucketIdToDispatchedKeys, bucketId, key);
            ParallelQueueRemovalMessage pqrm = new ParallelQueueRemovalMessage(temp);
            pqrm.setRecipients(recipients);
            this.sender.getCache().getInternalDistributedSystem().getDistributionManager().putOutgoing(pqrm);
        }
    }

    private void addRemovedEventToMap(Map<Integer, List<Object>> bucketIdToDispatchedKeys, int bucketId, Object key) {
        List<Object> dispatchedKeys = bucketIdToDispatchedKeys.get(bucketId);
        if (dispatchedKeys == null) {
            dispatchedKeys = new ArrayList<Object>();
            bucketIdToDispatchedKeys.put(bucketId, dispatchedKeys);
        }
        dispatchedKeys.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvents(PartitionedRegion prQ, int bucketId, List<Object> shadowKeys) {
        this.buckToDispatchLock.lock();
        boolean wasEmpty = this.regionToDispatchedKeysMap.isEmpty();
        try {
            Map<Integer, List<Object>> bucketIdToDispatchedKeys = this.regionToDispatchedKeysMap.get(prQ.getFullPath());
            if (bucketIdToDispatchedKeys == null) {
                bucketIdToDispatchedKeys = new ConcurrentHashMap<Integer, List<Object>>();
                this.regionToDispatchedKeysMap.put(prQ.getFullPath(), bucketIdToDispatchedKeys);
            }
            this.addRemovedEventsToMap(bucketIdToDispatchedKeys, bucketId, shadowKeys);
            if (wasEmpty) {
                this.regionToDispatchedKeysMapEmpty.signal();
            }
        }
        finally {
            this.buckToDispatchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvents(String prQPath, int bucketId, List<Object> shadowKeys) {
        this.buckToDispatchLock.lock();
        boolean wasEmpty = this.regionToDispatchedKeysMap.isEmpty();
        try {
            Map<Integer, List<Object>> bucketIdToDispatchedKeys = this.regionToDispatchedKeysMap.get(prQPath);
            if (bucketIdToDispatchedKeys == null) {
                bucketIdToDispatchedKeys = new ConcurrentHashMap<Integer, List<Object>>();
                this.regionToDispatchedKeysMap.put(prQPath, bucketIdToDispatchedKeys);
            }
            this.addRemovedEventsToMap(bucketIdToDispatchedKeys, bucketId, shadowKeys);
            if (wasEmpty) {
                this.regionToDispatchedKeysMapEmpty.signal();
            }
        }
        finally {
            this.buckToDispatchLock.unlock();
        }
    }

    private void addRemovedEventsToMap(Map<Integer, List<Object>> bucketIdToDispatchedKeys, int bucketId, List<Object> keys) {
        ArrayList dispatchedKeys = bucketIdToDispatchedKeys.get(bucketId);
        if (dispatchedKeys == null) {
            dispatchedKeys = keys == null ? new ArrayList() : keys;
        } else {
            dispatchedKeys.addAll(keys);
        }
        bucketIdToDispatchedKeys.put(bucketId, dispatchedKeys);
    }

    @Override
    public List peek(int batchSize) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List peek(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        PartitionedRegion prQ = this.getRandomShadowPR();
        if (prQ == null || prQ.getLocalMaxMemory() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.blockProcessorThreadIfRequired();
            return Collections.EMPTY_LIST;
        }
        ArrayList<GatewaySenderEventImpl> batch = new ArrayList<GatewaySenderEventImpl>(batchSize == BATCH_BASED_ON_TIME_ONLY ? 100 : batchSize);
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        this.addPeekedEvents(batch, batchSize == BATCH_BASED_ON_TIME_ONLY ? 100 : batchSize);
        while (batchSize == BATCH_BASED_ON_TIME_ONLY || batch.size() < batchSize) {
            int bId;
            if (this.areLocalBucketQueueRegionsPresent() && (bId = this.getRandomPrimaryBucket(prQ)) != -1) {
                GatewaySenderEventImpl object = (GatewaySenderEventImpl)this.peekAhead(prQ, bId);
                if (object != null) {
                    GatewaySenderEventImpl copy = object.makeHeapCopyIfOffHeap();
                    if (copy == null) {
                        if (this.stats == null) continue;
                        this.stats.incEventsNotQueuedConflated();
                        continue;
                    }
                    object = copy;
                }
                if (object != null) {
                    if (isDebugEnabled) {
                        logger.debug("The gatewayEventImpl in peek is {}", (Object)object);
                    }
                    batch.add(object);
                    this.peekedEvents.add(object);
                    continue;
                }
                if (this.stopPeekingDueToTime(timeToWait, end)) break;
                if (!isDebugEnabled) continue;
                logger.debug("{}: Peeked object was null. Peek continuing", (Object)this);
                continue;
            }
            if (this.stopPeekingDueToTime(timeToWait, end)) break;
            if (isDebugEnabled) {
                logger.debug("{}: Peek continuing", (Object)this);
            }
            long currentTime = System.currentTimeMillis();
            try {
                Thread.sleep(ParallelGatewaySenderQueue.calculateTimeToSleep(end - currentTime));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (batch.size() > 0) {
            this.peekEventsFromIncompleteTransactions(batch, prQ);
        }
        if (isDebugEnabled) {
            logger.debug("{}: Peeked a batch of {} entries. The size of the queue is {}. localSize is {}", (Object)this, (Object)batch.size(), (Object)this.size(), (Object)this.localSize());
        }
        if (batch.size() == 0) {
            this.blockProcessorThreadIfRequired();
        }
        return batch;
    }

    private boolean stopPeekingDueToTime(int timeToWait, long end) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        long currentTime = System.currentTimeMillis();
        if (isDebugEnabled) {
            logger.debug("{}: Peek current time: {}", (Object)this, (Object)currentTime);
        }
        if (timeToWait == -1 || end <= currentTime) {
            if (isDebugEnabled) {
                logger.debug("{}: Peek breaking", (Object)this);
            }
            return true;
        }
        return false;
    }

    protected boolean mustGroupTransactionEvents() {
        return this.sender.mustGroupTransactionEvents();
    }

    @VisibleForTesting
    void peekEventsFromIncompleteTransactions(List<GatewaySenderEventImpl> batch, PartitionedRegion prQ) {
        if (!this.mustGroupTransactionEvents()) {
            return;
        }
        Map<TransactionId, Integer> incompleteTransactionIdsInBatch = this.getIncompleteTransactionsInBatch(batch);
        if (incompleteTransactionIdsInBatch.size() == 0) {
            return;
        }
        int retries = 0;
        while (true) {
            Iterator<Map.Entry<TransactionId, Integer>> iter = incompleteTransactionIdsInBatch.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<TransactionId, Integer> pendingTransaction = iter.next();
                TransactionId transactionId = pendingTransaction.getKey();
                int bucketId = pendingTransaction.getValue();
                List<Object> events = this.peekEventsWithTransactionId(prQ, bucketId, transactionId);
                for (Object object : events) {
                    GatewaySenderEventImpl event = (GatewaySenderEventImpl)object;
                    batch.add(event);
                    this.peekedEvents.add(event);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Peeking extra event: {}, bucketId: {}, isLastEventInTransaction: {}, batch size: {}", event.getKey(), (Object)bucketId, (Object)event.isLastEventInTransaction(), (Object)batch.size());
                    }
                    if (!event.isLastEventInTransaction()) continue;
                    iter.remove();
                }
            }
            if (incompleteTransactionIdsInBatch.size() == 0 || retries >= this.sender.getRetriesToGetTransactionEventsFromQueue()) break;
            ++retries;
            try {
                Thread.sleep(GatewaySender.GET_TRANSACTION_EVENTS_FROM_QUEUE_WAIT_TIME_MS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (incompleteTransactionIdsInBatch.size() > 0) {
            logger.warn("Not able to retrieve all events for transactions: {} after {} retries of {}ms", incompleteTransactionIdsInBatch, (Object)retries, (Object)GatewaySender.GET_TRANSACTION_EVENTS_FROM_QUEUE_WAIT_TIME_MS);
            this.stats.incBatchesWithIncompleteTransactions();
        }
    }

    private Map<TransactionId, Integer> getIncompleteTransactionsInBatch(List<GatewaySenderEventImpl> batch) {
        HashMap<TransactionId, Integer> incompleteTransactionsInBatch = new HashMap<TransactionId, Integer>();
        for (GatewaySenderEventImpl event : batch) {
            if (event.getTransactionId() == null) continue;
            if (event.isLastEventInTransaction()) {
                incompleteTransactionsInBatch.remove(event.getTransactionId());
                continue;
            }
            incompleteTransactionsInBatch.put(event.getTransactionId(), event.getBucketId());
        }
        return incompleteTransactionsInBatch;
    }

    @VisibleForTesting
    static long calculateTimeToSleep(long timeToWait) {
        if (timeToWait <= 0L) {
            return 0L;
        }
        long timeToSleep = Math.min(50L, (long)((double)timeToWait * 0.05));
        if (timeToSleep == 0L) {
            timeToSleep = (long)((double)timeToWait * 0.5);
        }
        if (timeToSleep == 0L) {
            timeToSleep = timeToWait;
        }
        return timeToSleep;
    }

    private void addPeekedEvents(List<GatewaySenderEventImpl> batch, int batchSize) {
        if (this.resetLastPeeked) {
            Object[] helpArray = this.peekedEvents.toArray();
            if (helpArray.length > 0) {
                for (int i = helpArray.length - 1; i >= 0; --i) {
                    GatewaySenderEventImpl event = (GatewaySenderEventImpl)helpArray[i];
                    int bucketId = event.getBucketId();
                    PartitionedRegion region = (PartitionedRegion)event.getRegion();
                    if (region.getRegionAdvisor().isPrimaryForBucket(bucketId)) continue;
                    this.peekedEvents.remove(event);
                    BucketRegionQueue brq = this.getBucketRegionQueueByBucketId(this.getRandomShadowPR(), bucketId);
                    if (brq == null) continue;
                    brq.pushKeyIntoQueue(event.getShadowKey());
                }
            }
            if (this.peekedEventsProcessingInProgress) {
                this.addPreviouslyPeekedEvents(batch, batchSize);
            } else if (this.peekedEvents.size() <= batchSize) {
                batch.addAll(this.peekedEvents);
                this.resetLastPeeked = false;
            } else {
                this.peekedEventsProcessing.addAll(this.peekedEvents);
                this.peekedEventsProcessingInProgress = true;
                this.addPreviouslyPeekedEvents(batch, batchSize);
            }
            if (logger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                for (GatewaySenderEventImpl ge : batch) {
                    buffer.append("event :");
                    buffer.append(ge);
                }
                logger.debug("Adding already peeked events to the batch {}", (Object)buffer);
            }
        }
    }

    private void addPreviouslyPeekedEvents(List<GatewaySenderEventImpl> batch, int batchSize) {
        HashSet<TransactionId> incompleteTransactionsInBatch = new HashSet<TransactionId>();
        for (int i = 0; i < batchSize || incompleteTransactionsInBatch.size() != 0; ++i) {
            GatewaySenderEventImpl event = (GatewaySenderEventImpl)this.peekedEventsProcessing.remove();
            batch.add(event);
            if (this.mustGroupTransactionEvents() && event.getTransactionId() != null) {
                if (event.isLastEventInTransaction()) {
                    incompleteTransactionsInBatch.remove(event.getTransactionId());
                } else {
                    incompleteTransactionsInBatch.add(event.getTransactionId());
                }
            }
            if (!this.peekedEventsProcessing.isEmpty()) continue;
            this.resetLastPeeked = false;
            this.peekedEventsProcessingInProgress = false;
            break;
        }
    }

    protected void blockProcessorThreadIfRequired() throws InterruptedException {
        this.queueEmptyLock.lock();
        try {
            if (this.isQueueEmpty) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Going to wait, till notified.");
                }
                this.queueEmptyCondition.await(1000L);
            }
            this.isQueueEmpty = this.localSizeForProcessor() == 0;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Going to unblock. isQueueEmpty {}", (Object)this.isQueueEmpty);
            }
            this.queueEmptyLock.unlock();
        }
    }

    protected Object peekAhead(PartitionedRegion prQ, int bucketId) throws CacheException {
        Object object = null;
        BucketRegionQueue brq = this.getBucketRegionQueueByBucketId(prQ, bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peekahead for the bucket {}", (Object)this, (Object)bucketId);
        }
        try {
            object = brq.peek();
        }
        catch (BucketRegionQueueUnavailableException e) {
            return object;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peeked object from bucket {} object: {}", (Object)this, (Object)bucketId, object);
        }
        if (object == null && this.stats != null) {
            this.stats.incEventsNotQueuedConflated();
        }
        return object;
    }

    protected List<Object> peekEventsWithTransactionId(PartitionedRegion prQ, int bucketId, TransactionId transactionId) throws CacheException {
        List<Object> objects;
        BucketRegionQueue brq = this.getBucketRegionQueueByBucketId(prQ, bucketId);
        try {
            Predicate<GatewaySenderEventImpl> hasTransactionIdPredicate = ParallelGatewaySenderQueue.getHasTransactionIdPredicate(transactionId);
            Predicate<GatewaySenderEventImpl> isLastEventInTransactionPredicate = ParallelGatewaySenderQueue.getIsLastEventInTransactionPredicate();
            objects = brq.getElementsMatching(hasTransactionIdPredicate, isLastEventInTransactionPredicate);
        }
        catch (BucketRegionQueueUnavailableException e) {
            return Collections.emptyList();
        }
        return objects;
    }

    @VisibleForTesting
    public static Predicate<GatewaySenderEventImpl> getIsLastEventInTransactionPredicate() {
        return GatewaySenderEventImpl::isLastEventInTransaction;
    }

    @VisibleForTesting
    public static Predicate<GatewaySenderEventImpl> getHasTransactionIdPredicate(TransactionId transactionId) {
        return x -> transactionId.equals(x.getTransactionId());
    }

    protected BucketRegionQueue getBucketRegionQueueByBucketId(PartitionedRegion prQ, int bucketId) {
        return (BucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
    }

    public String displayContent() {
        StringBuilder sb = new StringBuilder();
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            if (prQ == null || prQ.getDataStore() == null) continue;
            Set<BucketRegion> allLocalBuckets = prQ.getDataStore().getAllLocalBucketRegions();
            for (BucketRegion br : allLocalBuckets) {
                if (br.size() <= 0) continue;
                sb.append("bucketId=" + br.getId() + ":" + String.valueOf(br.keySet()) + ";");
            }
        }
        return sb.toString();
    }

    public int localSize() {
        return this.localSize(false);
    }

    public int localSize(boolean includeSecondary) {
        int size = 0;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            if (prQ.isDestroyed()) continue;
            if (prQ.getDataStore() != null) {
                size = includeSecondary ? (size += prQ.getDataStore().getSizeOfLocalBuckets()) : (size += prQ.getDataStore().getSizeOfLocalPrimaryBuckets());
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("The name of the queue region is {} and the size is {}", (Object)prQ.getFullPath(), (Object)size);
        }
        return size;
    }

    public int localSizeForProcessor() {
        int size = 0;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            if (prQ.isDestroyed()) continue;
            if (((PartitionedRegion)prQ.getRegion()).getDataStore() != null) {
                Set<BucketRegion> primaryBuckets = ((PartitionedRegion)prQ.getRegion()).getDataStore().getAllLocalPrimaryBucketRegions();
                for (BucketRegion br : primaryBuckets) {
                    if (br.getId() % this.nDispatcher != this.index) continue;
                    size += br.size();
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("The name of the queue region is {} and the size is {}", (Object)prQ.getFullPath(), (Object)size);
        }
        return size;
    }

    @Override
    public int size() {
        int size = 0;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            if (prQ.isDestroyed()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("The name of the queue region is {} and the size is {}. keyset size is {}", (Object)prQ.getName(), (Object)prQ.size(), (Object)prQ.keys().size());
            }
            size += prQ.size();
        }
        return size + this.sender.getTmpQueuedEventSize();
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            AttributesMutator mutator = prQ.getAttributesMutator();
            mutator.addCacheListener(listener);
        }
    }

    @Override
    public void removeCacheListener() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int batchSize) throws CacheException {
        for (int i = 0; i < batchSize; ++i) {
            this.remove();
        }
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ConflationHandler conflationHandler = new ConflationHandler(conflatableObject, bucketId, tailKey);
        this.conflationExecutor.execute(conflationHandler);
    }

    public long getNumEntriesOverflowOnDiskTestOnly() {
        long numEntriesOnDisk = 0L;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            DiskRegionStats diskStats = prQ.getDiskRegionStats();
            if (diskStats == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: DiskRegionStats for shadow PR is null. Returning the numEntriesOverflowOnDisk as 0", (Object)this);
                }
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: DiskRegionStats for shadow PR is NOT null. Returning the numEntriesOverflowOnDisk obtained from DiskRegionStats", (Object)this);
            }
            numEntriesOnDisk += diskStats.getNumOverflowOnDisk();
        }
        return numEntriesOnDisk;
    }

    public long getNumEntriesInVMTestOnly() {
        long numEntriesInVM = 0L;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            DiskRegionStats diskStats = prQ.getDiskRegionStats();
            if (diskStats == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: DiskRegionStats for shadow PR is null. Returning the numEntriesInVM as 0", (Object)this);
                }
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: DiskRegionStats for shadow PR is NOT null. Returning the numEntriesInVM obtained from DiskRegionStats", (Object)this);
            }
            numEntriesInVM += diskStats.getNumEntriesInVM();
        }
        return numEntriesInVM;
    }

    @VisibleForTesting
    public int getNumOfPossibleDuplicateEvents() {
        int numberOfPossibleDuplicateEvents = 0;
        for (PartitionedRegion prQ : this.userRegionNameToShadowPRMap.values()) {
            Set<BucketRegion> primaryBuckets = prQ.getDataStore().getAllLocalPrimaryBucketRegions();
            for (BucketRegion br : primaryBuckets) {
                BucketRegionQueue brq = (BucketRegionQueue)br;
                List<Object> objects = brq.getHelperQueueList();
                for (Object o : objects) {
                    GatewaySenderEventImpl gse = (GatewaySenderEventImpl)o;
                    if (!gse.getPossibleDuplicate()) continue;
                    ++numberOfPossibleDuplicateEvents;
                }
            }
        }
        return numberOfPossibleDuplicateEvents;
    }

    public void cleanUp() {
        this.regionToDispatchedKeysMap.clear();
        this.removalThread.shutdown();
        this.cleanupConflationThreadPool(this.sender);
    }

    @Override
    public void close() {
        if (this.resetLastPeeked) {
            this.returnToQueuePreviouslyPeekedEvents();
            this.resetLastPeeked = false;
        }
    }

    private void returnToQueuePreviouslyPeekedEvents() {
        Object[] helpArray = this.peekedEvents.toArray();
        this.peekedEvents.clear();
        if (helpArray.length == 0) {
            return;
        }
        for (int i = helpArray.length - 1; i >= 0; --i) {
            GatewaySenderEventImpl event = (GatewaySenderEventImpl)helpArray[i];
            int bucketId = event.getBucketId();
            BucketRegionQueue brq = this.getBucketRegionQueueByBucketId(this.getRandomShadowPR(), bucketId);
            if (brq == null) continue;
            brq.pushKeyIntoQueue(event.getShadowKey());
        }
    }

    public Map<Integer, BlockingQueue<GatewaySenderEventImpl>> getBucketToTempQueueMap() {
        return this.bucketToTempQueueMap;
    }

    public static boolean isParallelQueue(String regionName) {
        return regionName.contains(QSTRING);
    }

    public static String getQueueName(String senderId, String regionPath) {
        return senderId + QSTRING + ParallelGatewaySenderQueue.convertPathToName(regionPath);
    }

    public static String getSenderId(String regionName) {
        int queueStringStart = regionName.indexOf(QSTRING);
        return regionName.substring(1, queueStringStart);
    }

    public long estimateMemoryFootprint(SingleObjectSizer sizer) {
        return sizer.sizeof(this) + sizer.sizeof(this.regionToDispatchedKeysMap) + sizer.sizeof(this.userRegionNameToShadowPRMap) + sizer.sizeof(this.bucketToTempQueueMap) + sizer.sizeof(this.peekedEvents) + sizer.sizeof(this.conflationExecutor);
    }

    public void clear(PartitionedRegion pr, int bucketId) {
        throw new RuntimeException("This method(clear)is not supported by ParallelGatewaySenderQueue");
    }

    public int size(PartitionedRegion pr, int bucketId) throws ForceReattemptException {
        throw new RuntimeException("This method(size)is not supported by ParallelGatewaySenderQueue");
    }

    static class MetaRegionFactory {
        MetaRegionFactory() {
        }

        ParallelGatewaySenderQueueMetaRegion newMetataRegion(InternalCache cache, String prQName, RegionAttributes ra, AbstractGatewaySender sender) {
            ParallelGatewaySenderQueueMetaRegion meta = new ParallelGatewaySenderQueueMetaRegion(prQName, ra, null, cache, sender, sender.getStatisticsClock());
            return meta;
        }
    }

    private class BatchRemovalThread
    extends Thread {
        private volatile boolean shutdown;
        private final InternalCache cache;

        public BatchRemovalThread(InternalCache c, ParallelGatewaySenderQueue queue) {
            super("BatchRemovalThread for GatewaySender_" + queue.sender.getId() + "_" + queue.index);
            this.shutdown = false;
            this.setDaemon(true);
            this.cache = c;
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().isCancelInProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                try {
                    InternalDistributedSystem ids = this.cache.getInternalDistributedSystem();
                    DistributionManager dm = ids.getDistributionManager();
                    while (true) {
                        try {
                            while (true) {
                                HashMap<String, Map<Integer, List<Object>>> temp;
                                if (this.checkCancelled()) {
                                    break block36;
                                }
                                boolean interrupted = Thread.interrupted();
                                try {
                                    BatchRemovalThread batchRemovalThread = this;
                                    synchronized (batchRemovalThread) {
                                        this.wait(messageSyncInterval);
                                    }
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                    if (this.checkCancelled()) {
                                        // empty if block
                                    }
                                    break block36;
                                }
                                finally {
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                if (logger.isDebugEnabled()) {
                                    ParallelGatewaySenderQueue.this.buckToDispatchLock.lock();
                                    try {
                                        logger.debug("BatchRemovalThread about to query the batch removal map {}", ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap);
                                    }
                                    finally {
                                        ParallelGatewaySenderQueue.this.buckToDispatchLock.unlock();
                                    }
                                }
                                ParallelGatewaySenderQueue.this.buckToDispatchLock.lock();
                                try {
                                    boolean wasEmpty = ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap.isEmpty();
                                    while (ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap.isEmpty()) {
                                        ParallelGatewaySenderQueue.this.regionToDispatchedKeysMapEmpty.await(15000L);
                                    }
                                    if (wasEmpty) continue;
                                    temp = new HashMap<String, Map<Integer, List<Object>>>(ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap);
                                    ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap.clear();
                                }
                                finally {
                                    ParallelGatewaySenderQueue.this.buckToDispatchLock.unlock();
                                    continue;
                                }
                                Set<InternalDistributedMember> recipients = this.getAllRecipients(this.cache, temp);
                                if (!recipients.isEmpty()) {
                                    ParallelQueueRemovalMessage pqrm = new ParallelQueueRemovalMessage(temp);
                                    pqrm.setRecipients(recipients);
                                    dm.putOutgoing(pqrm);
                                    continue;
                                }
                                ParallelGatewaySenderQueue.this.regionToDispatchedKeysMap.putAll(temp);
                            }
                        }
                        catch (CancelException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("BatchRemovalThread is exiting due to cancellation");
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            Error err;
                            if (t instanceof Error && SystemFailure.isJVMFailureError(err = (Error)t)) {
                                SystemFailure.initiateFailure(err);
                                throw err;
                            }
                            SystemFailure.checkFailure();
                            if (this.checkCancelled()) {
                                break;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("BatchRemovalThread: ignoring exception", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("BatchRemovalThread exiting due to cancellation: " + String.valueOf(e));
                    }
                }
                finally {
                    logger.info("The QueueRemovalThread is done.");
                }
            }
        }

        private Set<InternalDistributedMember> getAllRecipients(InternalCache cache, Map map) {
            ObjectOpenHashSet recipients = new ObjectOpenHashSet();
            for (Object pr : map.keySet()) {
                PartitionedRegion partitionedRegion = (PartitionedRegion)cache.getRegion((String)pr);
                if (partitionedRegion == null || partitionedRegion.getRegionAdvisor() == null) continue;
                recipients.addAll(partitionedRegion.getRegionAdvisor().adviseDataStore());
            }
            return recipients;
        }

        private Set<InternalDistributedMember> getAllRecipientsForEvent(InternalCache cache, String partitionedRegionName, int bucketId) {
            ObjectOpenHashSet recipients = new ObjectOpenHashSet();
            PartitionedRegion partitionedRegion = (PartitionedRegion)cache.getRegion(partitionedRegionName);
            if (partitionedRegion != null && partitionedRegion.getRegionAdvisor() != null) {
                String bucketFullPath = ParallelGatewaySenderQueue.SHADOW_BUCKET_PATH_PREFIX + partitionedRegion.getBucketName(bucketId);
                AbstractBucketRegionQueue bucketRegionQueue = (AbstractBucketRegionQueue)cache.getInternalRegionByPath(bucketFullPath);
                if (bucketRegionQueue != null && bucketRegionQueue.getBucketAdvisor() != null) {
                    Set<InternalDistributedMember> bucketMembers = bucketRegionQueue.getBucketAdvisor().adviseInitialized();
                    if (!bucketMembers.isEmpty()) {
                        recipients.addAll(bucketMembers);
                    } else {
                        recipients.addAll(partitionedRegion.getRegionAdvisor().adviseDataStore());
                    }
                } else {
                    recipients.addAll(partitionedRegion.getRegionAdvisor().adviseDataStore());
                }
            }
            return recipients;
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn("QueueRemovalThread ignored cancellation");
            }
        }
    }

    protected static class ParallelGatewaySenderQueueMetaRegion
    extends PartitionedRegion {
        AbstractGatewaySender sender = null;

        public ParallelGatewaySenderQueueMetaRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, AbstractGatewaySender pgSender, StatisticsClock statisticsClock) {
            super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForParallelGatewaySenderQueue(true).setParallelGatewaySender(pgSender), statisticsClock, ColocationLoggerFactory.create());
            this.sender = pgSender;
        }

        @Override
        public boolean isCopyOnRead() {
            return false;
        }

        @Override
        public boolean isSecret() {
            return true;
        }

        @Override
        protected boolean supportsConcurrencyChecks() {
            return false;
        }

        @Override
        public boolean shouldNotifyBridgeClients() {
            return false;
        }

        @Override
        public boolean generateEventID() {
            return false;
        }

        @Override
        protected boolean isUsedForParallelGatewaySenderQueue() {
            return true;
        }

        @Override
        public AbstractGatewaySender getParallelGatewaySender() {
            return this.sender;
        }
    }

    private class ConflationHandler
    implements Runnable {
        Conflatable conflatableObject;
        Long previousTailKeyTobeRemoved;
        int bucketId;

        public ConflationHandler(Conflatable conflatableObject, int bId, Long previousTailKey) {
            this.conflatableObject = conflatableObject;
            this.previousTailKeyTobeRemoved = previousTailKey;
            this.bucketId = bId;
        }

        @Override
        public void run() {
            PartitionedRegion prQ;
            block3: {
                GatewaySenderEventImpl event = (GatewaySenderEventImpl)this.conflatableObject;
                String regionPath = ColocationHelper.getLeaderRegion((PartitionedRegion)event.getRegion()).getFullPath();
                prQ = ParallelGatewaySenderQueue.this.userRegionNameToShadowPRMap.get(regionPath);
                try {
                    ParallelGatewaySenderQueue.this.destroyEventFromQueue(prQ, this.bucketId, this.previousTailKeyTobeRemoved);
                }
                catch (EntryNotFoundException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("{}: Not conflating {} due to EntryNotFoundException", (Object)this, this.conflatableObject.getKeyToConflate());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Conflated {} for key={} in queue for region={}", (Object)this, this.conflatableObject.getValueToConflate(), this.conflatableObject.getKeyToConflate(), (Object)prQ.getName());
            }
        }

        private Object deserialize(Object serializedBytes) {
            Object deserializedObject = serializedBytes;
            if (serializedBytes instanceof byte[]) {
                byte[] serializedBytesCast = (byte[])serializedBytes;
                try {
                    deserializedObject = EntryEventImpl.deserialize(serializedBytesCast);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return deserializedObject;
        }
    }
}

