/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.jetbrains.annotations.NotNull;

public class PutUserCredentials
extends BaseCommand {
    @Immutable
    private static final PutUserCredentials singleton = new PutUserCredentials();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        boolean isSecureMode = clientMessage.isSecureMode();
        if (!isSecureMode) {
            return;
        }
        int numberOfParts = clientMessage.getNumberOfParts();
        if (numberOfParts != 1) {
            return;
        }
        long existingUniqueId = serverConnection.getUniqueId();
        try {
            serverConnection.setAsTrue(2);
            byte[] uniqueId = serverConnection.setCredentials(clientMessage, existingUniqueId);
            this.writeResponse(uniqueId, null, clientMessage, false, serverConnection);
        }
        catch (GemFireSecurityException gfse) {
            if (serverConnection.getSecurityLogWriter().warningEnabled()) {
                serverConnection.getSecurityLogWriter().warning(String.format("%s", serverConnection.getName() + ": Security exception: " + String.valueOf(gfse) + (String)(gfse.getCause() != null ? ", caused by: " + gfse.getCause().toString() : "")));
            }
            PutUserCredentials.writeException(clientMessage, gfse, false, serverConnection);
        }
        catch (Exception ex) {
            if (serverConnection.getLogWriter().warningEnabled()) {
                serverConnection.getLogWriter().warning(String.format("An exception was thrown for client [%s]. %s", serverConnection.getProxyID(), ""), (Throwable)ex);
            }
            PutUserCredentials.writeException(clientMessage, ex, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

