/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class Put70
extends BaseCommand {
    @Immutable
    private static final Put70 singleton = new Put70();

    public static Command getCommand() {
        return singleton;
    }

    private Put70() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long p_start) throws IOException, InterruptedException {
        Object oldValue;
        boolean oldValueIsObject;
        boolean sendOldValue;
        EventIDHolder clientEvent;
        LocalRegion region;
        boolean isDebugEnabled;
        String regionName;
        Object key;
        Part valuePart;
        CacheServerStats stats;
        long start;
        block76: {
            boolean isDelta;
            Object expectedOldValue;
            boolean haveExpectedOldValue;
            Operation operation;
            start = p_start;
            stats = serverConnection.getCacheServerStats();
            serverConnection.setAsTrue(2);
            long oldStart = start;
            start = DistributionStats.getStatTime();
            stats.incReadPutRequestTime(start - oldStart);
            int idx = 0;
            Part regionNamePart = clientMessage.getPart(idx++);
            try {
                byte[] bytes;
                Part operationPart = clientMessage.getPart(idx++);
                operation = operationPart.isBytes() ? (null == (bytes = operationPart.getSerializedForm()) || 0 == bytes.length ? Operation.UPDATE : Operation.fromOrdinal(bytes[0])) : (operationPart.getObject() == null ? Operation.UPDATE : (Operation)operationPart.getObject());
            }
            catch (Exception e) {
                Put70.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            int flags = clientMessage.getPart(idx++).getInt();
            boolean requireOldValue = (flags & 1) == 1;
            boolean bl = haveExpectedOldValue = (flags & 2) == 2;
            if (haveExpectedOldValue) {
                try {
                    expectedOldValue = clientMessage.getPart(idx++).getObject();
                }
                catch (ClassNotFoundException e) {
                    Put70.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            } else {
                expectedOldValue = null;
            }
            Part keyPart = clientMessage.getPart(idx++);
            try {
                isDelta = (Boolean)clientMessage.getPart(idx).getObject();
            }
            catch (Exception e) {
                Put70.writeException(clientMessage, 70, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            int n = ++idx;
            valuePart = clientMessage.getPart(n);
            int n2 = ++idx;
            Part eventPart = clientMessage.getPart(n2);
            Object callbackArg = null;
            if (clientMessage.getNumberOfParts() > ++idx) {
                Part callbackArgPart = clientMessage.getPart(idx++);
                try {
                    callbackArg = callbackArgPart.getObject();
                }
                catch (Exception e) {
                    Put70.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                Put70.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            regionName = regionNamePart.getCachedString();
            isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("{}: Received {}put request ({} bytes) from {} for region {} key {} txId {} posdup: {}", (Object)serverConnection.getName(), (Object)(isDelta ? " delta " : " "), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)clientMessage.getTransactionId(), (Object)clientMessage.isRetry());
            }
            if (key == null || regionName == null) {
                String putMsg;
                StringBuilder errMessage = new StringBuilder();
                if (key == null) {
                    putMsg = " The input key for the put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)" The input key for the put request is null");
                    }
                    errMessage.append(" The input key for the put request is null");
                }
                if (regionName == null) {
                    putMsg = " The input region name for the put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)" The input region name for the put request is null");
                    }
                    errMessage.append(" The input region name for the put request is null");
                }
                Put70.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                Put70.writeRegionDestroyedEx(clientMessage, regionName, " was not found during put request", serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (valuePart.isNull() && operation != Operation.PUT_IF_ABSENT && region.containsKey(key)) {
                String putMsg = " Attempted to put a null value for existing key " + String.valueOf(key);
                if (isDebugEnabled) {
                    logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)putMsg);
                }
                Put70.writeErrorResponse(clientMessage, 8, putMsg, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
            clientEvent = new EventIDHolder(new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId));
            Breadcrumbs.setEventId(clientEvent.getEventId());
            if (clientMessage.isRetry() && this.shouldSetPossibleDuplicate(region, clientEvent)) {
                clientEvent.setPossibleDuplicate(true);
            }
            sendOldValue = false;
            oldValueIsObject = true;
            oldValue = null;
            try {
                boolean result;
                Object value = null;
                if (!isDelta) {
                    value = valuePart.getSerializedForm();
                }
                boolean isObject = valuePart.isObject();
                boolean isMetaRegion = region.isUsedForMetaRegion();
                clientMessage.setMetaRegion(isMetaRegion);
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
                AuthorizeRequest authzRequest = null;
                if (!isMetaRegion) {
                    authzRequest = serverConnection.getAuthzRequest();
                }
                if (authzRequest != null) {
                    if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                        authzRequest.createRegionAuthorize((String)key);
                    } else {
                        PutOperationContext putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg);
                        value = putContext.getValue();
                        isObject = putContext.isObject();
                        callbackArg = putContext.getCallbackArg();
                    }
                }
                if (isDebugEnabled) {
                    logger.debug("processing put65 with operation={}", (Object)operation);
                }
                if (operation == Operation.PUT_IF_ABSENT) {
                    if (clientMessage.isRetry() && clientEvent.getVersionTag() != null) {
                        if (isDebugEnabled) {
                            logger.debug("putIfAbsent operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        region.basicBridgePutIfAbsent(key, value, isObject, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                        oldValue = null;
                    } else {
                        oldValue = region.basicBridgePutIfAbsent(key, value, isObject, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                    }
                    sendOldValue = true;
                    oldValueIsObject = true;
                    if (oldValue instanceof CachedDeserializable) {
                        oldValue = ((CachedDeserializable)oldValue).getSerializedValue();
                    } else if (oldValue instanceof byte[]) {
                        oldValueIsObject = false;
                    }
                    result = true;
                } else if (operation == Operation.REPLACE) {
                    if (requireOldValue) {
                        if (clientMessage.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null && isDebugEnabled) {
                            logger.debug("replace(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        oldValue = region.basicBridgeReplace(key, value, isObject, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                        sendOldValue = !clientEvent.isConcurrencyConflict();
                        oldValueIsObject = true;
                        if (oldValue instanceof CachedDeserializable) {
                            oldValue = ((CachedDeserializable)oldValue).getSerializedValue();
                        } else if (oldValue instanceof byte[]) {
                            oldValueIsObject = false;
                        }
                        if (isDebugEnabled) {
                            logger.debug("returning {} from replace(K,V)", oldValue);
                        }
                        result = true;
                    } else {
                        boolean didPut = region.basicBridgeReplace(key, expectedOldValue, value, isObject, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                        if (clientMessage.isRetry() && clientEvent.getVersionTag() != null) {
                            if (isDebugEnabled) {
                                logger.debug("replace(k,v,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                            }
                            didPut = true;
                        }
                        sendOldValue = true;
                        oldValueIsObject = true;
                        Object object = oldValue = didPut ? Boolean.TRUE : Boolean.FALSE;
                        if (isDebugEnabled) {
                            logger.debug("returning {} from replace(K,V,V)", oldValue);
                        }
                        result = true;
                    }
                } else if (value == null && !isDelta) {
                    result = region.basicBridgeCreate(key, null, true, callbackArg, serverConnection.getProxyID(), true, clientEvent, false);
                    if (clientMessage.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null) {
                        result = true;
                        if (isDebugEnabled) {
                            logger.debug("create(k,null) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                    }
                } else {
                    TXManagerImpl txMgr;
                    byte[] delta = null;
                    if (isDelta) {
                        delta = valuePart.getSerializedForm();
                    }
                    result = (txMgr = (TXManagerImpl)serverConnection.getCache().getCacheTransactionManager()).getTXState() != null && operation.isCreate() ? region.basicBridgeCreate(key, (byte[])value, isObject, callbackArg, serverConnection.getProxyID(), true, clientEvent, true) : region.basicBridgePut(key, value, delta, isObject, callbackArg, serverConnection.getProxyID(), clientEvent, true);
                    if (clientMessage.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null) {
                        if (isDebugEnabled) {
                            logger.debug("put(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        result = true;
                    }
                }
                if (result) {
                    serverConnection.setModificationInfo(true, regionName, key);
                    break block76;
                }
                String message = serverConnection.getName() + ": Failed to put entry for region " + regionName + " key " + String.valueOf(key) + " value " + String.valueOf(valuePart);
                if (isDebugEnabled) {
                    logger.debug(message);
                }
                throw new Exception(message);
            }
            catch (RegionDestroyedException | ResourceException rde) {
                Put70.writeException(clientMessage, rde, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            catch (InvalidDeltaException ide) {
                logger.info("Error applying delta for key {} of region {}: {}", new Object[]{key, regionName, ide.getMessage()});
                Put70.writeException(clientMessage, 70, ide, false, serverConnection);
                serverConnection.setAsTrue(1);
                region.getCachePerfStats().incDeltaFullValuesRequested();
                return;
            }
            catch (Exception ce) {
                Put70.checkForInterrupt(serverConnection, ce);
                Put70.writeException(clientMessage, ce, false, serverConnection);
                serverConnection.setAsTrue(1);
                if (ce instanceof GemFireSecurityException) {
                    if (isDebugEnabled) {
                        logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)ce);
                    }
                } else if (isDebugEnabled) {
                    logger.debug("{}: Unexpected Exception", (Object)serverConnection.getName(), (Object)ce);
                }
                return;
            }
            finally {
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessPutTime(start - oldStart2);
            }
        }
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, sendOldValue, oldValueIsObject, oldValue, pr.getNetworkHopType(), clientEvent.getVersionTag());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection, sendOldValue, oldValueIsObject, oldValue, clientEvent.getVersionTag());
            }
        } else {
            this.writeReply(clientMessage, serverConnection, sendOldValue, oldValueIsObject, oldValue, clientEvent.getVersionTag());
        }
        serverConnection.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent put response back to {} for region {} key {} value {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart);
        }
        stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
    }

    boolean shouldSetPossibleDuplicate(LocalRegion region, EventIDHolder clientEvent) {
        boolean shouldSetPossibleDuplicate = true;
        if (region.getAttributes().getConcurrencyChecksEnabled()) {
            clientEvent.setRegion(region);
            if (!this.isRegionWithPersistence(region) && !this.recoverVersionTagForRetriedOperation(clientEvent)) {
                shouldSetPossibleDuplicate = false;
            }
        }
        return shouldSetPossibleDuplicate;
    }

    boolean isRegionWithPersistence(LocalRegion region) {
        PartitionedRegion partitionedRegion;
        if (region.getAttributes().getDataPolicy().withPersistence()) {
            return true;
        }
        if (region instanceof PartitionedRegion && !(partitionedRegion = (PartitionedRegion)region).isDataStore()) {
            return partitionedRegion.getRegionAdvisor().advisePersistentMembers().size() > 0;
        }
        return false;
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, VersionTag<?> versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int parts = 2;
        if (sendOldValue) {
            flags |= 1;
            if (oldValueIsObject) {
                flags |= 2;
            }
            ++parts;
        }
        if (versionTag != null) {
            flags |= 4;
            ++parts;
        }
        replyMsg.setNumberOfParts(parts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(Put70.okBytes());
        replyMsg.addIntPart(flags);
        if (sendOldValue) {
            replyMsg.addObjPart(oldValue);
        }
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, byte nwHopType, VersionTag<?> versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int parts = 1;
        ++parts;
        if (sendOldValue) {
            flags |= 1;
            if (oldValueIsObject) {
                flags |= 2;
            }
            ++parts;
        }
        if (versionTag != null) {
            flags |= 4;
            ++parts;
        }
        replyMsg.setNumberOfParts(parts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHopType});
        replyMsg.addIntPart(flags);
        if (sendOldValue) {
            replyMsg.addObjPart(oldValue);
        }
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

