/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.AuthIds;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUserAuths;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageIdExtractor;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.RandomSubjectIdGenerator;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionCollection;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeFactory;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.cache.tier.sockets.command.Default;
import org.apache.geode.internal.cache.tier.sockets.command.PutUserCredentials;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationExpiredException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;
import org.jetbrains.annotations.TestOnly;

public class ServerConnection
implements Runnable {
    protected static final Logger logger = LogService.getLogger();
    private static final Logger secureLogger = LogService.getLogger((String)"org.apache.geode.security");
    private static final int TIMEOUT_BUFFER_FOR_CONNECTION_CLEANUP_MS = 5000;
    private static final String DISALLOW_INTERNAL_MESSAGES_WITHOUT_CREDENTIALS_NAME = "geode.disallow-internal-messages-without-credentials";
    public static final String USER_NOT_FOUND = "User authorization attributes not found.";
    @MutableForTesting
    public static boolean allowInternalMessagesWithoutCredentials = !Boolean.getBoolean("geode.disallow-internal-messages-without-credentials");
    private Map<Integer, Command> commands;
    protected final SecurityService securityService;
    protected final CacheServerStats stats;
    private final ServerSideHandshakeFactory handshakeFactory;
    @MakeNotStatic
    private static final ConcurrentHashMap<Integer, LinkedBlockingQueue<ByteBuffer>> commBufferMap = new ConcurrentHashMap(4, 0.75f, 1);
    private ServerConnectionCollection serverConnectionCollection;
    private final ProcessingMessageTimer processingMessageTimer;
    private boolean doHandshake;
    private final ThreadsMonitoring threadMonitoring;
    private AbstractExecutor threadMonitorExecutor;
    Socket theSocket;
    private ByteBuffer commBuffer;
    protected final CachedRegionHelper crHelper;
    protected String name;
    private Message requestMessage;
    private final Message replyMessage;
    private final Message responseMessage;
    private final Message errorMessage;
    private final ChunkedMessage queryResponseMessage;
    private final ChunkedMessage chunkedResponseMessage;
    private final ChunkedMessage executeFunctionResponseMessage;
    private final ChunkedMessage registerInterestResponseMessage;
    private final ChunkedMessage keySetResponseMessage;
    @Deprecated
    private final InternalLogWriter logWriter;
    @Deprecated
    private final InternalLogWriter securityLogWriter;
    final Acceptor acceptor;
    protected ServerSideHandshake handshake;
    private int handshakeTimeout;
    private final Object handshakeMonitor;
    private volatile int requestSpecificTimeout;
    private int latestBatchIdReplied;
    private ClientProxyMembershipID proxyId;
    private byte[] memberIdByteArray;
    private AuthorizeRequestPP postAuthzRequest;
    protected final CommunicationMode communicationMode;
    @MakeNotStatic
    private static final ConcurrentHashMap<ClientProxyMembershipID, ClientUserAuths> proxyIdVsClientUserAuths = new ConcurrentHashMap();
    private ClientUserAuths clientUserAuths;
    private final Object clientUserAuthsLock;
    private long connectionId;
    private final Random randomConnectionIdGen;
    private Part securePart;
    protected Principal principal;
    private MessageIdExtractor messageIdExtractor;
    @MutableForTesting
    private static boolean TEST_VERSION_AFTER_HANDSHAKE_FLAG;
    private static final ThreadLocal<Byte> executeFunctionOnLocalNodeOnly;
    private boolean incedCleanupTableRef;
    private boolean incedCleanupProxyIdTableRef;
    private final Object chmLock;
    private boolean chmRegistered;
    private boolean clientDisconnectedCleanly;
    private Throwable clientDisconnectedException;
    private int failureCount;
    private volatile boolean processMessages;
    private final Object terminationLock;
    private boolean terminated;
    @MutableForTesting
    private static boolean forceClientCrashEvent;
    private boolean requiresResponse;
    private boolean requiresChunkedResponse;
    private boolean potentialModification;
    private boolean responded;
    private Object modKey;
    private String modRegion;
    private long userAuthId;

    public static ByteBuffer allocateCommBuffer(int size, Socket sock) {
        if (sock.getChannel() == null) {
            return ByteBuffer.allocate(size);
        }
        LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(size);
        ByteBuffer result = null;
        if (q != null) {
            result = q.poll();
        }
        if (result == null) {
            result = ByteBuffer.allocateDirect(size);
        } else {
            result.position(0);
            result.limit(result.capacity());
        }
        return result;
    }

    public static void releaseCommBuffer(ByteBuffer bb) {
        if (bb != null && bb.isDirect()) {
            LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(bb.capacity());
            if (q == null) {
                q = new LinkedBlockingQueue();
                LinkedBlockingQueue<ByteBuffer> oldQ = commBufferMap.putIfAbsent(bb.capacity(), q);
                if (oldQ != null) {
                    q = oldQ;
                }
            }
            q.offer(bb);
        }
    }

    public static void emptyCommBufferPool() {
        for (LinkedBlockingQueue<ByteBuffer> q : commBufferMap.values()) {
            q.clear();
        }
    }

    public ServerConnection(Socket socket, InternalCache internalCache, CachedRegionHelper cachedRegionHelper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) {
        block5: {
            this.handshakeFactory = new ServerSideHandshakeFactory();
            this.processingMessageTimer = new ProcessingMessageTimer();
            this.doHandshake = true;
            this.requestMessage = new Message(2, KnownVersion.CURRENT);
            this.replyMessage = new Message(1, KnownVersion.CURRENT);
            this.responseMessage = new Message(1, KnownVersion.CURRENT);
            this.errorMessage = new Message(1, KnownVersion.CURRENT);
            this.queryResponseMessage = new ChunkedMessage(2, KnownVersion.CURRENT);
            this.chunkedResponseMessage = new ChunkedMessage(1, KnownVersion.CURRENT);
            this.executeFunctionResponseMessage = new ChunkedMessage(1, KnownVersion.CURRENT);
            this.registerInterestResponseMessage = new ChunkedMessage(1, KnownVersion.CURRENT);
            this.keySetResponseMessage = new ChunkedMessage(1, KnownVersion.CURRENT);
            this.handshakeMonitor = new Object();
            this.requestSpecificTimeout = -1;
            this.latestBatchIdReplied = -1;
            this.clientUserAuthsLock = new Object();
            this.connectionId = 26739L;
            this.messageIdExtractor = new MessageIdExtractor();
            this.chmLock = new Object();
            this.processMessages = true;
            this.terminationLock = new Object();
            StringBuilder buffer = new StringBuilder(100);
            if (acceptor.isGatewayReceiver()) {
                buffer.append("GatewayReceiver connection from [");
            } else {
                buffer.append("Server connection from [");
            }
            buffer.append(communicationModeStr).append(" host address=").append(socket.getInetAddress().getHostAddress()).append("; ").append(communicationModeStr).append(" port=").append(socket.getPort()).append("]");
            this.name = buffer.toString();
            this.stats = stats;
            this.acceptor = acceptor;
            this.crHelper = cachedRegionHelper;
            this.logWriter = (InternalLogWriter)internalCache.getLogger();
            this.securityLogWriter = (InternalLogWriter)internalCache.getSecurityLoggerI18n();
            this.communicationMode = CommunicationMode.fromModeNumber(communicationMode);
            this.principal = null;
            this.postAuthzRequest = null;
            this.randomConnectionIdGen = new Random(this.hashCode());
            this.securityService = securityService;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                this.theSocket = socket;
                this.theSocket.setSendBufferSize(socketBufferSize);
                this.theSocket.setReceiveBufferSize(socketBufferSize);
                if (isDebugEnabled) {
                    logger.debug("{}: Accepted client connection from {}[client host={}; client port={}]", (Object)this.getName(), (Object)communicationModeStr, (Object)socket.getInetAddress(), (Object)socket.getPort());
                }
                this.handshakeTimeout = hsTimeout;
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                logger.debug("While creating server connection", (Throwable)e);
            }
        }
        this.threadMonitoring = this.getCache().getInternalDistributedSystem().getDM().getThreadMonitoring();
        this.initStreams(socket, socketBufferSize, stats);
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public static void executeFunctionOnLocalNodeOnly(Byte value) {
        byte b = value;
        executeFunctionOnLocalNodeOnly.set(b);
    }

    public static Byte isExecuteFunctionOnLocalNodeOnly() {
        return executeFunctionOnLocalNodeOnly.get();
    }

    @VisibleForTesting
    void setServerConnectionCollection(ServerConnectionCollection serverConnectionCollection) {
        this.serverConnectionCollection = serverConnectionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyClientConnection() {
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (this.handshake == null) {
                ServerSideHandshake readHandshake;
                try {
                    readHandshake = this.handshakeFactory.readHandshake(this.getSocket(), this.getHandShakeTimeout(), this.getCommunicationMode(), this.getDistributedSystem(), this.getSecurityService());
                }
                catch (SocketTimeoutException timeout) {
                    logger.warn("{}: Handshake reply code timeout, not received with in {} ms", (Object)this.getName(), (Object)this.handshakeTimeout);
                    this.failConnectionAttempt();
                    return false;
                }
                catch (EOFException | SocketException e) {
                    logger.info("{} {}", (Object)this.getName(), (Object)e);
                    this.failConnectionAttempt();
                    return false;
                }
                catch (IOException e) {
                    logger.warn(this.getName() + ": Received no handshake reply code", (Throwable)e);
                    this.failConnectionAttempt();
                    return false;
                }
                catch (AuthenticationFailedException | AuthenticationRequiredException ex) {
                    this.handleHandshakeAuthenticationException(ex);
                    return false;
                }
                catch (UnsupportedVersionException uve) {
                    logger.warn("{} {}", (Object)this.getName(), (Object)uve.getMessage(), (Object)uve);
                    this.handleHandshakeException(uve);
                    return false;
                }
                catch (Exception ex) {
                    logger.warn("{} {}", (Object)this.getName(), (Object)ex.getLocalizedMessage());
                    this.handleHandshakeException(ex);
                    return false;
                }
                this.setHandshake(readHandshake);
                this.setProxyId(readHandshake.getMembershipId());
                if (this.getCommunicationMode().isWAN()) {
                    try {
                        this.setAuthAttributes();
                    }
                    catch (AuthenticationFailedException | AuthenticationRequiredException ex) {
                        this.handleHandshakeAuthenticationException(ex);
                        return false;
                    }
                    catch (Exception ex) {
                        logger.warn("{} {}", (Object)this.getName(), (Object)ex.getLocalizedMessage());
                        this.handleHandshakeException(ex);
                        return false;
                    }
                }
                if (this.handshake.isOK()) {
                    try {
                        return this.processHandShake();
                    }
                    catch (CancelException e) {
                        if (!this.crHelper.isShutdown()) {
                            logger.warn(this.getName() + ": Unexpected cancellation: ", (Throwable)e);
                        }
                        this.cleanup();
                        return false;
                    }
                }
                this.crHelper.checkCancelInProgress(null);
                logger.warn("Received Unknown handshake reply code.");
                this.refuseHandshake("Received Unknown handshake reply code.", (byte)61);
                return false;
            }
        }
        return true;
    }

    private void failConnectionAttempt() {
        this.stats.incFailedConnectionAttempts();
        this.cleanup();
    }

    private void handleHandshakeException(Exception ex) {
        this.refuseHandshake(ex.getMessage(), (byte)60);
        this.failConnectionAttempt();
    }

    private void handleHandshakeAuthenticationException(Exception ex) {
        if (ex instanceof AuthenticationRequiredException) {
            AuthenticationRequiredException noauth = (AuthenticationRequiredException)ex;
            Object exStr = noauth.getLocalizedMessage();
            if (noauth.getCause() != null) {
                exStr = (String)exStr + " : " + noauth.getCause().getLocalizedMessage();
            }
            if (this.securityLogWriter.warningEnabled()) {
                this.securityLogWriter.warning(String.format("%s", this.getName() + ": Security exception: " + (String)exStr));
            }
            this.refuseHandshake(noauth.getMessage(), (byte)62);
            this.failConnectionAttempt();
        } else if (ex instanceof AuthenticationFailedException) {
            AuthenticationFailedException failed = (AuthenticationFailedException)ex;
            Object exStr = failed.getLocalizedMessage();
            if (failed.getCause() != null) {
                exStr = (String)exStr + " : " + failed.getCause().getLocalizedMessage();
            }
            if (this.securityLogWriter.warningEnabled()) {
                this.securityLogWriter.warning(String.format("%s", this.getName() + ": Security exception: " + (String)exStr));
            }
            this.refuseHandshake(failed.getMessage(), (byte)63);
            this.failConnectionAttempt();
        } else {
            logger.warn("Unexpected exception type in ServerConnection handleHandshakeAuthenticationException");
            throw new RuntimeException("Invalid exception type, must be either AuthenticationRequiredException or AuthenticationFailedException", ex);
        }
    }

    protected Map<Integer, Command> getCommands() {
        return this.commands;
    }

    protected Socket getSocket() {
        return this.theSocket;
    }

    private int getHandShakeTimeout() {
        return this.handshakeTimeout;
    }

    protected DistributedSystem getDistributedSystem() {
        return this.getCache().getDistributedSystem();
    }

    public InternalCache getCache() {
        return this.crHelper.getCache();
    }

    public ServerSideHandshake getHandshake() {
        return this.handshake;
    }

    public void setHandshake(ServerSideHandshake handshake) {
        this.handshake = handshake;
        KnownVersion v = handshake.getVersion();
        this.replyMessage.setVersion(v);
        this.requestMessage.setVersion(v);
        this.responseMessage.setVersion(v);
        this.errorMessage.setVersion(v);
        this.queryResponseMessage.setVersion(v);
        this.chunkedResponseMessage.setVersion(v);
        this.executeFunctionResponseMessage.setVersion(v);
        this.registerInterestResponseMessage.setVersion(v);
        this.keySetResponseMessage.setVersion(v);
    }

    void setRequestMessage(Message requestMessage) {
        this.requestMessage = requestMessage;
    }

    public KnownVersion getClientVersion() {
        return this.handshake.getVersion();
    }

    protected void setProxyId(ClientProxyMembershipID proxyId) {
        this.proxyId = proxyId;
        this.memberIdByteArray = EventID.getMembershipId(proxyId);
        this.name = "Server connection from [" + String.valueOf(proxyId) + "; port=" + this.theSocket.getPort() + "]";
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long setUserAuthorizeAndPostAuthorizeRequest(AuthorizeRequest authzRequest, AuthorizeRequestPP postAuthzRequest) {
        UserAuthAttributes userAuthAttr = new UserAuthAttributes(authzRequest, postAuthzRequest);
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.clientUserAuths == null) {
                this.initializeClientUserAuths();
            }
            return this.clientUserAuths.putUserAuth(userAuthAttr);
        }
    }

    @Deprecated
    public InternalLogWriter getSecurityLogWriter() {
        return this.securityLogWriter;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    private Map<ServerSideHandshake, MutableInt> getCleanupTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupTable();
    }

    private Map<ClientProxyMembershipID, MutableInt> getCleanupProxyIdTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupProxyIdTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean processHandShake() {
        int queueSize;
        int endpointType;
        MutableInt numRefs;
        boolean isDebugEnabled;
        boolean clientJoined;
        boolean result;
        block56: {
            boolean registerClient;
            boolean bl;
            result = false;
            clientJoined = false;
            isDebugEnabled = logger.isDebugEnabled();
            try {
                CacheClientProxy proxy;
                Map<ServerSideHandshake, MutableInt> map = this.getCleanupTable();
                // MONITORENTER : map
                numRefs = this.getCleanupTable().get(this.handshake);
                endpointType = 0;
                queueSize = 0;
                if (!this.proxyId.isDurable()) break block56;
                if (isDebugEnabled) {
                    logger.debug("looking if the Proxy existed for this durable client or not :{}", (Object)this.proxyId);
                }
                if ((proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId)) != null && proxy.waitRemoval()) {
                    proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                }
                if (proxy != null) {
                    if (isDebugEnabled) {
                        logger.debug("Proxy existed for this durable client :{} and proxy : {}", (Object)this.proxyId, (Object)proxy);
                    }
                    if (proxy.isPrimary()) {
                        endpointType = 2;
                        queueSize = proxy.getQueueSize();
                    } else {
                        endpointType = 1;
                        queueSize = proxy.getQueueSize();
                    }
                }
                if (numRefs != null || proxy == null || proxy.isPaused()) break block56;
                String handshakeRefusalMessage = String.format("Duplicate durable clientId (%s)", this.proxyId.getDurableId());
                logger.warn("{} : {}", (Object)this.name, (Object)handshakeRefusalMessage);
                this.refuseHandshake(handshakeRefusalMessage, (byte)64);
                bl = result;
                // MONITOREXIT : map
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                registerClient = false;
                Map<ClientProxyMembershipID, MutableInt> map2 = this.getCleanupProxyIdTable();
            }
            catch (Throwable throwable) {
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                boolean registerClient2 = false;
                Map<ClientProxyMembershipID, MutableInt> map = this.getCleanupProxyIdTable();
                // MONITORENTER : map
                MutableInt numRefs2 = this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs2 != null) {
                    numRefs2.increment();
                } else {
                    registerClient2 = true;
                    this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
                }
                this.incedCleanupProxyIdTableRef = true;
                // MONITOREXIT : map
                if (isDebugEnabled) {
                    logger.debug("{}registering client {}", (Object)(registerClient2 ? "" : "not "), (Object)this.proxyId);
                }
                this.crHelper.checkCancelInProgress(null);
                if (clientJoined && this.isFiringMembershipEvents()) {
                    InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
                }
                ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
                Object object = this.chmLock;
                // MONITORENTER : object
                this.chmRegistered = true;
                // MONITOREXIT : object
                if (registerClient2) {
                    chm.registerClient(this.proxyId, this.acceptor.getMaximumTimeBetweenPings());
                }
                this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
                this.acceptor.getConnectionListener().connectionOpened(registerClient2, this.communicationMode);
                throw throwable;
            }
            MutableInt numRefs3 = this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs3 != null) {
                numRefs3.increment();
            } else {
                registerClient = true;
                this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : map2
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            Object object = this.chmLock;
            // MONITORENTER : object
            this.chmRegistered = true;
            // MONITOREXIT : object
            if (registerClient) {
                chm.registerClient(this.proxyId, this.acceptor.getMaximumTimeBetweenPings());
            }
            this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (numRefs != null) {
            if (this.acceptHandShake((byte)endpointType, queueSize)) {
                numRefs.increment();
                this.incedCleanupTableRef = true;
                result = true;
            }
            boolean bl = result;
            // MONITOREXIT : map
            if (this.isTerminated()) return false;
            if (!result) {
                return false;
            }
            boolean registerClient = false;
            Map<ClientProxyMembershipID, MutableInt> map = this.getCleanupProxyIdTable();
            // MONITORENTER : map
            Object numRefs4 = this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs4 != null) {
                numRefs4.increment();
            } else {
                registerClient = true;
                this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : map
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            numRefs4 = this.chmLock;
            // MONITORENTER : numRefs4
            this.chmRegistered = true;
            // MONITOREXIT : numRefs4
            if (registerClient) {
                chm.registerClient(this.proxyId, this.acceptor.getMaximumTimeBetweenPings());
            }
            this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (this.acceptHandShake((byte)endpointType, queueSize)) {
            clientJoined = true;
            this.getCleanupTable().put(this.handshake, new MutableInt(1));
            this.incedCleanupTableRef = true;
            this.stats.incCurrentClients();
            result = true;
        }
        boolean bl = result;
        // MONITOREXIT : map
        if (this.isTerminated()) return false;
        if (!result) {
            return false;
        }
        boolean registerClient = false;
        Object chm = this.getCleanupProxyIdTable();
        // MONITORENTER : chm
        MutableInt numRefs5 = this.getCleanupProxyIdTable().get(this.proxyId);
        if (numRefs5 != null) {
            numRefs5.increment();
        } else {
            registerClient = true;
            this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
        }
        this.incedCleanupProxyIdTableRef = true;
        // MONITOREXIT : chm
        if (isDebugEnabled) {
            logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
        }
        this.crHelper.checkCancelInProgress(null);
        if (clientJoined && this.isFiringMembershipEvents()) {
            InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
        }
        chm = this.acceptor.getClientHealthMonitor();
        Object object = this.chmLock;
        // MONITORENTER : object
        this.chmRegistered = true;
        // MONITOREXIT : object
        if (registerClient) {
            ((ClientHealthMonitor)chm).registerClient(this.proxyId, this.acceptor.getMaximumTimeBetweenPings());
        }
        this.serverConnectionCollection = ((ClientHealthMonitor)chm).addConnection(this.proxyId, this);
        this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
        return bl;
    }

    private boolean isFiringMembershipEvents() {
        return this.acceptor.isRunning() && !this.acceptor.getCachedRegionHelper().getCache().isClosed() && !this.acceptor.getCachedRegionHelper().getCache().getCancelCriterion().isCancelInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refuseHandshake(String message, byte exception) {
        try {
            this.acceptor.refuseHandshake(this.theSocket.getOutputStream(), message, exception);
        }
        catch (IOException iOException) {
        }
        finally {
            this.stats.incFailedConnectionAttempts();
            this.cleanup();
        }
    }

    private boolean acceptHandShake(byte endpointType, int queueSize) {
        return this.doHandShake(endpointType, queueSize) && this.handshakeAccepted();
    }

    protected boolean doHandShake(byte endpointType, int queueSize) {
        try {
            this.handshake.handshakeWithClient(this.theSocket.getOutputStream(), this.theSocket.getInputStream(), endpointType, queueSize, this.communicationMode, this.principal);
        }
        catch (IOException ioe) {
            if (!this.crHelper.isShutdown() && !this.isTerminated()) {
                logger.warn("{}: Handshake accept failed on socket {}: {}", (Object)this.name, (Object)this.theSocket, (Object)ioe);
            }
            this.cleanup();
            return false;
        }
        return true;
    }

    private boolean handshakeAccepted() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Accepted handshake", (Object)this.name);
        }
        if (this.communicationMode == CommunicationMode.ClientToServerForQueue) {
            this.stats.incCurrentQueueConnections();
        } else {
            this.stats.incCurrentClientConnections();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCq(String cqName, boolean isDurable) throws Exception {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMessage.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("setCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                byte[] secureBytes = this.requestMessage.getSecureBytes();
                secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
                AuthIds aIds = new AuthIds(secureBytes);
                long uniqueId = aIds.getUniqueId();
                CacheClientProxy proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                if (proxy == null) return;
                proxy.setCQVsUserAuth(cqName, uniqueId, isDurable);
                return;
            }
            catch (Exception ex) {
                if (!isDebugEnabled) throw ex;
                logger.debug("While setting cq got exception ", (Throwable)ex);
                throw ex;
            }
        } else {
            if (!isDebugEnabled) return;
            logger.debug("setCq() security header is not found ");
        }
    }

    public void removeCq(String cqName, boolean isDurable) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMessage.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("removeCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                this.clientUserAuths.removeUserAuthAttributesForCq(cqName, isDurable);
            }
            catch (Exception ex) {
                if (isDebugEnabled) {
                    logger.debug("While setting cq got exception ", (Throwable)ex);
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("removeCq() security header is not found");
        }
    }

    public boolean isClientServerConnection() {
        return this.communicationMode.isClientToServerOrSubscriptionFeed();
    }

    public boolean getProcessMessages() {
        return this.processMessages;
    }

    @VisibleForTesting
    void setProcessMessages(boolean processMessages) {
        this.processMessages = processMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandshake() {
        if (this.verifyClientConnection()) {
            this.initializeCommands();
            if (!this.getCommunicationMode().isWAN()) {
                Object object = this.clientUserAuthsLock;
                synchronized (object) {
                    this.initializeClientUserAuths();
                }
            }
        }
        if (TEST_VERSION_AFTER_HANDSHAKE_FLAG) {
            short testVersionAfterHandshake = 4;
            Assert.assertTrue(this.handshake.getVersion().ordinal() == testVersionAfterHandshake, "Found different version after handshake");
            TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doNormalMessage() {
        if (this.serverConnectionCollection == null) {
            logger.warn("Continued processing ServerConnection after handshake failed");
            this.processMessages = false;
            return;
        }
        Message message = this.getMessage();
        if (!this.serverConnectionCollection.incrementConnectionsProcessing()) {
            this.processMessages = false;
            return;
        }
        if (this.isTerminated()) {
            this.processMessages = false;
            return;
        }
        ThreadState threadState = null;
        this.resumeThreadMonitoring();
        try {
            if (message != null) {
                Command command;
                if (!this.processMessages || this.crHelper.isShutdown()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} ignoring message of type {} from client {} due to shutdown.", (Object)this.getName(), (Object)MessageType.getString(message.getMessageType()), (Object)this.proxyId);
                    }
                    return;
                }
                if (message.getMessageType() != 5 && message.getNumberOfParts() <= 0) {
                    ++this.failureCount;
                    if (this.failureCount > 3) {
                        this.processMessages = false;
                        return;
                    }
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{} received {} with txid {}", (Object)this.getName(), (Object)MessageType.getString(message.getMessageType()), (Object)message.getTransactionId());
                    if (message.getTransactionId() < -1) {
                        message.setTransactionId(-1);
                    }
                }
                if (message.getMessageType() != 5) {
                    this.acceptor.getClientHealthMonitor().receivedPing(this.proxyId);
                }
                if ((command = this.getCommand(message.getMessageType())) == null) {
                    command = Default.getCommand();
                }
                threadState = this.bindSubject(command);
                command.execute(message, this, this.securityService);
            }
        }
        finally {
            this.suspendThreadMonitoring();
            this.serverConnectionCollection.connectionsProcessing.decrementAndGet();
            this.setNotProcessingMessage();
            this.clearRequestMessage();
            if (threadState != null) {
                threadState.clear();
            }
        }
    }

    ThreadState bindSubject(Command command) {
        if (!this.securityService.isIntegratedSecurity()) {
            return null;
        }
        if (this.communicationMode.isWAN()) {
            return null;
        }
        if (command instanceof PutUserCredentials) {
            return null;
        }
        if (this.isInternalMessage(this.requestMessage, allowInternalMessagesWithoutCredentials)) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        String messageType = MessageType.getString(this.requestMessage.getMessageType());
        if (uniqueId == 0L || uniqueId == -1L) {
            logger.debug("No unique ID yet. {}, {}", (Object)messageType, (Object)this.getName());
            return null;
        }
        Subject subject = this.clientUserAuths.getSubject(uniqueId);
        if (subject == null) {
            secureLogger.warn("Failed to bind the subject of uniqueId {} for message {} with {} : Possible re-authentication required", (Object)uniqueId, (Object)messageType, (Object)this.getName());
            throw new AuthenticationRequiredException("Failed to find the authenticated user.");
        }
        ThreadState threadState = this.securityService.bindSubject(subject);
        secureLogger.debug("Bound {} with uniqueId {} for message {} with {}", subject.getPrincipal(), (Object)uniqueId, (Object)messageType, (Object)this.getName());
        return threadState;
    }

    @VisibleForTesting
    Message getMessage() {
        return BaseCommand.readRequest(this);
    }

    private void suspendThreadMonitoring() {
        if (this.threadMonitorExecutor != null) {
            this.threadMonitorExecutor.suspendMonitoring();
        }
    }

    @VisibleForTesting
    void resumeThreadMonitoring() {
        if (this.threadMonitorExecutor != null) {
            this.threadMonitorExecutor.resumeMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.terminationLock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanClientAuths() {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.clientUserAuths != null) {
                this.clientUserAuths.cleanup(false);
                this.clientUserAuths = null;
            }
        }
    }

    void handleTermination() {
        if (this.crHelper.isShutdown()) {
            this.setClientDisconnectCleanly();
        }
        this.handleTermination(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTermination(boolean timedOut) {
        MutableInt numRefs;
        Object object = this.terminationLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.setNotProcessingMessage();
        boolean clientDeparted = false;
        boolean cleanupStats = false;
        Map<ServerSideHandshake, MutableInt> map = this.getCleanupTable();
        synchronized (map) {
            if (this.incedCleanupTableRef) {
                this.incedCleanupTableRef = false;
                cleanupStats = true;
                numRefs = this.getCleanupTable().get(this.handshake);
                if (numRefs != null) {
                    numRefs.decrement();
                    if (numRefs.intValue() <= 0) {
                        clientDeparted = true;
                        this.getCleanupTable().remove(this.handshake);
                        this.stats.decCurrentClients();
                    }
                }
                if (this.communicationMode == CommunicationMode.ClientToServerForQueue) {
                    this.stats.decCurrentQueueConnections();
                } else {
                    this.stats.decCurrentClientConnections();
                }
            }
        }
        boolean unregisterClient = false;
        numRefs = this.getCleanupProxyIdTable();
        synchronized (numRefs) {
            if (this.incedCleanupProxyIdTableRef) {
                this.incedCleanupProxyIdTableRef = false;
                MutableInt numRefs2 = this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs2 != null) {
                    numRefs2.decrement();
                    if (numRefs2.intValue() <= 0) {
                        unregisterClient = true;
                        this.getCleanupProxyIdTable().remove(this.proxyId);
                        proxyIdVsClientUserAuths.remove(this.proxyId);
                    }
                }
            }
        }
        this.cleanup(timedOut);
        if (this.getAcceptor().isRunning() && clientDeparted && this.isFiringMembershipEvents()) {
            if (this.clientDisconnectedCleanly && !forceClientCrashEvent) {
                InternalClientMembership.notifyClientLeft(this.proxyId.getDistributedMember());
            } else {
                InternalClientMembership.notifyClientCrashed(this.proxyId.getDistributedMember());
            }
        }
        boolean needsUnregister = false;
        Object object2 = this.chmLock;
        synchronized (object2) {
            if (this.chmRegistered) {
                needsUnregister = true;
                this.chmRegistered = false;
            }
        }
        if (needsUnregister) {
            this.acceptor.getClientHealthMonitor().removeConnection(this.proxyId, this);
            if (unregisterClient) {
                this.acceptor.getClientHealthMonitor().unregisterClient(this.proxyId, this.getAcceptor(), this.clientDisconnectedCleanly, this.clientDisconnectedException);
            }
        }
        if (unregisterClient) {
            secureLogger.debug("ServerConnection.handleTermination clean client auths");
            this.cleanClientAuths();
        }
        if (cleanupStats) {
            this.acceptor.getConnectionListener().connectionClosed(clientDeparted, this.communicationMode);
        }
    }

    protected void doOneMessage() {
        if (this.doHandshake) {
            this.doHandshake();
            this.doHandshake = false;
        } else {
            this.resetTransientData();
            this.doNormalMessage();
        }
    }

    private void initializeClientUserAuths() {
        this.clientUserAuths = ServerConnection.getClientUserAuths(this.proxyId);
    }

    static ClientUserAuths getClientUserAuths(ClientProxyMembershipID proxyId) {
        int proxyIdHashCode = proxyId.hashCode();
        Consumer<Random> initializer = r -> r.setSeed((long)proxyIdHashCode + System.currentTimeMillis());
        RandomSubjectIdGenerator idGenerator = new RandomSubjectIdGenerator(new Random(), initializer);
        ClientUserAuths clientUserAuths = new ClientUserAuths(idGenerator);
        ClientUserAuths returnedClientUserAuths = proxyIdVsClientUserAuths.putIfAbsent(proxyId, clientUserAuths);
        if (returnedClientUserAuths == null) {
            return clientUserAuths;
        }
        return returnedClientUserAuths;
    }

    void initializeCommands() {
        KnownVersion clientVersion = this.getClientVersion();
        if (!clientVersion.hasClientServerProtocolChange()) {
            clientVersion = clientVersion.getClientServerProtocolVersion();
        }
        this.commands = CommandInitializer.getDefaultInstance().get(clientVersion);
    }

    private Command getCommand(Integer messageType) {
        return this.commands.get(messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAuth(Message message, boolean keepAlive) {
        try {
            byte[] secureBytes = message.getSecureBytes();
            secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
            AuthIds aIds = new AuthIds(secureBytes);
            long connId = aIds.getConnectionId();
            if (connId != this.connectionId) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            Object object = this.clientUserAuthsLock;
            synchronized (object) {
                if (this.clientUserAuths != null) {
                    this.clientUserAuths.removeSubject(aIds.getUniqueId());
                    this.clientUserAuths.removeUserId(aIds.getUniqueId(), keepAlive);
                }
            }
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException("Authentication failed", exception);
        }
    }

    public byte[] setCredentials(Message message, long existingUniqueId) {
        if (!AcceptorImpl.isAuthenticationRequired() && message.isSecureMode()) {
            return new byte[0];
        }
        if (!message.isSecureMode()) {
            throw new AuthenticationFailedException("Authentication failed");
        }
        return this.getUniqueIdBytes(message, existingUniqueId);
    }

    @VisibleForTesting
    byte[] getUniqueIdBytes(Message message, long existingUniqueId) {
        try {
            return this.encryptId(this.getUniqueId(message, existingUniqueId));
        }
        catch (CacheClosedException | AuthenticationExpiredException | AuthenticationFailedException | AuthenticationRequiredException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException("REPLY_REFUSED", exception);
        }
    }

    @VisibleForTesting
    long getUniqueId(Message message, long existingUniqueId) throws Exception {
        Properties credentials;
        byte[] secureBytes = message.getSecureBytes();
        secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
        AuthIds aIds = new AuthIds(secureBytes);
        long connId = aIds.getConnectionId();
        if (connId != this.connectionId) {
            throw new AuthenticationFailedException("Authentication failed");
        }
        byte[] credBytes = message.getPart(0).getSerializedForm();
        credBytes = this.handshake.getEncryptor().decryptBytes(credBytes);
        try (ByteArrayDataInput dinp = new ByteArrayDataInput(credBytes);){
            credentials = DataSerializer.readProperties((DataInput)dinp);
        }
        DistributedSystem system = this.getDistributedSystem();
        String methodName = system.getProperties().getProperty("security-client-authenticator");
        Object principal = Handshake.verifyCredentials(methodName, credentials, system.getSecurityProperties(), (InternalLogWriter)system.getLogWriter(), (InternalLogWriter)system.getSecurityLogWriter(), this.proxyId.getDistributedMember(), this.securityService);
        long uniqueId = principal instanceof Subject ? this.putSubject((Subject)principal, existingUniqueId) : this.getUniqueId((Principal)principal);
        return uniqueId;
    }

    @VisibleForTesting
    long putSubject(Subject subject, long existingUniqueId) {
        long uniqueId = this.clientUserAuths.putSubject(subject, existingUniqueId);
        CacheClientProxy clientProxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.getProxyID());
        if (clientProxy != null && clientProxy.getSubject() != null && clientProxy.isWaitingForReAuthentication()) {
            secureLogger.debug("update subject on client proxy {} with uniqueId {}", (Object)clientProxy, (Object)uniqueId);
            clientProxy.setSubject(subject);
            clientProxy.notifyReAuthentication();
        }
        return uniqueId;
    }

    @TestOnly
    protected ClientUserAuths getClientUserAuths() {
        return this.clientUserAuths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    protected void setClientUserAuths(ClientUserAuths clientUserAuths) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            this.clientUserAuths = clientUserAuths;
        }
    }

    private void setSecurityPart() {
        try {
            this.connectionId = this.randomConnectionIdGen.nextLong();
            this.securePart = new Part();
            byte[] id = this.encryptId(this.connectionId);
            this.securePart.setPartState(id, false);
        }
        catch (Exception ex) {
            logger.warn("Server failed to encrypt data " + String.valueOf(ex));
            throw new GemFireSecurityException("Server failed to encrypt response message.");
        }
    }

    public Part updateAndGetSecurityPart() {
        if (AcceptorImpl.isAuthenticationRequired() && !this.communicationMode.isWAN() && !this.requestMessage.getAndResetIsMetaRegion() && !this.isInternalMessage(this.requestMessage, allowInternalMessagesWithoutCredentials)) {
            this.setSecurityPart();
            return this.securePart;
        }
        if (AcceptorImpl.isAuthenticationRequired() && logger.isDebugEnabled()) {
            logger.debug("ServerConnection.updateAndGetSecurityPart() not adding security part for message type {}", (Object)MessageType.getString(this.requestMessage.messageType));
        }
        return null;
    }

    public boolean isInternalMessage(Message message, boolean allowOldInternalMessages) {
        boolean isInternalMessage;
        int messageType = message.getMessageType();
        boolean bl = isInternalMessage = messageType == 5 || messageType == 68 || messageType == 31 || messageType == 78 || messageType == 53 || messageType == 81 || messageType == 88 || messageType == 90 || messageType == 85 || messageType == 87 || messageType == 18 || messageType == -1 || messageType == 52 || messageType == 71 || messageType == 73;
        if (!isInternalMessage && allowOldInternalMessages) {
            isInternalMessage = messageType == 48 || messageType == 49 || messageType == 67 || messageType == 51 || messageType == 94 || messageType == 93 || messageType == 92 || messageType == 91 || messageType == 96 || messageType == 97 || messageType == 98 || messageType == 101 || messageType == 102;
        }
        return isInternalMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.getAcceptor().isSelector()) {
            boolean finishedMessage = false;
            try {
                this.stats.decThreadQueueSize();
                if (this.isTerminated()) return;
                this.getAcceptor().setTLCommBuffer();
                this.doOneMessage();
                if (!this.processMessages || this.crHelper.isShutdown()) return;
                this.registerWithSelector();
                finishedMessage = true;
                return;
            }
            catch (ClosedChannelException | CancelException exception) {
                return;
            }
            catch (IOException ex) {
                logger.warn("Unexpected Exception", (Throwable)ex);
                this.setClientDisconnectedException(ex);
                return;
            }
            catch (AuthenticationRequiredException ex) {
                logger.warn("Unexpected Exception", (Throwable)ex);
                return;
            }
            finally {
                this.getAcceptor().releaseTLCommBuffer();
                this.setNotProcessingMessage();
                this.unsetRequestSpecificTimeout();
                if (!finishedMessage) {
                    try {
                        this.handleTermination();
                    }
                    catch (CancelException ex) {}
                }
            }
        }
        this.threadMonitorExecutor = this.threadMonitoring.createAbstractExecutor(ThreadsMonitoring.Mode.ServerConnectionExecutor);
        this.suspendThreadMonitoring();
        this.threadMonitoring.register(this.threadMonitorExecutor);
        try {
            while (this.processMessages && !this.crHelper.isShutdown()) {
                try {
                    this.doOneMessage();
                }
                catch (CancelException cancelException) {}
                continue;
                finally {
                    this.unsetRequestSpecificTimeout();
                    Breadcrumbs.clearBreadcrumb();
                }
            }
            return;
        }
        finally {
            this.threadMonitoring.unregister(this.threadMonitorExecutor);
            try {
                this.unsetRequestSpecificTimeout();
                this.handleTermination();
                DistributedSystem.releaseThreadsSockets();
            }
            catch (CancelException cancelException) {}
        }
    }

    void registerWithSelector() throws IOException {
        this.getSelectableChannel().configureBlocking(false);
        this.getAcceptor().registerServerConnection(this);
    }

    SelectableChannel getSelectableChannel() {
        return this.theSocket.getChannel();
    }

    void registerWithSelector2(Selector s) throws ClosedChannelException {
        this.getSelectableChannel().register(s, 1, this);
    }

    void makeBlocking() throws IOException {
        SocketChannel c = this.theSocket.getChannel();
        ((SelectableChannel)c).configureBlocking(true);
    }

    public static void setForceClientCrashEvent(boolean value) {
        forceClientCrashEvent = value;
    }

    public String getMembershipID() {
        return this.proxyId.getDSMembership();
    }

    public int getSocketPort() {
        return this.theSocket.getPort();
    }

    public String getSocketHost() {
        return this.theSocket.getInetAddress().getHostAddress();
    }

    protected CommunicationMode getCommunicationMode() {
        return this.communicationMode;
    }

    InetAddress getSocketAddress() {
        return this.theSocket.getInetAddress();
    }

    public void setRequestSpecificTimeout(int requestSpecificTimeout) {
        this.requestSpecificTimeout = requestSpecificTimeout;
    }

    private void unsetRequestSpecificTimeout() {
        this.requestSpecificTimeout = -1;
    }

    protected int getClientReadTimeout() {
        if (this.requestSpecificTimeout == -1) {
            return this.handshake.getClientReadTimeout();
        }
        return this.requestSpecificTimeout;
    }

    void setProcessingMessage() {
        this.processingMessageTimer.setProcessingMessage();
    }

    void updateProcessingMessage() {
        this.processingMessageTimer.updateProcessingMessage();
    }

    private void setNotProcessingMessage() {
        this.processingMessageTimer.setNotProcessingMessage();
    }

    long getCurrentMessageProcessingTime() {
        return this.processingMessageTimer.getCurrentMessageProcessingTime();
    }

    boolean hasBeenTimedOutOnClient() {
        int timeout = this.getClientReadTimeout();
        if (timeout > 0) {
            return this.getCurrentMessageProcessingTime() > (long)(timeout += 5000);
        }
        return false;
    }

    public String getSocketString() {
        try {
            return String.valueOf(this.theSocket.getInetAddress()) + ":" + this.theSocket.getPort() + " timeout: " + this.theSocket.getSoTimeout();
        }
        catch (Exception e) {
            return String.format("Error in getSocketString: %s", e.getLocalizedMessage());
        }
    }

    private void clearRequestMessage() {
        this.requestMessage.clear();
    }

    public void incrementLatestBatchIdReplied(int justProcessed) {
        if (justProcessed - this.latestBatchIdReplied != 1) {
            this.stats.incOutOfOrderBatchIds();
            logger.warn("Batch IDs are out of order. Setting latestBatchId to: {}. It was: {}", (Object)justProcessed, (Object)this.latestBatchIdReplied);
        }
        this.latestBatchIdReplied = justProcessed;
    }

    public int getLatestBatchIdReplied() {
        return this.latestBatchIdReplied;
    }

    void initStreams(Socket s, int socketBufferSize, MessageStats messageStats) {
        try {
            this.commBuffer = this.getAcceptor().isSelector() ? null : ServerConnection.allocateCommBuffer(socketBufferSize, s);
            this.requestMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.replyMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.responseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.errorMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.chunkedResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.queryResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.executeFunctionResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.registerInterestResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.keySetResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        return this.theSocket == null || !this.theSocket.isConnected() || this.theSocket.isClosed();
    }

    public void cleanup(boolean timedOut) {
        if (this.cleanup() && timedOut) {
            this.stats.incConnectionsTimedOut();
        }
    }

    public boolean cleanup() {
        if (this.isClosed()) {
            return false;
        }
        if (this.communicationMode.isWAN() || this.communicationMode.isCountedAsClientServerConnection()) {
            this.getAcceptor().decClientServerConnectionCount();
        }
        if (!this.theSocket.isClosed()) {
            String closerName = this.communicationMode.isWAN() ? "WANSocketCloser" : "CacheServerSocketCloser";
            this.acceptor.getSocketCloser().asyncClose(this.theSocket, closerName, () -> {}, this::cleanupAfterSocketClose);
            return true;
        }
        this.cleanupAfterSocketClose();
        return true;
    }

    protected void cleanupAfterSocketClose() {
        block4: {
            try {
                if (this.postAuthzRequest != null) {
                    this.postAuthzRequest.close();
                    this.postAuthzRequest = null;
                }
            }
            catch (Exception ex) {
                if (!this.securityLogWriter.warningEnabled()) break block4;
                this.securityLogWriter.warning(String.format("%s: An exception was thrown while closing client post-process authorization callback. %s", this.name, ex));
            }
        }
        this.getAcceptor().unregisterServerConnection(this);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Closed connection", (Object)this.name);
        }
        this.releaseCommBuffer();
        this.processMessages = false;
    }

    private void releaseCommBuffer() {
        ByteBuffer byteBuffer = this.commBuffer;
        if (byteBuffer != null) {
            this.commBuffer = null;
            ServerConnection.releaseCommBuffer(byteBuffer);
        }
    }

    public void emergencyClose() {
        this.terminated = true;
        Socket s = this.theSocket;
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyId;
    }

    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    public CacheServerStats getCacheServerStats() {
        return this.stats;
    }

    public Message getReplyMessage() {
        return this.replyMessage;
    }

    public ChunkedMessage getChunkedResponseMessage() {
        return this.chunkedResponseMessage;
    }

    public Message getErrorResponseMessage() {
        return this.errorMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    Message getRequestMessage() {
        return this.requestMessage;
    }

    ChunkedMessage getQueryResponseMessage() {
        return this.queryResponseMessage;
    }

    public ChunkedMessage getFunctionResponseMessage() {
        return this.executeFunctionResponseMessage;
    }

    ChunkedMessage getKeySetResponseMessage() {
        return this.keySetResponseMessage;
    }

    public ChunkedMessage getRegisterInterestResponseMessage() {
        return this.registerInterestResponseMessage;
    }

    void resetTransientData() {
        this.potentialModification = false;
        this.requiresResponse = false;
        this.responded = false;
        this.requiresChunkedResponse = false;
        this.modKey = null;
        this.modRegion = null;
        this.queryResponseMessage.setNumberOfParts(2);
        this.chunkedResponseMessage.setNumberOfParts(1);
        this.executeFunctionResponseMessage.setNumberOfParts(1);
        this.registerInterestResponseMessage.setNumberOfParts(1);
        this.keySetResponseMessage.setNumberOfParts(1);
    }

    String getModRegion() {
        return this.modRegion;
    }

    Object getModKey() {
        return this.modKey;
    }

    boolean getPotentialModification() {
        return this.potentialModification;
    }

    public void setModificationInfo(boolean potentialModification, String modRegion, Object modKey) {
        this.potentialModification = potentialModification;
        this.modRegion = modRegion;
        this.modKey = modKey;
    }

    public void setAsTrue(int boolID) {
        switch (boolID) {
            case 1: {
                this.responded = true;
                break;
            }
            case 2: {
                this.requiresResponse = true;
                break;
            }
            case 3: {
                this.requiresChunkedResponse = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The ID passed is %s which does not correspond with any transient data", boolID));
            }
        }
    }

    public boolean getTransientFlag(int boolID) {
        return switch (boolID) {
            case 1 -> this.responded;
            case 2 -> this.requiresResponse;
            case 3 -> this.requiresChunkedResponse;
            default -> throw new IllegalArgumentException(String.format("The ID passed is %s which does not correspond with any transient data", boolID));
        };
    }

    public void setFlagProcessMessagesAsFalse() {
        this.processMessages = false;
    }

    @Deprecated
    public InternalLogWriter getLogWriter() {
        return this.logWriter;
    }

    void setUserAuthId(long uniqueId) {
        this.userAuthId = uniqueId;
    }

    private byte[] encryptId(long id) throws Exception {
        try (HeapDataOutputStream heapDataOutputStream = new HeapDataOutputStream(KnownVersion.CURRENT);){
            heapDataOutputStream.writeLong(id);
            byte[] byArray = this.handshake.getEncryptor().encryptBytes(heapDataOutputStream.toByteArray());
            return byArray;
        }
    }

    public long getUniqueId() {
        long uniqueId;
        if (this.communicationMode.isWAN()) {
            uniqueId = this.userAuthId;
        } else if (this.requestMessage.isSecureMode()) {
            uniqueId = this.messageIdExtractor.getUniqueIdFromMessage(this.requestMessage, this.handshake.getEncryptor(), this.connectionId);
        } else {
            throw new AuthenticationRequiredException("No security credentials are provided");
        }
        return uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserAuthAttributes getUserAuthAttributes() throws IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (this.securityService.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.clientUserAuths != null) {
                uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
            }
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException(USER_NOT_FOUND);
        }
        return uaa;
    }

    public AuthorizeRequest getAuthzRequest() throws AuthenticationRequiredException, IOException {
        UserAuthAttributes uaa = this.getUserAuthAttributes();
        if (uaa == null) {
            return null;
        }
        AuthorizeRequest authReq = uaa.getAuthzRequest();
        if (logger.isDebugEnabled()) {
            logger.debug("getAuthzRequest() authrequest: {}", (Object)(authReq == null ? "NULL (only authentication is required)" : "not null"));
        }
        return authReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizeRequestPP getPostAuthzRequest() throws AuthenticationRequiredException, IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (this.securityService.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.clientUserAuths != null) {
                uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
            }
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException(USER_NOT_FOUND);
        }
        return uaa.getPostAuthzRequest();
    }

    public byte[] getEventMemberIDByteArray() {
        return this.memberIdByteArray;
    }

    public void setClientDisconnectCleanly() {
        this.clientDisconnectedCleanly = true;
    }

    public void setClientDisconnectedException(Throwable e) {
        this.clientDisconnectedException = e;
    }

    void setMessageIdExtractor(MessageIdExtractor messageIdExtractor) {
        this.messageIdExtractor = messageIdExtractor;
    }

    private void setAuthAttributes() throws AuthenticationRequiredException, AuthenticationFailedException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IOException, IllegalAccessException {
        long uniqueId;
        logger.debug("setAttributes()");
        Object principal = this.getHandshake().verifyCredentials();
        if (principal instanceof Subject) {
            uniqueId = ServerConnection.getClientUserAuths(this.getProxyID()).putSubject((Subject)principal, -1L);
        } else {
            uniqueId = this.getUniqueId((Principal)principal);
            this.setPrincipal((Principal)principal);
        }
        this.setUserAuthId(uniqueId);
    }

    private long getUniqueId(Principal principal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NotAuthorizedException, IOException {
        InternalLogWriter securityLogWriter = this.getSecurityLogWriter();
        DistributedSystem system = this.getDistributedSystem();
        Properties systemProperties = system.getProperties();
        String authzFactoryName = systemProperties.getProperty("security-client-accessor");
        String postAuthzFactoryName = systemProperties.getProperty("security-client-accessor-pp");
        AuthorizeRequest authzRequest = null;
        if (authzFactoryName != null && !authzFactoryName.isEmpty()) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(this.getName() + ": Setting pre-process authorization callback to: " + authzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(String.format("%s: Authorization enabled but authentication callback (%s)  returned with null credentials for proxyID: %s", this.getName(), "security-client-authenticator", this.getProxyID()));
            }
            authzRequest = new AuthorizeRequest(authzFactoryName, this.getProxyID(), principal, (Cache)this.getCache());
        }
        AuthorizeRequestPP postAuthzRequest = null;
        if (postAuthzFactoryName != null && !postAuthzFactoryName.isEmpty()) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(this.getName() + ": Setting post-process authorization callback to: " + postAuthzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(String.format("%s: Post-process authorization enabled, but no authentication callback (%s) is configured", this.getName(), "security-client-authenticator"));
            }
            postAuthzRequest = new AuthorizeRequestPP(postAuthzFactoryName, this.getProxyID(), principal, this.getCache());
        }
        return this.setUserAuthorizeAndPostAuthorizeRequest(authzRequest, postAuthzRequest);
    }

    static {
        executeFunctionOnLocalNodeOnly = ThreadLocal.withInitial(() -> (byte)0);
    }

    @VisibleForTesting
    static class ProcessingMessageTimer {
        @VisibleForTesting
        static final long NOT_PROCESSING = -1L;
        @VisibleForTesting
        final AtomicLong processingMessageStartTime = new AtomicLong(-1L);

        ProcessingMessageTimer() {
        }

        void setProcessingMessage() {
            this.processingMessageStartTime.set(System.currentTimeMillis());
        }

        void updateProcessingMessage() {
            long now;
            long current = this.processingMessageStartTime.get();
            if (-1L != current && (now = System.currentTimeMillis()) > current) {
                this.processingMessageStartTime.compareAndSet(current, now);
            }
        }

        void setNotProcessingMessage() {
            this.processingMessageStartTime.set(-1L);
        }

        long getCurrentMessageProcessingTime() {
            long result = this.processingMessageStartTime.get();
            if (result != -1L) {
                result = System.currentTimeMillis() - result;
            }
            return result;
        }
    }
}

