/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.SocketMessageWriter;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataInputStream;
import org.apache.geode.internal.serialization.VersionedDataOutputStream;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.serialization.VersioningIO;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ClientRegistrationMetadata {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;
    private final Socket socket;
    private final SocketMessageWriter socketMessageWriter;
    private ClientProxyMembershipID clientProxyMembershipID;
    private byte clientConflation;
    private Properties clientCredentials;
    private KnownVersion clientVersion;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;

    ClientRegistrationMetadata(InternalCache cache, Socket socket) {
        this.cache = cache;
        this.socket = socket;
        this.socketMessageWriter = new SocketMessageWriter();
    }

    boolean initialize() throws IOException {
        DataOutputStream unversionedDataOutputStream;
        DataInputStream unversionedDataInputStream = new DataInputStream(this.socket.getInputStream());
        if (this.getAndValidateClientVersion(this.socket, unversionedDataInputStream, unversionedDataOutputStream = new DataOutputStream(this.socket.getOutputStream()))) {
            if (this.oldClientRequiresVersionedStreams(this.clientVersion)) {
                this.dataInputStream = new VersionedDataInputStream((InputStream)unversionedDataInputStream, this.clientVersion);
                this.dataOutputStream = new VersionedDataOutputStream((OutputStream)unversionedDataOutputStream, this.clientVersion);
            } else {
                this.dataInputStream = unversionedDataInputStream;
                this.dataOutputStream = unversionedDataOutputStream;
            }
            this.dataInputStream.readByte();
            int numberOfPorts = this.dataInputStream.readInt();
            for (int i = 0; i < numberOfPorts; ++i) {
                this.dataInputStream.readInt();
            }
            this.getAndValidateClientProxyMembershipID();
            if (this.getAndValidateClientConflation()) {
                this.clientCredentials = Handshake.readCredentials(this.dataInputStream, this.dataOutputStream, this.cache.getDistributedSystem(), this.cache.getSecurityService());
                return true;
            }
        }
        return false;
    }

    ClientProxyMembershipID getClientProxyMembershipID() {
        return this.clientProxyMembershipID;
    }

    byte getClientConflation() {
        return this.clientConflation;
    }

    Properties getClientCredentials() {
        return this.clientCredentials;
    }

    KnownVersion getClientVersion() {
        return this.clientVersion;
    }

    DataOutputStream getDataOutputStream() {
        return this.dataOutputStream;
    }

    private boolean getAndValidateClientVersion(Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        Object message;
        short clientVersionOrdinal = VersioningIO.readOrdinal((DataInput)dataInputStream);
        this.clientVersion = Versioning.getKnownVersionOrDefault((Version)Versioning.getVersion((short)clientVersionOrdinal), null);
        if (this.clientVersion == null) {
            message = KnownVersion.unsupportedVersionMessage((short)clientVersionOrdinal);
        } else {
            Map<Integer, Command> commands = CommandInitializer.getDefaultInstance().get(this.clientVersion);
            if (commands == null) {
                message = "No commands registered for version " + String.valueOf(this.clientVersion) + ".";
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Registering client with version: {}", (Object)this, (Object)this.clientVersion);
                }
                return true;
            }
        }
        UnsupportedVersionException unsupportedVersionException = new UnsupportedVersionException((String)message);
        SocketAddress socketAddress = socket.getRemoteSocketAddress();
        if (socketAddress != null) {
            String sInfo = " Client: " + String.valueOf(socketAddress) + ".";
            unsupportedVersionException = new UnsupportedVersionException((String)message + sInfo);
        }
        logger.warn("CacheClientNotifier: Registering client version is unsupported.  Error details: ", (Throwable)unsupportedVersionException);
        this.socketMessageWriter.writeException(dataOutputStream, CommunicationMode.UnsuccessfulServerToClient.getModeNumber(), unsupportedVersionException, null);
        return false;
    }

    private boolean oldClientRequiresVersionedStreams(KnownVersion clientVersion) {
        return KnownVersion.CURRENT.compareTo((Version)clientVersion) > 0;
    }

    private void getAndValidateClientProxyMembershipID() throws IOException {
        try {
            this.clientProxyMembershipID = ClientProxyMembershipID.readCanonicalized(this.dataInputStream);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    private boolean getAndValidateClientConflation() throws IOException {
        byte[] overrides = Handshake.extractOverrides(new byte[]{(byte)this.dataInputStream.read()});
        this.clientConflation = overrides[0];
        switch (this.clientConflation) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.socketMessageWriter.writeException(this.dataOutputStream, (byte)61, new IllegalArgumentException("Invalid conflation byte"), this.clientVersion);
                return false;
            }
        }
        return true;
    }
}

