/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.persistence.ConflictingPersistentDataException;
import org.apache.geode.cache.persistence.RevokedPersistentDataException;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.InternalPersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.MembershipViewRequest;
import org.apache.geode.internal.cache.persistence.PersistenceInitialImageAdvisor;
import org.apache.geode.internal.cache.persistence.PersistenceObserverHolder;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.persistence.PersistentMemberState;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;
import org.apache.geode.internal.cache.persistence.PersistentMembershipView;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryMessage;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryMessageSenderFactory;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryResults;
import org.apache.geode.internal.cache.persistence.PrepareNewPersistentMemberMessage;
import org.apache.geode.internal.cache.persistence.RemovePersistentMemberMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.geode.internal.util.Transformer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.TestOnly;

public class PersistenceAdvisorImpl
implements InternalPersistenceAdvisor {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final PersistenceAdvisorObserver DEFAULT_PERSISTENCE_ADVISOR_OBSERVER;
    @MutableForTesting
    private static PersistenceAdvisorObserver persistenceAdvisorObserver;
    protected final Object lock;
    protected final CacheDistributionAdvisor cacheDistributionAdvisor;
    protected final String regionPath;
    protected final PersistentMemberView persistentMemberView;
    private final DiskRegionStats diskRegionStats;
    private final PersistentMemberManager persistentMemberManager;
    private final ProfileChangeListener profileChangeListener;
    private final Set<PersistentMemberID> recoveredMembers;
    private final Set<PersistentMemberID> removedMembers = new HashSet<PersistentMemberID>();
    private final Set<PersistentMemberID> equalMembers;
    private final DistributedLockService distributedLockService;
    private volatile boolean holdingTieLock;
    private volatile boolean online;
    private volatile Set<PersistentStateListener> persistentStateListeners = Collections.emptySet();
    private volatile boolean initialized;
    private volatile boolean shouldUpdatePersistentView;
    protected volatile boolean isClosed;
    protected volatile Set<PersistentMemberID> allMembersWaitingFor;
    protected volatile Set<PersistentMemberID> offlineMembersWaitingFor;
    private final PersistentStateQueryMessageSenderFactory persistentStateQueryMessageSenderFactory;
    private final StartupStatus startupStatus;
    private final Transformer<PersistentMemberID, String> persistentMemberIdTransformer;
    private final TransformUtils.CollectionTransformer<PersistentMemberID, String> collectionTransformer;

    public PersistenceAdvisorImpl(CacheDistributionAdvisor cacheDistributionAdvisor, DistributedLockService distributedLockService, PersistentMemberView persistentMemberView, String regionPath, DiskRegionStats diskRegionStats, PersistentMemberManager persistentMemberManager) {
        this(cacheDistributionAdvisor, distributedLockService, persistentMemberView, regionPath, diskRegionStats, persistentMemberManager, new StartupStatus(), TransformUtils.persistentMemberIdToLogEntryTransformer, TransformUtils::transform, new PersistentStateQueryMessageSenderFactory());
    }

    @VisibleForTesting
    PersistenceAdvisorImpl(CacheDistributionAdvisor cacheDistributionAdvisor, DistributedLockService distributedLockService, PersistentMemberView persistentMemberView, String regionPath, DiskRegionStats diskRegionStats, PersistentMemberManager persistentMemberManager, StartupStatus startupStatus, Transformer<PersistentMemberID, String> persistentMemberIdTransformer, TransformUtils.CollectionTransformer<PersistentMemberID, String> collectionTransformer, PersistentStateQueryMessageSenderFactory persistentStateQueryMessageSenderFactory) {
        this.cacheDistributionAdvisor = cacheDistributionAdvisor;
        this.distributedLockService = distributedLockService;
        this.regionPath = regionPath;
        this.persistentMemberView = persistentMemberView;
        this.diskRegionStats = diskRegionStats;
        this.persistentMemberManager = persistentMemberManager;
        this.startupStatus = startupStatus;
        this.persistentMemberIdTransformer = persistentMemberIdTransformer;
        this.collectionTransformer = collectionTransformer;
        this.persistentStateQueryMessageSenderFactory = persistentStateQueryMessageSenderFactory;
        this.profileChangeListener = new ProfileChangeListener();
        this.lock = cacheDistributionAdvisor;
        this.recoveredMembers = this.getPersistedMembers();
        this.equalMembers = new CopyOnWriteHashSet<PersistentMemberID>(persistentMemberView.getOfflineAndEqualMembers());
        for (PersistentMemberID id : this.equalMembers) {
            persistentMemberView.memberOnline(id);
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.wasAboutToDestroy()) {
            logger.info("Region {} crashed during a region destroy. Finishing the destroy.", (Object)this.regionPath);
            this.finishPendingDestroy();
        }
        this.cacheDistributionAdvisor.addProfileChangeListener(this.profileChangeListener);
        HashSet<PersistentMemberPattern> revokedMembers = this.persistentMemberManager.addRevocationListener(this.profileChangeListener, this.persistentMemberView.getRevokedMembers());
        for (PersistentMemberPattern pattern : revokedMembers) {
            this.memberRevoked(pattern);
        }
        this.startMemberLogging();
        this.initialized = true;
    }

    private void startMemberLogging() {
        this.addListener(new PersistentStateListener.PersistentStateAdapter(){

            @Override
            public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
                if (logger.isDebugEnabled()) {
                    HashSet<PersistentMemberID> members = new HashSet<PersistentMemberID>(PersistenceAdvisorImpl.this.cacheDistributionAdvisor.adviseInitializedPersistentMembers().values());
                    members.remove(persistentID);
                    HashSet onlineMembers = new HashSet();
                    PersistenceAdvisorImpl.this.collectionTransformer.transform(members, onlineMembers, PersistenceAdvisorImpl.this.persistentMemberIdTransformer);
                    logger.info("The following persistent member has gone offline for region {}: {}  Remaining participating members for the region include: {}", (Object)PersistenceAdvisorImpl.this.regionPath, (Object)PersistenceAdvisorImpl.this.persistentMemberIdTransformer.transform(persistentID), onlineMembers);
                }
            }
        });
    }

    @Override
    public PersistentStateQueryResults getMyStateOnMembers(Set<InternalDistributedMember> members) throws ReplyException {
        return this.fetchPersistentStateQueryResults(members, this.cacheDistributionAdvisor.getDistributionManager(), this.persistentMemberView.getMyPersistentID(), this.persistentMemberView.getMyInitializingID());
    }

    private PersistentStateQueryResults fetchPersistentStateQueryResults(Set<InternalDistributedMember> members, DistributionManager dm, PersistentMemberID persistentMemberID, PersistentMemberID initializingMemberId) {
        PersistentStateQueryMessage.PersistentStateQueryReplyProcessor replyProcessor = this.persistentStateQueryMessageSenderFactory.createPersistentStateQueryReplyProcessor(dm, members);
        PersistentStateQueryMessage message = this.persistentStateQueryMessageSenderFactory.createPersistentStateQueryMessage(this.regionPath, persistentMemberID, initializingMemberId, replyProcessor.getProcessorId());
        return message.send(members, dm, replyProcessor);
    }

    @Override
    public PersistentMemberState getPersistedStateOfMember(PersistentMemberID id) {
        if (this.isRevoked(id)) {
            return PersistentMemberState.REVOKED;
        }
        if (this.equalMembers != null && this.equalMembers.contains(id)) {
            return PersistentMemberState.EQUAL;
        }
        for (PersistentMemberID onlineMember : this.persistentMemberView.getOnlineMembers()) {
            if (!onlineMember.isOlderOrEqualVersionOf(id)) continue;
            return PersistentMemberState.ONLINE;
        }
        for (PersistentMemberID offline : this.persistentMemberView.getOfflineMembers()) {
            if (!id.isOlderOrEqualVersionOf(offline)) continue;
            return PersistentMemberState.OFFLINE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMembershipView(InternalDistributedMember peer, boolean targetReinitializing) {
        this.beginUpdatingPersistentView();
        DistributionManager dm = this.cacheDistributionAdvisor.getDistributionManager();
        PersistentMembershipView peersPersistentMembershipView = MembershipViewRequest.send(peer, dm, this.regionPath, targetReinitializing);
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Updating persistent view from {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)peer);
        }
        Object object = this.lock;
        synchronized (object) {
            PersistentMemberID myId = this.getPersistentID();
            Map<InternalDistributedMember, PersistentMemberID> peersOnlineMembers = peersPersistentMembershipView.getOnlineMembers();
            Set<PersistentMemberID> peersOfflineMembers = peersPersistentMembershipView.getOfflineMembers();
            for (PersistentMemberID id : peersOnlineMembers.values()) {
                if (this.isRevoked(id) || this.removedMembers.contains(id) || id.equals(myId) || this.recoveredMembers.remove(id) || id.getDiskStoreId().equals(this.getDiskStoreID())) continue;
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Processing membership view from peer. Marking {} as online because {} says its online", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)peer);
                }
                this.persistentMemberView.memberOnline(id);
            }
            for (PersistentMemberID id : peersOfflineMembers) {
                if (this.isRevoked(id) || this.removedMembers.contains(id) || id.equals(myId) || this.recoveredMembers.remove(id) || id.getDiskStoreId().equals(this.getDiskStoreID())) continue;
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Processing membership view from peer. Marking {} as online because {} says its offline, but we have never seen it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)peer);
                }
                this.persistentMemberView.memberOnline(id);
            }
            for (PersistentMemberID id : this.recoveredMembers) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Processing membership view from peer. Removing {} because {} doesn't have it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)peer);
                }
                this.persistentMemberView.memberRemoved(id);
            }
        }
        Set<PersistentMemberPattern> revokedMembers = peersPersistentMembershipView.getRevokedMembers();
        for (PersistentMemberPattern revoked : revokedMembers) {
            this.persistentMemberManager.revokeMember(revoked);
        }
    }

    private boolean isRevoked(PersistentMemberID id) {
        return this.persistentMemberManager.isRevoked(this.regionPath, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnline(boolean didGII, boolean atomicCreation, PersistentMemberID newId) throws ReplyException {
        if (this.online) {
            return;
        }
        if (!didGII) {
            this.setInitializing(newId);
        }
        Object object = this.lock;
        synchronized (object) {
            HashSet<PersistentMemberID> membersToMarkOffline = new HashSet<PersistentMemberID>(this.persistentMemberView.getOnlineMembers());
            Map<InternalDistributedMember, PersistentMemberID> onlineMembers = !atomicCreation ? this.cacheDistributionAdvisor.adviseInitializedPersistentMembers() : this.cacheDistributionAdvisor.advisePersistentMembers();
            membersToMarkOffline.removeAll(onlineMembers.values());
            if (this.equalMembers != null && !this.equalMembers.isEmpty()) {
                Collection<PersistentMemberID> allMembers = this.cacheDistributionAdvisor.advisePersistentMembers().values();
                HashSet<DiskStoreID> runningDiskStores = new HashSet<DiskStoreID>();
                for (PersistentMemberID mem : allMembers) {
                    runningDiskStores.add(mem.getDiskStoreId());
                }
                for (PersistentMemberID id : this.equalMembers) {
                    if (runningDiskStores.contains(id.getDiskStoreId())) continue;
                    this.equalMembers.remove(id);
                }
                membersToMarkOffline.removeAll(this.equalMembers);
            }
            for (PersistentMemberID id : membersToMarkOffline) {
                this.persistentMemberView.memberOffline(id);
            }
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Persisting the new membership view and ID as online. Online members {}. Offline members {}. Equal memebers {}.", (Object)this.shortDiskStoreId(), (Object)this.regionPath, this.persistentMemberView.getOnlineMembers(), this.persistentMemberView.getOfflineMembers(), this.equalMembers);
            }
            this.persistentMemberView.setInitialized();
            this.online = true;
            this.removedMembers.clear();
        }
        if (this.diskRegionStats != null) {
            this.diskRegionStats.incInitializations(!didGII);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginUpdatingPersistentView() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shouldUpdatePersistentView) {
                this.shouldUpdatePersistentView = true;
                Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.cacheDistributionAdvisor.adviseInitializedPersistentMembers();
                for (Map.Entry<InternalDistributedMember, PersistentMemberID> entry : onlineMembers.entrySet()) {
                    this.memberOnline(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInitializing(PersistentMemberID newId) {
        this.beginUpdatingPersistentView();
        DistributionManager dm = this.cacheDistributionAdvisor.getDistributionManager();
        PersistentMemberID oldId = this.getPersistentID();
        PersistentMemberID initializingId = this.getInitializingID();
        Set<InternalDistributedMember> profileUpdateRecipients = this.cacheDistributionAdvisor.adviseProfileUpdate();
        if (newId == null || !newId.equals(oldId) && !newId.equals(initializingId)) {
            if (initializingId != null) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: We still have an initializing id: {}. Telling peers to remove the old id {} and transitioning this initializing id to old id. recipients {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)initializingId, (Object)oldId, profileUpdateRecipients);
                }
                long viewVersion = this.cacheDistributionAdvisor.startOperation();
                try {
                    PrepareNewPersistentMemberMessage.send(profileUpdateRecipients, dm, this.regionPath, oldId, initializingId);
                }
                finally {
                    if (viewVersion != -1L) {
                        this.cacheDistributionAdvisor.endOperation(viewVersion);
                    }
                }
                oldId = initializingId;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Persisting my new persistent ID {}", (Object)newId);
            }
            this.persistentMemberView.setInitializing(newId);
        }
        profileUpdateRecipients = this.cacheDistributionAdvisor.adviseProfileUpdate();
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Sending the new ID to peers. They should remove the old id {}. Recipients: {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)oldId, profileUpdateRecipients);
        }
        if (newId != null) {
            PrepareNewPersistentMemberMessage.send(profileUpdateRecipients, dm, this.regionPath, oldId, newId);
        }
    }

    @Override
    public PersistentMemberID generatePersistentID() {
        return this.persistentMemberView.generatePersistentID();
    }

    @Override
    public PersistentMembershipView getMembershipView() {
        if (!this.initialized) {
            return null;
        }
        Set<PersistentMemberID> offlineMembers = this.getPersistedMembers();
        Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.cacheDistributionAdvisor.adviseInitializedPersistentMembers();
        offlineMembers.removeAll(onlineMembers.values());
        PersistentMemberID myId = this.getPersistentID();
        if (myId != null) {
            onlineMembers.put(this.cacheDistributionAdvisor.getDistributionManager().getDistributionManagerId(), myId);
        }
        return new PersistentMembershipView(offlineMembers, onlineMembers, this.persistentMemberManager.getRevokedMembers());
    }

    @Override
    public Set<PersistentMemberID> getPersistedMembers() {
        HashSet<PersistentMemberID> persistentMembers = new HashSet<PersistentMemberID>();
        persistentMembers.addAll(this.persistentMemberView.getOfflineMembers());
        persistentMembers.addAll(this.persistentMemberView.getOfflineAndEqualMembers());
        persistentMembers.addAll(this.persistentMemberView.getOnlineMembers());
        return persistentMembers;
    }

    @Override
    public boolean checkMyStateOnMembers(Set<InternalDistributedMember> replicates) throws ReplyException {
        PersistentStateQueryResults remoteStates = this.getMyStateOnMembers(replicates);
        HashSet<InternalDistributedMember> copyOfReplicates = null;
        persistenceAdvisorObserver.observe(this.regionPath);
        boolean equal = false;
        PersistentMemberID myId = this.getPersistentID();
        for (Map.Entry<InternalDistributedMember, PersistentMemberState> entry : remoteStates.getStateOnPeers().entrySet()) {
            PersistentMemberState remoteState;
            InternalDistributedMember member = entry.getKey();
            PersistentMemberID remoteId = remoteStates.getPersistentIds().get(member);
            PersistentMemberState stateOnPeer = entry.getValue();
            if (PersistentMemberState.REVOKED.equals((Object)stateOnPeer)) {
                throw new RevokedPersistentDataException(String.format("The persistent member id %s has been revoked in this distributed system. You cannot recover from disk files which have been revoked.", myId));
            }
            if (myId != null && stateOnPeer == null) {
                String message = String.format("Region %s remote member %s with persistent data %s was not part of the same distributed system as the local data from %s", this.regionPath, member, remoteId, myId);
                if (copyOfReplicates == null) {
                    copyOfReplicates = new HashSet<InternalDistributedMember>(replicates);
                }
                copyOfReplicates.remove(member);
                if (copyOfReplicates.isEmpty()) {
                    throw new ConflictingPersistentDataException(message);
                }
                logger.info(message);
            }
            if (myId != null && stateOnPeer == PersistentMemberState.EQUAL) {
                equal = true;
            }
            if (remoteId == null || (remoteState = this.getPersistedStateOfMember(remoteId)) != PersistentMemberState.OFFLINE) continue;
            String message = String.format("Region %s refusing to initialize from member %s with persistent data %s which was offline when the local data from %s was last online", this.regionPath, member, remoteId, myId);
            throw new ConflictingPersistentDataException(message);
        }
        return equal;
    }

    @VisibleForTesting
    public static void setPersistenceAdvisorObserver(PersistenceAdvisorObserver o) {
        persistenceAdvisorObserver = o == null ? DEFAULT_PERSISTENCE_ADVISOR_OBSERVER : o;
    }

    @Override
    public PersistentMemberID getPersistentIDIfOnline() {
        if (this.online) {
            return this.persistentMemberView.getMyPersistentID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberOffline(InternalDistributedMember distributedMember, PersistentMemberID persistentID) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Member offine. id={}, persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)distributedMember, (Object)persistentID);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean foundMember = this.recoveredMembers.remove(persistentID);
            foundMember |= this.equalMembers.remove(persistentID);
            foundMember |= this.getPersistedMembers().contains(persistentID);
            if (this.shouldUpdatePersistentView && this.online) {
                try {
                    if (this.persistentMemberView.getOfflineAndEqualMembers().contains(persistentID)) {
                        return;
                    }
                    if (foundMember) {
                        if (PersistenceObserverHolder.getInstance().memberOffline(this.regionPath, persistentID)) {
                            this.persistentMemberView.memberOffline(persistentID);
                        }
                        PersistenceObserverHolder.getInstance().afterPersistedOffline(this.regionPath, persistentID);
                    }
                }
                catch (DiskAccessException e) {
                    logger.warn("Unable to persist membership change", (Throwable)e);
                }
            }
            this.notifyListenersMemberOffline(distributedMember, persistentID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberOnline(InternalDistributedMember distributedMember, PersistentMemberID persistentID) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Sending the new ID to peers.  Member online. id={}, persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)distributedMember, (Object)persistentID);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldUpdatePersistentView) {
                this.recoveredMembers.remove(persistentID);
                try {
                    if (PersistenceObserverHolder.getInstance().memberOnline(this.regionPath, persistentID)) {
                        this.persistentMemberView.memberOnline(persistentID);
                    }
                    PersistenceObserverHolder.getInstance().afterPersistedOnline(this.regionPath, persistentID);
                }
                catch (DiskAccessException e) {
                    logger.warn("Unable to persist membership change", (Throwable)e);
                }
            } else if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Not marking member online in persistent view because we're still in initialization", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
            }
            this.notifyListenersMemberOnline(distributedMember, persistentID);
        }
    }

    private void memberRevoked(PersistentMemberPattern pattern) {
        this.persistentMemberView.memberRevoked(pattern);
        for (PersistentMemberID id : this.persistentMemberView.getOfflineMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
        for (PersistentMemberID id : this.persistentMemberView.getOnlineMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
        for (PersistentMemberID id : this.persistentMemberView.getOfflineAndEqualMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void memberRemoved(PersistentMemberID id, boolean revoked) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Member removed. persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
        }
        Object object = this.lock;
        synchronized (object) {
            this.recoveredMembers.remove(id);
            this.equalMembers.remove(id);
            if (!this.online) {
                this.removedMembers.add(id);
            }
            try {
                if (PersistenceObserverHolder.getInstance().memberRemoved(this.regionPath, id)) {
                    this.persistentMemberView.memberRemoved(id);
                }
                for (PersistentMemberID persistedId : this.getPersistedMembers()) {
                    if (!persistedId.isOlderOrEqualVersionOf(id)) continue;
                    this.persistentMemberView.memberRemoved(persistedId);
                }
                PersistenceObserverHolder.getInstance().afterRemovePersisted(this.regionPath, id);
            }
            catch (DiskAccessException e) {
                logger.warn("Unable to persist membership change", (Throwable)e);
            }
            this.notifyListenersMemberRemoved(id, revoked);
        }
    }

    @Override
    public PersistentMemberID getPersistentID() {
        return this.persistentMemberView.getMyPersistentID();
    }

    @Override
    public PersistentMemberID getInitializingID() {
        return this.persistentMemberView.getMyInitializingID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PersistentStateListener listener) {
        PersistenceAdvisorImpl persistenceAdvisorImpl = this;
        synchronized (persistenceAdvisorImpl) {
            HashSet<PersistentStateListener> tmpListeners = new HashSet<PersistentStateListener>(this.persistentStateListeners);
            tmpListeners.add(listener);
            this.persistentStateListeners = Collections.unmodifiableSet(tmpListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PersistentStateListener listener) {
        PersistenceAdvisorImpl persistenceAdvisorImpl = this;
        synchronized (persistenceAdvisorImpl) {
            if (!this.persistentStateListeners.contains(listener)) {
                return;
            }
            HashSet<PersistentStateListener> tmpListeners = new HashSet<PersistentStateListener>(this.persistentStateListeners);
            tmpListeners.remove(listener);
            this.persistentStateListeners = Collections.unmodifiableSet(tmpListeners);
        }
    }

    @TestOnly
    Set<PersistentStateListener> getPersistentStateListenerSet() {
        return this.persistentStateListeners;
    }

    private void notifyListenersMemberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        for (PersistentStateListener listener : this.persistentStateListeners) {
            listener.memberOnline(member, persistentID);
        }
    }

    private void notifyListenersMemberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        for (PersistentStateListener listener : this.persistentStateListeners) {
            listener.memberOffline(member, persistentID);
        }
    }

    private void notifyListenersMemberRemoved(PersistentMemberID persistentID, boolean revoked) {
        for (PersistentStateListener listener : this.persistentStateListeners) {
            listener.memberRemoved(persistentID, revoked);
        }
    }

    @Override
    public HashSet<PersistentMemberID> getPersistedOnlineOrEqualMembers() {
        HashSet<PersistentMemberID> members = new HashSet<PersistentMemberID>(this.persistentMemberView.getOnlineMembers());
        members.addAll(this.equalMembers);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareNewMember(InternalDistributedMember sender, PersistentMemberID oldId, PersistentMemberID newId) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Preparing new persistent id {}. Old id is {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)newId, (Object)oldId);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.cacheDistributionAdvisor.containsId(sender)) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Refusing to prepare id because {} is not in our advisor", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)sender);
                }
                return;
            }
            this.persistentMemberView.memberOnline(newId);
            if (oldId != null && !oldId.equals(newId)) {
                this.memberRemoved(oldId, false);
            }
        }
    }

    protected String shortDiskStoreId() {
        DiskStoreID diskStoreID = this.getDiskStoreID();
        return diskStoreID == null ? "mem" : diskStoreID.abbrev();
    }

    @Override
    public void removeMember(PersistentMemberID id) {
        this.memberRemoved(id, false);
    }

    @Override
    public void markMemberOffline(InternalDistributedMember member, PersistentMemberID id) {
        this.memberOffline(member, id);
    }

    @Override
    public CacheDistributionAdvisor getCacheDistributionAdvisor() {
        return this.cacheDistributionAdvisor;
    }

    @Override
    public void setWaitingOnMembers(Set<PersistentMemberID> allMembersToWaitFor, Set<PersistentMemberID> offlineMembersToWaitFor) {
        this.allMembersWaitingFor = allMembersToWaitFor;
        this.offlineMembersWaitingFor = offlineMembersToWaitFor;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishPendingDestroy() {
        long viewVersion = this.cacheDistributionAdvisor.startOperation();
        try {
            RemovePersistentMemberMessage.send(this.cacheDistributionAdvisor.adviseProfileUpdate(), this.cacheDistributionAdvisor.getDistributionManager(), this.regionPath, this.getPersistentID(), this.getInitializingID());
            this.persistentMemberView.finishPendingDestroy();
        }
        finally {
            if (viewVersion != -1L) {
                this.cacheDistributionAdvisor.endOperation(viewVersion);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.recoveredMembers.clear();
            this.recoveredMembers.addAll(this.getPersistedMembers());
        }
    }

    @Override
    public CacheDistributionAdvisor.InitialImageAdvice getInitialImageAdvice(CacheDistributionAdvisor.InitialImageAdvice previousAdvice, boolean hasDiskImageToRecoverFrom) {
        PersistenceInitialImageAdvisor piia = new PersistenceInitialImageAdvisor(this, this.shortDiskStoreId(), this.regionPath, this.cacheDistributionAdvisor, hasDiskImageToRecoverFrom);
        return piia.getAdvice(previousAdvice);
    }

    @Override
    public Set<PersistentMemberID> getMembersToWaitFor(Set<PersistentMemberID> previouslyOnlineMembers, Set<PersistentMemberID> offlineMembers) throws ReplyException {
        PersistentMemberID myPersistentID = this.getPersistentID();
        PersistentMemberID myInitializingId = this.getInitializingID();
        HashSet<PersistentMemberID> membersToWaitFor = new HashSet<PersistentMemberID>(previouslyOnlineMembers);
        offlineMembers.addAll(previouslyOnlineMembers);
        if (myPersistentID != null || myInitializingId != null) {
            InternalDistributedMember memberId;
            Set<InternalDistributedMember> members = this.cacheDistributionAdvisor.adviseProfileUpdate();
            Set<InternalDistributedMember> membersHostingThisRegion = this.cacheDistributionAdvisor.adviseGeneric();
            PersistentStateQueryResults results = this.fetchPersistentStateQueryResults(members, this.cacheDistributionAdvisor.getDistributionManager(), myPersistentID, myInitializingId);
            boolean addedMembers = true;
            while (addedMembers) {
                addedMembers = false;
                for (Map.Entry<InternalDistributedMember, Set<PersistentMemberID>> entry : results.getOnlineMemberMap().entrySet()) {
                    memberId = entry.getKey();
                    Set<PersistentMemberID> peersOnlineMembers = entry.getValue();
                    PersistentMemberID persistentID = results.getPersistentIds().get(memberId);
                    PersistentMemberID initializingID = results.getInitializingIds().get(memberId);
                    if (!membersToWaitFor.contains(persistentID) && !membersToWaitFor.contains(initializingID)) continue;
                    for (PersistentMemberID peerOnlineMember : peersOnlineMembers) {
                        if (this.isRevoked(peerOnlineMember) || peerOnlineMember.getDiskStoreId().equals(this.getDiskStoreID()) || this.persistentMemberView.getOfflineMembers().contains(peerOnlineMember) || !membersToWaitFor.add(peerOnlineMember)) continue;
                        addedMembers = true;
                        this.persistentMemberView.memberOnline(peerOnlineMember);
                        if (!logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) continue;
                        logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Adding {} to the list of members we're wait for, because {} has newer or equal data than is and is waiting for that member", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)peerOnlineMember, (Object)memberId);
                    }
                }
            }
            this.removeOlderMembers(membersToWaitFor);
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Initial state of membersToWaitFor, before pruning {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, membersToWaitFor);
            }
            for (Map.Entry<InternalDistributedMember, Object> entry : results.getStateOnPeers().entrySet()) {
                memberId = entry.getKey();
                PersistentMemberID persistentID = results.getPersistentIds().get(memberId);
                PersistentMemberID initializingID = results.getInitializingIds().get(memberId);
                DiskStoreID diskStoreID = results.getDiskStoreIds().get(memberId);
                PersistentMemberState state = (PersistentMemberState)((Object)entry.getValue());
                if (PersistentMemberState.REVOKED.equals((Object)state)) {
                    throw new RevokedPersistentDataException(String.format("The persistent member id %s has been revoked in this distributed system. You cannot recover from disk files which have been revoked.", myPersistentID));
                }
                if (membersHostingThisRegion.contains(memberId) && persistentID != null && state != null && myInitializingId == null && (state.equals((Object)PersistentMemberState.ONLINE) || state.equals((Object)PersistentMemberState.EQUAL))) {
                    if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                        logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Not waiting for {} because it thinks our state was {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)persistentID, (Object)state);
                    }
                    this.removeNewerPersistentID(membersToWaitFor, persistentID);
                }
                if (persistentID != null) {
                    this.removeNewerPersistentID(offlineMembers, persistentID);
                }
                if (membersHostingThisRegion.contains(memberId) && initializingID != null && state != null && (state.equals((Object)PersistentMemberState.ONLINE) || state.equals((Object)PersistentMemberState.EQUAL))) {
                    if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                        logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Not waiting for {} because it thinks our state was {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)initializingID, (Object)state);
                    }
                    this.removeByDiskStoreID(membersToWaitFor, diskStoreID, false);
                }
                if (initializingID != null) {
                    this.removeNewerPersistentID(offlineMembers, initializingID);
                }
                this.handlePartiallyDestroyedRegion(offlineMembers, membersToWaitFor, persistentID, initializingID, diskStoreID);
            }
        }
        return membersToWaitFor;
    }

    private void handlePartiallyDestroyedRegion(Set<PersistentMemberID> offlineMembers, Set<PersistentMemberID> membersToWaitFor, PersistentMemberID persistentID, PersistentMemberID initializingID, DiskStoreID diskStoreID) {
        if (initializingID == null && persistentID == null & diskStoreID != null) {
            this.removeByDiskStoreID(membersToWaitFor, diskStoreID, true);
            this.removeByDiskStoreID(offlineMembers, diskStoreID, true);
        }
    }

    protected void removeOlderMembers(Set<PersistentMemberID> persistentMemberSet) {
        HashMap<DiskStoreID, PersistentMemberID> mostRecentMap = new HashMap<DiskStoreID, PersistentMemberID>();
        ArrayList<PersistentMemberID> idsToRemove = new ArrayList<PersistentMemberID>();
        for (PersistentMemberID persistentMember : persistentMemberSet) {
            boolean persistentMemberIsNewer;
            DiskStoreID diskStoreId = persistentMember.getDiskStoreId();
            PersistentMemberID mostRecent = (PersistentMemberID)mostRecentMap.get(diskStoreId);
            if (mostRecent == null) {
                mostRecentMap.put(diskStoreId, persistentMember);
                continue;
            }
            PersistentMemberID older = persistentMember;
            boolean bl = persistentMemberIsNewer = !persistentMember.isOlderOrEqualVersionOf(mostRecent);
            if (persistentMemberIsNewer) {
                older = mostRecent;
                mostRecentMap.put(diskStoreId, persistentMember);
            }
            idsToRemove.add(older);
        }
        persistentMemberSet.removeAll(idsToRemove);
    }

    private void removeNewerPersistentID(Set<PersistentMemberID> membersToWaitFor, PersistentMemberID persistentID) {
        Iterator<PersistentMemberID> itr = membersToWaitFor.iterator();
        while (itr.hasNext()) {
            PersistentMemberID id = itr.next();
            if (!persistentID.isOlderOrEqualVersionOf(id)) continue;
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Not waiting for {} because local member knows more about it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
            }
            itr.remove();
        }
    }

    private void removeByDiskStoreID(Set<PersistentMemberID> membersToWaitFor, DiskStoreID diskStoreID, boolean updateAdvisor) {
        Iterator<PersistentMemberID> itr = membersToWaitFor.iterator();
        while (itr.hasNext()) {
            PersistentMemberID id = itr.next();
            if (!id.getDiskStoreId().equals(diskStoreID)) continue;
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Not waiting for {} because it no longer has this region in its disk store", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
            }
            itr.remove();
            if (!updateAdvisor) continue;
            this.memberRemoved(id, false);
        }
    }

    @Override
    public boolean wasHosting() {
        return this.getPersistentID() != null || this.getInitializingID() != null;
    }

    protected String getRegionPathForOfflineMembers() {
        return this.regionPath;
    }

    protected Set<PersistentMemberID> getMissingMembers() {
        return this.offlineMembersWaitingFor;
    }

    public Set<PersistentMemberID> getAllMembersToWaitFor() {
        return this.allMembersWaitingFor;
    }

    @Override
    public void logWaitingForMembers() {
        HashSet membersToWaitForLogEntries = new HashSet();
        if (this.offlineMembersWaitingFor != null && !this.offlineMembersWaitingFor.isEmpty()) {
            this.collectionTransformer.transform(this.offlineMembersWaitingFor, membersToWaitForLogEntries, this.persistentMemberIdTransformer);
            this.startupStatus.startup(String.format("Region %s has potentially stale data. It is waiting for another member to recover the latest data.%sMy persistent id:%s%s%sMembers with potentially new data:%s%s%sUse the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", this.regionPath, System.lineSeparator(), System.lineSeparator(), this.persistentMemberIdTransformer.transform(this.getPersistentID()), System.lineSeparator(), System.lineSeparator(), membersToWaitForLogEntries, System.lineSeparator()), new Object[0]);
        } else {
            this.collectionTransformer.transform(this.allMembersWaitingFor, membersToWaitForLogEntries, this.persistentMemberIdTransformer);
            this.startupStatus.startup(String.format("Region %s has potentially stale data. It is waiting for another online member to recover the latest data.%sMy persistent id:%s%s%sMembers with potentially new data:%s%s%sUse the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", this.regionPath, System.lineSeparator(), System.lineSeparator(), this.persistentMemberIdTransformer.transform(this.getPersistentID()), System.lineSeparator(), System.lineSeparator(), membersToWaitForLogEntries, System.lineSeparator()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEqualMembers() {
        Object object = this.lock;
        synchronized (object) {
            this.equalMembers.clear();
        }
    }

    @Override
    public void checkInterruptedByShutdownAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            PersistenceAdvisorImpl persistenceAdvisorImpl = this;
            synchronized (persistenceAdvisorImpl) {
                this.isClosed = true;
                this.persistentMemberManager.removeRevocationListener(this.profileChangeListener);
                this.cacheDistributionAdvisor.removeProfileChangeListener(this.profileChangeListener);
                this.persistentStateListeners = Collections.emptySet();
                this.releaseTieLock();
            }
        }
        catch (CancelException e) {
            logger.debug("persistence advisor close abridged due to shutdown", (Throwable)e);
        }
        catch (Exception ex) {
            logger.warn("persistence advisor close has failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean acquireTieLock() {
        this.holdingTieLock = this.distributedLockService.lock("PERSISTENCE_" + this.regionPath, 0L, -1L);
        if (!this.holdingTieLock && logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Failed to acquire the lock.", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
        }
        return this.holdingTieLock;
    }

    @Override
    public void releaseTieLock() {
        if (this.holdingTieLock) {
            this.distributedLockService.unlock("PERSISTENCE_" + this.regionPath);
            this.holdingTieLock = false;
        }
    }

    private boolean wasAboutToDestroy() {
        return this.persistentMemberView.wasAboutToDestroy() || this.persistentMemberView.wasAboutToDestroyDataStorage();
    }

    protected synchronized void resetState() {
        this.online = false;
        this.removedMembers.clear();
    }

    public void flushMembershipChanges() {
        try {
            this.cacheDistributionAdvisor.waitForCurrentOperations();
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Override
    public void persistMembersOfflineAndEqual(Map<InternalDistributedMember, PersistentMemberID> map) {
        for (PersistentMemberID persistentID : map.values()) {
            this.persistentMemberView.memberOfflineAndEqual(persistentID);
        }
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return this.persistentMemberView.getDiskStoreID();
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    static {
        persistenceAdvisorObserver = DEFAULT_PERSISTENCE_ADVISOR_OBSERVER = s -> {};
    }

    private class ProfileChangeListener
    implements ProfileListener,
    PersistentMemberManager.MemberRevocationListener {
        private ProfileChangeListener() {
        }

        @Override
        public void profileCreated(DistributionAdvisor.Profile profile) {
            this.profileUpdated(profile);
        }

        @Override
        public void profileRemoved(DistributionAdvisor.Profile profile, boolean destroyed) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (cp.persistentID != null) {
                if (destroyed) {
                    PersistenceAdvisorImpl.this.memberRemoved(cp.persistentID, false);
                } else {
                    PersistenceAdvisorImpl.this.memberOffline(profile.getDistributedMember(), cp.persistentID);
                }
            }
        }

        @Override
        public void profileUpdated(DistributionAdvisor.Profile profile) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (cp.persistentID != null && cp.persistenceInitialized) {
                PersistenceAdvisorImpl.this.memberOnline(profile.getDistributedMember(), cp.persistentID);
            }
        }

        @Override
        public void revoked(PersistentMemberPattern pattern) {
            PersistenceAdvisorImpl.this.memberRevoked(pattern);
        }

        @Override
        public Set<PersistentMemberID> getMissingMemberIds() {
            return PersistenceAdvisorImpl.this.getMissingMembers();
        }

        @Override
        public String getRegionPath() {
            return PersistenceAdvisorImpl.this.getRegionPathForOfflineMembers();
        }

        @Override
        public boolean matches(PersistentMemberPattern pattern) {
            return pattern.matches(PersistenceAdvisorImpl.this.getPersistentID()) || pattern.matches(PersistenceAdvisorImpl.this.getInitializingID());
        }
    }

    @FunctionalInterface
    public static interface PersistenceAdvisorObserver {
        public void observe(String var1);
    }
}

