/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.DataStoreBuckets;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RegionAdvisor
extends CacheDistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    public static final short VOLUNTEERING_THREAD_COUNT = Integer.getInteger("gemfire.RegionAdvisor.volunteeringThreadCount", 1).shortValue();
    private final Queue<Runnable> volunteeringQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Semaphore volunteeringSemaphore = new Semaphore(VOLUNTEERING_THREAD_COUNT);
    private volatile int lastActiveProfiles = 0;
    private volatile int numDataStores = 0;
    protected volatile ProxyBucketRegion[] buckets;
    @VisibleForTesting
    protected Queue<QueuedBucketProfile> preInitQueue;
    private final Object preInitQueueMonitor;
    private final ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> clientBucketProfilesMap;
    @Immutable
    private static final Predicate<DistributionAdvisor.Profile> prServerWithInterestFilter = profile -> {
        CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
        return prof.isPartitioned && prof.hasCacheServer && prof.filterProfile != null && prof.filterProfile.hasInterest();
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected RegionAdvisor(PartitionedRegion region) {
        super(region);
        Object object = this.preInitQueueMonitor = new Object();
        synchronized (object) {
            this.preInitQueue = new ConcurrentLinkedQueue<QueuedBucketProfile>();
        }
        this.clientBucketProfilesMap = new ConcurrentHashMap();
    }

    public static RegionAdvisor createRegionAdvisor(PartitionedRegion region) {
        RegionAdvisor advisor = new RegionAdvisor(region);
        advisor.initialize();
        return advisor;
    }

    public PartitionedRegionStats getPartitionedRegionStats() {
        return this.getPartitionedRegion().getPrStats();
    }

    public synchronized void initializeRegionAdvisor() {
        if (this.buckets != null) {
            return;
        }
        PartitionedRegion p = this.getPartitionedRegion();
        int numBuckets = p.getAttributes().getPartitionAttributes().getTotalNumBuckets();
        ProxyBucketRegion[] bucs = new ProxyBucketRegion[numBuckets];
        InternalRegionArguments args = new InternalRegionArguments();
        args.setPartitionedRegionAdvisor(this);
        for (int i = 0; i < bucs.length; ++i) {
            bucs[i] = new ProxyBucketRegion(i, p, args);
            bucs[i].initialize();
        }
        this.buckets = bucs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processProfilesQueuedDuringInitialization() {
        var1_1 = this.preInitQueueMonitor;
        synchronized (var1_1) {
            pi = this.preInitQueue.iterator();
            finishedInitQueue = false;
lbl6:
            // 3 sources

            try {
                while (pi.hasNext()) {
                    block18: {
                        o = pi.next();
                        qbp = (QueuedBucketProfile)o;
                        if (!qbp.isRemoval) {
                            if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                                RegionAdvisor.logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "applying queued profile addition for bucket {}", (Object)qbp.bucketId);
                            }
                            this.getBucket(qbp.bucketId).getBucketAdvisor().putProfile(qbp.bucketProfile);
                            continue;
                        }
                        if (!qbp.memberDeparted && this.getDistributionManager().isCurrentMember(qbp.memberId)) break block18;
                        if (qbp.memberDeparted) {
                            crashed = qbp.crashed;
                        } else {
                            v0 = crashed = this.stillInView(qbp.memberId) == false;
                        }
                        if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                            RegionAdvisor.logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "applying queued member departure for all buckets for {}", (Object)qbp.memberId);
                        }
                        for (ProxyBucketRegion bucket : this.buckets) {
                            ba = bucket.getBucketAdvisor();
                            ba.removeId(qbp.memberId, crashed, qbp.destroyed, qbp.fromMembershipListener);
                        }
                        ** GOTO lbl6
                    }
                    if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                        RegionAdvisor.logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "applying queued profile removal for all buckets for {}", (Object)qbp.memberId);
                    }
                    if (qbp.serials.length == 1 && qbp.serials[0] != -1) {
                        this.buckets[qbp.bucketId].getBucketAdvisor().removeIdWithSerial(qbp.memberId, qbp.serials[0], qbp.destroyed);
                        continue;
                    }
                    for (i = 0; i < this.buckets.length; ++i) {
                        ba = this.buckets[i].getBucketAdvisor();
                        serial = qbp.serials[i];
                        if (serial == -1) continue;
                        ba.removeIdWithSerial(qbp.memberId, serial, qbp.destroyed);
                    }
                    ** GOTO lbl6
                }
                finishedInitQueue = true;
            }
            finally {
                this.preInitQueue = null;
                if (!finishedInitQueue && !this.getAdvisee().getCancelCriterion().isCancelInProgress()) {
                    RegionAdvisor.logger.error("Failed to process all queued BucketProfiles for {}", (Object)this.getAdvisee());
                }
            }
        }
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new PartitionProfile(memberId, version);
    }

    public Queue<Runnable> getVolunteeringQueue() {
        return this.volunteeringQueue;
    }

    public Semaphore getVolunteeringSemaphore() {
        return this.volunteeringSemaphore;
    }

    public Map<Integer, List<BucketServerLocation66>> getAllClientBucketProfiles() {
        HashMap<Integer, List<BucketServerLocation66>> bucketToServerLocations = new HashMap<Integer, List<BucketServerLocation66>>();
        for (Integer bucketId : this.clientBucketProfilesMap.keySet()) {
            ArrayList<BucketServerLocation66> clientBucketProfiles = new ArrayList<BucketServerLocation66>();
            for (BucketAdvisor.BucketProfile bucketProfile : this.clientBucketProfilesMap.get(bucketId)) {
                if (!bucketProfile.isHosting) continue;
                BucketAdvisor.ServerBucketProfile cProfile = (BucketAdvisor.ServerBucketProfile)bucketProfile;
                Set<BucketServerLocation66> bucketServerLocations = cProfile.getBucketServerLocations();
                clientBucketProfiles.addAll(bucketServerLocations);
            }
            bucketToServerLocations.put(bucketId, clientBucketProfiles);
        }
        if (this.getPartitionedRegion().isDataStore()) {
            for (Integer bucketId : this.getPartitionedRegion().getDataStore().getAllLocalBucketIds()) {
                BucketAdvisor.BucketProfile profile = this.getBucketAdvisor(bucketId).getLocalProfile();
                if (logger.isDebugEnabled()) {
                    logger.debug("The local profile is : {}", (Object)profile);
                }
                if (profile == null) continue;
                List clientBucketProfiles = bucketToServerLocations.computeIfAbsent(bucketId, k -> new ArrayList());
                if (!(profile instanceof BucketAdvisor.ServerBucketProfile) || !profile.isHosting) continue;
                BucketAdvisor.ServerBucketProfile serverBucketProfile = (BucketAdvisor.ServerBucketProfile)profile;
                Set<BucketServerLocation66> bucketServerLocations = serverBucketProfile.getBucketServerLocations();
                clientBucketProfiles.removeAll(bucketServerLocations);
                clientBucketProfiles.addAll(bucketServerLocations);
            }
        }
        return bucketToServerLocations;
    }

    @VisibleForTesting
    public ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> getAllClientBucketProfilesTest() {
        ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> map = new ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>>();
        HashMap<Integer, List<BucketServerLocation66>> testMap = new HashMap<Integer, List<BucketServerLocation66>>(this.getAllClientBucketProfiles());
        for (Integer bucketId : testMap.keySet()) {
            HashSet parr = new HashSet(this.clientBucketProfilesMap.get(bucketId));
            map.put(bucketId, parr);
        }
        if (this.getPartitionedRegion().isDataStore()) {
            for (Integer bucketId : this.getPartitionedRegion().getDataStore().getAllLocalBucketIds()) {
                BucketAdvisor.BucketProfile profile = this.getBucketAdvisor(bucketId).getLocalProfile();
                if (!(profile instanceof BucketAdvisor.ServerBucketProfile) || !profile.isHosting) continue;
                map.get(bucketId).add((BucketAdvisor.ServerBucketProfile)profile);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("This maps is sksk {} and size is {}", map, (Object)((ConcurrentHashMap.CollectionView)((Object)map.keySet())).size());
        }
        return map;
    }

    public Set<BucketAdvisor.ServerBucketProfile> getClientBucketProfiles(Integer bucketId) {
        return this.clientBucketProfilesMap.get(bucketId);
    }

    public void setClientBucketProfiles(Integer bucketId, Set<BucketAdvisor.ServerBucketProfile> profiles) {
        this.clientBucketProfilesMap.put(bucketId, Collections.unmodifiableSet(profiles));
    }

    public void closeBucketAdvisors() {
        if (this.buckets != null) {
            for (ProxyBucketRegion pbr : this.buckets) {
                pbr.close();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.buckets != null) {
            for (ProxyBucketRegion bucket : this.buckets) {
                bucket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean regionDestroyed, boolean fromMembershipListener) {
        boolean removeBuckets = true;
        ProxyBucketRegion[] proxyBucketRegionArray = this.preInitQueueMonitor;
        synchronized (this.preInitQueueMonitor) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile((InternalDistributedMember)memberId, crashed, regionDestroyed, fromMembershipListener);
                this.preInitQueue.add(qbf);
                removeBuckets = false;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (removeBuckets && this.buckets != null) {
                for (ProxyBucketRegion pbr : this.buckets) {
                    boolean removed;
                    BucketAdvisor pbra = pbr.getBucketAdvisor();
                    boolean shouldSync = false;
                    DistributionAdvisor.Profile profile = null;
                    InternalDistributedMember mbr = null;
                    if (memberId instanceof InternalDistributedMember && (shouldSync = pbra.shouldSyncForCrashedMember(mbr = (InternalDistributedMember)memberId))) {
                        profile = pbr.getBucketAdvisor().getProfile(memberId);
                    }
                    if (!(removed = pbr.getBucketAdvisor().removeId(memberId, crashed, regionDestroyed, fromMembershipListener)) || !shouldSync) continue;
                    pbra.syncForCrashedMember(mbr, profile);
                }
            }
            boolean removedId = super.removeId(memberId, crashed, regionDestroyed, fromMembershipListener);
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "RegionAdvisor#removeId: removing member from region {}: {}; removed = {}; crashed = {}", (Object)this.getPartitionedRegion().getName(), (Object)memberId, (Object)removedId, (Object)crashed);
            }
            return removedId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdAndBuckets(InternalDistributedMember memberId, int prSerial, int[] serials, boolean regionDestroyed) {
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "RegionAdvisor#removeIdAndBuckets: removing member from region {}: {}; buckets = ({}) serials", (Object)this.getPartitionedRegion().getName(), (Object)memberId, serials == null ? "null" : Integer.valueOf(serials.length));
        }
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile(memberId, serials, regionDestroyed);
                this.preInitQueue.add(qbf);
                return;
            }
        }
        if (this.buckets != null) {
            Objects.requireNonNull(serials);
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "RegionAdvisor#removeIdAndBuckets: removing buckets for member{};{}", (Object)memberId, (Object)this);
            }
            for (int i = 0; i < this.buckets.length; ++i) {
                int s = serials[i];
                if (s == -1) continue;
                if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                    logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "RegionAdvisor#removeIdAndBuckets: removing bucket #{} serial {}", (Object)i, (Object)s);
                }
                this.buckets[i].getBucketAdvisor().removeIdWithSerial(memberId, s, regionDestroyed);
            }
            super.removeIdWithSerial(memberId, prSerial, regionDestroyed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdAndBucket(int bucketId, InternalDistributedMember memberId, int serial, boolean regionDestroyed) {
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile(bucketId, memberId, serial, regionDestroyed);
                this.preInitQueue.add(qbf);
                return;
            }
        }
        if (this.buckets != null) {
            this.buckets[bucketId].getBucketAdvisor().removeIdWithSerial(memberId, serial, regionDestroyed);
        }
    }

    public void markBucketsOnMember(DistributedMember member, boolean sick) {
        if (this.buckets == null) {
            return;
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (sick && !this.buckets[i].getBucketOwners().contains(member)) continue;
            this.buckets[i].setBucketSick(member, sick);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Marked bucket ({}) {}", (Object)this.getPartitionedRegion().bucketStringForLogs(i), (Object)(this.buckets[i].isBucketSick() ? "sick" : "healthy"));
        }
    }

    public void updateBucketStatus(int bucketId, DistributedMember member, boolean profileRemoved) {
        if (profileRemoved) {
            this.buckets[bucketId].setBucketSick(member, false);
        } else {
            ResourceAdvisor advisor = this.getPartitionedRegion().getCache().getResourceAdvisor();
            boolean sick = advisor.adviseCriticalMembers().contains(member);
            if (logger.isDebugEnabled()) {
                logger.debug("updateBucketStatus:({}):member:{}:sick:{}", (Object)this.getPartitionedRegion().bucketStringForLogs(bucketId), (Object)member, (Object)sick);
            }
            this.buckets[bucketId].setBucketSick(member, sick);
        }
    }

    public void checkIfBucketSick(int bucketId, Object key) throws LowMemoryException {
        if (MemoryThresholds.isLowMemoryExceptionDisabled()) {
            return;
        }
        if (this.buckets[bucketId].isBucketSick()) {
            Set<DistributedMember> sm = this.buckets[bucketId].getSickMembers();
            if (sm.isEmpty()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("For bucket {} sick members are {}.", (Object)this.getPartitionedRegion().bucketStringForLogs(bucketId), sm);
            }
            throw new LowMemoryException(String.format("PartitionedRegion: %s cannot process operation on key %s because members %s are running low on memory", this.getPartitionedRegion().getFullPath(), key, sm), sm);
        }
    }

    public int getNumDataStores() {
        int numProfs = this.getNumProfiles();
        if (this.lastActiveProfiles != numProfs) {
            this.numDataStores = this.adviseDataStore().size();
            this.lastActiveProfiles = numProfs;
        }
        return this.numDataStores;
    }

    public Set<InternalDistributedMember> adviseDataStore() {
        return this.adviseDataStore(false);
    }

    public Set<InternalDistributedMember> adviseInitializedDataStore() {
        return this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                return p.isDataStore && (!p.dataPolicy.withPersistence() || p.regionInitialized);
            }
            return false;
        });
    }

    private Set<InternalDistributedMember> adviseNotAtShutDownAllStatus(int status) {
        return this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                return p.isDataStore && p.shutDownAllStatus < status;
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForProfileStatus(int status) {
        ProfileShutdownListener listener = new ProfileShutdownListener();
        this.addProfileChangeListener(listener);
        try {
            Region pr;
            String regionName = this.getPartitionedRegion().getFullPath();
            while ((pr = this.getPartitionedRegion().getCache().getRegion(regionName)) != null) {
                if (pr.isDestroyed()) {
                } else {
                    Set<InternalDistributedMember> members = this.adviseNotAtShutDownAllStatus(status);
                    int memberNum = members.size();
                    if (memberNum > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("waitForProfileStatus {} at PR:{}, expecting {} members: {}", (Object)status, (Object)this.getPartitionedRegion().getFullPath(), (Object)memberNum, members);
                        }
                        listener.waitForChange();
                    }
                    if (memberNum > 0) continue;
                }
                break;
            }
        }
        finally {
            this.removeProfileChangeListener(listener);
        }
    }

    public Set<InternalDistributedMember> adviseDataStore(boolean realHashSet) {
        Set<InternalDistributedMember> s = this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                return p.isDataStore;
            }
            return false;
        });
        if (realHashSet && s == Collections.EMPTY_SET) {
            s = new HashSet<InternalDistributedMember>();
        }
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "adviseDataStore returning {} from {}", s, (Object)this.toStringWithProfiles());
        }
        return s;
    }

    public Set<InternalDistributedMember> adviseFixedPartitionDataStores(String partitionName) {
        Set<InternalDistributedMember> s = this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                if (p.fixedPAttrs != null) {
                    for (FixedPartitionAttributesImpl fpa : p.fixedPAttrs) {
                        if (!fpa.getPartitionName().equals(partitionName)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
        if (s == Collections.EMPTY_SET) {
            s = new HashSet<InternalDistributedMember>();
        }
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "adviseFixedPartitionDataStore returning {} from {}", s, (Object)this.toStringWithProfiles());
        }
        return s;
    }

    public InternalDistributedMember adviseFixedPrimaryPartitionDataStore(int bucketId) {
        ArrayList fixedPartitionDataStore = new ArrayList(1);
        this.fetchProfiles(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                if (p.fixedPAttrs != null) {
                    for (FixedPartitionAttributesImpl fpa : p.fixedPAttrs) {
                        if (!fpa.isPrimary() || !fpa.hasBucket(bucketId)) continue;
                        fixedPartitionDataStore.add(0, p.getDistributedMember());
                        return true;
                    }
                }
            }
            return false;
        });
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "adviseFixedPartitionDataStore returning {} from {}", fixedPartitionDataStore, (Object)this.toStringWithProfiles());
        }
        if (fixedPartitionDataStore.isEmpty()) {
            return null;
        }
        return (InternalDistributedMember)fixedPartitionDataStore.get(0);
    }

    public List<FixedPartitionAttributesImpl> adviseAllFixedPartitionAttributes() {
        ArrayList<FixedPartitionAttributesImpl> allFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile pp = (PartitionProfile)profile;
                if (pp.fixedPAttrs != null) {
                    allFPAs.addAll(pp.fixedPAttrs);
                    return true;
                }
            }
            return false;
        });
        return allFPAs;
    }

    public List<FixedPartitionAttributesImpl> adviseSameFPAs(FixedPartitionAttributesImpl fpa) {
        ArrayList<FixedPartitionAttributesImpl> sameFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile pp = (PartitionProfile)profile;
                List<FixedPartitionAttributesImpl> fpaList = pp.fixedPAttrs;
                if (fpaList != null) {
                    int index = fpaList.indexOf(fpa);
                    if (index != -1) {
                        sameFPAs.add(fpaList.get(index));
                    }
                    return true;
                }
            }
            return false;
        });
        return sameFPAs;
    }

    public List<FixedPartitionAttributesImpl> adviseRemotePrimaryFPAs() {
        ArrayList<FixedPartitionAttributesImpl> remotePrimaryFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile pp = (PartitionProfile)profile;
                List<FixedPartitionAttributesImpl> fpaList = pp.fixedPAttrs;
                if (fpaList != null) {
                    for (FixedPartitionAttributesImpl fpa : fpaList) {
                        if (!fpa.isPrimary()) continue;
                        remotePrimaryFPAs.add(fpa);
                        return true;
                    }
                }
            }
            return false;
        });
        return remotePrimaryFPAs;
    }

    public Set<InternalDistributedMember> adviseAllPRNodes() {
        return this.adviseFilter(profile -> {
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            return prof.isPartitioned;
        });
    }

    Set adviseAllServersWithInterest() {
        return this.adviseFilter(profile -> {
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            return prof.hasCacheServer && prof.filterProfile != null && prof.filterProfile.hasInterest();
        });
    }

    public boolean hasPRServerWithInterest() {
        return this.satisfiesFilter(prServerWithInterestFilter);
    }

    public Set<InternalDistributedMember> adviseRequiresNotification() {
        return this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile prof = (PartitionProfile)profile;
                if (prof.isPartitioned) {
                    InterestPolicy pol;
                    if (prof.hasCacheListener && (pol = prof.subscriptionAttributes.getInterestPolicy()) == InterestPolicy.ALL) {
                        return true;
                    }
                    return prof.requiresNotification;
                }
            }
            return false;
        });
    }

    @Override
    public synchronized boolean putProfile(DistributionAdvisor.Profile p) {
        CacheDistributionAdvisor.CacheProfile profile = (CacheDistributionAdvisor.CacheProfile)p;
        PartitionedRegion pr = this.getPartitionedRegion();
        if (profile.hasCacheLoader) {
            pr.setHaveCacheLoader();
        }
        if (profile.filterProfile != null && !pr.isDataStore()) {
            profile.filterProfile = null;
        }
        return super.putProfile(profile);
    }

    public PartitionProfile getPartitionProfile(InternalDistributedMember id) {
        return (PartitionProfile)this.getProfile(id);
    }

    public boolean isPrimaryForBucket(int bucketId) {
        if (this.buckets == null) {
            return false;
        }
        return this.buckets[bucketId].isPrimary();
    }

    public boolean isBucketLocal(int bucketId) {
        if (this.buckets == null) {
            return false;
        }
        return this.buckets[bucketId].getHostedBucketRegion() != null;
    }

    public boolean areBucketsInitialized() {
        return this.buckets != null;
    }

    public Bucket getBucket(int bucketId) {
        ProxyBucketRegion pbr = this.buckets[bucketId];
        BucketRegion ret = pbr.getHostedBucketRegion();
        if (ret != null) {
            return ret;
        }
        return pbr;
    }

    public BucketAdvisor getBucketAdvisor(int bucketId) {
        ProxyBucketRegion pbr = this.buckets[bucketId];
        BucketRegion ret = pbr.getHostedBucketRegion();
        if (ret != null) {
            return ret.getBucketAdvisor();
        }
        return pbr.getBucketAdvisor();
    }

    public Map<Integer, BucketAdvisor> getAllBucketAdvisors() {
        HashMap<Integer, BucketAdvisor> map = new HashMap<Integer, BucketAdvisor>();
        for (ProxyBucketRegion pbr : this.buckets) {
            BucketRegion ret = pbr.getHostedBucketRegion();
            if (ret == null) continue;
            map.put(ret.getId(), ret.getBucketAdvisor());
        }
        return map;
    }

    public int[] getBucketSerials() {
        if (this.buckets == null) {
            PartitionedRegion p = this.getPartitionedRegion();
            int numBuckets = p.getAttributes().getPartitionAttributes().getTotalNumBuckets();
            int[] result = new int[numBuckets];
            Arrays.fill(result, -1);
            return result;
        }
        int[] result = new int[this.buckets.length];
        for (int i = 0; i < result.length; ++i) {
            ProxyBucketRegion pbr = this.buckets[i];
            BucketRegion b = pbr.getCreatedBucketRegion();
            result[i] = b == null ? -1 : b.getSerialNumber();
        }
        return result;
    }

    public InternalDistributedMember getPrimaryMemberForBucket(int bucketId) {
        ProxyBucketRegion b = this.buckets[bucketId];
        return b.getBucketAdvisor().getPrimary();
    }

    public InternalDistributedMember getPreferredNode(int bucketId) {
        ProxyBucketRegion b = this.buckets[bucketId];
        return b.getBucketAdvisor().getPreferredNode();
    }

    public boolean isStorageAssignedForBucket(int bucketId) {
        return this.buckets[bucketId].getBucketRedundancy() >= 0;
    }

    public boolean isStorageAssignedForBucket(int bucketId, int minRedundancy, boolean wait) {
        if (!wait) {
            return this.isStorageAssignedForBucket(bucketId);
        }
        return this.buckets[bucketId].getBucketAdvisor().waitForRedundancy(minRedundancy);
    }

    public int getBucketRedundancy(int bucketId) {
        return this.buckets[bucketId].getBucketRedundancy();
    }

    public Set<InternalDistributedMember> getBucketOwners(int bucketId) {
        return this.buckets[bucketId].getBucketOwners();
    }

    public Set<Integer> getBucketSet() {
        return new BucketSet();
    }

    public ProxyBucketRegion[] getProxyBucketArray() {
        return this.buckets;
    }

    public ArrayList<DataStoreBuckets> adviseFilteredDataStores(Set<InternalDistributedMember> memberFilter) {
        HashMap<InternalDistributedMember, Integer> memberToPrimaryCount = new HashMap<InternalDistributedMember, Integer>();
        for (ProxyBucketRegion pbr : this.buckets) {
            InternalDistributedMember p = pbr.getBucketAdvisor().basicGetPrimaryMember();
            if (p == null) continue;
            memberToPrimaryCount.merge(p, 1, Integer::sum);
        }
        ArrayList<DataStoreBuckets> ds = new ArrayList<DataStoreBuckets>(memberFilter.size());
        this.adviseFilter(profile -> {
            PartitionProfile p;
            if (profile instanceof PartitionProfile && memberFilter.contains((p = (PartitionProfile)profile).getDistributedMember())) {
                Integer priCount = (Integer)memberToPrimaryCount.get(p.getDistributedMember());
                int primaryCount = 0;
                if (priCount != null) {
                    primaryCount = priCount;
                }
                ds.add(new DataStoreBuckets(p.getDistributedMember(), p.numBuckets, primaryCount, p.localMaxMemory));
            }
            return false;
        });
        return ds;
    }

    public void incrementBucketCount(DistributionAdvisor.Profile p) {
        PartitionProfile pp = (PartitionProfile)this.getProfile(p.getDistributedMember());
        if (pp != null) {
            pp.numBuckets = (short)(pp.numBuckets + 1);
        }
    }

    public void decrementsBucketCount(DistributionAdvisor.Profile p) {
        PartitionProfile pp = (PartitionProfile)this.getProfile(p.getDistributedMember());
        if (pp != null) {
            pp.numBuckets = (short)(pp.numBuckets - 1);
            if (pp.numBuckets < 0) {
                pp.numBuckets = 0;
            }
        }
    }

    @Override
    public void dumpProfiles(String infoMsg) {
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpProfiles] dumping {}", (Object)this.toStringWithProfiles());
        }
        super.dumpProfiles(infoMsg);
        ProxyBucketRegion[] pbrs = this.buckets;
        if (pbrs == null) {
            return;
        }
        for (ProxyBucketRegion pbr : pbrs) {
            pbr.getBucketAdvisor().dumpProfiles(infoMsg);
            BucketPersistenceAdvisor persistentAdvisor = pbr.getPersistenceAdvisor();
            if (persistentAdvisor == null) continue;
            persistentAdvisor.dump(infoMsg);
        }
    }

    public void notPrimary(int bucketId, InternalDistributedMember wasPrimary) {
        ProxyBucketRegion b = this.buckets[bucketId];
        b.getBucketAdvisor().notPrimary(wasPrimary);
    }

    public Set advisePrimaryOwners() {
        ProxyBucketRegion[] bucs = this.buckets;
        HashSet<InternalDistributedMember> hs = new HashSet<InternalDistributedMember>();
        for (int i = 0; i < bucs.length; ++i) {
            InternalDistributedMember mem;
            if (!this.isStorageAssignedForBucket(i) || (mem = bucs[i].getBucketAdvisor().getPrimary()) == null) continue;
            hs.add(mem);
        }
        return hs;
    }

    public <T> boolean accept(BucketVisitor<T> visitor, T aggregate) {
        ProxyBucketRegion[] bucs = this.buckets;
        Objects.requireNonNull(bucs);
        for (ProxyBucketRegion pbr : bucs) {
            if (visitor.visit(this, pbr, aggregate)) continue;
            return false;
        }
        return true;
    }

    public PartitionedRegion getPartitionedRegion() {
        return (PartitionedRegion)this.getAdvisee();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBucketProfile(int bucketId, BucketAdvisor.BucketProfile profile) {
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile(bucketId, profile);
                this.preInitQueue.add(qbf);
                return;
            }
        }
        this.getBucket(bucketId).getBucketAdvisor().putProfile(profile);
    }

    public Set<InternalDistributedMember> adviseBucketProfileExchange() {
        return this.adviseDataStore();
    }

    public long adviseTotalMemoryAllocation() {
        AtomicLong total = new AtomicLong();
        this.adviseFilter(profile -> {
            if (profile instanceof PartitionProfile) {
                PartitionProfile p = (PartitionProfile)profile;
                total.addAndGet(p.localMaxMemory);
            }
            return false;
        });
        return total.get();
    }

    public int getCreatedBucketsCount() {
        ProxyBucketRegion[] bucs = this.buckets;
        if (bucs == null) {
            return 0;
        }
        int createdBucketsCount = 0;
        for (ProxyBucketRegion buc : bucs) {
            if (buc.getBucketOwnersCount() <= 0) continue;
            ++createdBucketsCount;
        }
        return createdBucketsCount;
    }

    public ArrayList getBucketRegionProfiles() {
        ProxyBucketRegion[] bucs = this.buckets;
        if (bucs == null) {
            return null;
        }
        ArrayList<BucketProfileAndId> result = new ArrayList<BucketProfileAndId>(bucs.length);
        for (int i = 0; i < bucs.length; ++i) {
            BucketRegion br = bucs[i].getCreatedBucketRegion();
            if (br == null) continue;
            result.add(new BucketProfileAndId(br.getProfile(), i));
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    public void putBucketRegionProfiles(ArrayList<BucketProfileAndId> l) {
        for (BucketProfileAndId bp : l) {
            int id = bp.getId();
            this.getBucket(id).getBucketAdvisor().putProfile(bp.getBucketProfile());
        }
    }

    public boolean hasPartitionedRegion(InternalDistributedMember profileId) {
        if (this.getDistributionManager().getId().equals(profileId)) {
            return true;
        }
        return this.getProfile(profileId) != null;
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (logger.isDebugEnabled()) {
            logger.debug("RA: removing profile {}", (Object)profile);
        }
        if (this.getAdvisee() instanceof PartitionedRegion) {
            ((PartitionedRegion)this.getAdvisee()).removeCriticalMember(profile.peerMemberId);
        }
        if (this.buckets != null) {
            for (ProxyBucketRegion bucket : this.buckets) {
                bucket.getBucketAdvisor().checkForLostPrimaryElector(profile);
            }
        }
    }

    static class QueuedBucketProfile {
        protected final int bucketId;
        final BucketAdvisor.BucketProfile bucketProfile;
        protected final boolean memberDeparted;
        final boolean isRemoval;
        protected final boolean crashed;
        final boolean fromMembershipListener;
        protected final boolean destroyed;
        protected final InternalDistributedMember memberId;
        final int[] serials;

        QueuedBucketProfile(int bId, BucketAdvisor.BucketProfile p) {
            this.bucketId = bId;
            this.bucketProfile = p;
            this.isRemoval = false;
            this.crashed = false;
            this.memberDeparted = false;
            this.memberId = null;
            this.serials = null;
            this.destroyed = false;
            this.fromMembershipListener = false;
        }

        QueuedBucketProfile(InternalDistributedMember mbr, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
            this.bucketId = 0;
            this.bucketProfile = null;
            this.isRemoval = true;
            this.crashed = crashed;
            this.memberDeparted = true;
            this.memberId = mbr;
            this.serials = null;
            this.destroyed = destroyed;
            this.fromMembershipListener = fromMembershipListener;
        }

        QueuedBucketProfile(InternalDistributedMember mbr, int[] serials, boolean destroyed) {
            this.bucketId = 0;
            this.bucketProfile = null;
            this.isRemoval = true;
            this.crashed = false;
            this.memberDeparted = false;
            this.memberId = mbr;
            this.serials = serials;
            this.destroyed = destroyed;
            this.fromMembershipListener = false;
        }

        QueuedBucketProfile(int bucketId, InternalDistributedMember mbr, int serial, boolean destroyed) {
            this.bucketId = bucketId;
            this.bucketProfile = null;
            this.isRemoval = true;
            this.crashed = false;
            this.memberDeparted = false;
            this.memberId = mbr;
            this.serials = new int[]{serial};
            this.destroyed = destroyed;
            this.fromMembershipListener = false;
        }
    }

    public static class PartitionProfile
    extends CacheDistributionAdvisor.CacheProfile {
        public int localMaxMemory;
        public transient boolean isDataStore = false;
        public boolean requiresNotification = false;
        public transient short numBuckets = 0;
        public List<FixedPartitionAttributesImpl> fixedPAttrs;
        public int shutDownAllStatus = -1;

        public PartitionProfile() {
        }

        public PartitionProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
            this.isPartitioned = true;
        }

        @Override
        protected int getIntInfo() {
            int s = super.getIntInfo();
            if (this.requiresNotification) {
                s |= 0x8000;
            }
            return s;
        }

        @Override
        protected void setIntInfo(int s) {
            super.setIntInfo(s);
            this.requiresNotification = (s & 0x8000) != 0;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.localMaxMemory = in.readInt();
            this.isDataStore = this.localMaxMemory > 0;
            this.fixedPAttrs = (List)DataSerializer.readObject(in);
            this.shutDownAllStatus = in.readInt();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.localMaxMemory);
            DataSerializer.writeObject(this.fixedPAttrs, out);
            out.writeInt(this.shutDownAllStatus);
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("RegionAdvisor.PartitionProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; isDataStore=").append(this.isDataStore).append("; requiresNotification=").append(this.requiresNotification).append("; localMaxMemory=").append(this.localMaxMemory).append("; numBuckets=").append(this.numBuckets);
            if (this.fixedPAttrs != null) {
                sb.append("; FixedPartitionAttributes=").append(this.fixedPAttrs);
            }
            sb.append("; filterProfile=").append(this.filterProfile);
            sb.append("; shutDownAllStatus=").append(this.shutDownAllStatus);
        }

        @Override
        public int getDSFID() {
            return 18;
        }
    }

    private class ProfileShutdownListener
    implements ProfileListener {
        private boolean profileChanged = false;

        ProfileShutdownListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForChange() {
            PartitionedRegion pr = RegionAdvisor.this.getPartitionedRegion();
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                while (!this.profileChanged && pr != null && !pr.isDestroyed()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.profileChanged = false;
            }
        }

        @Override
        public void profileCreated(DistributionAdvisor.Profile profile) {
            this.profileUpdated(profile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void profileRemoved(DistributionAdvisor.Profile profile, boolean regionDestroyed) {
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                this.profileChanged = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void profileUpdated(DistributionAdvisor.Profile profile) {
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                this.profileChanged = true;
                this.notifyAll();
            }
        }
    }

    private class BucketSet
    extends AbstractSet<Integer> {
        final ProxyBucketRegion[] pbrs;

        BucketSet() {
            this.pbrs = RegionAdvisor.this.buckets;
        }

        @Override
        public int size() {
            return this.pbrs.length;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new BucketSetIterator();
        }

        class BucketSetIterator
        implements Iterator<Integer> {
            private int currentItem = -1;

            BucketSetIterator() {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (RegionAdvisor.this.getPartitionedRegion().isFixedPartitionedRegion()) {
                    if (this.currentItem + 1 < BucketSet.this.pbrs.length) {
                        int possibleBucketId = this.currentItem;
                        boolean bucketExists = false;
                        List<FixedPartitionAttributesImpl> fpaList = RegionAdvisor.this.adviseAllFixedPartitionAttributes();
                        List<FixedPartitionAttributesImpl> localFpas = RegionAdvisor.this.getPartitionedRegion().getFixedPartitionAttributesImpl();
                        if (localFpas != null) {
                            fpaList.addAll(localFpas);
                        }
                        block0: while (++possibleBucketId < BucketSet.this.pbrs.length && !bucketExists) {
                            for (FixedPartitionAttributesImpl fpa : fpaList) {
                                if (!fpa.hasBucket(possibleBucketId)) continue;
                                bucketExists = true;
                                continue block0;
                            }
                        }
                        return bucketExists;
                    }
                    return false;
                }
                return this.currentItem + 1 < BucketSet.this.pbrs.length;
            }

            @Override
            public Integer next() {
                if (++this.currentItem < BucketSet.this.pbrs.length) {
                    if (RegionAdvisor.this.isStorageAssignedForBucket(this.currentItem)) {
                        return this.currentItem;
                    }
                    if (RegionAdvisor.this.getPartitionedRegion().isFixedPartitionedRegion()) {
                        boolean bucketExists = false;
                        List<FixedPartitionAttributesImpl> fpaList = RegionAdvisor.this.adviseAllFixedPartitionAttributes();
                        List<FixedPartitionAttributesImpl> localFpas = RegionAdvisor.this.getPartitionedRegion().getFixedPartitionAttributesImpl();
                        if (localFpas != null) {
                            fpaList.addAll(localFpas);
                        }
                        do {
                            for (FixedPartitionAttributesImpl fpa : fpaList) {
                                if (!fpa.hasBucket(this.currentItem)) continue;
                                bucketExists = true;
                                break;
                            }
                            if (bucketExists) continue;
                            ++this.currentItem;
                        } while (this.currentItem < BucketSet.this.pbrs.length && !bucketExists);
                        if (bucketExists) {
                            RegionAdvisor.this.getPartitionedRegion().createBucket(this.currentItem, 0, null);
                            return this.currentItem;
                        }
                    } else {
                        RegionAdvisor.this.getPartitionedRegion().createBucket(this.currentItem, 0, null);
                        return this.currentItem;
                    }
                }
                throw new NoSuchElementException();
            }
        }
    }

    public static interface BucketVisitor<T> {
        public boolean visit(RegionAdvisor var1, ProxyBucketRegion var2, T var3);
    }

    public static class BucketProfileAndId
    implements DataSerializable {
        private static final long serialVersionUID = 332892607792421553L;
        private int id;
        private BucketAdvisor.BucketProfile bp;
        private boolean isServerBucketProfile = false;

        public BucketProfileAndId(DistributionAdvisor.Profile bp, int id) {
            this.id = id;
            this.bp = (BucketAdvisor.BucketProfile)bp;
            if (bp instanceof BucketAdvisor.ServerBucketProfile) {
                this.isServerBucketProfile = true;
            }
        }

        public BucketProfileAndId() {
        }

        public int getId() {
            return this.id;
        }

        BucketAdvisor.BucketProfile getBucketProfile() {
            return this.bp;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.id = in.readInt();
            this.isServerBucketProfile = in.readBoolean();
            this.bp = this.isServerBucketProfile ? new BucketAdvisor.ServerBucketProfile() : new BucketAdvisor.BucketProfile();
            InternalDataSerializer.invokeFromData(this.bp, in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeBoolean(this.isServerBucketProfile);
            InternalDataSerializer.invokeToData(this.bp, out);
        }

        public String toString() {
            return "BucketProfileAndId (profile=" + String.valueOf(this.bp) + "; id=" + this.id + ")";
        }
    }
}

