/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;

public class QueueRemovalMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private List<Object> messagesList;

    public QueueRemovalMessage() {
        this.setRecipient(ALL_RECIPIENTS);
    }

    void setMessagesList(List messages) {
        this.messagesList = (List)UncheckedUtils.uncheckedCast((Object)messages);
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        InternalCache cache = dm.getCache();
        if (cache != null) {
            Iterator<Object> iterator = this.messagesList.iterator();
            this.processRegionQueues(cache, iterator);
        }
    }

    void processRegionQueues(InternalCache cache, Iterator iterator) {
        while (iterator.hasNext()) {
            HARegionQueue hrq;
            String regionName = (String)iterator.next();
            int size = (Integer)iterator.next();
            LocalRegion region = (LocalRegion)cache.getRegion(regionName);
            if (region == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("processing QRM region {} does not exist.", (Object)regionName);
                }
                hrq = null;
            } else {
                long maxWaitTimeForInitialization = 30000L;
                hrq = ((HARegion)region).getOwnerWithWait(maxWaitTimeForInitialization);
            }
            boolean succeed = this.processRegionQueue(iterator, regionName, size, hrq);
            if (!succeed) {
                return;
            }
            if (hrq == null) continue;
            hrq.synchronizeQueueWithPrimary(this.getSender(), cache);
        }
    }

    boolean processRegionQueue(Iterator iterator, String regionName, int size, HARegionQueue hrq) {
        for (int i = 0; i < size; ++i) {
            EventID id = (EventID)iterator.next();
            if (hrq == null || !hrq.isQueueInitialized()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("QueueRemovalMessage: hrq is not ready when trying to remove dispatched event on queue {} for {}", (Object)regionName, (Object)id);
                continue;
            }
            if (this.removeQueueEvent(regionName, hrq, id)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeQueueEvent(String regionName, HARegionQueue hrq, EventID id) {
        boolean interrupted = Thread.interrupted();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("QueueRemovalMessage: removing dispatched events on queue {} for {}", (Object)regionName, (Object)id);
            }
            hrq.removeDispatchedEvents(id);
        }
        catch (RegionDestroyedException ignore) {
            logger.info("Queue found destroyed while processing the last dispatched sequence ID for a HARegionQueue's DACE. The event ID is {} for HARegion with name={}", new Object[]{id, regionName});
        }
        catch (CancelException ignore) {
            boolean bl = false;
            return bl;
        }
        catch (CacheException e) {
            logger.error(String.format("QueueRemovalMessage::process:Exception in processing the last dispatched sequence ID for a HARegionQueue's DACE. The problem is with event ID, %s for HARegion with name=%s", regionName, id), (Throwable)e);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (RejectedExecutionException ignore) {
            interrupted = true;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeInteger(this.messagesList.size(), out);
        Iterator<Object> iterator = this.messagesList.iterator();
        String regionName = null;
        Integer numberOfIds = null;
        Object eventId = null;
        while (iterator.hasNext()) {
            regionName = (String)iterator.next();
            DataSerializer.writeString(regionName, out);
            numberOfIds = (Integer)iterator.next();
            DataSerializer.writeInteger(numberOfIds, out);
            int maxVal = numberOfIds;
            for (int i = 0; i < maxVal; ++i) {
                eventId = iterator.next();
                DataSerializer.writeObject(eventId, out);
            }
        }
    }

    public int getDSFID() {
        return -73;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        int size = DataSerializer.readInteger(in);
        this.messagesList = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            this.messagesList.add(DataSerializer.readString(in));
            Integer eventIdSize = DataSerializer.readInteger(in);
            this.messagesList.add(eventIdSize);
            int eventIdSizeInt = eventIdSize;
            for (int j = 0; j < eventIdSizeInt; ++j) {
                this.messagesList.add(DataSerializer.readObject(in));
            }
            i = i + eventIdSizeInt + 1;
        }
    }

    @Override
    public String toString() {
        return "QueueRemovalMessage" + String.valueOf(this.messagesList);
    }
}

