/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;

public class RegionFunctionContextImpl
extends FunctionContextImpl
implements InternalRegionFunctionContext {
    private final Region dataSet;
    private final Set<?> filter;
    private final Map<String, LocalDataSet> colocatedLocalDataMap;
    private final int[] localBucketArray;
    private final boolean isPossibleDuplicate;
    private final Object principal;

    public RegionFunctionContextImpl(Cache cache, String functionId, Region<?, ?> dataSet, Object args, Set<?> routingObjects, Map<String, LocalDataSet> colocatedLocalDataMap, int[] localBucketArray, ResultSender<?> resultSender, boolean isPossibleDuplicate) {
        this(cache, functionId, dataSet, args, routingObjects, colocatedLocalDataMap, localBucketArray, resultSender, isPossibleDuplicate, null);
    }

    public RegionFunctionContextImpl(Cache cache, String functionId, Region<?, ?> dataSet, Object args, Set<?> routingObjects, Map<String, LocalDataSet> colocatedLocalDataMap, int[] localBucketArray, ResultSender<?> resultSender, boolean isPossibleDuplicate, Object principal) {
        super(cache, functionId, args, resultSender);
        this.dataSet = dataSet;
        this.filter = routingObjects;
        this.colocatedLocalDataMap = colocatedLocalDataMap;
        this.localBucketArray = localBucketArray;
        this.isPossibleDuplicate = isPossibleDuplicate;
        this.principal = principal == null ? ((InternalCache)cache).getSecurityService().getPrincipal() : principal;
        this.setFunctionContexts();
    }

    private void setFunctionContexts() {
        if (this.colocatedLocalDataMap != null) {
            for (LocalDataSet ls : this.colocatedLocalDataMap.values()) {
                ls.setFunctionContext(this);
            }
        }
    }

    @Override
    public <K, V> Region<K, V> getDataSet() {
        return this.dataSet;
    }

    @Override
    public Set<?> getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return "[RegionFunctionContextImpl:dataSet=" + String.valueOf(this.dataSet) + ";filter=" + String.valueOf(this.filter) + ";args=" + String.valueOf(this.getArguments()) + ";principal=" + String.valueOf(this.getPrincipal()) + "]";
    }

    public Region getLocalDataSet(Region r) {
        if (this.colocatedLocalDataMap != null) {
            return this.colocatedLocalDataMap.get(r.getFullPath());
        }
        return null;
    }

    @Override
    public Map<String, LocalDataSet> getColocatedLocalDataSets() {
        if (this.colocatedLocalDataMap != null) {
            HashMap<String, LocalDataSet> ret = new HashMap<String, LocalDataSet>(this.colocatedLocalDataMap);
            ret.remove(this.dataSet.getFullPath());
            return Collections.unmodifiableMap(ret);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.isPossibleDuplicate;
    }

    @Override
    public <K, V> int[] getLocalBucketArray(Region<K, V> region) {
        if (!region.getAttributes().getDataPolicy().withPartitioning()) {
            return null;
        }
        return this.localBucketArray;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }
}

