/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.eviction.CountLRUEviction;
import org.apache.geode.internal.cache.eviction.CountLRUStatistics;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.EvictionCountersImpl;
import org.apache.geode.internal.cache.eviction.HeapLRUController;
import org.apache.geode.internal.cache.eviction.HeapLRUStatistics;
import org.apache.geode.internal.cache.eviction.MemoryLRUController;
import org.apache.geode.internal.cache.eviction.MemoryLRUStatistics;

public abstract class AbstractEvictionController
implements EvictionController {
    private final EvictionAction evictionAction;
    private final EvictionCounters counters;
    private final EvictionAlgorithm algorithm;

    public static EvictionController create(EvictionAttributes evictionAttributes, boolean isOffHeap, StatisticsFactory statsFactory, String statsName) {
        EvictionAlgorithm algorithm = evictionAttributes.getAlgorithm();
        EvictionAction action = evictionAttributes.getAction();
        ObjectSizer sizer = evictionAttributes.getObjectSizer();
        int maximum = evictionAttributes.getMaximum();
        if (algorithm == EvictionAlgorithm.LRU_HEAP) {
            HeapLRUStatistics evictionStats = new HeapLRUStatistics(statsFactory, statsName);
            EvictionCountersImpl evictionCounters = new EvictionCountersImpl(evictionStats);
            return new HeapLRUController(evictionCounters, action, sizer, algorithm);
        }
        if (algorithm == EvictionAlgorithm.LRU_MEMORY || algorithm == EvictionAlgorithm.LIFO_MEMORY) {
            MemoryLRUStatistics evictionStats = new MemoryLRUStatistics(statsFactory, statsName);
            EvictionCountersImpl evictionCounters = new EvictionCountersImpl(evictionStats);
            return new MemoryLRUController(evictionCounters, maximum, sizer, action, isOffHeap, algorithm);
        }
        if (algorithm == EvictionAlgorithm.LRU_ENTRY || algorithm == EvictionAlgorithm.LIFO_ENTRY) {
            CountLRUStatistics evictionStats = new CountLRUStatistics(statsFactory, statsName);
            EvictionCountersImpl evictionCounters = new EvictionCountersImpl(evictionStats);
            return new CountLRUEviction(evictionCounters, maximum, action, algorithm);
        }
        throw new IllegalStateException("Unhandled algorithm " + String.valueOf(algorithm));
    }

    protected AbstractEvictionController(EvictionCounters evictionCounters, EvictionAction evictionAction, EvictionAlgorithm algorithm) {
        this.counters = evictionCounters;
        this.evictionAction = evictionAction;
        this.algorithm = algorithm;
    }

    public abstract String toString();

    @Override
    public EvictionAction getEvictionAction() {
        return this.evictionAction;
    }

    @Override
    public EvictionCounters getCounters() {
        return this.counters;
    }

    @Override
    public EvictionAlgorithm getEvictionAlgorithm() {
        return this.algorithm;
    }

    @Override
    public long limit() {
        return this.getCounters().getLimit();
    }

    @Override
    public void close() {
        this.getCounters().close();
    }

    @Override
    public void closeBucket(BucketRegion bucketRegion) {
        this.getCounters().decrementCounter(bucketRegion.getCounter());
    }

    @Override
    public void setPerEntryOverhead(int entryOverhead) {
    }
}

