/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.BytesAndBits;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public interface DiskEntry
extends RegionEntry {
    @Immutable
    public static final byte[] INVALID_BYTES = new byte[0];
    @Immutable
    public static final byte[] LOCAL_INVALID_BYTES = new byte[0];
    @Immutable
    public static final byte[] TOMBSTONE_BYTES = new byte[0];

    public void setValueWithContext(RegionEntryContext var1, Object var2);

    public void handleValueOverflow(RegionEntryContext var1);

    public boolean isRemovedFromDisk();

    public DiskId getDiskId();

    public int updateAsyncEntrySize(EvictionController var1);

    public DiskEntry getPrev();

    public DiskEntry getNext();

    public void setPrev(DiskEntry var1);

    public void setNext(DiskEntry var1);

    public static class RecoveredEntry {
        private final long recoveredKeyId;
        private final Object value;
        private final long offsetInOplog;
        private final byte userBits;
        private final int valueLength;
        private long oplogId;
        private VersionTag tag;
        private final boolean valueRecovered;

        public RecoveredEntry(long keyId, long oplogId, long offsetInOplog, byte userBits, int valueLength) {
            this(keyId, oplogId, offsetInOplog, userBits, valueLength, null, false);
        }

        public RecoveredEntry(long keyId, long oplogId, long offsetInOplog, byte userBits, int valueLength, Object value) {
            this(keyId, oplogId, offsetInOplog, userBits, valueLength, value, true);
        }

        public RecoveredEntry(long keyId, long oplogId, long offsetInOplog, byte userBits, int valueLength, Object value, boolean valueRecovered) {
            this.recoveredKeyId = keyId;
            this.value = value;
            this.oplogId = oplogId;
            this.offsetInOplog = offsetInOplog;
            this.userBits = EntryBits.setRecoveredFromDisk(userBits, true);
            this.valueLength = valueLength;
            this.valueRecovered = valueRecovered;
        }

        public long getRecoveredKeyId() {
            return this.recoveredKeyId;
        }

        public Object getValue() {
            return this.value;
        }

        public byte getUserBits() {
            return this.userBits;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        public long getOffsetInOplog() {
            return this.offsetInOplog;
        }

        public long getOplogId() {
            return this.oplogId;
        }

        public void setOplogId(long v) {
            this.oplogId = v;
        }

        public boolean getValueRecovered() {
            return this.valueRecovered;
        }

        public VersionTag getVersionTag() {
            return this.tag;
        }

        public void setVersionTag(VersionTag tag) {
            this.tag = tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyToDiskEntry(PlaceHolderDiskRegion drv, DiskEntry entry, RegionEntryContext context) {
            DiskId did;
            DiskId diskId = did = entry.getDiskId();
            synchronized (diskId) {
                this.applyToDiskEntry(entry, context, drv, did);
            }
        }

        public void applyToDiskEntry(DiskEntry entry, RegionEntryContext region, AbstractDiskRegion dr, DiskId did) {
            Token oldValueAsToken = entry.getValueAsToken();
            boolean oldValueWasNull = oldValueAsToken == null;
            long oldOplogId = did.getOplogId();
            long newOplogId = this.getOplogId();
            if (newOplogId != oldOplogId) {
                did.setOplogId(newOplogId);
                this.setOplogId(oldOplogId);
            }
            did.setOffsetInOplog(this.getOffsetInOplog());
            did.setUserBits(this.getUserBits());
            int oldValueLength = did.getValueLength();
            did.setValueLength(this.getValueLength());
            if (!this.getValueRecovered()) {
                if (!oldValueWasNull) {
                    entry.handleValueOverflow(region);
                    entry.setValueWithContext(region, null);
                }
            } else {
                entry.setValueWithContext(region, entry.prepareValueForCache(region, this.getValue(), false));
            }
            if (!this.getValueRecovered()) {
                if (!oldValueWasNull) {
                    int inVM = -1;
                    if (Token.isInvalidOrRemoved(oldValueAsToken)) {
                        inVM = 0;
                    }
                    Helper.updateStats(dr, region, inVM, 1, did.getValueLength());
                } else {
                    int valueLenDelta = -oldValueLength;
                    Helper.updateStats(dr, region, 0, 0, valueLenDelta += did.getValueLength());
                }
            } else {
                int inVM = 1;
                if (Token.isInvalidOrRemoved(this.getValue())) {
                    inVM = 0;
                }
                if (oldValueWasNull) {
                    Helper.updateStats(dr, region, inVM, -1, -oldValueLength);
                } else if (inVM == 1 && Token.isInvalidOrRemoved(oldValueAsToken)) {
                    Helper.updateStats(dr, region, 1, 0, 0);
                } else if (inVM == 0 && !Token.isInvalidOrRemoved(oldValueAsToken)) {
                    Helper.updateStats(dr, region, -1, 0, 0);
                }
            }
        }
    }

    public static class Helper {
        private static final Logger logger = LogService.getLogger();
        @Immutable
        private static final ValueWrapper INVALID_VW = new ByteArrayValueWrapper(true, INVALID_BYTES);
        @Immutable
        private static final ValueWrapper LOCAL_INVALID_VW = new ByteArrayValueWrapper(true, LOCAL_INVALID_BYTES);
        @Immutable
        private static final ValueWrapper TOMBSTONE_VW = new ByteArrayValueWrapper(true, TOMBSTONE_BYTES);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Object getValueOnDisk(DiskEntry entry, DiskRegion dr) {
            Object object;
            DiskId id = entry.getDiskId();
            if (id == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = id;
                synchronized (diskId) {
                    if (dr.isBackup() && id.getKeyId() == 0L || !entry.isValueNull() && id.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(id.getUserBits())) {
                        Object var4_4 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                        dr.releaseReadLock();
                        return var4_4;
                    }
                    object = dr.getNoBuffer(id);
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Object getSerializedValueOnDisk(DiskEntry entry, DiskRegion dr) {
            Object object;
            DiskId did = entry.getDiskId();
            if (did == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    if (dr.isBackup() && did.getKeyId() == 0L) {
                        Object var4_4 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                        dr.releaseReadLock();
                        return var4_4;
                    }
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            {
                if (!entry.isValueNull() && did.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(did.getUserBits())) {
                    Object var4_5 = null;
                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                    dr.releaseReadLock();
                    return var4_5;
                }
                object = dr.getSerializedData(did);
            }
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object getValueOnDiskOrBuffer(DiskEntry entry, DiskRegion dr, RegionEntryContext context) {
            Object v = Helper.getOffHeapValueOnDiskOrBuffer(entry, dr, context);
            if (v instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)v;
                try {
                    v = cd.getDeserializedValue(null, null);
                }
                finally {
                    OffHeapHelper.release(cd);
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static Object getOffHeapValueOnDiskOrBuffer(DiskEntry entry, DiskRegion dr, RegionEntryContext context) {
            Object syncObj;
            DiskId did;
            block11: {
                did = entry.getDiskId();
                syncObj = did;
                if (syncObj == null) {
                    syncObj = entry;
                }
                if (syncObj == did) {
                    dr.acquireReadLock();
                }
                try {
                    Object object = syncObj;
                    // MONITORENTER : object
                    if (did == null || !did.isPendingAsync()) break block11;
                    Object v = entry.getValueRetain(context, true);
                    if (Token.isRemovedFromDisk(v)) {
                        v = null;
                    }
                    Object object2 = v;
                    // MONITOREXIT : object
                    if (syncObj != did) return object2;
                    dr.releaseReadLock();
                    return object2;
                }
                catch (Throwable throwable) {
                    if (syncObj != did) throw throwable;
                    dr.releaseReadLock();
                    throw throwable;
                }
            }
            if (did == null || dr.isBackup() && did.getKeyId() == 0L || !entry.isValueNull() && did.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(did.getUserBits())) {
                Object var6_7 = null;
                // MONITOREXIT : object
                if (syncObj != did) return var6_7;
                dr.releaseReadLock();
                return var6_7;
            }
            Object object = dr.getSerializedData(did);
            // MONITOREXIT : object
            if (syncObj != did) return object;
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean isOverflowedToDisk(DiskEntry de, DiskRegion dr, DistributedRegion.DiskPosition dp) {
            Object syncObj;
            DiskId did;
            block15: {
                boolean bl;
                DiskEntry diskEntry = de;
                // MONITORENTER : diskEntry
                did = de.getDiskId();
                // MONITOREXIT : diskEntry
                syncObj = did;
                if (syncObj == null) {
                    syncObj = de;
                }
                if (syncObj == did) {
                    dr.acquireReadLock();
                }
                try {
                    Object object = syncObj;
                    // MONITORENTER : object
                    if (!de.isValueNull()) break block15;
                    if (did == null) {
                        DiskEntry diskEntry2 = de;
                        // MONITORENTER : diskEntry2
                        did = de.getDiskId();
                        // MONITOREXIT : diskEntry2
                        assert (did != null);
                        boolean bl2 = Helper.isOverflowedToDisk(de, dr, dp);
                        // MONITOREXIT : object
                        if (syncObj != did) return bl2;
                        dr.releaseReadLock();
                        return bl2;
                    }
                    dp.setPosition(did.getOplogId(), did.getOffsetInOplog());
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (syncObj != did) throw throwable;
                    dr.releaseReadLock();
                    throw throwable;
                }
                if (syncObj != did) return bl;
                dr.releaseReadLock();
                return bl;
            }
            boolean bl = false;
            // MONITOREXIT : object
            if (syncObj != did) return bl;
            dr.releaseReadLock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean fillInValue(DiskEntry de, InitialImageOperation.Entry entry, DiskRegion dr, RegionEntryContext context, KnownVersion version) {
            Object value;
            Object syncObj;
            DiskId did;
            block42: {
                BytesAndBits bb;
                block43: {
                    DiskEntry diskEntry = de;
                    // MONITORENTER : diskEntry
                    did = de.getDiskId();
                    // MONITOREXIT : diskEntry
                    syncObj = did;
                    if (syncObj == null) {
                        syncObj = de;
                    }
                    if (syncObj == did) {
                        dr.acquireReadLock();
                    }
                    try {
                        Object object = syncObj;
                        // MONITORENTER : object
                        entry.setLastModified(de.getLastModified());
                        ReferenceCountHelper.setReferenceCountOwner(entry);
                        value = de.getValueRetain(context, true);
                        ReferenceCountHelper.setReferenceCountOwner(null);
                        if (value != null) break block42;
                        if (did != null) break block43;
                        DiskEntry diskEntry2 = de;
                        // MONITORENTER : diskEntry2
                        did = de.getDiskId();
                        // MONITOREXIT : diskEntry2
                        assert (did != null);
                        boolean bl = Helper.fillInValue(de, entry, dr, context, version);
                        // MONITOREXIT : object
                        if (syncObj != did) return bl;
                        dr.releaseReadLock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (syncObj != did) throw throwable;
                        dr.releaseReadLock();
                        throw throwable;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DiskEntry.Helper.fillInValue, key={}; getting value from disk, disk id={}", entry.getKey(), (Object)did);
                }
                try {
                    bb = dr.getBytesAndBits(did, false);
                }
                catch (DiskAccessException ignore) {
                    boolean bl = false;
                    // MONITOREXIT : object
                    if (syncObj != did) return bl;
                    dr.releaseReadLock();
                    return bl;
                }
                if (EntryBits.isInvalid(bb.getBits())) {
                    entry.setInvalid();
                } else if (EntryBits.isLocalInvalid(bb.getBits())) {
                    entry.setLocalInvalid();
                } else if (EntryBits.isTombstone(bb.getBits())) {
                    entry.setTombstone();
                } else {
                    entry.setValue(bb.getBytes());
                    entry.setSerialized(EntryBits.isSerialized(bb.getBits()));
                }
                boolean ignore = true;
                // MONITOREXIT : object
                if (syncObj != did) return ignore;
                dr.releaseReadLock();
                return ignore;
            }
            if (syncObj == did) {
                dr.releaseReadLock();
            }
            if (Token.isRemovedFromDisk(value)) {
                return false;
            }
            if (value instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)value;
                try {
                    if (!cd.isSerialized()) {
                        entry.setSerialized(false);
                        entry.setValue(cd.getDeserializedForReading());
                        return true;
                    }
                    Object tmp = cd.getValue();
                    if (tmp instanceof byte[]) {
                        entry.setValue(tmp);
                        entry.setSerialized(true);
                        return true;
                    }
                    try {
                        HeapDataOutputStream hdos = new HeapDataOutputStream(version);
                        BlobHelper.serializeTo(tmp, hdos);
                        hdos.trim();
                        entry.setValue(hdos);
                        entry.setSerialized(true);
                        return true;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("An IOException was thrown while serializing.", e);
                    }
                }
                finally {
                    if (value != entry.getValue()) {
                        OffHeapHelper.releaseWithNoTracking(value);
                    }
                }
            }
            if (value instanceof byte[]) {
                entry.setValue(value);
                entry.setSerialized(false);
                return true;
            }
            if (value == Token.INVALID) {
                entry.setInvalid();
                return true;
            }
            if (value == Token.LOCAL_INVALID) {
                entry.setLocalInvalid();
                return true;
            }
            if (value == Token.TOMBSTONE) {
                entry.setTombstone();
                return true;
            }
            Object preparedValue = value;
            if (preparedValue != null && (preparedValue = AbstractRegionEntry.prepareValueForGII(preparedValue)) == null) {
                return false;
            }
            try {
                HeapDataOutputStream hdos = new HeapDataOutputStream(version);
                BlobHelper.serializeTo(preparedValue, hdos);
                hdos.trim();
                entry.setValue(hdos);
                entry.setSerialized(true);
                return true;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("An IOException was thrown while serializing.", e);
            }
        }

        public static void initialize(DiskEntry entry, DiskRecoveryStore diskRecoveryStore, Object newValue) {
            DiskRegionView drv = null;
            if (diskRecoveryStore instanceof InternalRegion) {
                drv = ((InternalRegion)diskRecoveryStore).getDiskRegion();
            } else if (diskRecoveryStore instanceof DiskRegionView) {
                drv = (DiskRegionView)((Object)diskRecoveryStore);
            }
            if (drv == null) {
                throw new IllegalArgumentException("Disk region is null");
            }
            if (newValue instanceof RecoveredEntry) {
                RecoveredEntry re = (RecoveredEntry)newValue;
                DiskId did = entry.getDiskId();
                did.setOplogId(re.getOplogId());
                did.setOffsetInOplog(re.getOffsetInOplog());
                did.setKeyId(re.getRecoveredKeyId());
                did.setUserBits(re.getUserBits());
                did.setValueLength(re.getValueLength());
                if (!re.getValueRecovered()) {
                    Helper.updateStats(drv, diskRecoveryStore, 0, 1, did.getValueLength());
                } else {
                    entry.setValueWithContext(drv, entry.prepareValueForCache((RegionEntryContext)((Object)diskRecoveryStore), re.getValue(), false));
                    if (!Token.isInvalidOrRemoved(re.getValue())) {
                        Helper.updateStats(drv, diskRecoveryStore, 1, 0, 0);
                    }
                }
            } else {
                DiskId did = entry.getDiskId();
                if (did != null) {
                    did.setKeyId(0L);
                }
                if (newValue != null && !Token.isInvalidOrRemoved(newValue)) {
                    Helper.updateStats(drv, diskRecoveryStore, 1, 0, 0);
                }
            }
        }

        public static boolean wrapOffHeapReference(Object o) {
            if (o instanceof StoredObject) {
                return ((StoredObject)o).hasRefCount();
            }
            return false;
        }

        public static ValueWrapper createValueWrapper(Object value, EntryEventImpl event) {
            byte[] bytes;
            if (value == Token.INVALID) {
                return INVALID_VW;
            }
            if (value == Token.LOCAL_INVALID) {
                return LOCAL_INVALID_VW;
            }
            if (value == Token.TOMBSTONE) {
                return TOMBSTONE_VW;
            }
            boolean isSerializedObject = true;
            if (value instanceof CachedDeserializable) {
                CachedDeserializable proxy = (CachedDeserializable)value;
                if (Helper.wrapOffHeapReference(proxy)) {
                    return new OffHeapValueWrapper((StoredObject)proxy);
                }
                isSerializedObject = proxy.isSerialized();
                bytes = isSerializedObject ? proxy.getSerializedValue() : (byte[])proxy.getDeserializedForReading();
                if (event != null && isSerializedObject) {
                    event.setCachedSerializedNewValue(bytes);
                }
            } else if (value instanceof byte[]) {
                isSerializedObject = false;
                bytes = (byte[])value;
            } else {
                Assert.assertTrue(!Token.isRemovedFromDisk(value));
                if (event != null && event.getCachedSerializedNewValue() != null) {
                    bytes = event.getCachedSerializedNewValue();
                } else {
                    bytes = EntryEventImpl.serialize(value);
                    if (bytes.length == 0) {
                        throw new IllegalStateException("serializing <" + String.valueOf(value) + "> produced empty byte array");
                    }
                    if (event != null) {
                        event.setCachedSerializedNewValue(bytes);
                    }
                }
            }
            return new ByteArrayValueWrapper(isSerializedObject, bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ValueWrapper createValueWrapperFromEntry(DiskEntry entry, InternalRegion region, EntryEventImpl event) {
            if (event != null) {
                Object rawValue = event.getRawNewValue();
                if (Helper.wrapOffHeapReference(rawValue)) {
                    return new OffHeapValueWrapper((StoredObject)rawValue);
                }
                if (event.getCachedSerializedNewValue() != null) {
                    return new ByteArrayValueWrapper(true, event.getCachedSerializedNewValue());
                }
                if (rawValue != null) {
                    return Helper.createValueWrapper(rawValue, event);
                }
            }
            Object value = entry.getValueRetain(region, true);
            try {
                ValueWrapper valueWrapper = Helper.createValueWrapper(value, event);
                return valueWrapper;
            }
            finally {
                OffHeapHelper.release(value);
            }
        }

        private static void writeToDisk(DiskEntry entry, InternalRegion region, boolean async) throws RegionClearedException {
            Helper.writeToDisk(entry, region, async, null);
        }

        private static void writeToDisk(DiskEntry entry, InternalRegion region, boolean async, EntryEventImpl event) throws RegionClearedException {
            Helper.writeBytesToDisk(entry, region, async, Helper.createValueWrapperFromEntry(entry, region, event));
        }

        private static void writeBytesToDisk(DiskEntry entry, InternalRegion region, boolean async, ValueWrapper vw) throws RegionClearedException {
            entry.getDiskId().unmarkForWriting();
            region.getDiskRegion().put(entry, region, vw, async);
        }

        public static void update(DiskEntry entry, InternalRegion region, Object newValue) throws RegionClearedException {
            Helper.update(entry, region, newValue, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void update(DiskEntry entry, InternalRegion region, Object newValue, EntryEventImpl event) throws RegionClearedException {
            if (newValue == null) {
                throw new NullPointerException("Entry's value should not be null.");
            }
            boolean basicUpdateCalled = false;
            try {
                DiskStoreImpl.AsyncDiskEntry asyncDiskEntry;
                DiskRegion dr = region.getDiskRegion();
                DiskId did = entry.getDiskId();
                Object syncObj = did;
                if (syncObj == null) {
                    syncObj = entry;
                }
                if (syncObj == did) {
                    dr.acquireReadLock();
                }
                try {
                    Object object = syncObj;
                    synchronized (object) {
                        basicUpdateCalled = true;
                        asyncDiskEntry = Helper.basicUpdate(entry, region, newValue, event);
                    }
                }
                finally {
                    if (syncObj == did) {
                        dr.releaseReadLock();
                    }
                }
                if (asyncDiskEntry != null && did.isPendingAsync()) {
                    Helper.scheduleAsyncWrite(asyncDiskEntry);
                }
            }
            finally {
                if (!basicUpdateCalled) {
                    OffHeapHelper.release(newValue);
                }
            }
        }

        static DiskStoreImpl.AsyncDiskEntry basicUpdateForTesting(DiskEntry entry, InternalRegion region, Object newValue, EntryEventImpl event) throws RegionClearedException {
            return Helper.basicUpdate(entry, region, newValue, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private static DiskStoreImpl.AsyncDiskEntry basicUpdate(DiskEntry entry, InternalRegion region, Object newValue, EntryEventImpl event) throws RegionClearedException {
            result = null;
            dr = region.getDiskRegion();
            did = entry.getDiskId();
            oldValue = entry.getValueAsToken();
            if (Token.isRemovedFromDisk(newValue)) {
                if (dr.isBackup()) {
                    dr.testIsRecoveredAndClear(did);
                }
                caughtCacheClosed = false;
                try {
                    if (Token.isRemovedFromDisk(oldValue)) ** GOTO lbl78
                    result = Helper.basicRemoveFromDisk(entry, region, false);
                }
                catch (CacheClosedException e) {
                    caughtCacheClosed = true;
                    throw e;
                }
                finally {
                    if (!caughtCacheClosed) {
                        entry.setValueWithContext(region, newValue);
                    }
                }
            } else if (newValue instanceof RecoveredEntry) {
                ((RecoveredEntry)newValue).applyToDiskEntry(entry, region, dr, did);
            } else {
                newValueStoredInEntry = false;
                try {
                    oldValueLength = did != null && did.isPendingAsync() != false ? 0 : Helper.getValueLength(did);
                    if (dr.isBackup()) {
                        dr.testIsRecoveredAndClear(did);
                        if (Helper.doSynchronousWrite(region, dr)) {
                            if (AbstractRegionEntry.isCompressible(dr, newValue)) {
                                newValueStoredInEntry = true;
                                entry.setValueWithContext(region, newValue);
                                if (!entry.isRemovedFromDisk()) {
                                    Helper.writeToDisk(entry, region, false, event);
                                }
                            } else {
                                Helper.writeBytesToDisk(entry, region, false, Helper.createValueWrapper(newValue, event));
                                newValueStoredInEntry = true;
                                entry.setValueWithContext(region, newValue);
                            }
                        } else {
                            maintainRVV = region.getConcurrencyChecksEnabled();
                            if (!did.isPendingAsync() || maintainRVV) {
                                did.setPendingAsync(true);
                                tag = null;
                                stamp = entry.getVersionStamp();
                                if (stamp != null) {
                                    tag = stamp.asVersionTag();
                                }
                                result = new DiskStoreImpl.AsyncDiskEntry(region, entry, tag);
                            }
                            newValueStoredInEntry = true;
                            entry.setValueWithContext(region, newValue);
                        }
                    } else if (did != null) {
                        newValueStoredInEntry = true;
                        entry.setValueWithContext(region, newValue);
                        did.markForWriting();
                    } else {
                        newValueStoredInEntry = true;
                        entry.setValueWithContext(region, newValue);
                    }
                }
                finally {
                    if (!newValueStoredInEntry) {
                        OffHeapHelper.release(newValue);
                    }
                }
                if (Token.isInvalidOrRemoved(newValue)) {
                    if (oldValue == null) {
                        Helper.updateStats(dr, region, 0, -1, -oldValueLength);
                    } else if (!Token.isInvalidOrRemoved(oldValue)) {
                        Helper.updateStats(dr, region, -1, 0, 0);
                    }
                } else if (oldValue == null) {
                    Helper.updateStats(dr, region, 1, -1, -oldValueLength);
                } else if (Token.isInvalidOrRemoved(oldValue)) {
                    Helper.updateStats(dr, region, 1, 0, 0);
                }
            }
lbl78:
            // 9 sources

            if (entry instanceof EvictableEntry) {
                le = (EvictableEntry)entry;
                le.unsetEvicted();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getValueLength(DiskId did) {
            int result = 0;
            if (did != null) {
                DiskId diskId = did;
                synchronized (diskId) {
                    result = did.getValueLength();
                }
            }
            return result;
        }

        public static Object getValueInVMOrDiskWithoutFaultIn(DiskEntry entry, InternalRegion region) {
            Object result = OffHeapHelper.copyAndReleaseIfNeeded(Helper.getValueOffHeapOrDiskWithoutFaultIn(entry, region), (InternalCache)region.getCache());
            if (result instanceof CachedDeserializable) {
                result = ((CachedDeserializable)result).getDeserializedValue(null, null);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object getValueOffHeapOrDiskWithoutFaultIn(DiskEntry entry, InternalRegion region) {
            Object v = entry.getValueRetain(region, true);
            if (v == null || Token.isRemovedFromDisk(v) && !region.isIndexCreationThread()) {
                DiskEntry diskEntry = entry;
                synchronized (diskEntry) {
                    v = entry.getValueRetain(region, true);
                    if (v == null) {
                        v = Helper.getOffHeapValueOnDiskOrBuffer(entry, region.getDiskRegion(), region);
                    }
                }
            }
            if (Token.isRemovedFromDisk(v)) {
                v = null;
            }
            return v;
        }

        public static Object faultInValue(DiskEntry entry, InternalRegion region) {
            return Helper.faultInValue(entry, region, false);
        }

        public static Object faultInValueRetain(DiskEntry entry, InternalRegion region) {
            return Helper.faultInValue(entry, region, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object faultInValue(DiskEntry entry, InternalRegion region, boolean retainResult) {
            boolean lruFaultedIn;
            Object v;
            block18: {
                DiskRegion dr = region.getDiskRegion();
                v = entry.getValueRetain(region, true);
                lruFaultedIn = false;
                boolean done = false;
                try {
                    DiskEntry diskEntry;
                    if (entry instanceof EvictableEntry && !dr.isSync()) {
                        diskEntry = entry;
                        synchronized (diskEntry) {
                            DiskId did = entry.getDiskId();
                            if (did != null && did.isPendingAsync()) {
                                done = true;
                                boolean evicted = ((EvictableEntry)((Object)entry)).isEvicted();
                                if (evicted && !dr.isBackup()) {
                                    did.setPendingAsync(false);
                                }
                                Helper.lruEntryFaultIn((EvictableEntry)((Object)entry), region);
                                lruFaultedIn = true;
                            }
                        }
                    }
                    if (done || v != null && (!Token.isRemovedFromDisk(v) || region.isIndexCreationThread())) break block18;
                    diskEntry = entry;
                    synchronized (diskEntry) {
                        v = entry.getValueRetain(region, true);
                        if (v == null) {
                            v = Helper.readValueFromDisk(entry, region);
                            if (entry instanceof EvictableEntry && v != null && !Token.isInvalid(v)) {
                                Helper.lruEntryFaultIn((EvictableEntry)((Object)entry), region);
                                lruFaultedIn = true;
                            }
                        }
                    }
                }
                finally {
                    if (!retainResult) {
                        v = OffHeapHelper.copyAndReleaseIfNeeded(v, (InternalCache)region.getCache());
                    }
                }
            }
            if (Token.isRemoved(v)) {
                v = null;
            } else {
                entry.setRecentlyUsed(region);
            }
            if (lruFaultedIn) {
                Helper.lruUpdateCallback(region);
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void recoverValue(DiskEntry entry, long oplogId, DiskRecoveryStore recoveryStore, ByteArrayDataInput in) {
            boolean lruFaultedIn = false;
            DiskEntry diskEntry = entry;
            synchronized (diskEntry) {
                DiskId did;
                if (entry.isValueNull() && (did = entry.getDiskId()) != null) {
                    Object value = null;
                    DiskRegionView dr = recoveryStore.getDiskRegionView();
                    dr.acquireReadLock();
                    try {
                        DiskId diskId = did;
                        synchronized (diskId) {
                            if (oplogId == did.getOplogId() && (value = Helper.getValueFromDisk(dr, did, in, dr.getCache())) != null) {
                                Helper.setValueOnFaultIn(value, did, entry, dr, recoveryStore);
                            }
                        }
                    }
                    finally {
                        dr.releaseReadLock();
                    }
                    if (entry instanceof EvictableEntry && value != null && !Token.isInvalid(value)) {
                        Helper.lruEntryFaultIn((EvictableEntry)((Object)entry), recoveryStore);
                        lruFaultedIn = true;
                    }
                }
            }
            if (lruFaultedIn) {
                Helper.lruUpdateCallback(recoveryStore);
            }
        }

        private static Object getValueFromDisk(DiskRegionView dr, DiskId did, ByteArrayDataInput in, InternalCache cache) {
            Object value;
            if (dr.isBackup() && did.getKeyId() == 0L) {
                value = null;
            } else {
                value = dr.getRaw(did);
                if (value instanceof BytesAndBits) {
                    BytesAndBits bb = (BytesAndBits)value;
                    value = EntryBits.isInvalid(bb.getBits()) ? Token.INVALID : (EntryBits.isLocalInvalid(bb.getBits()) ? Token.LOCAL_INVALID : (EntryBits.isTombstone(bb.getBits()) ? Token.TOMBSTONE : (EntryBits.isSerialized(bb.getBits()) ? Helper.readSerializedValue(bb.getBytes(), bb.getVersion(), in, false, cache) : Helper.readRawValue(bb.getBytes()))));
                }
            }
            return value;
        }

        private static void lruUpdateCallback(DiskRecoveryStore recoveryStore) {
            try {
                if (recoveryStore.getEvictionAttributes() != null && recoveryStore.getEvictionAttributes().getAlgorithm().isLIFO()) {
                    recoveryStore.getRegionMap().updateEvictionCounter();
                    return;
                }
                recoveryStore.getRegionMap().lruUpdateCallback();
            }
            catch (DiskAccessException dae) {
                recoveryStore.handleDiskAccessException(dae);
                throw dae;
            }
        }

        private static void lruEntryFaultIn(EvictableEntry entry, DiskRecoveryStore recoveryStore) {
            RegionMap rm = recoveryStore.getRegionMap();
            try {
                rm.lruEntryFaultIn(entry);
            }
            catch (DiskAccessException dae) {
                recoveryStore.handleDiskAccessException(dae);
                throw dae;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Object readValueFromDisk(DiskEntry entry, DiskRecoveryStore region) {
            Object object;
            Object value;
            DiskRegionView dr = region.getDiskRegionView();
            DiskId did = entry.getDiskId();
            if (did == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    value = Helper.getValueFromDisk(dr, did, null, dr.getCache());
                    if (value == null) {
                        Object var6_6 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                        dr.releaseReadLock();
                        return var6_6;
                    }
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            {
                Helper.setValueOnFaultIn(value, did, entry, dr, region);
                object = value;
            }
            dr.releaseReadLock();
            return object;
        }

        private static Object setValueOnFaultIn(Object value, DiskId did, DiskEntry entry, DiskRegionView dr, DiskRecoveryStore region) {
            int bytesOnDisk = Helper.getValueLength(did);
            Object preparedValue = entry.prepareValueForCache((RegionEntryContext)((Object)region), value, false);
            region.updateSizeOnFaultIn(entry.getKey(), region.calculateValueSize(preparedValue), bytesOnDisk);
            entry.setValueWithContext((RegionEntryContext)((Object)region), preparedValue);
            if (!Token.isInvalidOrRemoved(value)) {
                Helper.updateStats(dr, region, 1, -1, -bytesOnDisk);
            }
            return preparedValue;
        }

        public static Object readSerializedValue(byte[] valueBytes, KnownVersion version, ByteArrayDataInput in, boolean forceDeserialize, InternalCache cache) {
            if (forceDeserialize) {
                return EntryEventImpl.deserialize(valueBytes, version, in);
            }
            return CachedDeserializableFactory.create(valueBytes, cache);
        }

        public static Object readRawValue(byte[] valueBytes) {
            return valueBytes;
        }

        public static void updateStats(DiskRegionView drv, Object owner, int entriesInVmDelta, int overflowOnDiskDelta, int overflowBytesOnDiskDelta) {
            if (entriesInVmDelta != 0) {
                drv.incNumEntriesInVM(entriesInVmDelta);
            }
            if (overflowOnDiskDelta != 0) {
                drv.incNumOverflowOnDisk(overflowOnDiskDelta);
            }
            if (overflowBytesOnDiskDelta != 0) {
                drv.incNumOverflowBytesOnDisk(overflowBytesOnDiskDelta);
            }
            if (owner instanceof BucketRegion) {
                BucketRegion br = (BucketRegion)owner;
                br.incNumEntriesInVM(entriesInVmDelta);
                br.incNumOverflowOnDisk(overflowOnDiskDelta);
                br.incNumOverflowBytesOnDisk(overflowBytesOnDiskDelta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int overflowToDisk(DiskEntry entry, InternalRegion region, EvictionController ccHelper) throws RegionClearedException {
            int change;
            DiskRegion dr = region.getDiskRegion();
            int oldSize = region.calculateRegionEntryValueSize(entry);
            DiskId did = entry.getDiskId();
            if (did == null) {
                ((EvictableEntry)((Object)entry)).setDelayedDiskId(region);
                did = entry.getDiskId();
            }
            boolean scheduledAsyncHere = false;
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    block16: {
                        if (!entry.isRemovedFromDisk()) break block16;
                        int n = 0;
                        return n;
                    }
                    boolean wasAlreadyPendingAsync = did.isPendingAsync();
                    if (did.needsToBeWritten()) {
                        if (Helper.doSynchronousWrite(region, dr)) {
                            Helper.writeToDisk(entry, region, false);
                        } else if (!wasAlreadyPendingAsync) {
                            scheduledAsyncHere = true;
                            did.setPendingAsync(true);
                        }
                    }
                    if (scheduledAsyncHere || wasAlreadyPendingAsync) {
                        change = entry.updateAsyncEntrySize(ccHelper);
                    } else {
                        region.updateSizeOnEvict(entry.getKey(), oldSize);
                        entry.handleValueOverflow(region);
                        entry.setValueWithContext(region, null);
                        change = ((EvictableEntry)((Object)entry)).updateEntrySize(ccHelper);
                        Helper.updateStats(dr, region, -1, 1, Helper.getValueLength(did));
                    }
                }
            }
            finally {
                dr.releaseReadLock();
            }
            if (scheduledAsyncHere && did.isPendingAsync()) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, entry, null));
            }
            return change;
        }

        private static void scheduleAsyncWrite(DiskStoreImpl.AsyncDiskEntry ade) {
            DiskRegion dr = ade.region.getDiskRegion();
            dr.scheduleAsyncWrite(ade);
        }

        public static void handleFullAsyncQueue(DiskEntry entry, InternalRegion region, VersionTag tag) {
            Helper.writeEntryToDisk(entry, region, tag, true);
        }

        public static void doAsyncFlush(VersionTag tag, InternalRegion region) {
            if (region.isThisRegionBeingClosedOrDestroyed()) {
                return;
            }
            DiskRegion dr = region.getDiskRegion();
            if (!dr.isBackup()) {
                return;
            }
            assert (!dr.isSync());
            dr.acquireReadLock();
            try {
                dr.getDiskStore().putVersionTagOnly(region, tag, true);
            }
            finally {
                dr.releaseReadLock();
            }
        }

        public static void doAsyncFlush(DiskEntry entry, InternalRegion region, VersionTag tag) {
            Helper.writeEntryToDisk(entry, region, tag, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static void writeEntryToDisk(DiskEntry entry, InternalRegion region, VersionTag tag, boolean asyncQueueWasFull) {
            if (region.isThisRegionBeingClosedOrDestroyed()) {
                return;
            }
            DiskRegion dr = region.getDiskRegion();
            if (!asyncQueueWasFull) {
                dr.setClearCountReference();
            }
            DiskEntry diskEntry = entry;
            // MONITORENTER : diskEntry
            try {
                DiskId did;
                dr.acquireReadLock();
                DiskId diskId = did = entry.getDiskId();
                // MONITORENTER : diskId
                if (did.isPendingAsync()) {
                    block30: {
                        did.setPendingAsync(false);
                        Token entryVal = entry.getValueAsToken();
                        int entryValSize = region.calculateRegionEntryValueSize(entry);
                        try {
                            if (Token.isRemovedFromDisk(entryVal)) {
                                if (region.isThisRegionBeingClosedOrDestroyed()) {
                                    // MONITOREXIT : diskId
                                    dr.releaseReadLock();
                                    return;
                                }
                                dr.remove(region, entry, true, false);
                                if (dr.isBackup()) {
                                    did.setKeyId(0L);
                                }
                                break block30;
                            }
                            if ((Token.isInvalid(entryVal) || entryVal == Token.TOMBSTONE) && !dr.isBackup()) break block30;
                            if (entryVal != null) {
                                Helper.writeToDisk(entry, region, true);
                                assert (!dr.isSync());
                                if (!Token.isInvalid(entryVal) && entryVal != Token.TOMBSTONE && entry instanceof EvictableEntry && ((EvictableEntry)((Object)entry)).isEvicted()) {
                                    region.updateSizeOnEvict(entry.getKey(), entryValSize);
                                    Helper.updateStats(dr, region, -1, 1, did.getValueLength());
                                    entry.handleValueOverflow(region);
                                    entry.setValueWithContext(region, null);
                                }
                                break block30;
                            }
                            if (tag != null) {
                                Helper.doAsyncFlush(tag, region);
                            }
                            // MONITOREXIT : diskId
                            dr.releaseReadLock();
                            return;
                        }
                        catch (RegionClearedException regionClearedException) {
                            // empty catch block
                        }
                    }
                    VersionStamp stamp = entry.getVersionStamp();
                    if (tag == null || stamp == null || stamp.getMemberID() == tag.getMemberID() && stamp.getRegionVersion() == tag.getRegionVersion()) return;
                    Helper.doAsyncFlush(tag, region);
                    return;
                }
                if (tag != null) {
                    Helper.doAsyncFlush(tag, region);
                }
                // MONITOREXIT : diskId
                return;
            }
            finally {
                if (asyncQueueWasFull) {
                    // MONITOREXIT : diskEntry
                    return;
                }
                dr.removeClearCountReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void removeFromDisk(DiskEntry entry, InternalRegion region, boolean isClear) throws RegionClearedException {
            DiskStoreImpl.AsyncDiskEntry asyncDiskEntry;
            DiskRegion dr = region.getDiskRegion();
            DiskId did = entry.getDiskId();
            Object syncObj = did;
            if (did == null) {
                syncObj = entry;
            }
            if (syncObj == did) {
                dr.acquireReadLock();
            }
            try {
                Object object = syncObj;
                synchronized (object) {
                    asyncDiskEntry = Helper.basicRemoveFromDisk(entry, region, isClear);
                }
            }
            finally {
                if (syncObj == did) {
                    dr.releaseReadLock();
                }
            }
            if (asyncDiskEntry != null && did.isPendingAsync()) {
                Helper.scheduleAsyncWrite(asyncDiskEntry);
            }
        }

        private static DiskStoreImpl.AsyncDiskEntry basicRemoveFromDisk(DiskEntry entry, InternalRegion region, boolean isClear) throws RegionClearedException {
            DiskRegion dr = region.getDiskRegion();
            DiskId did = entry.getDiskId();
            Token curValAsToken = entry.getValueAsToken();
            if (did == null || dr.isBackup() && did.getKeyId() == 0L) {
                if (!Token.isInvalidOrRemoved(curValAsToken)) {
                    Helper.updateStats(dr, region, -1, 0, 0);
                }
                dr.unscheduleAsyncWrite(did);
                return null;
            }
            DiskStoreImpl.AsyncDiskEntry result = null;
            did.unmarkForWriting();
            int oldValueLength = did.getValueLength();
            if (Helper.doSynchronousWrite(region, dr) || isClear) {
                dr.remove(region, entry, false, isClear);
                if (dr.isBackup()) {
                    did.setKeyId(0L);
                }
                did.setPendingAsync(false);
            } else {
                boolean maintainRVV;
                boolean bl = maintainRVV = region.getConcurrencyChecksEnabled() && dr.isBackup();
                if (!did.isPendingAsync() || maintainRVV) {
                    did.setPendingAsync(true);
                    VersionTag tag = null;
                    VersionStamp stamp = entry.getVersionStamp();
                    if (stamp != null) {
                        tag = stamp.asVersionTag();
                    }
                    result = new DiskStoreImpl.AsyncDiskEntry(region, entry, tag);
                }
            }
            if (curValAsToken == null) {
                Helper.updateStats(dr, region, 0, -1, -oldValueLength);
            } else if (!Token.isInvalidOrRemoved(curValAsToken)) {
                Helper.updateStats(dr, region, -1, 0, 0);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateVersionOnly(DiskEntry entry, InternalRegion region, VersionTag tag) {
            DiskRegion dr = region.getDiskRegion();
            if (!dr.isBackup()) {
                return;
            }
            assert (tag != null && tag.getMemberID() != null);
            boolean scheduleAsync = false;
            DiskId did = entry.getDiskId();
            Object syncObj = did;
            if (syncObj == null) {
                syncObj = entry;
            }
            if (syncObj == did) {
                dr.acquireReadLock();
            }
            try {
                Object object = syncObj;
                synchronized (object) {
                    if (Helper.doSynchronousWrite(region, dr)) {
                        dr.getDiskStore().putVersionTagOnly(region, tag, false);
                    } else {
                        scheduleAsync = true;
                    }
                }
            }
            finally {
                if (syncObj == did) {
                    dr.releaseReadLock();
                }
            }
            if (scheduleAsync) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, tag));
            }
        }

        static boolean doSynchronousWrite(InternalRegion region, DiskRegion dr) {
            return dr.isSync() || dr.isBackup() && !region.isInitialized();
        }

        public static interface ValueWrapper {
            public boolean isSerialized();

            public int getLength();

            public byte getUserBits();

            public void sendTo(ByteBuffer var1, Flushable var2) throws IOException;

            public String getBytesAsString();
        }

        public static class OffHeapValueWrapper
        implements ValueWrapper {
            private final StoredObject offHeapData;

            public OffHeapValueWrapper(StoredObject so) {
                assert (so.hasRefCount());
                assert (!so.isCompressed());
                this.offHeapData = so;
            }

            @Override
            public boolean isSerialized() {
                return this.offHeapData.isSerialized();
            }

            @Override
            public int getLength() {
                return this.offHeapData.getDataSize();
            }

            @Override
            public byte getUserBits() {
                byte userBits = 0;
                if (this.isSerialized()) {
                    userBits = EntryBits.setSerialized(userBits, true);
                }
                return userBits;
            }

            @Override
            public void sendTo(ByteBuffer bb, Flushable flushable) throws IOException {
                ByteBuffer chunkbb;
                int maxOffset = this.getLength();
                if (maxOffset == 0) {
                    return;
                }
                if (maxOffset > bb.capacity() && (chunkbb = this.offHeapData.createDirectByteBuffer()) != null) {
                    flushable.flush(bb, chunkbb);
                    return;
                }
                long bbAddress = AddressableMemoryManager.getDirectByteBufferAddress(bb);
                if (bbAddress != 0L) {
                    int bytesRemaining = maxOffset;
                    int availableSpace = bb.remaining();
                    long addrToWrite = bbAddress + (long)bb.position();
                    long addrToRead = this.offHeapData.getAddressForReadingData(0, maxOffset);
                    if (bytesRemaining > availableSpace) {
                        do {
                            AddressableMemoryManager.copyMemory(addrToRead, addrToWrite, availableSpace);
                            bb.position(bb.position() + availableSpace);
                            addrToRead += (long)availableSpace;
                            flushable.flush();
                            addrToWrite = bbAddress + (long)bb.position();
                        } while ((bytesRemaining -= availableSpace) > (availableSpace = bb.remaining()));
                    }
                    AddressableMemoryManager.copyMemory(addrToRead, addrToWrite, bytesRemaining);
                    bb.position(bb.position() + bytesRemaining);
                } else {
                    long addr;
                    long endAddr = addr + (long)maxOffset;
                    for (addr = this.offHeapData.getAddressForReadingData(0, maxOffset); addr != endAddr; ++addr) {
                        bb.put(AddressableMemoryManager.readByte(addr));
                        if (bb.hasRemaining()) continue;
                        flushable.flush();
                    }
                }
            }

            @Override
            public String getBytesAsString() {
                return this.offHeapData.getStringForm();
            }
        }

        public static class ByteArrayValueWrapper
        implements ValueWrapper {
            public final boolean isSerializedObject;
            public final byte[] bytes;

            public ByteArrayValueWrapper(boolean isSerializedObject, byte[] bytes) {
                this.isSerializedObject = isSerializedObject;
                this.bytes = bytes;
            }

            @Override
            public boolean isSerialized() {
                return this.isSerializedObject;
            }

            @Override
            public int getLength() {
                return this.bytes != null ? this.bytes.length : 0;
            }

            private boolean isInvalidToken() {
                return this == INVALID_VW;
            }

            private boolean isLocalInvalidToken() {
                return this == LOCAL_INVALID_VW;
            }

            private boolean isTombstoneToken() {
                return this == TOMBSTONE_VW;
            }

            @Override
            public byte getUserBits() {
                byte userBits = 0;
                if (this.isSerialized()) {
                    if (this.isTombstoneToken()) {
                        userBits = EntryBits.setTombstone(userBits, true);
                    } else if (this.isInvalidToken()) {
                        userBits = EntryBits.setInvalid(userBits, true);
                    } else if (this.isLocalInvalidToken()) {
                        userBits = EntryBits.setLocalInvalid(userBits, true);
                    } else {
                        if (this.bytes == null) {
                            throw new IllegalStateException("userBits==1 and value is null");
                        }
                        if (this.bytes.length == 0) {
                            throw new IllegalStateException("userBits==1 and value is zero length");
                        }
                        userBits = EntryBits.setSerialized(userBits, true);
                    }
                }
                return userBits;
            }

            @Override
            public void sendTo(ByteBuffer bb, Flushable flushable) throws IOException {
                int bytesThisTime;
                int maxOffset = this.getLength();
                for (int offset = 0; offset < maxOffset; offset += bytesThisTime) {
                    bytesThisTime = maxOffset - offset;
                    boolean needsFlush = false;
                    if (bytesThisTime > bb.remaining()) {
                        needsFlush = true;
                        bytesThisTime = bb.remaining();
                    }
                    bb.put(this.bytes, offset, bytesThisTime);
                    if (!needsFlush) continue;
                    flushable.flush();
                }
            }

            @Override
            public String getBytesAsString() {
                if (this.bytes == null) {
                    return "null";
                }
                StringBuilder sb = new StringBuilder();
                int len = this.getLength();
                for (int i = 0; i < len; ++i) {
                    sb.append(this.bytes[i]).append(", ");
                }
                return sb.toString();
            }
        }

        public static class CompactorValueWrapper
        extends ByteArrayValueWrapper {
            private final int length;

            public CompactorValueWrapper(byte[] bytes, int length) {
                super(false, bytes);
                this.length = length;
            }

            @Override
            public boolean isSerialized() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public byte getUserBits() {
                throw new UnsupportedOperationException();
            }
        }

        public static interface Flushable {
            public void flush() throws IOException;

            public void flush(ByteBuffer var1, ByteBuffer var2) throws IOException;
        }
    }
}

