/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.distributed.internal.CacheTime;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.versions.CompactVersionHolder;
import org.apache.geode.internal.cache.versions.VersionHolder;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TombstoneService {
    private static final Logger logger = LogService.getLogger();
    @VisibleForTesting
    public static final long REPLICATE_TOMBSTONE_TIMEOUT_DEFAULT;
    @MutableForTesting
    public static long REPLICATE_TOMBSTONE_TIMEOUT;
    @VisibleForTesting
    public static final long NON_REPLICATE_TOMBSTONE_TIMEOUT_DEFAULT;
    @MutableForTesting
    public static long NON_REPLICATE_TOMBSTONE_TIMEOUT;
    @VisibleForTesting
    public static final int EXPIRED_TOMBSTONE_LIMIT_DEFAULT;
    @MutableForTesting
    public static int EXPIRED_TOMBSTONE_LIMIT;
    @VisibleForTesting
    public static final long DEFUNCT_TOMBSTONE_SCAN_INTERVAL_DEFAULT;
    public static final long DEFUNCT_TOMBSTONE_SCAN_INTERVAL;
    @VisibleForTesting
    public static final double GC_MEMORY_THRESHOLD_DEFAULT;
    @MutableForTesting
    public static double GC_MEMORY_THRESHOLD;
    @VisibleForTesting
    public static final boolean FORCE_GC_MEMORY_EVENTS_DEFAULT = false;
    @MutableForTesting
    public static boolean FORCE_GC_MEMORY_EVENTS;
    @VisibleForTesting
    public static final long MAX_SLEEP_TIME_DEFAULT = 10000L;
    @MutableForTesting
    public static long MAX_SLEEP_TIME;
    @VisibleForTesting
    public static final boolean IDLE_EXPIRATION_DEFAULT = false;
    @MutableForTesting
    public static boolean IDLE_EXPIRATION;
    private final ReplicateTombstoneSweeper replicatedTombstoneSweeper;
    private final NonReplicateTombstoneSweeper nonReplicatedTombstoneSweeper;

    public static TombstoneService initialize(InternalCache cache) {
        return new TombstoneService(cache);
    }

    private TombstoneService(InternalCache cache) {
        this.replicatedTombstoneSweeper = new ReplicateTombstoneSweeper(cache, cache.getCachePerfStats(), cache.getCancelCriterion(), cache.getDistributionManager().getExecutors().getWaitingThreadPool());
        this.nonReplicatedTombstoneSweeper = new NonReplicateTombstoneSweeper(cache, cache.getCachePerfStats(), cache.getCancelCriterion());
        this.replicatedTombstoneSweeper.start();
        this.nonReplicatedTombstoneSweeper.start();
    }

    public void stop() {
        this.replicatedTombstoneSweeper.stop();
        this.nonReplicatedTombstoneSweeper.stop();
    }

    public void scheduleTombstone(LocalRegion r, RegionEntry entry, VersionTag destroyedVersion) {
        if (entry.getVersionStamp() == null) {
            logger.warn("Detected an attempt to schedule a tombstone for an entry that is not versioned in region " + r.getFullPath(), (Throwable)new Exception("stack trace"));
            return;
        }
        Tombstone ts = new Tombstone(entry, r, destroyedVersion);
        this.getSweeper(r).scheduleTombstone(ts);
    }

    public TombstoneSweeper getSweeper(LocalRegion r) {
        if (r.getScope().isDistributed() && r.getServerProxy() == null && r.getDataPolicy().withReplication()) {
            return this.replicatedTombstoneSweeper;
        }
        return this.nonReplicatedTombstoneSweeper;
    }

    public void unscheduleTombstones(LocalRegion r) {
        this.getSweeper(r).unscheduleTombstones(r);
    }

    public int getGCBlockCount() {
        return this.replicatedTombstoneSweeper.getGCBlockCount();
    }

    public int incrementGCBlockCount() {
        return this.replicatedTombstoneSweeper.incrementGCBlockCount();
    }

    public int decrementGCBlockCount() {
        return this.replicatedTombstoneSweeper.decrementGCBlockCount();
    }

    public long getScheduledTombstoneCount() {
        long result = 0L;
        result += this.replicatedTombstoneSweeper.getScheduledTombstoneCount();
        return result += this.nonReplicatedTombstoneSweeper.getScheduledTombstoneCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> gcTombstones(LocalRegion r, Map<VersionSource<?>, Long> regionGCVersions, boolean needsKeys) {
        Object object = this.getBlockGCLock();
        synchronized (object) {
            int count = this.getGCBlockCount();
            if (count > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("gcTombstones skipped due to {} Delta GII on going", (Object)count);
                }
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("gcTombstones invoked for region {} and version map {}", (Object)r, regionGCVersions);
            }
            VersionSource myId = r.getVersionMember();
            TombstoneSweeper sweeper = this.getSweeper(r);
            ArrayList removals = new ArrayList();
            sweeper.removeUnexpiredIf(t -> {
                if (t.region == r) {
                    Long maxReclaimedRV;
                    Object destroyingMember = t.getMemberID();
                    if (destroyingMember == null) {
                        destroyingMember = myId;
                    }
                    if ((maxReclaimedRV = (Long)regionGCVersions.get(destroyingMember)) != null && t.getRegionVersion() <= maxReclaimedRV) {
                        removals.add(t);
                        return true;
                    }
                }
                return false;
            });
            for (Map.Entry<VersionSource<?>, Long> entry : regionGCVersions.entrySet()) {
                r.getVersionVector().recordGCVersion(entry.getKey(), entry.getValue());
            }
            r.getVersionVector().pruneOldExceptions();
            if (r.getDataPolicy().withPersistence()) {
                r.getDiskRegion().writeRVVGC(r);
            }
            HashSet<Object> removedKeys = needsKeys ? new HashSet<Object>() : Collections.emptySet();
            for (Tombstone t2 : removals) {
                boolean tombstoneWasStillInRegionMap = t2.region.getRegionMap().removeTombstone(t2.entry, t2);
                if (!needsKeys || !tombstoneWasStillInRegionMap) continue;
                removedKeys.add(t2.entry.getKey());
            }
            return removedKeys;
        }
    }

    public void gcTombstoneKeys(LocalRegion r, Set<Object> tombstoneKeys) {
        if (r.getServerProxy() == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("gcTombstoneKeys invoked for region {} and keys {}", (Object)r, tombstoneKeys);
        }
        TombstoneSweeper sweeper = this.getSweeper(r);
        ArrayList removals = new ArrayList(tombstoneKeys.size());
        sweeper.removeUnexpiredIf(t -> {
            if (t.region == r && tombstoneKeys.contains(t.entry.getKey())) {
                removals.add(t);
                return true;
            }
            return false;
        });
        for (Tombstone t2 : removals) {
            t2.region.getRegionMap().removeTombstone(t2.entry, t2);
        }
    }

    public boolean forceBatchExpirationForTests(int count) throws InterruptedException {
        return this.replicatedTombstoneSweeper.testHook_forceExpiredTombstoneGC(count, 30L, TimeUnit.SECONDS);
    }

    public boolean forceBatchExpirationForTests(int count, long timeout, TimeUnit unit) throws InterruptedException {
        return this.replicatedTombstoneSweeper.testHook_forceExpiredTombstoneGC(count, timeout, unit);
    }

    public String toString() {
        return "Destroyed entries GC service.  Replicate Queue=" + String.valueOf(this.replicatedTombstoneSweeper) + " Non-replicate Queue=" + String.valueOf(this.nonReplicatedTombstoneSweeper);
    }

    public Object getBlockGCLock() {
        return this.replicatedTombstoneSweeper.getBlockGCLock();
    }

    static {
        REPLICATE_TOMBSTONE_TIMEOUT = REPLICATE_TOMBSTONE_TIMEOUT_DEFAULT = Long.getLong("gemfire.tombstone-timeout", 600000L).longValue();
        NON_REPLICATE_TOMBSTONE_TIMEOUT = NON_REPLICATE_TOMBSTONE_TIMEOUT_DEFAULT = Long.getLong("gemfire.non-replicated-tombstone-timeout", 480000L).longValue();
        EXPIRED_TOMBSTONE_LIMIT = EXPIRED_TOMBSTONE_LIMIT_DEFAULT = Integer.getInteger("gemfire.tombstone-gc-threshold", 100000).intValue();
        DEFUNCT_TOMBSTONE_SCAN_INTERVAL = DEFUNCT_TOMBSTONE_SCAN_INTERVAL_DEFAULT = Long.getLong("gemfire.tombstone-scan-interval", 60000L).longValue();
        GC_MEMORY_THRESHOLD = GC_MEMORY_THRESHOLD_DEFAULT = (double)Integer.getInteger("gemfire.tombstone-gc-memory-threshold", 30).intValue() * 0.01;
        FORCE_GC_MEMORY_EVENTS = false;
        MAX_SLEEP_TIME = 10000L;
        IDLE_EXPIRATION = false;
    }

    protected static class ReplicateTombstoneSweeper
    extends TombstoneSweeper {
        private final ExecutorService executor;
        private final List<Tombstone> expiredTombstones;
        private final Object expiredTombstonesLock = new Object();
        private boolean forceBatchExpiration = false;
        private volatile boolean batchExpirationInProgress;
        private final Object blockGCLock = new Object();
        private int progressingDeltaGIICount;
        private CountDownLatch testHook_forceBatchExpireCall;
        private int testHook_forceExpirationCount = 0;

        ReplicateTombstoneSweeper(CacheTime cacheTime, CachePerfStats stats, CancelCriterion cancelCriterion, ExecutorService executor) {
            super(cacheTime, stats, cancelCriterion, REPLICATE_TOMBSTONE_TIMEOUT, "Replicate/Partition Region Garbage Collector");
            this.expiredTombstones = new ArrayList<Tombstone>();
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrementGCBlockCount() {
            Object object = this.getBlockGCLock();
            synchronized (object) {
                return --this.progressingDeltaGIICount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int incrementGCBlockCount() {
            Object object = this.getBlockGCLock();
            synchronized (object) {
                return ++this.progressingDeltaGIICount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getGCBlockCount() {
            Object object = this.getBlockGCLock();
            synchronized (object) {
                return this.progressingDeltaGIICount;
            }
        }

        public Object getBlockGCLock() {
            return this.blockGCLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeExpiredIf(Predicate<Tombstone> predicate) {
            boolean result = false;
            long removalSize = 0L;
            Object object = this.expiredTombstonesLock;
            synchronized (object) {
                for (int idx = this.expiredTombstones.size() - 1; idx >= 0; --idx) {
                    Tombstone t = this.expiredTombstones.get(idx);
                    if (!predicate.test(t)) continue;
                    removalSize += (long)t.getSize();
                    this.expiredTombstones.remove(idx);
                    result = true;
                }
            }
            this.updateMemoryEstimate(-removalSize);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void expireBatch() {
            if (this.batchExpirationInProgress) {
                return;
            }
            Object object = this.getBlockGCLock();
            synchronized (object) {
                int count = this.getGCBlockCount();
                if (count > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("expireBatch skipped due to {} Delta GII on going", (Object)count);
                    }
                    return;
                }
                this.batchExpirationInProgress = true;
                boolean batchScheduled = false;
                try {
                    HashMap reapedKeys = new HashMap();
                    Iterator iterator = this.expiredTombstonesLock;
                    synchronized (iterator) {
                        for (Tombstone t2 : this.expiredTombstones) {
                            DistributedRegion tr = (DistributedRegion)t2.region;
                            if (!tr.isInitialized()) continue;
                            tr.getVersionVector().recordGCVersion(t2.getMemberID(), t2.getRegionVersion());
                            if (reapedKeys.containsKey(tr)) continue;
                            reapedKeys.put(tr, Collections.emptySet());
                        }
                    }
                    for (DistributedRegion r : reapedKeys.keySet()) {
                        r.getVersionVector().pruneOldExceptions();
                        if (!r.getDataPolicy().withPersistence()) continue;
                        r.getDiskRegion().writeRVVGC(r);
                    }
                    this.removeExpiredIf(t -> {
                        boolean tombstoneWasStillInRegionMap;
                        DistributedRegion tr = (DistributedRegion)t.region;
                        if (reapedKeys.containsKey(tr) && (tombstoneWasStillInRegionMap = tr.getRegionMap().removeTombstone(t.entry, (VersionHolder)t)) && this.hasToTrackKeysForClients(tr)) {
                            HashSet<Object> keys = (HashSet<Object>)reapedKeys.get(tr);
                            if (keys.isEmpty()) {
                                keys = new HashSet<Object>();
                                reapedKeys.put(tr, keys);
                            }
                            keys.add(t.entry.getKey());
                        }
                        return true;
                    });
                    this.executor.execute(() -> {
                        try {
                            for (Map.Entry mapEntry : reapedKeys.entrySet()) {
                                DistributedRegion r = (DistributedRegion)mapEntry.getKey();
                                Set rKeysReaped = (Set)mapEntry.getValue();
                                r.distributeTombstoneGC(rKeysReaped);
                            }
                        }
                        finally {
                            this.batchExpirationInProgress = false;
                        }
                    });
                    batchScheduled = true;
                }
                finally {
                    if (this.testHook_forceBatchExpireCall != null) {
                        this.testHook_forceBatchExpireCall.countDown();
                    }
                    if (!batchScheduled) {
                        this.batchExpirationInProgress = false;
                    }
                }
            }
        }

        private boolean hasToTrackKeysForClients(DistributedRegion r) {
            return r.isUsedForPartitionedRegionBucket() && (r.getFilterProfile() != null && r.getFilterProfile().hasInterest() || r.getPartitionedRegion().getRegionAdvisor().hasPRServerWithInterest());
        }

        @Override
        protected void checkExpiredTombstoneGC() {
            if (this.shouldCallExpireBatch()) {
                this.forceBatchExpiration = false;
                this.expireBatch();
            }
            this.checkIfBatchExpirationShouldBeForced();
        }

        private boolean shouldCallExpireBatch() {
            if (this.testHook_forceExpirationCount > 0) {
                return false;
            }
            if (this.forceBatchExpiration) {
                return true;
            }
            if (this.testHook_forceBatchExpireCall != null) {
                return true;
            }
            return this.expiredTombstones.size() >= EXPIRED_TOMBSTONE_LIMIT;
        }

        private void testHookIfIdleExpireBatch() {
            if (IDLE_EXPIRATION && this.sleepTime >= this.EXPIRY_TIME && !this.expiredTombstones.isEmpty()) {
                this.expireBatch();
            }
        }

        @Override
        protected void updateStatistics() {
            this.stats.setReplicatedTombstonesSize(this.getMemoryEstimate());
        }

        private void checkIfBatchExpirationShouldBeForced() {
            if (this.testHook_forceExpirationCount > 0) {
                return;
            }
            if (GC_MEMORY_THRESHOLD <= 0.0) {
                return;
            }
            if (this.batchExpirationInProgress) {
                return;
            }
            if (this.expiredTombstones.size() <= EXPIRED_TOMBSTONE_LIMIT / 4) {
                return;
            }
            if (FORCE_GC_MEMORY_EVENTS || this.isFreeMemoryLow()) {
                this.forceBatchExpiration = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("forcing batch expiration due to low memory conditions");
                }
            }
        }

        private boolean isFreeMemoryLow() {
            Runtime rt = Runtime.getRuntime();
            long unusedMemory = rt.freeMemory();
            long totalMemory = rt.totalMemory();
            long maxMemory = rt.maxMemory();
            return (double)(unusedMemory += maxMemory - totalMemory) / ((double)totalMemory * 1.0) < GC_MEMORY_THRESHOLD;
        }

        @Override
        protected boolean hasExpired(long msUntilTombstoneExpires) {
            if (this.testHook_forceExpirationCount > 0) {
                --this.testHook_forceExpirationCount;
                return true;
            }
            return msUntilTombstoneExpires <= 0L || msUntilTombstoneExpires > this.EXPIRY_TIME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void expireTombstone(Tombstone tombstone) {
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                logger.trace(LogMarker.TOMBSTONE_VERBOSE, "adding expired tombstone {} to batch", (Object)tombstone);
            }
            Object object = this.expiredTombstonesLock;
            synchronized (object) {
                this.expiredTombstones.add(tombstone);
            }
        }

        @Override
        public long getOldestTombstoneTime() {
            long result = 0L;
            if (this.tombstones.peek() != null) {
                result = ((Tombstone)this.tombstones.peek()).getVersionTimeStamp();
            }
            return result;
        }

        @Override
        public String getOldestTombstone() {
            String result = null;
            if (this.tombstones.peek() != null) {
                result = ((Tombstone)this.tombstones.peek()).toString();
            }
            return result;
        }

        @Override
        protected void handleNoUnexpiredTombstones() {
            this.testHook_forceExpirationCount = 0;
        }

        @Override
        public String toString() {
            return super.toString() + " batchedExpiredTombstones[" + this.expiredTombstones.size() + "] = " + String.valueOf(this.expiredTombstones);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean testHook_forceExpiredTombstoneGC(int count, long timeout, TimeUnit unit) throws InterruptedException {
            Object object = this.getBlockGCLock();
            synchronized (object) {
                this.testHook_forceBatchExpireCall = new CountDownLatch(1);
            }
            try {
                object = this;
                synchronized (object) {
                    this.testHook_forceExpirationCount += count;
                    this.notifyAll();
                }
                boolean bl = this.testHook_forceBatchExpireCall.await(timeout, unit);
                return bl;
            }
            finally {
                this.testHook_forceBatchExpireCall = null;
            }
        }

        @Override
        protected void beforeSleepChecks() {
            this.testHookIfIdleExpireBatch();
        }

        @Override
        public long getScheduledTombstoneCount() {
            return super.getScheduledTombstoneCount() + (long)this.expiredTombstones.size();
        }
    }

    private static class NonReplicateTombstoneSweeper
    extends TombstoneSweeper {
        NonReplicateTombstoneSweeper(CacheTime cacheTime, CachePerfStats stats, CancelCriterion cancelCriterion) {
            super(cacheTime, stats, cancelCriterion, NON_REPLICATE_TOMBSTONE_TIMEOUT, "Non-replicate Region Garbage Collector");
        }

        @Override
        protected boolean removeExpiredIf(Predicate<Tombstone> predicate) {
            return false;
        }

        @Override
        protected void updateStatistics() {
            this.stats.setNonReplicatedTombstonesSize(this.getMemoryEstimate());
        }

        @Override
        protected boolean hasExpired(long msUntilTombstoneExpires) {
            return msUntilTombstoneExpires <= 0L || msUntilTombstoneExpires > this.EXPIRY_TIME;
        }

        @Override
        protected void expireTombstone(Tombstone tombstone) {
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                logger.trace(LogMarker.TOMBSTONE_VERBOSE, "removing expired tombstone {}", (Object)tombstone);
            }
            this.updateMemoryEstimate(-tombstone.getSize());
            tombstone.region.getRegionMap().removeTombstone(tombstone.entry, tombstone);
        }

        @Override
        protected void checkExpiredTombstoneGC() {
        }

        @Override
        protected void handleNoUnexpiredTombstones() {
        }

        @Override
        boolean testHook_forceExpiredTombstoneGC(int count, long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        protected void beforeSleepChecks() {
        }

        @Override
        public long getOldestTombstoneTime() {
            long result = 0L;
            if (this.tombstones.peek() != null) {
                result = ((Tombstone)this.tombstones.peek()).getVersionTimeStamp();
            }
            return result;
        }

        @Override
        public String getOldestTombstone() {
            String result = null;
            if (this.tombstones.peek() != null) {
                result = ((Tombstone)this.tombstones.peek()).toString();
            }
            return result;
        }
    }

    @VisibleForTesting
    public static class Tombstone
    extends CompactVersionHolder {
        public static final int PER_TOMBSTONE_OVERHEAD = ReflectionSingleObjectSizer.REFERENCE_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE * 3 + ReflectionSingleObjectSizer.REFERENCE_SIZE + 18;
        RegionEntry entry;
        LocalRegion region;

        @VisibleForTesting
        public Tombstone(RegionEntry entry, LocalRegion region, VersionTag destroyedVersion) {
            super(destroyedVersion);
            this.entry = entry;
            this.region = region;
        }

        public int getSize() {
            return PER_TOMBSTONE_OVERHEAD + ObjectSizer.DEFAULT.sizeof(this.entry.getKey());
        }

        @Override
        public String toString() {
            String v = super.toString();
            return "(" + String.valueOf(this.entry.getKey()) + "; " + this.region.getName() + "; " + v + ")";
        }
    }

    public static abstract class TombstoneSweeper
    implements Runnable {
        protected final long EXPIRY_TIME;
        private final long PURGE_INTERVAL;
        protected long sleepTime;
        private long minimumPurgeTime = 1L;
        private long lastPurgeTimestamp;
        @VisibleForTesting
        public final Queue<Tombstone> tombstones;
        private final AtomicLong memoryUsedEstimate;
        private final Thread sweeperThread;
        private final StoppableReentrantLock queueHeadLock;
        protected final CacheTime cacheTime;
        protected final CachePerfStats stats;
        private final CancelCriterion cancelCriterion;
        private volatile boolean isStopped;

        TombstoneSweeper(CacheTime cacheTime, CachePerfStats stats, CancelCriterion cancelCriterion, long expiryTime, String threadName) {
            this.cacheTime = cacheTime;
            this.stats = stats;
            this.cancelCriterion = cancelCriterion;
            this.EXPIRY_TIME = expiryTime;
            this.PURGE_INTERVAL = Math.min(DEFUNCT_TOMBSTONE_SCAN_INTERVAL, expiryTime);
            this.tombstones = new ConcurrentLinkedQueue<Tombstone>();
            this.memoryUsedEstimate = new AtomicLong();
            this.queueHeadLock = new StoppableReentrantLock(cancelCriterion);
            this.sweeperThread = new LoggingThread(threadName, (Runnable)this);
            this.lastPurgeTimestamp = this.getNow();
        }

        public void unscheduleTombstones(LocalRegion r) {
            this.removeIf(t -> t.region == r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeUnexpiredIf(Predicate<Tombstone> predicate) {
            boolean result = false;
            long removalSize = 0L;
            this.lockQueueHead();
            try {
                Iterator it = this.getQueue().iterator();
                while (it.hasNext()) {
                    Tombstone t = (Tombstone)it.next();
                    if (!predicate.test(t)) continue;
                    removalSize += (long)t.getSize();
                    it.remove();
                    result = true;
                }
            }
            finally {
                this.unlockQueueHead();
            }
            this.updateMemoryEstimate(-removalSize);
            return result;
        }

        private boolean removeIf(Predicate<Tombstone> predicate) {
            boolean isTombstoneRemoved = this.removeUnexpiredIf(predicate);
            if (this.removeExpiredIf(predicate)) {
                isTombstoneRemoved = true;
            }
            return isTombstoneRemoved;
        }

        synchronized void start() {
            this.sweeperThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            TombstoneSweeper tombstoneSweeper = this;
            synchronized (tombstoneSweeper) {
                this.isStopped = true;
                this.notifyAll();
            }
            try {
                this.sweeperThread.join(100L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }

        private void lockQueueHead() {
            this.queueHeadLock.lock();
        }

        private void unlockQueueHead() {
            this.queueHeadLock.unlock();
        }

        public long getMemoryEstimate() {
            return this.memoryUsedEstimate.get();
        }

        public void updateMemoryEstimate(long delta) {
            this.memoryUsedEstimate.addAndGet(delta);
        }

        protected Queue<Tombstone> getQueue() {
            return this.tombstones;
        }

        void scheduleTombstone(Tombstone ts) {
            this.tombstones.add(ts);
            this.updateMemoryEstimate(ts.getSize());
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                logger.trace(LogMarker.TOMBSTONE_VERBOSE, "Destroyed entries sweeper starting with sleep interval of {} milliseconds", (Object)this.EXPIRY_TIME);
            }
            while (!this.isStopped && !this.cancelCriterion.isCancelInProgress()) {
                try {
                    this.updateStatistics();
                    SystemFailure.checkFailure();
                    long now = this.getNow();
                    this.checkExpiredTombstoneGC();
                    this.checkOldestUnexpired(now);
                    this.purgeObsoleteTombstones(now);
                    this.doSleep();
                }
                catch (CancelException ignore) {
                    break;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    logger.fatal("GemFire garbage collection service encountered an unexpected exception", e);
                }
            }
        }

        private long getNow() {
            return this.cacheTime.cacheTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSleep() {
            if (this.sleepTime <= 0L) {
                return;
            }
            this.beforeSleepChecks();
            this.sleepTime = Math.min(this.sleepTime, MAX_SLEEP_TIME);
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                logger.trace(LogMarker.TOMBSTONE_VERBOSE, "sleeping for {}", (Object)this.sleepTime);
            }
            TombstoneSweeper tombstoneSweeper = this;
            synchronized (tombstoneSweeper) {
                if (this.isStopped) {
                    return;
                }
                try {
                    this.wait(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void purgeObsoleteTombstones(long now) {
            if (this.minimumPurgeTime > this.sleepTime) {
                return;
            }
            if (now - this.lastPurgeTimestamp < this.PURGE_INTERVAL) {
                return;
            }
            this.lastPurgeTimestamp = now;
            boolean removedObsoleteTombstone = this.removeIf(tombstone -> {
                if (tombstone.region.getRegionMap().isTombstoneNotNeeded(tombstone.entry, tombstone.getEntryVersion())) {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                        logger.trace(LogMarker.TOMBSTONE_VERBOSE, "removing obsolete tombstone: {}", tombstone);
                    }
                    return true;
                }
                return false;
            });
            if (removedObsoleteTombstone) {
                this.sleepTime = 0L;
            } else {
                long elapsed = this.getNow() - now;
                this.sleepTime -= elapsed;
                if (this.sleepTime <= 0L) {
                    this.minimumPurgeTime = elapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public void checkOldestUnexpired(long now) {
            this.sleepTime = 0L;
            this.lockQueueHead();
            Tombstone oldest = this.tombstones.peek();
            try {
                if (oldest == null) {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                        logger.trace(LogMarker.TOMBSTONE_VERBOSE, "queue is empty - will sleep");
                    }
                    this.handleNoUnexpiredTombstones();
                    this.sleepTime = this.EXPIRY_TIME;
                } else {
                    long msUntilHeadTombstoneExpires;
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                        logger.trace(LogMarker.TOMBSTONE_VERBOSE, "oldest unexpired tombstone is {}", (Object)oldest);
                    }
                    if (this.hasExpired(msUntilHeadTombstoneExpires = oldest.getVersionTimeStamp() + this.EXPIRY_TIME - now)) {
                        try {
                            this.tombstones.remove();
                            this.expireTombstone(oldest);
                        }
                        catch (CancelException cancelException) {
                        }
                        catch (Exception e) {
                            logger.warn("Unexpected exception while processing tombstones", (Throwable)e);
                        }
                    } else {
                        this.sleepTime = Math.min(msUntilHeadTombstoneExpires, this.EXPIRY_TIME);
                    }
                }
            }
            finally {
                this.unlockQueueHead();
            }
        }

        public long getScheduledTombstoneCount() {
            return this.getQueue().size();
        }

        public String toString() {
            return "[" + this.getQueue().size() + "] " + this.getQueue().toString();
        }

        protected abstract boolean removeExpiredIf(Predicate<Tombstone> var1);

        protected abstract void checkExpiredTombstoneGC();

        protected abstract void handleNoUnexpiredTombstones();

        protected abstract boolean hasExpired(long var1);

        protected abstract void expireTombstone(Tombstone var1);

        protected abstract void updateStatistics();

        protected abstract void beforeSleepChecks();

        abstract boolean testHook_forceExpiredTombstoneGC(int var1, long var2, TimeUnit var4) throws InterruptedException;

        public abstract long getOldestTombstoneTime();

        public abstract String getOldestTombstone();
    }
}

