/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.Serializable;
import java.util.Collection;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireException;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;

public class PutAllPartialResultException
extends GemFireException {
    private static final long serialVersionUID = 2411654400733621071L;
    private final PutAllPartialResult result;

    public PutAllPartialResultException(PutAllPartialResult result) {
        super("Bulk operation had some failures");
        this.result = result;
    }

    public PutAllPartialResultException() {
        super("Bulk operation had some failures");
        this.result = new PutAllPartialResult(-1);
    }

    public void consolidate(PutAllPartialResultException pre) {
        this.result.consolidate(pre.getResult());
    }

    public void consolidate(PutAllPartialResult otherResult) {
        this.result.consolidate(otherResult);
    }

    public void setSucceededKeysAndVersions(VersionedObjectList keysAndVersions) {
        this.result.setSucceededKeysAndVersions(keysAndVersions);
    }

    public PutAllPartialResult getResult() {
        return this.result;
    }

    public VersionedObjectList getSucceededKeysAndVersions() {
        return this.result.getSucceededKeysAndVersions();
    }

    public Exception getFailure() {
        return this.result.getFailure();
    }

    public boolean hasFailure() {
        return this.result.hasFailure();
    }

    public Object getFirstFailedKey() {
        return this.result.getFirstFailedKey();
    }

    @Override
    public String getMessage() {
        return this.result.toString();
    }

    public static class PutAllPartialResult
    implements Serializable {
        private static final long serialVersionUID = -2168767259323206954L;
        private VersionedObjectList succeededKeys = new VersionedObjectList();
        private Object firstFailedKey;
        private Exception firstCauseOfFailure;
        private int totalMapSize;

        public PutAllPartialResult(int totalMapSize) {
            this.totalMapSize = totalMapSize;
        }

        public void setTotalMapSize(int totalMapSize) {
            this.totalMapSize = totalMapSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSucceededKeysAndVersions(VersionedObjectList other) {
            PutAllPartialResult putAllPartialResult = this;
            synchronized (putAllPartialResult) {
                this.succeededKeys = other;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consolidate(PutAllPartialResult other) {
            PutAllPartialResult putAllPartialResult = this;
            synchronized (putAllPartialResult) {
                this.succeededKeys.addAll(other.getSucceededKeysAndVersions());
            }
            this.saveFailedKey(other.firstFailedKey, other.firstCauseOfFailure);
        }

        public Exception getFailure() {
            return this.firstCauseOfFailure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addKeysAndVersions(VersionedObjectList keysAndVersions) {
            PutAllPartialResult putAllPartialResult = this;
            synchronized (putAllPartialResult) {
                this.succeededKeys.addAll(keysAndVersions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addKeys(Collection<?> keys) {
            PutAllPartialResult putAllPartialResult = this;
            synchronized (putAllPartialResult) {
                if (this.succeededKeys.getVersionTags().size() > 0) {
                    throw new IllegalStateException("attempt to store versionless keys when there are already versioned results");
                }
                this.succeededKeys.addAllKeys(keys);
            }
        }

        public void saveFailedKey(Object key, Exception cause) {
            if (key == null) {
                return;
            }
            if (this.firstFailedKey == null || cause instanceof CancelException) {
                this.firstFailedKey = key;
                this.firstCauseOfFailure = cause;
            }
        }

        public VersionedObjectList getSucceededKeysAndVersions() {
            return this.succeededKeys;
        }

        public Object getFirstFailedKey() {
            return this.firstFailedKey;
        }

        public boolean hasFailure() {
            return this.firstFailedKey != null;
        }

        public boolean hasSucceededKeys() {
            return this.succeededKeys.size() > 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key " + String.valueOf(this.firstFailedKey) + " and possibly others failed the operation due to " + String.valueOf(this.firstCauseOfFailure) + "\n");
            if (this.totalMapSize > 0) {
                int failedKeyNum = this.totalMapSize - this.succeededKeys.size();
                sb.append("The bulk operation failed on " + failedKeyNum + " out of " + this.totalMapSize + " entries. ");
            }
            return sb.toString();
        }

        public String detailString() {
            return this.toString() + this.getKeyListString();
        }

        public String getKeyListString() {
            StringBuilder sb = new StringBuilder();
            sb.append("The keys for the successful entries are: ");
            int cnt = 0;
            VersionedObjectList.Iterator iterator = this.succeededKeys.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                sb.append(" ").append(key);
                ++cnt;
            }
            return sb.toString();
        }
    }
}

