/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;

public class NonLocalRegionEntryWithStats
extends NonLocalRegionEntry {
    private long hitCount;
    private long missCount;
    private long lastAccessed;

    public NonLocalRegionEntryWithStats(RegionEntry re, LocalRegion br, boolean allowTombstones) {
        super(re, br, allowTombstones);
        try {
            this.lastAccessed = re.getLastAccessed();
            this.hitCount = re.getHitCount();
            this.missCount = re.getMissCount();
        }
        catch (InternalStatisticsDisabledException unexpected) {
            Assert.assertTrue(false, "Unexpected " + String.valueOf(unexpected));
        }
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public long getLastAccessed() throws StatisticsDisabledException {
        return this.lastAccessed;
    }

    @Override
    public long getHitCount() throws StatisticsDisabledException {
        return this.hitCount;
    }

    @Override
    public long getMissCount() throws StatisticsDisabledException {
        return this.missCount;
    }

    public NonLocalRegionEntryWithStats() {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.lastAccessed);
        out.writeLong(this.hitCount);
        out.writeLong(this.missCount);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.lastAccessed = in.readLong();
        this.hitCount = in.readLong();
        this.missCount = in.readLong();
    }
}

