/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.VersionedDataSerializable;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.StaticSerialization;

public class FilterRoutingInfo
implements VersionedDataSerializable {
    @Immutable
    private static final KnownVersion[] serializationVersions = new KnownVersion[0];
    private boolean memberWithFilterInfoExists = false;
    private transient FilterInfo localFilterInfo;
    private final HashMap<InternalDistributedMember, FilterInfo> serverFilterInfo = new HashMap();

    public void setLocalCqInfo(HashMap<Long, Integer> cqInfo) {
        if (this.localFilterInfo == null) {
            this.localFilterInfo = new FilterInfo();
        }
        this.localFilterInfo.cqs = cqInfo;
        this.localFilterInfo.filterProcessedLocally = true;
    }

    public void setLocalInterestedClients(Set<Long> clients, Set<Long> clientsInv) {
        if (this.localFilterInfo == null) {
            this.localFilterInfo = new FilterInfo();
        }
        this.localFilterInfo.setInterestedClients(clients);
        this.localFilterInfo.setInterestedClientsInv(clientsInv);
        this.localFilterInfo.filterProcessedLocally = true;
    }

    public FilterInfo getLocalFilterInfo() {
        return this.localFilterInfo;
    }

    public void setCqRoutingInfo(InternalDistributedMember member, HashMap<Long, Integer> cqInfo) {
        FilterInfo fInfo = new FilterInfo();
        fInfo.setCQs(cqInfo);
        this.serverFilterInfo.put(member, fInfo);
        if (cqInfo.size() > 0) {
            this.memberWithFilterInfoExists = true;
        }
    }

    public void addInterestedClients(InternalDistributedMember member, Set<Long> clients, Set<Long> clientsInv, boolean longIDs) {
        this.memberWithFilterInfoExists = true;
        FilterInfo fInfo = this.serverFilterInfo.get(member);
        if (fInfo == null) {
            fInfo = new FilterInfo();
            this.serverFilterInfo.put(member, fInfo);
        }
        if (clients != null && clients.size() > 0) {
            fInfo.setInterestedClients(clients);
        }
        if (clientsInv != null && clientsInv.size() > 0) {
            fInfo.setInterestedClientsInv(clientsInv);
        }
        if (longIDs) {
            fInfo.longIDs = true;
        }
    }

    public Set<InternalDistributedMember> getMembers() {
        return this.serverFilterInfo.keySet();
    }

    public boolean hasMemberWithFilterInfo() {
        return this.memberWithFilterInfoExists;
    }

    public FilterInfo getFilterInfo(InternalDistributedMember member) {
        return this.serverFilterInfo.get(member);
    }

    public void addFilterInfo(FilterRoutingInfo eventRouting) {
        for (Map.Entry<InternalDistributedMember, FilterInfo> entry : eventRouting.serverFilterInfo.entrySet()) {
            FilterInfo existing = this.serverFilterInfo.get(entry.getKey());
            if (existing == null) {
                existing = new FilterInfo();
                this.serverFilterInfo.put(entry.getKey(), existing);
            }
            existing.addFilterInfo(entry.getValue());
        }
        if (eventRouting.localFilterInfo != null) {
            if (this.localFilterInfo == null) {
                this.localFilterInfo = new FilterInfo();
            }
            this.localFilterInfo.addFilterInfo(eventRouting.localFilterInfo);
        }
        this.memberWithFilterInfoExists |= eventRouting.memberWithFilterInfoExists;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        InternalDistributedMember myID = null;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            myID = cache.getMyId();
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            InternalDistributedMember member = InternalDistributedMember.readEssentialData(in);
            FilterInfo fInfo = new FilterInfo();
            InternalDataSerializer.invokeFromData(fInfo, in);
            if (myID != null && !((Object)myID).equals(member)) continue;
            this.serverFilterInfo.put(member, fInfo);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        int size = this.serverFilterInfo.size();
        out.writeInt(size);
        for (Map.Entry<InternalDistributedMember, FilterInfo> e : this.serverFilterInfo.entrySet()) {
            InternalDistributedMember member = e.getKey();
            member.writeEssentialData(out);
            FilterInfo fInfo = e.getValue();
            InternalDataSerializer.invokeToData(fInfo, out);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return serializationVersions;
    }

    public String toString() {
        Object result = "FilterRoutingInfo(";
        if (this.localFilterInfo != null) {
            result = (String)result + "local=";
            result = (String)result + String.valueOf(this.localFilterInfo);
            result = (String)result + ", ";
        }
        result = (String)result + "remote=";
        result = (String)result + String.valueOf(this.serverFilterInfo);
        return (String)result + ")";
    }

    public static class FilterInfo
    implements VersionedDataSerializable {
        public boolean longIDs;
        private static final long serialVersionUID = 0L;
        private HashMap<Long, Integer> cqs;
        private transient byte[] myData;
        private Set<Long> interestedClients;
        private Set<Long> interestedClientsInv;
        public boolean filterProcessedLocally = false;
        @Immutable
        private static final KnownVersion[] serializationVersions = new KnownVersion[0];

        public void addFilterInfo(FilterInfo other) {
            if (other.cqs != null) {
                if (this.cqs == null) {
                    this.cqs = new HashMap();
                }
                for (Map.Entry<Long, Integer> entry : other.cqs.entrySet()) {
                    this.cqs.put(entry.getKey(), entry.getValue());
                }
            }
            if (other.interestedClients != null) {
                if (this.interestedClients == null) {
                    this.interestedClients = new HashSet<Long>();
                }
                this.interestedClients.addAll(other.interestedClients);
            }
            if (other.interestedClientsInv != null) {
                if (this.interestedClientsInv == null) {
                    this.interestedClientsInv = new HashSet<Long>();
                }
                this.interestedClientsInv.addAll(other.interestedClientsInv);
            }
        }

        public void clearCQRouting() {
            this.cqs = null;
        }

        public KnownVersion[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.myData = DataSerializer.readByteArray(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            int size = 9;
            size += this.interestedClients == null ? 4 : this.interestedClients.size() * 8 + 5;
            size += this.interestedClientsInv == null ? 4 : this.interestedClientsInv.size() * 8 + 5;
            byte[] myData = StaticSerialization.getThreadLocalByteArray((int)(size += this.cqs == null ? 0 : this.cqs.size() * 12));
            HeapDataOutputStream hdos = new HeapDataOutputStream(myData);
            hdos.disallowExpansion();
            if (this.cqs == null) {
                hdos.writeBoolean(false);
            } else {
                hdos.writeBoolean(true);
                InternalDataSerializer.writeArrayLength(this.cqs.size(), hdos);
                for (Map.Entry<Long, Integer> longIntegerEntry : this.cqs.entrySet()) {
                    InternalDataSerializer.writeUnsignedVL(longIntegerEntry.getKey(), hdos);
                    InternalDataSerializer.writeUnsignedVL(longIntegerEntry.getValue().intValue(), hdos);
                }
            }
            InternalDataSerializer.writeSetOfLongs(this.interestedClients, this.longIDs, hdos);
            InternalDataSerializer.writeSetOfLongs(this.interestedClientsInv, this.longIDs, hdos);
            hdos.finishWriting();
            DataSerializer.writeByteArray(myData, hdos.size(), out);
        }

        public HashMap<Long, Integer> getCQs() {
            if (this.cqs == null && this.myData != null) {
                this.deserialize();
            }
            return this.cqs;
        }

        public void setCQs(HashMap<Long, Integer> cqs) {
            this.cqs = cqs;
        }

        public Set<Long> getInterestedClients() {
            if (this.interestedClients == null && this.myData != null) {
                this.deserialize();
            }
            return this.interestedClients;
        }

        public void setInterestedClients(Set<Long> clients) {
            this.interestedClients = clients;
        }

        public Set<Long> getInterestedClientsInv() {
            if (this.interestedClientsInv == null && this.myData != null) {
                this.deserialize();
            }
            return this.interestedClientsInv;
        }

        public void setInterestedClientsInv(Set<Long> clients) {
            this.interestedClientsInv = clients;
        }

        private void deserialize() {
            try (ByteArrayDataInput dis = new ByteArrayDataInput(this.myData);){
                boolean hasCQs = dis.readBoolean();
                if (hasCQs) {
                    int numEntries = InternalDataSerializer.readArrayLength((DataInput)dis);
                    this.cqs = new HashMap(numEntries);
                    for (int i = 0; i < numEntries; ++i) {
                        Long key = InternalDataSerializer.readUnsignedVL((DataInput)dis);
                        Integer value = (int)InternalDataSerializer.readUnsignedVL((DataInput)dis);
                        this.cqs.put(key, value);
                    }
                }
                this.interestedClients = InternalDataSerializer.readSetOfLongs((DataInput)dis);
                this.interestedClientsInv = InternalDataSerializer.readSetOfLongs((DataInput)dis);
                this.myData = null;
            }
            catch (IOException e) {
                throw new InternalGemFireError(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.interestedClients != null && this.interestedClients.size() > 0) {
                sb.append("interestedClients:");
                sb.append(this.interestedClients);
            }
            if (this.interestedClientsInv != null && this.interestedClientsInv.size() > 0) {
                sb.append(", interestedClientsInv:");
                sb.append(this.interestedClientsInv);
            }
            if (InternalDistributedSystem.getLogger().finerEnabled()) {
                if (this.cqs != null) {
                    sb.append(", cqs=");
                    sb.append(this.cqs.keySet());
                }
            } else if (this.cqs != null) {
                sb.append(", ").append(this.cqs.size()).append(" cqs");
            }
            return sb.toString();
        }
    }
}

