/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.geode.CancelCriterion;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidValueException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.internal.LoadMonitor;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.api.MemberDataBuilder;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.ClientHealthMonitoringRegion;
import org.apache.geode.internal.cache.AbstractCacheServer;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.OverflowAttributes;
import org.apache.geode.internal.cache.tier.sockets.AcceptorBuilder;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.logging.log4j.Logger;

public class CacheServerImpl
extends AbstractCacheServer
implements DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    private static final int FORCE_LOAD_UPDATE_FREQUENCY = Integer.getInteger("gemfire.BridgeServer.FORCE_LOAD_UPDATE_FREQUENCY", 10);
    static final String CACHE_SERVER_BIND_ADDRESS_NOT_AVAILABLE_EXCEPTION_MESSAGE = "A cache server's bind address is only available if it has been started";
    private final SecurityService securityService;
    private final StatisticsClock statisticsClock;
    private final AcceptorBuilder acceptorBuilder;
    private final boolean sendResourceEvents;
    private final boolean includeMembershipGroups;
    private volatile Acceptor acceptor;
    private volatile CacheServerAdvisor advisor;
    private volatile LoadMonitor loadMonitor;
    private boolean isDefaultServer;
    private int serialNumber;
    private final Supplier<SocketCreator> socketCreatorSupplier;
    private final CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider;
    private final ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider;
    private final Function<DistributionAdvisee, CacheServerAdvisor> cacheServerAdvisorProvider;
    public static final boolean ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE = Boolean.getBoolean("gemfire.cache-server.enable-notify-by-subscription-false");
    @MakeNotStatic
    private static final AtomicInteger profileSN = new AtomicInteger();

    CacheServerImpl(InternalCache cache, SecurityService securityService, StatisticsClock statisticsClock, AcceptorBuilder acceptorBuilder, boolean sendResourceEvents, boolean includeMembershipGroups, Supplier<SocketCreator> socketCreatorSupplier, CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider, ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider, Function<DistributionAdvisee, CacheServerAdvisor> cacheServerAdvisorProvider) {
        super(cache);
        this.securityService = securityService;
        this.statisticsClock = statisticsClock;
        this.acceptorBuilder = acceptorBuilder;
        this.sendResourceEvents = sendResourceEvents;
        this.includeMembershipGroups = includeMembershipGroups;
        this.socketCreatorSupplier = socketCreatorSupplier;
        this.cacheClientNotifierProvider = cacheClientNotifierProvider;
        this.clientHealthMonitorProvider = clientHealthMonitorProvider;
        this.cacheServerAdvisorProvider = cacheServerAdvisorProvider;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    @Override
    public StatisticsClock getStatisticsClock() {
        return this.statisticsClock;
    }

    private void checkRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("A cache server's configuration cannot be changed once it is running.");
        }
    }

    @Override
    public int getPort() {
        if (this.acceptor != null) {
            return this.acceptor.getPort();
        }
        return super.getPort();
    }

    @Override
    public void setPort(int port) {
        this.checkRunning();
        super.setPort(port);
    }

    @Override
    public void setBindAddress(String address) {
        this.checkRunning();
        super.setBindAddress(address);
    }

    @Override
    public void setHostnameForClients(String name) {
        this.checkRunning();
        super.setHostnameForClients(name);
    }

    @Override
    public void setMaxConnections(int maxCon) {
        this.checkRunning();
        super.setMaxConnections(maxCon);
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.checkRunning();
        super.setMaxThreads(maxThreads);
    }

    @Override
    public void setNotifyBySubscription(boolean b) {
        this.checkRunning();
        if (ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE) {
            this.notifyBySubscription = b;
        }
    }

    @Override
    public void setMaximumMessageCount(int maximumMessageCount) {
        this.checkRunning();
        super.setMaximumMessageCount(maximumMessageCount);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @Override
    public void setLoadPollInterval(long loadPollInterval) {
        this.checkRunning();
        super.setLoadPollInterval(loadPollInterval);
    }

    @Override
    public int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @Override
    public void setLoadProbe(ServerLoadProbe loadProbe) {
        this.checkRunning();
        super.setLoadProbe(loadProbe);
    }

    @Override
    public int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    public boolean isDefaultServer() {
        return this.isDefaultServer;
    }

    public void setIsDefaultServer() {
        this.isDefaultServer = true;
    }

    public void configureFrom(CacheServer other) {
        this.setPort(other.getPort());
        this.setBindAddress(other.getBindAddress());
        this.setHostnameForClients(other.getHostnameForClients());
        this.setMaxConnections(other.getMaxConnections());
        this.setMaxThreads(other.getMaxThreads());
        this.setNotifyBySubscription(other.getNotifyBySubscription());
        this.setSocketBufferSize(other.getSocketBufferSize());
        this.setTcpNoDelay(other.getTcpNoDelay());
        this.setMaximumTimeBetweenPings(other.getMaximumTimeBetweenPings());
        this.setMaximumMessageCount(other.getMaximumMessageCount());
        this.setMessageTimeToLive(other.getMessageTimeToLive());
        this.setGroups(other.getGroups());
        this.setLoadProbe(other.getLoadProbe());
        this.setLoadPollInterval(other.getLoadPollInterval());
        ClientSubscriptionConfig cscOther = other.getClientSubscriptionConfig();
        ClientSubscriptionConfig cscThis = this.getClientSubscriptionConfig();
        cscThis.setEvictionPolicy(cscOther.getEvictionPolicy());
        cscThis.setCapacity(cscOther.getCapacity());
        String diskStoreName = cscOther.getDiskStoreName();
        if (diskStoreName != null) {
            cscThis.setDiskStoreName(diskStoreName);
        } else {
            cscThis.setOverflowDirectory(cscOther.getOverflowDirectory());
        }
    }

    @Override
    public synchronized void start() throws IOException {
        Assert.assertTrue(this.cache != null);
        this.serialNumber = CacheServerImpl.createSerialNumber();
        if (DynamicRegionFactory.get().isOpen() && !this.notifyBySubscription) {
            logger.info("Forcing notifyBySubscription to support dynamic regions");
            this.notifyBySubscription = true;
        }
        this.advisor = this.cacheServerAdvisorProvider.apply(this);
        this.loadMonitor = new LoadMonitor(this.loadProbe, this.maxConnections, this.loadPollInterval, FORCE_LOAD_UPDATE_FREQUENCY, this.advisor);
        final ClientSubscriptionConfig clientSubscriptionConfig = this.getClientSubscriptionConfig();
        final String diskStoreName = clientSubscriptionConfig.getDiskStoreName();
        OverflowAttributes overflowAttributes = new OverflowAttributes(){

            @Override
            public String getEvictionPolicy() {
                return clientSubscriptionConfig.getEvictionPolicy();
            }

            @Override
            public int getQueueCapacity() {
                return clientSubscriptionConfig.getCapacity();
            }

            @Override
            public int getPort() {
                return CacheServerImpl.this.port;
            }

            @Override
            public boolean isDiskStore() {
                return diskStoreName != null;
            }

            @Override
            public String getOverflowDirectory() {
                return clientSubscriptionConfig.getOverflowDirectory();
            }

            @Override
            public String getDiskStoreName() {
                return diskStoreName;
            }
        };
        this.acceptor = this.createAcceptor(overflowAttributes);
        this.acceptor.start();
        this.advisor.handshake();
        this.loadMonitor.start(new ServerLocation(this.getExternalAddress(), this.getPort()), this.acceptor.getStats());
        ClientHealthMonitoringRegion.getInstance(this.cache);
        logger.info(String.format("CacheServer Configuration:  %s", this.getConfig()));
        ClientMembershipListener[] membershipListeners = ClientMembership.getClientMembershipListeners();
        boolean membershipListenerRegistered = false;
        for (ClientMembershipListener membershipListener : membershipListeners) {
            if (this.listener != membershipListener) continue;
            membershipListenerRegistered = true;
            break;
        }
        if (!membershipListenerRegistered) {
            ClientMembership.registerClientMembershipListener(this.listener);
        }
        if (this.sendResourceEvents) {
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.CACHE_SERVER_START, this);
        }
    }

    @Override
    public Acceptor createAcceptor(OverflowAttributes overflowAttributes) throws IOException {
        this.acceptorBuilder.forServer(this);
        return this.acceptorBuilder.create(overflowAttributes);
    }

    @Override
    public String getExternalAddress() {
        return this.getExternalAddress(true);
    }

    public String getExternalAddress(boolean checkServerRunning) {
        if (checkServerRunning && !this.isRunning()) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            throw new IllegalStateException(CACHE_SERVER_BIND_ADDRESS_NOT_AVAILABLE_EXCEPTION_MESSAGE);
        }
        if (this.hostnameForClients == null || this.hostnameForClients.isEmpty()) {
            if (this.acceptor != null) {
                return this.acceptor.getExternalAddress();
            }
            return null;
        }
        return this.hostnameForClients;
    }

    @Override
    public boolean isRunning() {
        return this.acceptor != null && this.acceptor.isRunning();
    }

    @Override
    public synchronized void stop() {
        RuntimeException firstException;
        block12: {
            if (!this.isRunning()) {
                return;
            }
            firstException = null;
            try {
                if (this.loadMonitor != null) {
                    this.loadMonitor.stop();
                }
            }
            catch (RuntimeException e) {
                logger.warn("CacheServer - Error closing load monitor", (Throwable)e);
                firstException = e;
            }
            try {
                if (this.advisor != null) {
                    this.advisor.close();
                }
            }
            catch (RuntimeException e) {
                logger.warn("CacheServer - Error closing advisor", (Throwable)e);
                firstException = e;
            }
            try {
                if (this.acceptor != null) {
                    this.acceptor.close();
                }
            }
            catch (RuntimeException e) {
                logger.warn("CacheServer - Error closing acceptor monitor", (Throwable)e);
                if (firstException == null) break block12;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        ClientMembership.unregisterClientMembershipListener(this.listener);
        TXManagerImpl txMgr = (TXManagerImpl)this.cache.getCacheTransactionManager();
        txMgr.removeHostedTXStatesForClients();
        if (this.sendResourceEvents) {
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.CACHE_SERVER_STOP, this);
        }
    }

    private String getConfig() {
        ClientSubscriptionConfig csc = this.getClientSubscriptionConfig();
        String str = "port=" + this.getPort() + " max-connections=" + this.getMaxConnections() + " max-threads=" + this.getMaxThreads() + " notify-by-subscription=" + this.getNotifyBySubscription() + " socket-buffer-size=" + this.getSocketBufferSize() + " maximum-time-between-pings=" + this.getMaximumTimeBetweenPings() + " maximum-message-count=" + this.getMaximumMessageCount() + " message-time-to-live=" + this.getMessageTimeToLive() + " eviction-policy=" + csc.getEvictionPolicy() + " capacity=" + csc.getCapacity() + " overflow directory=";
        str = csc.getDiskStoreName() != null ? str + csc.getDiskStoreName() : str + csc.getOverflowDirectory();
        str = str + " groups=" + String.valueOf(Arrays.asList(this.getGroups())) + " loadProbe=" + String.valueOf(this.loadProbe) + " loadPollInterval=" + this.loadPollInterval + " tcpNoDelay=" + this.tcpNoDelay;
        return str;
    }

    public String toString() {
        ClientSubscriptionConfig csc = this.getClientSubscriptionConfig();
        String str = "CacheServer on port=" + this.getPort() + " client subscription config policy=" + csc.getEvictionPolicy() + " client subscription config capacity=" + csc.getCapacity();
        str = csc.getDiskStoreName() != null ? str + " client subscription config overflow disk store=" + csc.getDiskStoreName() : str + " client subscription config overflow directory=" + csc.getOverflowDirectory();
        return str;
    }

    @Override
    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        return this.getCacheClientNotifier().getClientProxy(durableClientId);
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        return this.getCacheClientNotifier().getClientProxy(ClientProxyMembershipID.getClientId(member));
    }

    public Set getAllClientSessions() {
        return new HashSet<CacheClientProxy>(this.getCacheClientNotifier().getClientProxies());
    }

    public static String clientMessagesRegion(InternalCache cache, String ePolicy, int capacity, int port, String overFlowDir, boolean isDiskStore) {
        InternalRegionFactory factory = CacheServerImpl.getRegionFactoryForClientMessagesRegion(cache, ePolicy, capacity, overFlowDir, isDiskStore);
        return CacheServerImpl.createClientMessagesRegion(factory, port);
    }

    private static InternalRegionFactory getRegionFactoryForClientMessagesRegion(InternalCache cache, String ePolicy, int capacity, String overflowDir, boolean isDiskStore) throws InvalidValueException, GemFireIOException {
        InternalRegionFactory factory = cache.createInternalRegionFactory();
        factory.setScope(Scope.LOCAL);
        if (isDiskStore) {
            factory.setDiskStoreName(overflowDir);
            factory.setDiskSynchronous(true);
        } else if (overflowDir == null || overflowDir.equals(".")) {
            factory.setDiskStoreName(null);
            factory.setDiskSynchronous(true);
        } else {
            File dir = new File(overflowDir + File.separatorChar + CacheServerImpl.generateNameForClientMsgsRegion(OSProcess.getId()));
            dir.deleteOnExit();
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new GemFireIOException("Could not create client subscription overflow directory: " + dir.getAbsolutePath());
            }
            File[] dirs = new File[]{dir};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            dsf.setAutoCompact(true).setDiskDirsAndSizes(dirs, new int[]{Integer.MAX_VALUE}).create("bsi");
            factory.setDiskStoreName("bsi");
            factory.setDiskSynchronous(true);
        }
        factory.setDataPolicy(DataPolicy.NORMAL);
        factory.setStatisticsEnabled(true);
        if ("entry".equals(ePolicy)) {
            factory.setEvictionAttributes(EvictionAttributes.createLIFOEntryAttributes(capacity, EvictionAction.OVERFLOW_TO_DISK));
        } else if ("mem".equals(ePolicy)) {
            factory.setEvictionAttributes(EvictionAttributes.createLIFOMemoryAttributes(capacity, EvictionAction.OVERFLOW_TO_DISK));
        } else {
            throw new InvalidValueException(String.format("%s Invalid eviction policy", ePolicy));
        }
        return factory;
    }

    private static String createClientMessagesRegion(InternalRegionFactory factory, int port) {
        String regionName = CacheServerImpl.generateNameForClientMsgsRegion(port);
        try {
            factory.setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true);
            factory.create(regionName);
        }
        catch (RegionExistsException ree) {
            InternalGemFireError assErr = new InternalGemFireError("unexpected exception", ree);
            throw assErr;
        }
        return regionName;
    }

    public static String generateNameForClientMsgsRegion(int id) {
        return "client_subscription_" + id;
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.advisor;
    }

    public CacheServerAdvisor getCacheServerAdvisor() {
        return this.advisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.getDistributionAdvisor().createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.cache.getInternalDistributedSystem();
    }

    @Override
    public String getName() {
        return "CacheServer";
    }

    @Override
    public String getFullPath() {
        return this.getName();
    }

    private static int createSerialNumber() {
        return profileSN.incrementAndGet();
    }

    @Override
    public String[] getCombinedGroups() {
        ArrayList<String> groupList = new ArrayList<String>();
        if (this.includeMembershipGroups) {
            for (String g : MemberDataBuilder.parseGroups(null, (String)this.getSystem().getConfig().getGroups())) {
                if (groupList.contains(g)) continue;
                groupList.add(g);
            }
        }
        for (String g : this.getGroups()) {
            if (groupList.contains(g)) continue;
            groupList.add(g);
        }
        String[] groups = new String[groupList.size()];
        return groupList.toArray(groups);
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof CacheServerAdvisor.CacheServerProfile);
        CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
        bp.setHost(this.getExternalAddress(false));
        bp.setPort(this.getPort());
        bp.setGroups(this.getCombinedGroups());
        bp.setMaxConnections(this.maxConnections);
        bp.setInitialLoad(this.loadMonitor.getLastLoad());
        bp.setLoadPollInterval(this.getLoadPollInterval());
        bp.serialNumber = this.getSerialNumber();
        bp.finishInit();
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    protected CacheClientNotifier getCacheClientNotifier() {
        return this.getAcceptor().getCacheClientNotifier();
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        if (!this.isRunning()) {
            throw new IllegalStateException("The cache server must be running to use this operation");
        }
        this.getCacheClientNotifier().registerInterestRegistrationListener(listener);
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        this.getCacheClientNotifier().unregisterInterestRegistrationListener(listener);
    }

    public Set getInterestRegistrationListeners() {
        return this.getCacheClientNotifier().getInterestRegistrationListeners();
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.loadMonitor;
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public long getTimeLimitMillis() {
        return 120000L;
    }

    @Override
    public Supplier<SocketCreator> getSocketCreatorSupplier() {
        return this.socketCreatorSupplier;
    }

    @Override
    public CacheClientNotifier.CacheClientNotifierProvider getCacheClientNotifierProvider() {
        return this.cacheClientNotifierProvider;
    }

    @Override
    public ClientHealthMonitor.ClientHealthMonitorProvider getClientHealthMonitorProvider() {
        return this.clientHealthMonitorProvider;
    }
}

