/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BaseRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntryEventSerialization;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.OrderedTombstoneMap;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.RegionMapOwner;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.TxCallbackEventFactory;
import org.apache.geode.internal.cache.TxCallbackEventFactoryImpl;
import org.apache.geode.internal.cache.entries.AbstractOplogDiskRegionEntry;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.map.CacheModificationLock;
import org.apache.geode.internal.cache.map.FocusedRegionMap;
import org.apache.geode.internal.cache.map.RegionMapCommitPut;
import org.apache.geode.internal.cache.map.RegionMapDestroy;
import org.apache.geode.internal.cache.map.RegionMapPut;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.region.entry.RegionEntryFactoryBuilder;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionHolder;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapClearRequired;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.geode.internal.util.concurrent.ConcurrentMapWithReusableEntries;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegionMap
extends BaseRegionMap
implements FocusedRegionMap,
CacheModificationLock {
    private static final Logger logger = LogService.getLogger();
    private final TxCallbackEventFactory txCallbackEventFactory = new TxCallbackEventFactoryImpl();
    protected ConcurrentMapWithReusableEntries<Object, Object> map;
    @MutableForTesting
    static final Runnable testHookRunnableForConcurrentOperation = null;
    private RegionEntryFactory entryFactory;
    private RegionMap.Attributes attr;
    private RegionMapOwner owner;
    private final EntryEventSerialization entryEventSerialization = new EntryEventSerialization();
    private RegionMap.ARMLockTestHook armLockTestHook;

    protected AbstractRegionMap(InternalRegionArguments internalRegionArgs) {
    }

    protected void initialize(RegionMapOwner owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs, boolean isLRU) {
        boolean offHeap;
        boolean withVersioning;
        boolean isDisk;
        this._setAttributes(attr);
        this.setOwner(owner);
        this.setEntryMap(this.createConcurrentMapWithReusableEntries(attr.initialCapacity, attr.loadFactor, attr.concurrencyLevel, false, new AbstractRegionEntry.HashRegionEntryCreator()));
        if (owner instanceof InternalRegion) {
            InternalRegion region = (InternalRegion)owner;
            isDisk = region.getDiskRegion() != null;
            withVersioning = region.getConcurrencyChecksEnabled();
            offHeap = region.getOffHeap();
        } else if (owner instanceof PlaceHolderDiskRegion) {
            offHeap = ((RegionEntryContext)((Object)owner)).getOffHeap();
            isDisk = true;
            withVersioning = ((DiskRegionView)owner).getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
        } else {
            throw new IllegalStateException("expected LocalRegion or PlaceHolderDiskRegion");
        }
        this.setEntryFactory(new RegionEntryFactoryBuilder().create(attr.statisticsEnabled, isLRU, isDisk, withVersioning, offHeap));
    }

    private ConcurrentMapWithReusableEntries<Object, Object> createConcurrentMapWithReusableEntries(int initialCapacity, float loadFactor, int concurrencyLevel, boolean isIdentityMap, CustomEntryConcurrentHashMap.HashEntryCreator<Object, Object> entryCreator) {
        if (entryCreator != null) {
            return new CustomEntryConcurrentHashMap<Object, Object>(initialCapacity, loadFactor, concurrencyLevel, isIdentityMap, entryCreator);
        }
        return new CustomEntryConcurrentHashMap<Object, Object>(initialCapacity, loadFactor, concurrencyLevel, isIdentityMap);
    }

    @Override
    public void changeOwner(LocalRegion r) {
        if (r == this._getOwnerObject()) {
            return;
        }
        this.setOwner(r);
    }

    @Override
    public void setEntryFactory(RegionEntryFactory f) {
        this.entryFactory = f;
    }

    @Override
    public RegionEntryFactory getEntryFactory() {
        return this.entryFactory;
    }

    private void _setAttributes(RegionMap.Attributes a) {
        this.attr = a;
    }

    @Override
    public RegionMap.Attributes getAttributes() {
        return this.attr;
    }

    public LocalRegion _getOwner() {
        return (LocalRegion)this.owner;
    }

    boolean _isOwnerALocalRegion() {
        return this.owner instanceof LocalRegion;
    }

    Object _getOwnerObject() {
        return this.owner;
    }

    private void setOwner(RegionMapOwner owner) {
        this.owner = owner;
    }

    @Override
    public ConcurrentMapWithReusableEntries<Object, Object> getCustomEntryConcurrentHashMap() {
        return this.map;
    }

    @Override
    public Map<Object, Object> getEntryMap() {
        return this.map;
    }

    @Override
    public void setEntryMap(ConcurrentMapWithReusableEntries<Object, Object> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.getEntryMap().size();
    }

    @Override
    public int sizeInVM() {
        return this.getEntryMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntryMap().isEmpty();
    }

    @Override
    public Set keySet() {
        return this.getEntryMap().keySet();
    }

    @Override
    public Collection<RegionEntry> regionEntries() {
        return this.getEntryMap().values();
    }

    @Override
    public Collection<RegionEntry> regionEntriesInVM() {
        return this.getEntryMap().values();
    }

    @Override
    public boolean containsKey(Object key) {
        RegionEntry re = this.getEntry(key);
        if (re == null) {
            return false;
        }
        return !re.isRemoved();
    }

    @Override
    public RegionEntry getEntry(Object key) {
        RegionEntry re = (RegionEntry)this.getEntryMap().get(key);
        return re;
    }

    @Override
    public RegionEntry getEntry(EntryEventImpl event) {
        return this.getEntry(event.getKey());
    }

    @Override
    public RegionEntry getEntryInVM(Object key) {
        return (RegionEntry)this.getEntryMap().get(key);
    }

    @Override
    public RegionEntry putEntryIfAbsent(Object key, RegionEntry regionEntry) {
        Object v;
        RegionEntry oldRe = (RegionEntry)this.getEntryMap().putIfAbsent(key, regionEntry);
        if (oldRe == null && regionEntry instanceof OffHeapRegionEntry && this._isOwnerALocalRegion() && this._getOwner().isThisRegionBeingClosedOrDestroyed() && (v = regionEntry.getValue()) != Token.REMOVED_PHASE1 && v != Token.REMOVED_PHASE2 && v instanceof StoredObject && ((StoredObject)v).hasRefCount() && this.getEntryMap().remove(key, regionEntry)) {
            ((OffHeapRegionEntry)regionEntry).release();
        }
        return oldRe;
    }

    @Override
    public RegionEntry getOperationalEntryInVM(Object key) {
        RegionEntry re = (RegionEntry)this.getEntryMap().get(key);
        return re;
    }

    @Override
    public void removeEntry(Object key, RegionEntry regionEntry, boolean updateStat) {
        if (regionEntry.isTombstone() && this.getEntryMap().get(key) == regionEntry) {
            logger.fatal("Internal product error: attempt to directly remove a versioned tombstone from region entry map", (Throwable)new Exception("stack trace"));
            return;
        }
        if (this.getEntryMap().remove(key, regionEntry)) {
            regionEntry.removePhase2();
            if (updateStat) {
                this.incEntryCount(-1);
            }
        }
    }

    @Override
    public void incEntryCount(int delta) {
        CachePerfStats stats;
        LocalRegion lr = this._getOwner();
        if (lr != null && (stats = lr.getCachePerfStats()) != null) {
            stats.incEntryCount(delta);
        }
    }

    void incClearCount(LocalRegion lr) {
        CachePerfStats stats;
        if (lr != null && !(lr instanceof HARegion) && (stats = lr.getCachePerfStats()) != null) {
            stats.incClearCount();
        }
    }

    private void _mapClear() {
        DistributionManager manager;
        ExecutorService executor = null;
        InternalCache cache = this.owner.getCache();
        if (cache != null && (manager = cache.getDistributionManager()) != null) {
            executor = manager.getExecutors().getWaitingThreadPool();
        }
        this.getCustomEntryConcurrentHashMap().clearWithExecutor(executor);
    }

    @Override
    public void close(BucketRegion bucketRegion) {
        this.clear(null, bucketRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<VersionSource> clear(RegionVersionVector rvv, BucketRegion bucketRegion) {
        HashSet<VersionSource> result = new HashSet<VersionSource>();
        if (!this._isOwnerALocalRegion()) {
            this._mapClear();
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Clearing entries for {} rvv={}", (Object)this._getOwner(), (Object)rvv);
        }
        LocalRegion lr = this._getOwner();
        RegionVersionVector localRvv = lr.getVersionVector();
        this.incClearCount(lr);
        Object object = lr.getSizeGuard();
        synchronized (object) {
            if (rvv == null) {
                int delta = 0;
                try {
                    delta = this.sizeInVM();
                }
                catch (GemFireIOException gemFireIOException) {
                    // empty catch block
                }
                int tombstones = lr.getTombstoneCount();
                this._mapClear();
                this._getOwner().updateSizeOnClearRegion(delta - tombstones);
                this._getOwner().incTombstoneCount(-tombstones);
                if (delta != 0) {
                    this.incEntryCount(-delta);
                }
            } else {
                int delta = 0;
                int tombstones = 0;
                VersionSource myId = this._getOwner().getVersionMember();
                if (localRvv != rvv) {
                    localRvv.recordGCVersions(rvv);
                }
                boolean isTraceEnabled = logger.isTraceEnabled();
                Iterator<RegionEntry> iterator = this.regionEntries().iterator();
                while (iterator.hasNext()) {
                    RegionEntry re;
                    RegionEntry regionEntry = re = iterator.next();
                    synchronized (regionEntry) {
                        Token value = re.getValueAsToken();
                        if (value == Token.REMOVED_PHASE1 || value == Token.REMOVED_PHASE2) {
                            continue;
                        }
                        Object id = re.getVersionStamp().getMemberID();
                        if (id == null) {
                            id = myId;
                        }
                        if (rvv.contains(id, re.getVersionStamp().getRegionVersion())) {
                            if (isTraceEnabled) {
                                logger.trace("region clear op is removing {} {}", re.getKey(), (Object)re.getVersionStamp());
                            }
                            boolean tombstone = re.isTombstone();
                            if (this.getEntryMap().remove(re.getKey(), re)) {
                                if (OffHeapClearRequired.doesClearNeedToCheckForOffHeap()) {
                                    GatewaySenderEventImpl.release(re.getValue());
                                }
                                try {
                                    re.removePhase1(lr, true);
                                }
                                catch (RegionClearedException regionClearedException) {
                                    // empty catch block
                                }
                                re.removePhase2();
                                this.lruEntryDestroy(re);
                                if (tombstone) {
                                    this._getOwner().incTombstoneCount(-1);
                                    ++tombstones;
                                } else {
                                    ++delta;
                                }
                            }
                        } else {
                            result.add((VersionSource)id);
                        }
                    }
                }
                this._getOwner().updateSizeOnClearRegion(delta);
                this.incEntryCount(-delta);
                this.incEntryCount(-tombstones);
                if (logger.isDebugEnabled()) {
                    logger.debug("Size after clearing = {}", (Object)this.getEntryMap().size());
                }
                if (isTraceEnabled && this.getEntryMap().size() < 20) {
                    this._getOwner().dumpBackingMap();
                }
            }
        }
        return result;
    }

    public void lruUpdateCallback(boolean b) {
    }

    @Override
    public void lruEntryCreate(RegionEntry e) {
    }

    @Override
    public void lruEntryDestroy(RegionEntry regionEntry) {
    }

    @Override
    public void lruEntryUpdate(RegionEntry e) {
    }

    @Override
    public void decTxRefCount(RegionEntry e) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        e.decRefCount(null, lr);
    }

    @Override
    public void processVersionTag(RegionEntry regionEntry, EntryEventImpl event) {
        if (regionEntry.getVersionStamp() != null) {
            ImageState is;
            regionEntry.getVersionStamp().processVersionTag(event);
            VersionTag tag = event.getVersionTag();
            if (tag != null && !event.getRegion().isInitialized() && (is = event.getRegion().getImageState()) != null && !event.getRegion().isUsedForPartitionedRegionBucket()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("recording version tag in image state: {}", (Object)tag);
                }
                is.addVersionTag(event.getKey(), tag);
            }
        }
    }

    private void processVersionTagForGII(RegionEntry re, LocalRegion owner, VersionTag entryVersion, boolean isTombstone, InternalDistributedMember sender, boolean checkConflicts) {
        re.getVersionStamp().processVersionTag(this._getOwner(), entryVersion, isTombstone, false, owner.getMyId(), sender, checkConflicts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        Map.Entry entry;
        OrderedTombstoneMap<RegionEntry> tombstones = new OrderedTombstoneMap<RegionEntry>();
        if (rm != null) {
            ConcurrentMapWithReusableEntries<Object, Object> other = rm.getCustomEntryConcurrentHashMap();
            Iterator<Map.Entry<Object, Object>> it = other.entrySetWithReusableEntries().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                it.remove();
                RegionEntry oldRe = (RegionEntry)me.getValue();
                Object key = me.getKey();
                Object value = oldRe.getValueRetain((RegionEntryContext)((AbstractRegionMap)rm)._getOwnerObject(), true);
                try {
                    if (value == Token.NOT_AVAILABLE) {
                        value = null;
                    }
                    if (value == Token.TOMBSTONE && !this._getOwner().getConcurrencyChecksEnabled()) continue;
                    RegionEntry newRe = this.getEntryFactory().createEntry((RegionEntryContext)this._getOwnerObject(), key, value);
                    this.copyRecoveredEntry(oldRe, newRe);
                    if (newRe.isTombstone()) {
                        VersionTag tag = newRe.getVersionStamp().asVersionTag();
                        tombstones.put(tag, newRe);
                    } else {
                        this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(newRe));
                        if (this._getOwner() instanceof BucketRegionQueue) {
                            BucketRegionQueue brq = (BucketRegionQueue)this._getOwner();
                            brq.incSecondaryQueueSize(1);
                        }
                    }
                    this.incEntryCount(1);
                    this.lruEntryUpdate(newRe);
                }
                finally {
                    OffHeapHelper.release(value);
                    if (!(oldRe instanceof OffHeapRegionEntry)) continue;
                    ((OffHeapRegionEntry)oldRe).release();
                    continue;
                }
                this.lruUpdateCallback();
            }
        } else {
            Iterator<RegionEntry> iter = this.regionEntries().iterator();
            while (iter.hasNext()) {
                RegionEntry re = iter.next();
                if (re.isTombstone()) {
                    if (re.getVersionStamp() == null) {
                        iter.remove();
                        continue;
                    }
                    tombstones.put(re.getVersionStamp().asVersionTag(), re);
                    continue;
                }
                this._getOwner().updateSizeOnCreate(re.getKey(), this._getOwner().calculateRegionEntryValueSize(re));
                if (!(this._getOwner() instanceof BucketRegionQueue)) continue;
                BucketRegionQueue brq = (BucketRegionQueue)this._getOwner();
                brq.incSecondaryQueueSize(1);
            }
            this.incEntryCount(this.size());
            this.lruUpdateCallback();
        }
        while ((entry = tombstones.take()) != null) {
            this._getOwner().scheduleTombstone((RegionEntry)entry.getValue(), entry.getKey());
        }
    }

    private void copyRecoveredEntry(RegionEntry oldRe, RegionEntry newRe) {
        if (newRe.getVersionStamp() != null) {
            newRe.getVersionStamp().setMemberID((VersionSource)oldRe.getVersionStamp().getMemberID());
            newRe.getVersionStamp().setVersions(oldRe.getVersionStamp().asVersionTag());
        }
        if (newRe instanceof AbstractOplogDiskRegionEntry) {
            ((AbstractOplogDiskRegionEntry)newRe).setDiskId(oldRe);
            this._getOwner().getDiskRegion().replaceIncompatibleEntry((DiskEntry)oldRe, (DiskEntry)newRe);
        }
        this.getEntryMap().put(newRe.getKey(), newRe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEntry initRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        RegionEntry newRe;
        boolean needsCallback = false;
        RegionEntry regionEntry = newRe = this.getEntryFactory().createEntry((RegionEntryContext)this._getOwnerObject(), key, value);
        synchronized (regionEntry) {
            if (value.getVersionTag() != null && newRe.getVersionStamp() != null) {
                newRe.getVersionStamp().setVersions(value.getVersionTag());
            }
            RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
            while (oldRe != null) {
                RegionEntry regionEntry2 = oldRe;
                synchronized (regionEntry2) {
                    if (oldRe.isRemoved() && !oldRe.isTombstone()) {
                        if (this._isOwnerALocalRegion()) {
                            this._getOwner().getCachePerfStats().incRetries();
                        }
                    } else {
                        if (newRe instanceof OffHeapRegionEntry) {
                            ((OffHeapRegionEntry)newRe).release();
                        }
                        throw new IllegalStateException("Could not recover entry for key " + String.valueOf(key) + ".  The entry already exists!");
                    }
                    this.getEntryMap().remove(key, oldRe);
                    oldRe = this.putEntryIfAbsent(key, newRe);
                }
            }
            if (this._isOwnerALocalRegion()) {
                if (newRe.isTombstone()) {
                    this._getOwner().scheduleTombstone(newRe, newRe.getVersionStamp().asVersionTag());
                } else {
                    this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(newRe));
                }
                this.incEntryCount(1);
            }
            this.lruEntryUpdate(newRe);
            needsCallback = true;
        }
        if (needsCallback) {
            this.lruUpdateCallback();
        }
        EntryLogger.logRecovery(this._getOwnerObject(), key, value);
        return newRe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        boolean needsCallback = false;
        RegionEntry re = this.getEntry(key);
        if (re == null) {
            return null;
        }
        RegionEntry regionEntry = re;
        synchronized (regionEntry) {
            if (re.isRemoved() && !re.isTombstone()) {
                return null;
            }
            if (value.getVersionTag() != null && re.getVersionStamp() != null) {
                re.getVersionStamp().setVersions(value.getVersionTag());
            }
            try {
                if (this._isOwnerALocalRegion()) {
                    boolean oldValueWasTombstone = re.isTombstone();
                    boolean oldIsDestroyedOrRemoved = re.isDestroyedOrRemoved();
                    if (oldValueWasTombstone) {
                        this._getOwner().unscheduleTombstone(re);
                    }
                    int oldSize = this._getOwner().calculateRegionEntryValueSize(re);
                    re.setValue(this._getOwner(), value);
                    if (re.isTombstone()) {
                        this._getOwner().scheduleTombstone(re, re.getVersionStamp().asVersionTag());
                        if (!oldIsDestroyedOrRemoved) {
                            this._getOwner().updateSizeOnRemove(key, oldSize);
                        }
                    } else if (oldIsDestroyedOrRemoved) {
                        this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(re));
                    } else {
                        this._getOwner().updateSizeOnPut(key, oldSize, this._getOwner().calculateRegionEntryValueSize(re));
                    }
                } else {
                    value.applyToDiskEntry((PlaceHolderDiskRegion)this._getOwnerObject(), (DiskEntry)re, (RegionEntryContext)this._getOwnerObject());
                }
            }
            catch (RegionClearedException rce) {
                throw new IllegalStateException("RegionClearedException should never happen in this context", rce);
            }
            this.lruEntryUpdate(re);
            needsCallback = true;
        }
        if (needsCallback) {
            this.lruUpdateCallback();
        }
        EntryLogger.logRecovery(this._getOwnerObject(), key, value);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initialImagePut(Object key, long lastModified, Object newValue, boolean wasRecovered, boolean deferLRUCallback, VersionTag entryVersion, InternalDistributedMember sender, boolean isSynchronizing) {
        boolean acceptedVersionTag;
        boolean result = false;
        boolean done = false;
        boolean cleared = false;
        LocalRegion owner = this._getOwner();
        boolean bl = acceptedVersionTag = entryVersion != null && owner.getConcurrencyChecksEnabled();
        if (newValue == Token.TOMBSTONE && !owner.getConcurrencyChecksEnabled()) {
            return false;
        }
        if (owner instanceof HARegion && newValue instanceof CachedDeserializable && (newValue = ((HARegion)owner).updateHAEventWrapper(sender, (CachedDeserializable)newValue)) == null) {
            return false;
        }
        try {
            RegionEntry newRe = this.getEntryFactory().createEntry(owner, key, Token.REMOVED_PHASE1);
            RegionEntry oldRe = null;
            RegionEntry regionEntry = newRe;
            synchronized (regionEntry) {
                try {
                    oldRe = this.putEntryIfAbsent(key, newRe);
                    while (!done && oldRe != null) {
                        RegionEntry regionEntry2 = oldRe;
                        synchronized (regionEntry2) {
                            if (oldRe.isRemovedPhase2()) {
                                owner.getCachePerfStats().incRetries();
                                this.getEntryMap().remove(key, oldRe);
                                oldRe = this.putEntryIfAbsent(key, newRe);
                            } else {
                                if (acceptedVersionTag) {
                                    Assert.assertTrue(entryVersion.getMemberID() != null, "GII entry versions must have identifiers");
                                    boolean isTombstone = newValue == Token.TOMBSTONE;
                                    this.processVersionTagForGII(oldRe, owner, entryVersion, isTombstone, sender, !wasRecovered || isSynchronizing);
                                }
                                boolean oldIsTombstone = oldRe.isTombstone();
                                boolean oldIsDestroyedOrRemoved = oldRe.isDestroyedOrRemoved();
                                int oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                if (owner.getIndexManager() != null && !oldRe.isRemoved()) {
                                    owner.getIndexManager().updateIndexes(oldRe, 3, 1);
                                }
                                if (result = oldRe.initialImagePut(owner, lastModified, newValue, wasRecovered, acceptedVersionTag)) {
                                    if (oldIsTombstone) {
                                        owner.unscheduleTombstone(oldRe);
                                    }
                                    if (newValue == Token.TOMBSTONE) {
                                        if (!oldIsDestroyedOrRemoved) {
                                            owner.updateSizeOnRemove(key, oldSize);
                                        }
                                        owner.scheduleTombstone(oldRe, entryVersion);
                                        if (!oldIsTombstone) {
                                            this.lruEntryDestroy(oldRe);
                                        }
                                    } else {
                                        int newSize = owner.calculateRegionEntryValueSize(oldRe);
                                        if (!oldIsTombstone) {
                                            owner.updateSizeOnPut(key, oldSize, newSize);
                                            this.lruEntryUpdate(oldRe);
                                        } else {
                                            owner.updateSizeOnCreate(key, newSize);
                                            this.lruEntryCreate(oldRe);
                                        }
                                        EntryLogger.logInitialImagePut(this._getOwnerObject(), key, newValue);
                                    }
                                }
                                if (owner.getIndexManager() != null) {
                                    if (oldRe.isRemoved()) {
                                        owner.getIndexManager().updateIndexes(oldRe, 3, 3);
                                    } else {
                                        owner.getIndexManager().updateIndexes(oldRe, oldIsDestroyedOrRemoved ? 1 : 2, oldIsDestroyedOrRemoved ? 0 : 2);
                                    }
                                }
                                done = true;
                            }
                        }
                    }
                    if (done) return result;
                    if (acceptedVersionTag) {
                        Assert.assertTrue(entryVersion.getMemberID() != null, "GII entry versions must have identifiers");
                        boolean isTombstone = newValue == Token.TOMBSTONE;
                        this.processVersionTagForGII(newRe, owner, entryVersion, isTombstone, sender, !wasRecovered || isSynchronizing);
                    }
                    if (result = newRe.initialImageInit(owner, lastModified, newValue, true, wasRecovered, acceptedVersionTag)) {
                        if (newValue == Token.TOMBSTONE) {
                            owner.scheduleTombstone(newRe, entryVersion);
                        } else {
                            owner.updateSizeOnCreate(key, owner.calculateRegionEntryValueSize(newRe));
                            EntryLogger.logInitialImagePut(this._getOwnerObject(), key, newValue);
                            this.lruEntryCreate(newRe);
                        }
                        this.incEntryCount(1);
                    }
                    if (owner.getIndexManager() != null && !newRe.isRemoved()) {
                        owner.getIndexManager().updateIndexes(newRe, 1, 0);
                    }
                    done = true;
                }
                catch (ConcurrentCacheModificationException e) {
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 12, 15] lbl81 : MonitorExitStatement: MONITOREXIT : var17_18
                    if (deferLRUCallback) return bl2;
                    if (done) {
                        this.lruUpdateCallback();
                        return bl2;
                    }
                    if (cleared) return bl2;
                    this.resetThreadLocals();
                    return bl2;
                }
                finally {
                    if (done && result && owner instanceof BucketRegionQueue) {
                        BucketRegionQueue brq = (BucketRegionQueue)owner;
                        brq.addToEventQueue(key, done, null);
                    }
                    if (!done) {
                        this.removeEntry(key, newRe, false);
                        if (owner.getIndexManager() != null && !newRe.isRemoved()) {
                            try {
                                owner.getIndexManager().updateIndexes(newRe, 3, 4);
                            }
                            catch (QueryException qe) {
                                logger.info("Unable to clean up thread locals for indexes", (Throwable)qe);
                            }
                        }
                    }
                }
                return result;
            }
        }
        catch (RegionClearedException rce) {
            done = false;
            cleared = true;
            return result;
        }
        catch (QueryException qe) {
            done = false;
            cleared = true;
            return result;
        }
        finally {
            if (!deferLRUCallback) {
                if (done) {
                    this.lruUpdateCallback();
                } else if (!cleared) {
                    this.resetThreadLocals();
                }
            }
        }
    }

    @Override
    public boolean confirmEvictionDestroy(RegionEntry regionEntry) {
        Assert.assertTrue(false, "Not an LRU region, can not confirm LRU eviction operation");
        return true;
    }

    @Override
    public boolean destroy(EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean cacheWrite, boolean isEviction, Object expectedOldValue, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        RegionMapDestroy regionMapDestroy = new RegionMapDestroy((InternalRegion)this.owner, this, this);
        return regionMapDestroy.destroy(event, inTokenMode, duringRI, cacheWrite, isEviction, expectedOldValue, removeRecoveredEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void txApplyDestroy(Object key, TransactionId txId, TXRmtEvent txEvent, boolean inTokenMode, boolean inRI, Operation op, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, boolean isOriginRemote, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        block89: {
            assert (pendingCallbacks != null);
            boolean isDebugEnabled = logger.isDebugEnabled();
            LocalRegion owner = this._getOwner();
            boolean isRegionReady = !inTokenMode;
            inTokenMode = this.isInTokenModeNeeded(owner, inTokenMode);
            boolean hasRemoteOrigin = !txId.getMemberId().equals(owner.getMyId());
            boolean callbackEventAddedToPending = false;
            IndexManager oqlIndexManager = owner.getIndexManager();
            boolean locked = owner.lockWhenRegionIsInitializing();
            try {
                RegionEntry re = this.getEntry(key);
                if (re != null) {
                    if (oqlIndexManager != null) {
                        oqlIndexManager.waitForIndexInit();
                    }
                    try {
                        RegionEntry regionEntry = re;
                        synchronized (regionEntry) {
                            if (!re.isRemoved() || re.isTombstone()) {
                                Object oldValue = re.getValueInVM(owner);
                                int oldSize = owner.calculateRegionEntryValueSize(re);
                                boolean wasDestroyedOrRemoved = re.isDestroyedOrRemoved();
                                EntryEventImpl callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                try {
                                    if (owner.isUsedForPartitionedRegionBucket()) {
                                        this.txHandleWANEvent(owner, callbackEvent, txEntryState);
                                    }
                                    callbackEvent.setRegionEntry(re);
                                    callbackEvent.setOldValue(oldValue);
                                    if (isDebugEnabled) {
                                        logger.debug("txApplyDestroy callbackEvent={}", (Object)callbackEvent);
                                    }
                                    this.txRemoveOldIndexEntry(Operation.DESTROY, re);
                                    if (txEvent != null) {
                                        txEvent.addDestroy(owner, re, re.getKey(), aCallbackArgument);
                                    }
                                    boolean clearOccured = false;
                                    try {
                                        this.processAndGenerateTXVersionTag(callbackEvent, re, txEntryState);
                                        if (inTokenMode) {
                                            if (oldValue == Token.TOMBSTONE) {
                                                owner.unscheduleTombstone(re);
                                            }
                                            re.setValue(owner, Token.DESTROYED);
                                        } else if (!re.isTombstone()) {
                                            if (owner.getConcurrencyChecksEnabled() && callbackEvent.getVersionTag() != null) {
                                                re.makeTombstone(owner, callbackEvent.getVersionTag());
                                            } else {
                                                re.removePhase1(owner, false);
                                                re.removePhase2();
                                                this.removeEntry(key, re, false);
                                            }
                                        } else {
                                            owner.rescheduleTombstone(re, re.getVersionStamp().asVersionTag());
                                        }
                                        EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                        if (!wasDestroyedOrRemoved) {
                                            owner.updateSizeOnRemove(key, oldSize);
                                        }
                                    }
                                    catch (RegionClearedException rce) {
                                        clearOccured = true;
                                    }
                                    owner.txApplyDestroyPart2(re, re.getKey(), inTokenMode, clearOccured, wasDestroyedOrRemoved);
                                    boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, isRegionReady || inRI);
                                    if (invokeCallbacks) {
                                        AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                        pendingCallbacks.add(callbackEvent);
                                        callbackEventAddedToPending = true;
                                    }
                                    if (!clearOccured) {
                                        this.lruEntryDestroy(re);
                                    }
                                    if (owner.getConcurrencyChecksEnabled() && txEntryState != null) {
                                        txEntryState.setVersionTag(callbackEvent.getVersionTag());
                                    }
                                }
                                finally {
                                    if (!callbackEventAddedToPending) {
                                        this.releaseEvent(callbackEvent);
                                    }
                                }
                            }
                            break block89;
                        }
                    }
                    finally {
                        if (oqlIndexManager != null) {
                            oqlIndexManager.countDownIndexUpdaters();
                        }
                    }
                }
                if (!isRegionReady || owner.getConcurrencyChecksEnabled()) {
                    boolean opCompleted = false;
                    RegionEntry newRe = this.getEntryFactory().createEntry(owner, key, Token.REMOVED_PHASE1);
                    if (oqlIndexManager != null) {
                        oqlIndexManager.waitForIndexInit();
                    }
                    EntryEventImpl callbackEvent = null;
                    try {
                        RegionEntry regionEntry = newRe;
                        synchronized (regionEntry) {
                            RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
                            while (!opCompleted && oldRe != null) {
                                RegionEntry clearOccured = oldRe;
                                synchronized (clearOccured) {
                                    if (oldRe.isRemovedPhase2()) {
                                        owner.getCachePerfStats().incRetries();
                                        this.getEntryMap().remove(key, oldRe);
                                        oldRe = this.putEntryIfAbsent(key, newRe);
                                    } else {
                                        try {
                                            boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, isRegionReady || inRI);
                                            callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                            try {
                                                callbackEvent.setRegionEntry(oldRe);
                                                callbackEvent.setOldValue(Token.NOT_AVAILABLE);
                                                if (isDebugEnabled) {
                                                    logger.debug("txApplyDestroy token mode callbackEvent={}", (Object)callbackEvent);
                                                }
                                                if (owner.isUsedForPartitionedRegionBucket()) {
                                                    this.txHandleWANEvent(owner, callbackEvent, txEntryState);
                                                }
                                                this.processAndGenerateTXVersionTag(callbackEvent, oldRe, txEntryState);
                                                if (invokeCallbacks) {
                                                    AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                                    pendingCallbacks.add(callbackEvent);
                                                    callbackEventAddedToPending = true;
                                                }
                                                int oldSize = 0;
                                                boolean wasTombstone = oldRe.isTombstone();
                                                boolean wasDestroyedOrRemoved = oldRe.isDestroyedOrRemoved();
                                                if (!wasTombstone) {
                                                    oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                                }
                                                oldRe.setValue(owner, Token.DESTROYED);
                                                EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                                if (wasTombstone) {
                                                    owner.unscheduleTombstone(oldRe);
                                                }
                                                if (!wasDestroyedOrRemoved) {
                                                    owner.updateSizeOnRemove(oldRe.getKey(), oldSize);
                                                }
                                                owner.txApplyDestroyPart2(oldRe, oldRe.getKey(), inTokenMode, false, wasDestroyedOrRemoved);
                                                this.lruEntryDestroy(oldRe);
                                            }
                                            finally {
                                                if (!callbackEventAddedToPending) {
                                                    this.releaseEvent(callbackEvent);
                                                }
                                            }
                                        }
                                        catch (RegionClearedException rce) {
                                            owner.txApplyDestroyPart2(oldRe, oldRe.getKey(), inTokenMode, true, true);
                                        }
                                        if (owner.getConcurrencyChecksEnabled() && callbackEvent.getVersionTag() != null) {
                                            oldRe.makeTombstone(owner, callbackEvent.getVersionTag());
                                        } else if (!inTokenMode) {
                                            oldRe.removePhase1(owner, false);
                                            oldRe.removePhase2();
                                            this.removeEntry(key, oldRe, false);
                                        }
                                        opCompleted = true;
                                    }
                                }
                            }
                            if (!opCompleted) {
                                opCompleted = true;
                                boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, isRegionReady || inRI);
                                callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                try {
                                    callbackEvent.setRegionEntry(newRe);
                                    callbackEvent.setOldValue(Token.NOT_AVAILABLE);
                                    if (isDebugEnabled) {
                                        logger.debug("txApplyDestroy token mode callbackEvent={}", (Object)callbackEvent);
                                    }
                                    if (owner.isUsedForPartitionedRegionBucket()) {
                                        this.txHandleWANEvent(owner, callbackEvent, txEntryState);
                                    }
                                    this.processAndGenerateTXVersionTag(callbackEvent, newRe, txEntryState);
                                    if (invokeCallbacks) {
                                        AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                        pendingCallbacks.add(callbackEvent);
                                        callbackEventAddedToPending = true;
                                    }
                                    EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                    if (owner.getConcurrencyChecksEnabled() && callbackEvent.getVersionTag() != null) {
                                        newRe.makeTombstone(owner, callbackEvent.getVersionTag());
                                    } else if (!inTokenMode) {
                                        newRe.removePhase1(owner, false);
                                        newRe.removePhase2();
                                        this.removeEntry(key, newRe, false);
                                    } else {
                                        newRe.setValue(owner, Token.DESTROYED);
                                    }
                                    owner.txApplyDestroyPart2(newRe, newRe.getKey(), inTokenMode, false, true);
                                }
                                finally {
                                    if (!callbackEventAddedToPending) {
                                        this.releaseEvent(callbackEvent);
                                    }
                                }
                            }
                            if (owner.getConcurrencyChecksEnabled() && txEntryState != null) {
                                txEntryState.setVersionTag(callbackEvent.getVersionTag());
                            }
                        }
                        if (oqlIndexManager != null) {
                            oqlIndexManager.countDownIndexUpdaters();
                        }
                        break block89;
                    }
                    catch (RegionClearedException regionClearedException) {
                        if (oqlIndexManager != null) {
                            oqlIndexManager.countDownIndexUpdaters();
                        }
                        break block89;
                        catch (Throwable throwable) {
                            if (oqlIndexManager != null) {
                                oqlIndexManager.countDownIndexUpdaters();
                            }
                            throw throwable;
                        }
                    }
                }
                EntryEventImpl callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                try {
                    if (owner.isUsedForPartitionedRegionBucket()) {
                        this.txHandleWANEvent(owner, callbackEvent, txEntryState);
                    }
                    AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                    pendingCallbacks.add(callbackEvent);
                    callbackEventAddedToPending = true;
                }
                finally {
                    if (!callbackEventAddedToPending) {
                        this.releaseEvent(callbackEvent);
                    }
                }
            }
            catch (DiskAccessException dae) {
                owner.handleDiskAccessException(dae);
                throw dae;
            }
            finally {
                if (locked) {
                    owner.unlockWhenRegionIsInitializing();
                }
            }
        }
    }

    boolean isInTokenModeNeeded(LocalRegion owner, boolean inTokenMode) {
        return !owner.getConcurrencyChecksEnabled() && inTokenMode;
    }

    void releaseEvent(EntryEventImpl event) {
        event.release();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean invalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry, boolean forceCallbacks) throws EntryNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 78[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleAlreadyInvalidEntry(EntryEventImpl event, LocalRegion owner, RegionEntry re) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invalidate: Entry already invalid: '{}'", event.getKey());
        }
        this.processVersionTag(re, event);
        if (owner.getConcurrencyChecksEnabled() && event.hasValidVersionTag()) {
            event.invokeCallbacks(owner, true, true);
        }
    }

    private void invalidateNewEntry(EntryEventImpl event, LocalRegion owner, RegionEntry newRe) throws RegionClearedException {
        this.processVersionTag(newRe, event);
        event.putNewEntry(owner, newRe);
        owner.recordEvent(event);
        owner.updateSizeOnCreate(event.getKey(), event.getNewValueBucketSize());
    }

    protected void invalidateEntry(EntryEventImpl event, RegionEntry re, int oldSize) throws RegionClearedException {
        this.processVersionTag(re, event);
        event.putExistingEntry(this._getOwner(), re);
        EntryLogger.logInvalidate(event);
        this._getOwner().recordEvent(event);
        this._getOwner().updateSizeOnPut(event.getKey(), oldSize, event.getNewValueBucketSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        DiskRegion dr;
        LocalRegion owner = this._getOwner();
        if (owner == null) {
            Assert.assertTrue(false, "The owner for RegionMap " + String.valueOf(this) + " is null for event " + String.valueOf(event));
        }
        if ((dr = owner.getDiskRegion()) != null) {
            dr.setClearCountReference();
        }
        this.lockForCacheModification(owner, event);
        boolean locked = owner.lockWhenRegionIsInitializing();
        try {
            RegionEntry re = this.getEntry(event.getKey());
            boolean entryExisted = false;
            if (re != null) {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    try {
                        if (re.isTombstone() || !re.isRemoved() && !re.isDestroyed()) {
                            entryExisted = true;
                        }
                        this.processVersionTag(re, event);
                        owner.generateAndSetVersionTag(event, re);
                        EntryLogger.logUpdateEntryVersion(event);
                        this._getOwner().recordEvent(event);
                    }
                    catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                        // empty catch block
                    }
                }
            }
            if (!entryExisted) {
                owner.checkEntryNotFound(event.getKey());
            }
        }
        catch (DiskAccessException dae) {
            this._getOwner().handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            if (locked) {
                owner.unlockWhenRegionIsInitializing();
            }
            this.releaseCacheModificationLock(owner, event);
            if (dr != null) {
                dr.removeClearCountReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void txApplyInvalidate(Object key, Object newValue, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, boolean localOp, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        assert (pendingCallbacks != null);
        LocalRegion owner = this._getOwner();
        EntryEventImpl callbackEvent = null;
        boolean forceNewEntry = !owner.isInitialized() && owner.isAllEvents();
        boolean hasRemoteOrigin = !((TXId)txId).getMemberId().equals(owner.getMyId());
        DiskRegion dr = owner.getDiskRegion();
        IndexManager oqlIndexManager = owner.getIndexManager();
        if (oqlIndexManager != null) {
            oqlIndexManager.waitForIndexInit();
        }
        boolean locked = owner.lockWhenRegionIsInitializing();
        try {
            if (forceNewEntry) {
                RegionEntry newRe;
                boolean opCompleted = false;
                RegionEntry regionEntry = newRe = this.getEntryFactory().createEntry(owner, key, Token.REMOVED_PHASE1);
                synchronized (regionEntry) {
                    try {
                        RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
                        while (!opCompleted && oldRe != null) {
                            RegionEntry regionEntry2 = oldRe;
                            synchronized (regionEntry2) {
                                if (oldRe.isRemovedPhase2()) {
                                    owner.getCachePerfStats().incRetries();
                                    this.getEntryMap().remove(key, oldRe);
                                    oldRe = this.putEntryIfAbsent(key, newRe);
                                } else {
                                    opCompleted = true;
                                    boolean oldWasTombstone = oldRe.isTombstone();
                                    int oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                    Object oldValue = oldRe.getValueInVM(owner);
                                    boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, owner.isInitialized());
                                    boolean callbackEventInPending = false;
                                    callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                    try {
                                        callbackEvent.setRegionEntry(oldRe);
                                        callbackEvent.setOldValue(oldValue);
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("txApplyInvalidate callbackEvent={}", (Object)callbackEvent);
                                        }
                                        this.txRemoveOldIndexEntry(Operation.INVALIDATE, oldRe);
                                        if (didDestroy) {
                                            oldRe.txDidDestroy(owner.cacheTimeMillis());
                                        }
                                        if (txEvent != null) {
                                            txEvent.addInvalidate(owner, oldRe, oldRe.getKey(), newValue, aCallbackArgument);
                                        }
                                        oldRe.setValueResultOfSearch(false);
                                        this.processAndGenerateTXVersionTag(callbackEvent, oldRe, txEntryState);
                                        boolean clearOccured = false;
                                        try {
                                            oldRe.setValue(owner, oldRe.prepareValueForCache(owner, newValue, true));
                                            EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                            owner.updateSizeOnPut(key, oldSize, 0);
                                            if (oldWasTombstone) {
                                                owner.unscheduleTombstone(oldRe);
                                            }
                                        }
                                        catch (RegionClearedException rce) {
                                            clearOccured = true;
                                        }
                                        owner.txApplyInvalidatePart2(oldRe, oldRe.getKey(), didDestroy, true);
                                        if (invokeCallbacks) {
                                            AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                            pendingCallbacks.add(callbackEvent);
                                            callbackEventInPending = true;
                                        }
                                        if (!clearOccured) {
                                            this.lruEntryUpdate(oldRe);
                                        }
                                        if (this.shouldPerformConcurrencyChecks(owner, callbackEvent) && txEntryState != null) {
                                            txEntryState.setVersionTag(callbackEvent.getVersionTag());
                                        }
                                    }
                                    finally {
                                        if (!callbackEventInPending) {
                                            this.releaseEvent(callbackEvent);
                                        }
                                    }
                                }
                            }
                        }
                        if (opCompleted) return;
                        boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, owner.isInitialized());
                        boolean callbackEventInPending = false;
                        callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                        try {
                            callbackEvent.setRegionEntry(newRe);
                            this.txRemoveOldIndexEntry(Operation.INVALIDATE, newRe);
                            newRe.setValueResultOfSearch(false);
                            boolean clearOccured = false;
                            try {
                                this.processAndGenerateTXVersionTag(callbackEvent, newRe, txEntryState);
                                newRe.setValue(owner, newRe.prepareValueForCache(owner, newValue, true));
                                EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                owner.updateSizeOnCreate(newRe.getKey(), 0);
                            }
                            catch (RegionClearedException rce) {
                                clearOccured = true;
                            }
                            owner.txApplyInvalidatePart2(newRe, newRe.getKey(), didDestroy, true);
                            if (invokeCallbacks) {
                                AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                pendingCallbacks.add(callbackEvent);
                                callbackEventInPending = true;
                            }
                            opCompleted = true;
                            if (!clearOccured) {
                                this.lruEntryCreate(newRe);
                                this.incEntryCount(1);
                            }
                            if (!this.shouldPerformConcurrencyChecks(owner, callbackEvent)) return;
                            if (txEntryState == null) return;
                            txEntryState.setVersionTag(callbackEvent.getVersionTag());
                        }
                        finally {
                            if (!callbackEventInPending) {
                                this.releaseEvent(callbackEvent);
                            }
                        }
                    }
                    finally {
                        if (!opCompleted) {
                            this.removeEntry(key, newRe, false);
                        }
                    }
                    return;
                }
            }
            RegionEntry re = this.getEntry(key);
            if (re != null) {
                RegionEntry newRe = re;
                synchronized (newRe) {
                    if (!Token.isRemoved(re.getValueAsToken())) {
                        int oldSize = owner.calculateRegionEntryValueSize(re);
                        Object oldValue = re.getValueInVM(owner);
                        boolean invokeCallbacks = AbstractRegionMap.shouldInvokeCallbacks(owner, owner.isInitialized());
                        boolean callbackEventInPending = false;
                        callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                        try {
                            callbackEvent.setRegionEntry(re);
                            callbackEvent.setOldValue(oldValue);
                            this.txRemoveOldIndexEntry(Operation.INVALIDATE, re);
                            if (didDestroy) {
                                re.txDidDestroy(owner.cacheTimeMillis());
                            }
                            if (txEvent != null) {
                                txEvent.addInvalidate(owner, re, re.getKey(), newValue, aCallbackArgument);
                            }
                            re.setValueResultOfSearch(false);
                            this.processAndGenerateTXVersionTag(callbackEvent, re, txEntryState);
                            boolean clearOccured = false;
                            try {
                                re.setValue(owner, re.prepareValueForCache(owner, newValue, true));
                                EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                owner.updateSizeOnPut(key, oldSize, 0);
                            }
                            catch (RegionClearedException rce) {
                                clearOccured = true;
                            }
                            owner.txApplyInvalidatePart2(re, re.getKey(), didDestroy, true);
                            if (invokeCallbacks) {
                                AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                                pendingCallbacks.add(callbackEvent);
                                callbackEventInPending = true;
                            }
                            if (!clearOccured) {
                                this.lruEntryUpdate(re);
                            }
                            if (!this.shouldPerformConcurrencyChecks(owner, callbackEvent)) return;
                            if (txEntryState == null) return;
                            txEntryState.setVersionTag(callbackEvent.getVersionTag());
                        }
                        finally {
                            if (!callbackEventInPending) {
                                this.releaseEvent(callbackEvent);
                            }
                        }
                        return;
                    }
                }
            }
            boolean callbackEventInPending = false;
            callbackEvent = this.txCallbackEventFactory.createCallbackEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
            try {
                AbstractRegionMap.switchEventOwnerAndOriginRemote(callbackEvent, hasRemoteOrigin);
                pendingCallbacks.add(callbackEvent);
                callbackEventInPending = true;
                return;
            }
            finally {
                if (!callbackEventInPending) {
                    this.releaseEvent(callbackEvent);
                }
            }
        }
        catch (DiskAccessException dae) {
            owner.handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            if (locked) {
                owner.unlockWhenRegionIsInitializing();
            }
            if (oqlIndexManager != null) {
                oqlIndexManager.countDownIndexUpdaters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictValue(Object key) {
        LocalRegion owner = this._getOwner();
        RegionEntry re = this.getEntry(key);
        if (re != null) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                if (!re.isValueNull()) {
                    re.setValueToNull();
                    owner.getDiskRegion().incNumEntriesInVM(-1L);
                    owner.getDiskRegion().incNumOverflowOnDisk(1L);
                    if (owner instanceof BucketRegion) {
                        ((BucketRegion)owner).incNumEntriesInVM(-1L);
                        ((BucketRegion)owner).incNumOverflowOnDisk(1L);
                    }
                }
            }
        }
    }

    @Override
    public RegionEntry basicPut(EntryEventImpl event, long unused, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean overwriteDestroyed) throws CacheWriterException, TimeoutException {
        RegionMapPut regionMapPut = new RegionMapPut(this, this._getOwner(), this, this.entryEventSerialization, event, ifNew, ifOld, overwriteDestroyed, requireOldValue, expectedOldValue);
        return regionMapPut.put();
    }

    @Override
    public void runWhileEvictionDisabled(Runnable r) {
        boolean disabled = this.disableLruUpdateCallback();
        try {
            r.run();
        }
        finally {
            if (disabled) {
                this.enableLruUpdateCallback();
            }
        }
    }

    @Override
    public void txApplyPut(Operation putOp, Object key, Object nv, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        assert (pendingCallbacks != null);
        LocalRegion owner = this._getOwner();
        EntryEventImpl callbackEvent = this.createTransactionCallbackEvent(owner, putOp, key, nv, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
        if (owner.isUsedForPartitionedRegionBucket()) {
            callbackEvent.makeSerializedNewValue();
            this.txHandleWANEvent(owner, callbackEvent, txEntryState);
        }
        RegionMapCommitPut commitPut = new RegionMapCommitPut(this, owner, callbackEvent, putOp, didDestroy, txId, txEvent, pendingCallbacks, txEntryState);
        commitPut.put();
    }

    private void txHandleWANEvent(LocalRegion owner, EntryEventImpl callbackEvent, TXEntryState txEntryState) {
        owner.txHandleWANEvent(callbackEvent);
        if (txEntryState != null && callbackEvent.getTailKey() != -1L) {
            txEntryState.setTailKey(callbackEvent.getTailKey());
        }
    }

    @Override
    public void processAndGenerateTXVersionTag(EntryEventImpl callbackEvent, RegionEntry re, TXEntryState txEntryState) {
        LocalRegion owner = this._getOwner();
        if (this.shouldPerformConcurrencyChecks(owner, callbackEvent)) {
            try {
                if (txEntryState != null && txEntryState.getRemoteVersionTag() != null) {
                    VersionTag remoteTag = txEntryState.getRemoteVersionTag();
                    if (re instanceof VersionStamp) {
                        VersionStamp stamp = (VersionStamp)((Object)re);
                        stamp.setVersions(remoteTag);
                    }
                }
                this.processVersionTag(re, callbackEvent);
            }
            catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                // empty catch block
            }
            if (txEntryState != null && txEntryState.getDistTxEntryStates() != null) {
                callbackEvent.setNextRegionVersion(txEntryState.getDistTxEntryStates().getRegionVersion());
            }
            owner.generateAndSetVersionTag(callbackEvent, re);
        }
    }

    private boolean shouldPerformConcurrencyChecks(LocalRegion owner, EntryEventImpl callbackEvent) {
        return owner.getConcurrencyChecksEnabled() && callbackEvent != null;
    }

    @Override
    public void txRemoveOldIndexEntry(Operation op, RegionEntry entry) {
        IndexManager idxManager;
        if ((op.isUpdate() && !entry.isInvalid() || op.isInvalidate() || op.isDestroy()) && (idxManager = this._getOwner().getIndexManager()) != null) {
            try {
                idxManager.updateIndexes(entry, 3, op.isUpdate() ? 1 : 0);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
    }

    public void dumpMap() {
        logger.info("dump of concurrent map of size {} for region {}", (Object)this.getEntryMap().size(), (Object)this._getOwner());
        for (Object o : this.getEntryMap().values()) {
            logger.info("dumpMap:" + o.toString());
        }
    }

    EntryEventImpl createTransactionCallbackEvent(LocalRegion re, Operation op, Object key, Object newValue, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        return this.txCallbackEventFactory.createCallbackEvent(re, op, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSyncIfPresent(Object key, Runnable runner) {
        RegionEntry re = this.getEntry(key);
        if (re != null) {
            boolean disabled = this.disableLruUpdateCallback();
            try {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    if (!re.isRemoved()) {
                        runner.run();
                    }
                }
            }
            finally {
                if (disabled) {
                    this.enableLruUpdateCallback();
                }
                try {
                    this.lruUpdateCallback();
                }
                catch (DiskAccessException dae) {
                    this._getOwner().handleDiskAccessException(dae);
                    throw dae;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIfDestroyed(Object key) {
        LocalRegion owner = this._getOwner();
        DiskRegion dr = owner.getDiskRegion();
        RegionEntry re = this.getEntry(key);
        if (re != null && re.isDestroyed()) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                if (re.isDestroyed()) {
                    re.removePhase2();
                    this.removeEntry(key, re, true);
                }
            }
        }
    }

    @Override
    public void lockForCacheModification(InternalRegion owner, EntryEventImpl event) {
        RegionVersionVector vector;
        boolean lockedByBulkOp;
        boolean bl = lockedByBulkOp = event.isBulkOpInProgress() && owner.getDataPolicy().withReplication();
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeLock(owner, event);
        }
        if (!(event.isOriginRemote() || lockedByBulkOp || owner.hasServerProxy() || (vector = owner.getVersionVector()) == null)) {
            vector.lockForCacheModification();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterLock(owner, event);
        }
    }

    @Override
    public void releaseCacheModificationLock(InternalRegion owner, EntryEventImpl event) {
        RegionVersionVector vector;
        boolean lockedByBulkOp;
        boolean bl = lockedByBulkOp = event.isBulkOpInProgress() && owner.getDataPolicy().withReplication();
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeRelease(owner, event);
        }
        if (!(event.isOriginRemote() || lockedByBulkOp || owner.hasServerProxy() || (vector = owner.getVersionVector()) == null)) {
            vector.releaseCacheModificationLock();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterRelease(owner, event);
        }
    }

    @Override
    public void lockRegionForAtomicTX(InternalRegion r) {
        RegionVersionVector vector;
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeLock(r, null);
        }
        if ((vector = r.getVersionVector()) != null) {
            vector.lockForCacheModification();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterLock(r, null);
        }
    }

    @Override
    public void unlockRegionForAtomicTX(InternalRegion r) {
        RegionVersionVector vector;
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeRelease(r, null);
        }
        if ((vector = r.getVersionVector()) != null) {
            vector.releaseCacheModificationLock();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterRelease(r, null);
        }
    }

    protected RegionEntry putEntryIfAbsentForTest(RegionEntry entry) {
        return this.putEntryIfAbsent(entry.getKey(), entry);
    }

    @Override
    public boolean isTombstoneNotNeeded(RegionEntry re, int destroyedVersion) {
        if (this.getEntry(re.getKey()) != re) {
            return true;
        }
        if (!re.isTombstone()) {
            return true;
        }
        VersionStamp vs = re.getVersionStamp();
        if (vs == null) {
            logger.error("Unexpected RegionEntry scheduled as tombstone: re.getClass {} destroyedVersion {}", re.getClass(), (Object)destroyedVersion);
            return true;
        }
        return vs.getEntryVersion() != destroyedVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTombstone(RegionEntry re, VersionHolder version) {
        boolean result = false;
        int destroyedVersion = version.getEntryVersion();
        Object object = this._getOwner().getSizeGuard();
        synchronized (object) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                int entryVersion = re.getVersionStamp().getEntryVersion();
                if (!re.isTombstone() || entryVersion > destroyedVersion) {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT_VERBOSE)) {
                        logger.trace(LogMarker.TOMBSTONE_COUNT_VERBOSE, "tombstone for {} was resurrected with v{}; destroyed version was v{}; count is {}; entryMap size is {}", re.getKey(), (Object)re.getVersionStamp().getEntryVersion(), (Object)destroyedVersion, (Object)this._getOwner().getTombstoneCount(), (Object)this.size());
                    }
                } else {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT_VERBOSE)) {
                        if (entryVersion == destroyedVersion) {
                            logger.trace(LogMarker.TOMBSTONE_COUNT_VERBOSE, "removing tombstone for {} with v{} rv{}; count is {}", re.getKey(), (Object)destroyedVersion, (Object)version.getRegionVersion(), (Object)(this._getOwner().getTombstoneCount() - 1));
                        } else {
                            logger.trace(LogMarker.TOMBSTONE_COUNT_VERBOSE, "removing entry (v{}) that is older than an expiring tombstone (v{} rv{}) for {}", (Object)entryVersion, (Object)destroyedVersion, (Object)version.getRegionVersion(), re.getKey());
                        }
                    }
                    try {
                        re.setValue(this._getOwner(), Token.REMOVED_PHASE2);
                        if (this.getEntryMap().remove(re.getKey(), re)) {
                            this._getOwner().cancelExpiryTask(re);
                            result = true;
                            this.incEntryCount(-1);
                            this._getOwner().incTombstoneCount(-1);
                            RegionVersionVector vector = this._getOwner().getVersionVector();
                            if (vector != null) {
                                vector.recordGCVersion(version.getMemberID(), version.getRegionVersion());
                            }
                        }
                    }
                    catch (RegionClearedException regionClearedException) {
                    }
                    catch (RegionDestroyedException regionDestroyedException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    public boolean verifyTombstoneCount(AtomicInteger numTombstones) {
        int deadEntries = 0;
        try {
            for (Object o : this.getEntryMap().values()) {
                RegionEntry re = (RegionEntry)o;
                if (!re.isTombstone()) continue;
                ++deadEntries;
            }
            if (deadEntries != numTombstones.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("tombstone count ({}) does not match actual number of tombstones ({})", (Object)numTombstones, (Object)deadEntries, (Object)new Exception());
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tombstone count verified");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int getEntryOverhead() {
        return (int)ReflectionSingleObjectSizer.sizeof(this.getEntryFactory().getEntryClass());
    }

    @Override
    public RegionMap.ARMLockTestHook getARMLockTestHook() {
        return this.armLockTestHook;
    }

    public void setARMLockTestHook(RegionMap.ARMLockTestHook theHook) {
        this.armLockTestHook = theHook;
    }
}

