/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class VersionInfoResponse
extends AdminResponse {
    private String verInfo;

    public static VersionInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        VersionInfoResponse m = new VersionInfoResponse();
        m.setRecipient(recipient);
        m.verInfo = GemFireVersion.asString();
        return m;
    }

    public String getVersionInfo() {
        return this.verInfo;
    }

    public int getDSFID() {
        return 1064;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.verInfo, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.verInfo = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "VersionInfoResponse from " + String.valueOf(this.getSender());
    }
}

