/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatAlertsManager;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class StatAlertsManagerAssignMessage
extends PooledDistributionMessage {
    private StatAlertDefinition[] alertDefs;
    private long refreshInterval;

    public StatAlertsManagerAssignMessage() {
        this.alertDefs = null;
        this.refreshInterval = -1L;
    }

    public StatAlertsManagerAssignMessage(StatAlertDefinition[] alertDefs, long refreshInterval) {
        this.alertDefs = alertDefs;
        this.refreshInterval = refreshInterval;
    }

    public static StatAlertsManagerAssignMessage create(StatAlertDefinition[] alertDefs, long refreshInterval) {
        return new StatAlertsManagerAssignMessage(alertDefs, refreshInterval);
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        this.setManager(dm);
    }

    private void setManager(ClusterDistributionManager dm) {
        StatAlertsManager manager = StatAlertsManager.getInstance(dm);
        manager.updateAlertDefinition(this.alertDefs, 1);
        manager.setRefreshTimeInterval(this.refreshInterval);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeLong(this.refreshInterval);
        DataSerializer.writeObjectArray(this.alertDefs, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.refreshInterval = in.readLong();
        this.alertDefs = (StatAlertDefinition[])DataSerializer.readObjectArray(in);
    }

    public int getDSFID() {
        return 1065;
    }

    @Override
    public String toString() {
        return "StatAlertsManagerAssignRequest from " + String.valueOf(this.getSender());
    }
}

