/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.RuntimeDistributionConfigImpl;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class FetchSysCfgResponse
extends AdminResponse {
    Config sc;

    public static FetchSysCfgResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        FetchSysCfgResponse m = new FetchSysCfgResponse();
        m.setRecipient(recipient);
        DistributionConfig conf = dm.getSystem().getConfig();
        if (conf instanceof RuntimeDistributionConfigImpl) {
            m.sc = ((RuntimeDistributionConfigImpl)conf).takeSnapshot();
        }
        return m;
    }

    public Config getConfig() {
        return this.sc;
    }

    public int getDSFID() {
        return 1032;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.sc, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.sc = (Config)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "FetchSysCfgResponse from " + String.valueOf(this.getRecipient()) + " cfg=" + String.valueOf(this.sc);
    }
}

