/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.DurableClientInfoRequest;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class DurableClientInfoResponse
extends AdminResponse {
    private boolean returnVal = false;

    public static DurableClientInfoResponse create(DistributionManager dm, InternalDistributedMember recipient, DurableClientInfoRequest request) {
        DurableClientInfoResponse m = new DurableClientInfoResponse();
        m.setRecipient(recipient);
        try {
            InternalCache c = (InternalCache)CacheFactory.getInstanceCloseOk(dm.getSystem());
            if (!c.getCacheServers().isEmpty()) {
                CacheServerImpl server = (CacheServerImpl)c.getCacheServers().iterator().next();
                switch (request.action) {
                    case 10: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasDurableClient(request.durableId);
                        break;
                    }
                    case 11: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasPrimaryForDurableClient(request.durableId);
                    }
                }
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        return m;
    }

    boolean getResultBoolean() {
        return this.returnVal;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.returnVal);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.returnVal = in.readBoolean();
    }

    @Override
    public String toString() {
        return "DurableClientInfoResponse from " + String.valueOf(this.getSender());
    }

    public int getDSFID() {
        return -23;
    }
}

