/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AlertLevelChangeMessage
extends SerialDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private int newLevel;

    public static AlertLevelChangeMessage create(int newLevel) {
        AlertLevelChangeMessage alertLevelChangeMessage = new AlertLevelChangeMessage();
        alertLevelChangeMessage.newLevel = newLevel;
        return alertLevelChangeMessage;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        dm.getAlertingService().removeAlertListener(this.getSender());
        if (this.newLevel != AlertLevel.NONE.intLevel()) {
            dm.getAlertingService().addAlertListener(this.getSender(), AlertLevel.find(this.newLevel));
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "Added new AlertListener");
            }
        }
    }

    public int getDSFID() {
        return 1007;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.newLevel);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.newLevel = in.readInt();
    }

    @Override
    public String toString() {
        return String.format("Changing alert level to %s", new Object[]{AlertLevel.find(this.newLevel)});
    }
}

