/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AdminConsoleDisconnectMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private boolean alertListenerExpected;
    private transient boolean ignoreAlertListenerRemovalFailure;
    private boolean crashed;
    private String reason;

    public static AdminConsoleDisconnectMessage create() {
        AdminConsoleDisconnectMessage m = new AdminConsoleDisconnectMessage();
        return m;
    }

    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }

    public void setAlertListenerExpected(boolean alertListenerExpected) {
        this.alertListenerExpected = alertListenerExpected;
    }

    public void setIgnoreAlertListenerRemovalFailure(boolean ignore) {
        this.ignoreAlertListenerRemovalFailure = ignore;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        GemFireStatSampler sampler;
        InternalDistributedSystem sys = dm.getSystem();
        if (this.alertListenerExpected && !dm.getAlertingService().removeAlertListener(this.getSender()) && !this.ignoreAlertListenerRemovalFailure) {
            logger.warn("Unable to remove console with id {} from alert listeners.", (Object)this.getSender());
        }
        if ((sampler = sys.getStatSampler()) != null) {
            sampler.removeListenersByRecipient(this.getSender());
        }
        dm.handleConsoleShutdown(this.getSender(), this.crashed, String.format("Reason for automatic admin disconnect : %s", this.reason));
    }

    public int getDSFID() {
        return 1004;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.alertListenerExpected);
        out.writeBoolean(this.crashed);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.alertListenerExpected = in.readBoolean();
        this.crashed = in.readBoolean();
        this.reason = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "AdminConsoleDisconnectMessage from " + String.valueOf(this.getSender());
    }
}

