/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.statistics.GemFireStatSampler;

public class AddStatListenerResponse
extends AdminResponse {
    int listenerId;

    public static AddStatListenerResponse create(DistributionManager dm, InternalDistributedMember recipient, long resourceId, String statName) {
        AddStatListenerResponse m = new AddStatListenerResponse();
        m.setRecipient(recipient);
        GemFireStatSampler sampler = null;
        sampler = dm.getSystem().getStatSampler();
        if (sampler != null) {
            m.listenerId = sampler.addListener(recipient, resourceId, statName);
        }
        return m;
    }

    public int getListenerId() {
        return this.listenerId;
    }

    public int getDSFID() {
        return 1003;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return "AddStatListenerResponse from " + String.valueOf(this.getRecipient()) + " listenerId=" + this.listenerId;
    }
}

