/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ClientMembershipMessage
extends PooledDistributionMessage {
    public static final int JOINED = 0;
    public static final int LEFT = 1;
    public static final int CRASHED = 2;
    private String clientId;
    private String clientHost;
    private int eventType;

    public ClientMembershipMessage() {
    }

    public ClientMembershipMessage(String clientId, String clientHost, int eventType) {
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.eventType = eventType;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        AdminDistributedSystemImpl adminDs = AdminDistributedSystemImpl.getConnectedInstance();
        if (adminDs != null) {
            String senderId = null;
            InternalDistributedMember msgSender = this.getSender();
            if (msgSender != null) {
                senderId = msgSender.getId();
            }
            adminDs.processClientMembership(senderId, this.clientId, this.clientHost, this.eventType);
        }
    }

    public int getDSFID() {
        return 1080;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.clientId, out);
        DataSerializer.writeString(this.clientHost, out);
        out.writeInt(this.eventType);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.clientId = DataSerializer.readString(in);
        this.clientHost = DataSerializer.readString(in);
        this.eventType = in.readInt();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public int getEventType() {
        return this.eventType;
    }

    public static String getEventTypeString(int eventType) {
        switch (eventType) {
            case 0: {
                return "Member JOINED";
            }
            case 1: {
                return "Member LEFT";
            }
            case 2: {
                return "Member CRASHED";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String toString() {
        String clientMembership = "JOINED";
        switch (this.eventType) {
            case 1: {
                clientMembership = "LEFT";
                break;
            }
            case 2: {
                clientMembership = "CRASHED and left";
                break;
            }
        }
        return "Client with Id: " + this.clientId + " running on host: " + this.clientHost + " " + clientMembership + " the server: " + String.valueOf(this.getSender());
    }
}

