/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataStream;

public class VersionedObjectOutput
implements ObjectOutput,
VersionedDataStream {
    private final ObjectOutput out;
    private final KnownVersion version;

    public VersionedObjectOutput(ObjectOutput out, KnownVersion version) {
        if (version.isNewerThan((Version)KnownVersion.CURRENT)) {
            Assert.fail("unexpected version: " + String.valueOf(version) + ", CURRENT: " + String.valueOf(KnownVersion.CURRENT));
        }
        this.out = out;
        this.version = version;
    }

    public KnownVersion getVersion() {
        return this.version;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.out.writeObject(obj);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

