/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.util.internal.UncheckedUtils;

public class ScheduledThreadPoolExecutorWithKeepAlive
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private final ScheduledThreadPoolExecutor timer;
    private final ThreadsMonitoring threadsMonitoring;

    public ScheduledThreadPoolExecutorWithKeepAlive(int poolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ThreadsMonitoring threadsMonitoring) {
        super(0, poolSize - 1, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, new BlockCallerPolicy());
        this.timer = new ScheduledThreadPoolExecutor(1, threadFactory){

            @Override
            protected void terminated() {
                super.terminated();
                ScheduledThreadPoolExecutorWithKeepAlive.super.shutdown();
            }
        };
        this.threadsMonitoring = threadsMonitoring;
    }

    @Override
    public void execute(Runnable command) {
        this.timer.execute(new HandOffTask(command));
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.startMonitor(ThreadsMonitoring.Mode.ScheduledThreadExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.endMonitor();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        DelegatingScheduledFuture<V> future = new DelegatingScheduledFuture<V>(callable);
        ScheduledFuture timerFuture = (ScheduledFuture)UncheckedUtils.uncheckedCast(this.timer.schedule(new HandOffTask(future), delay, unit));
        future.setDelegate(timerFuture);
        return future;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedule(command, delay, unit, null);
    }

    private <V> ScheduledFuture<V> schedule(Runnable command, long delay, TimeUnit unit, V result) {
        DelegatingScheduledFuture<V> future = new DelegatingScheduledFuture<V>(command, result);
        ScheduledFuture timerFuture = (ScheduledFuture)UncheckedUtils.uncheckedCast(this.timer.schedule(new HandOffTask(future), delay, unit));
        future.setDelegate(timerFuture);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        DelegatingScheduledFuture<Object> future = new DelegatingScheduledFuture<Object>(command, null, true);
        ScheduledFuture<?> timerFuture = this.timer.scheduleAtFixedRate(new HandOffTask(future), initialDelay, period, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        DelegatingScheduledFuture<Object> future = new DelegatingScheduledFuture<Object>(command, null, true);
        ScheduledFuture<?> timerFuture = this.timer.scheduleWithFixedDelay(new HandOffTask(future), initialDelay, delay, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    @Override
    public void shutdown() {
        this.timer.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = this.timer.shutdownNow();
        super.shutdownNow();
        return tasks;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        if (!this.timer.awaitTermination(timeout, unit)) {
            return false;
        }
        long elapsed = System.nanoTime() - start;
        long remaining = unit.toNanos(timeout) - elapsed;
        if (remaining < 0L) {
            return false;
        }
        return super.awaitTermination(remaining, TimeUnit.NANOSECONDS);
    }

    @Override
    public int getCorePoolSize() {
        return super.getCorePoolSize() + 1;
    }

    @Override
    public int getLargestPoolSize() {
        return super.getLargestPoolSize() + 1;
    }

    @Override
    public int getMaximumPoolSize() {
        return super.getMaximumPoolSize() + 1;
    }

    @Override
    public int getPoolSize() {
        return super.getPoolSize() + 1;
    }

    @Override
    public boolean isShutdown() {
        return this.timer.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.timer.isTerminated();
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean b) {
        this.timer.setContinueExistingPeriodicTasksAfterShutdownPolicy(b);
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean b) {
        this.timer.setExecuteExistingDelayedTasksAfterShutdownPolicy(b);
    }

    @VisibleForTesting
    public ScheduledThreadPoolExecutor getDelegateExecutor() {
        return this.timer;
    }

    @VisibleForTesting
    public static class BlockCallerPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ie);
            }
        }
    }

    private class HandOffTask
    implements Runnable {
        private final Runnable task;

        private HandOffTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                ScheduledThreadPoolExecutorWithKeepAlive.super.execute(this.task);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static class DelegatingScheduledFuture<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final AtomicReference<ScheduledFuture<V>> delegate = new AtomicReference();
        private final boolean periodic;

        private DelegatingScheduledFuture(Runnable runnable, V result) {
            this(runnable, result, false);
        }

        private DelegatingScheduledFuture(Callable<V> callable) {
            this(callable, false);
        }

        private DelegatingScheduledFuture(Runnable runnable, V result, boolean periodic) {
            super(runnable, result);
            this.periodic = periodic;
        }

        private DelegatingScheduledFuture(Callable<V> callable, boolean periodic) {
            super(callable);
            this.periodic = periodic;
        }

        @Override
        public void run() {
            if (this.periodic) {
                this.runAndReset();
            } else {
                super.run();
            }
        }

        public void setDelegate(ScheduledFuture<V> future) {
            this.delegate.set(future);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.delegate.get().cancel(true);
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate.get().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate.get().compareTo(o);
        }

        public boolean equals(Object o) {
            return this.delegate.get().equals(o);
        }

        public int hashCode() {
            return this.delegate.get().hashCode();
        }
    }
}

