/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.examples.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.apache.shiro.authz.Permission;

public class ExampleSecurityManager
implements SecurityManager {
    public static final String SECURITY_JSON = "security-json";
    protected static final String DEFAULT_JSON_FILE_NAME = "security.json";
    private Map<String, User> userNameToUser;

    @Override
    public boolean authorize(Object principal, ResourcePermission context) {
        if (principal == null) {
            return false;
        }
        User user = this.userNameToUser.get(principal.toString());
        if (user == null) {
            return false;
        }
        for (Role role : this.userNameToUser.get((Object)user.name).roles) {
            if (role == null) continue;
            for (Permission permission : role.permissions) {
                if (!permission.implies((Permission)context)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void init(Properties securityProperties) throws NotAuthorizedException {
        String jsonPropertyValue;
        String string = jsonPropertyValue = securityProperties != null ? securityProperties.getProperty(SECURITY_JSON) : null;
        if (jsonPropertyValue == null) {
            jsonPropertyValue = DEFAULT_JSON_FILE_NAME;
        }
        if (!this.initializeFromJsonResource(jsonPropertyValue)) {
            throw new AuthenticationFailedException("ExampleSecurityManager: unable to find json resource \"" + jsonPropertyValue + "\" as specified by [security-json].");
        }
    }

    @Override
    public Object authenticate(Properties credentials) throws AuthenticationFailedException {
        String user = credentials.getProperty("security-username");
        String password = credentials.getProperty("security-password");
        User userObj = this.userNameToUser.get(user);
        if (userObj == null) {
            throw new AuthenticationFailedException("ExampleSecurityManager: wrong username/password");
        }
        if (user != null && !userObj.password.equals(password) && !"".equals(user)) {
            throw new AuthenticationFailedException("ExampleSecurityManager: wrong username/password");
        }
        return user;
    }

    boolean initializeFromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(json);
            this.userNameToUser = new HashMap<String, User>();
            Map<String, Role> roleMap = this.readRoles(jsonNode);
            this.readUsers(this.userNameToUser, jsonNode, roleMap);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean initializeFromJsonResource(String jsonResource) {
        try {
            InputStream input = ClassLoader.getSystemResourceAsStream(jsonResource);
            if (input != null) {
                this.initializeFromJson(this.readJsonFromInputStream(input));
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public User getUser(String user) {
        return this.userNameToUser.get(user);
    }

    private String readJsonFromInputStream(InputStream input) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    private void readUsers(Map<String, User> rolesToUsers, JsonNode node, Map<String, Role> roleMap) {
        for (JsonNode usersNode : node.get("users")) {
            User user = new User();
            user.name = usersNode.get("name").asText();
            user.password = usersNode.has("password") ? usersNode.get("password").asText() : user.name;
            for (JsonNode rolesNode : usersNode.get("roles")) {
                user.roles.add(roleMap.get(rolesNode.asText()));
            }
            rolesToUsers.put(user.name, user);
        }
    }

    private Map<String, Role> readRoles(JsonNode jsonNode) {
        if (jsonNode.get("roles") == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        for (JsonNode rolesNode : jsonNode.get("roles")) {
            Role role = new Role();
            role.name = rolesNode.get("name").asText();
            String regionNames = null;
            String keys = null;
            JsonNode regionsNode = rolesNode.get("regions");
            if (regionsNode != null) {
                regionNames = regionsNode.isArray() ? StreamSupport.stream(regionsNode.spliterator(), false).map(JsonNode::asText).collect(Collectors.joining(",")) : regionsNode.asText();
            }
            for (JsonNode operationsAllowedNode : rolesNode.get("operationsAllowed")) {
                String operationPart;
                String[] parts = operationsAllowedNode.asText().split(":");
                String resourcePart = parts.length > 0 ? parts[0] : null;
                String string = operationPart = parts.length > 1 ? parts[1] : null;
                if (parts.length > 2) {
                    regionNames = parts[2];
                }
                if (parts.length > 3) {
                    keys = parts[3];
                }
                String regionPart = regionNames != null ? regionNames : "*";
                String keyPart = keys != null ? keys : "*";
                role.permissions.add(new ResourcePermission(ResourcePermission.Resource.valueOf(resourcePart), ResourcePermission.Operation.valueOf(operationPart), regionPart, keyPart));
            }
            roleMap.put(role.name, role);
            if (!rolesNode.has("serverGroup")) continue;
            role.serverGroup = rolesNode.get("serverGroup").asText();
        }
        return roleMap;
    }

    public static class User {
        String name;
        Set<Role> roles = new HashSet<Role>();
        String password;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public void setRoles(Set<Role> roles) {
            this.roles = roles;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Role {
        List<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        String name;
        String serverGroup;

        public List<ResourcePermission> getPermissions() {
            return this.permissions;
        }

        public void setPermissions(List<ResourcePermission> permissions) {
            this.permissions = permissions;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getServerGroup() {
            return this.serverGroup;
        }

        public void setServerGroup(String serverGroup) {
            this.serverGroup = serverGroup;
        }
    }
}

