/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.RemoteThread;
import org.apache.geode.internal.Assert;

public class DistributedMemberLock
implements Lock {
    public static final long NON_EXPIRING_LEASE = -1L;
    final DLockService dls;
    final Serializable key;
    final long leaseTimeout;
    final LockReentryPolicy reentryPolicy;
    final DLockService.ThreadRequestState threadState;

    public DistributedMemberLock(DistributedLockService dls, Serializable key) {
        this(dls, key, -1L, LockReentryPolicy.ALLOW);
    }

    public DistributedMemberLock(DistributedLockService dls, Serializable key, long leaseTimeout, LockReentryPolicy reentryPolicy) {
        if (dls == null || key == null) {
            throw new NullPointerException();
        }
        this.dls = (DLockService)dls;
        this.key = key;
        this.leaseTimeout = leaseTimeout;
        this.reentryPolicy = reentryPolicy;
        RemoteThread rThread = new RemoteThread(this.getDM().getId(), this.dls.incThreadSequence());
        this.threadState = new DLockService.ThreadRequestState(rThread.getThreadId(), true);
    }

    @Override
    public synchronized void lock() {
        this.executeOperation(new Operation(){

            @Override
            public boolean operate() {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                boolean locked = DistributedMemberLock.this.dls.lock(DistributedMemberLock.this.key, -1L, DistributedMemberLock.this.leaseTimeout);
                Assert.assertTrue(locked, "Failed to lock " + String.valueOf(this));
                return locked;
            }
        });
    }

    @Override
    public synchronized void lockInterruptibly() throws InterruptedException {
        this.executeOperationInterruptibly(new Operation(){

            @Override
            public boolean operate() throws InterruptedException {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                boolean locked = DistributedMemberLock.this.dls.lockInterruptibly(DistributedMemberLock.this.key, -1L, DistributedMemberLock.this.leaseTimeout);
                Assert.assertTrue(locked, "Failed to lockInterruptibly " + String.valueOf(this));
                return locked;
            }
        });
    }

    @Override
    public synchronized boolean tryLock() {
        return this.executeOperation(() -> {
            if (this.holdsLock() && this.reentryPolicy.preventReentry(this)) {
                return true;
            }
            return this.dls.lock(this.key, 0L, this.leaseTimeout);
        });
    }

    @Override
    public synchronized boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.executeOperationInterruptibly(() -> {
            if (this.holdsLock() && this.reentryPolicy.preventReentry(this)) {
                return true;
            }
            return this.dls.lockInterruptibly(this.key, this.getLockTimeoutForLock(time, unit), this.leaseTimeout);
        });
    }

    @Override
    public synchronized void unlock() {
        this.executeOperation(() -> {
            this.dls.unlock(this.key);
            return true;
        });
    }

    public synchronized boolean holdsLock() {
        return this.executeOperation(() -> this.dls.isHeldByThreadId(this.key, this.threadState.threadId));
    }

    private boolean executeOperationInterruptibly(Operation lockOp) throws InterruptedException {
        return this.doExecuteOperation(lockOp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeOperation(Operation lockOp) {
        while (true) {
            this.dls.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                boolean bl = this.doExecuteOperation(lockOp, false);
                return bl;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecuteOperation(Operation lockOp, boolean interruptible) throws InterruptedException {
        DLockService.ThreadRequestState oldThreadState = this.dls.getThreadRequestState().get();
        try {
            this.threadState.interruptible = interruptible;
            this.dls.getThreadRequestState().set(this.threadState);
            boolean bl = lockOp.operate();
            return bl;
        }
        finally {
            this.threadState.interruptible = false;
            this.dls.getThreadRequestState().set(oldThreadState);
        }
    }

    private DistributionManager getDM() {
        return this.dls.getDistributionManager();
    }

    long getLockTimeoutForLock(long time, TimeUnit unit) {
        if (time == -1L) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public String toString() {
        String identity = super.toString();
        identity = identity.substring(identity.lastIndexOf(".") + 1);
        return "[" + identity + ": dls=" + this.dls.getName() + "key=" + String.valueOf(this.key) + "]";
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("not implemented");
    }

    public static enum LockReentryPolicy {
        ALLOW,
        THROW_ERROR,
        PREVENT_SILENTLY;


        boolean preventReentry(DistributedMemberLock lock) {
            switch (this) {
                case ALLOW: {
                    return false;
                }
                case THROW_ERROR: {
                    throw new IllegalStateException("Attempted to reenter held lock " + String.valueOf(lock));
                }
                case PREVENT_SILENTLY: {
                    return true;
                }
            }
            throw new AssertionError((Object)("Unknown LockReentryPolicy: " + String.valueOf((Object)this)));
        }

        public String toString() {
            String myToString = "Unknown";
            switch (this) {
                case ALLOW: {
                    myToString = "ALLOW";
                    break;
                }
                case THROW_ERROR: {
                    myToString = "THROW_ERROR";
                    break;
                }
                case PREVENT_SILENTLY: {
                    myToString = "PREVENT_SILENTLY";
                    break;
                }
            }
            return myToString;
        }
    }

    private static interface Operation {
        public boolean operate() throws InterruptedException;
    }
}

