/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ProcessorKeeper21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DistributedLockStats;
import org.apache.geode.distributed.internal.locks.GrantorInfo;
import org.apache.geode.distributed.internal.locks.LockGrantorDestroyedException;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.locks.RemoteThread;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DLockRequestProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    protected final DLockRequestMessage request;
    private final DistributionManager dm;
    protected final DLockService svc;
    private final InternalDistributedMember grantor;
    private volatile boolean gotLock = false;
    private DLockResponseMessage response;
    private final boolean disableAlerts;
    @MutableForTesting
    private static boolean debugReleaseOrphanedGrant = false;
    private static final Object waitToProcessDLockResponseLock = new Object();
    @MutableForTesting
    private static volatile boolean waitToProcessDLockResponse = false;

    @Override
    protected boolean processTimeout() {
        return !this.disableAlerts;
    }

    protected static ProcessorKeeper21 getKeeper() {
        return ReplyProcessor21.keeper;
    }

    protected DLockRequestProcessor(LockGrantorId lockGrantorId, DLockService svc, Object objectName, int threadId, long startTime, long leaseMillis, long waitMillis, boolean reentrant, boolean tryLock, DistributionManager dm) {
        this(lockGrantorId, svc, objectName, threadId, startTime, leaseMillis, waitMillis, reentrant, tryLock, false, dm, false);
    }

    protected DLockRequestProcessor(LockGrantorId lockGrantorId, DLockService svc, Object objectName, int threadId, long startTime, long leaseMillis, long waitMillis, boolean reentrant, boolean tryLock, boolean disableAlerts, DistributionManager dm) {
        this(lockGrantorId, svc, objectName, threadId, startTime, leaseMillis, waitMillis, reentrant, tryLock, disableAlerts, dm, false);
    }

    protected DLockRequestProcessor(LockGrantorId lockGrantorId, DLockService svc, Object objectName, int threadId, long startTime, long leaseMillis, long waitMillis, boolean reentrant, boolean tryLock, DistributionManager dm, boolean async) {
        this(lockGrantorId, svc, objectName, threadId, startTime, leaseMillis, waitMillis, reentrant, tryLock, false, dm, false);
    }

    protected DLockRequestProcessor(LockGrantorId lockGrantorId, DLockService svc, Object objectName, int threadId, long startTime, long leaseMillis, long waitMillis, boolean reentrant, boolean tryLock, boolean disableAlerts, DistributionManager dm, boolean async) {
        super(dm, lockGrantorId.getLockGrantorMember());
        this.svc = svc;
        this.dm = dm;
        this.grantor = lockGrantorId.getLockGrantorMember();
        this.request = this.createRequest();
        Assert.assertTrue(this.getProcessorId() > 0);
        this.request.processorId = this.getProcessorId();
        this.request.serviceName = svc.getName();
        this.request.objectName = objectName;
        this.request.threadId = threadId;
        this.request.startTime = startTime;
        this.request.leaseMillis = leaseMillis;
        this.request.waitMillis = waitMillis;
        this.request.reentrant = reentrant;
        this.request.tryLock = tryLock;
        this.request.grantorVersion = lockGrantorId.getLockGrantorVersion();
        this.request.grantorSerialNumber = lockGrantorId.getLockGrantorSerialNumber();
        this.request.dlsSerialNumber = svc.getSerialNumber();
        this.request.setRecipient(this.grantor);
        this.disableAlerts = disableAlerts;
    }

    protected DLockRequestMessage createRequest() {
        return new DLockRequestMessage();
    }

    protected CancelCriterion getCancelCriterion(DistributionManager ignoreDM) {
        return this.svc.getCancelCriterion();
    }

    boolean repliedDestroyed() {
        if (this.response == null) {
            return false;
        }
        return this.response.responseCode == 6;
    }

    boolean repliedNotHolder() {
        if (this.response == null) {
            return false;
        }
        return this.response.responseCode == 3;
    }

    boolean repliedNotGrantor() {
        if (this.response == null) {
            return false;
        }
        return this.response.responseCode == 1;
    }

    boolean hadNoResponse() {
        return this.response == null;
    }

    boolean tryLockFailed() {
        if (this.response == null) {
            return false;
        }
        return this.response.responseCode == 4;
    }

    String getResponseCodeString() {
        if (this.response == null) {
            return null;
        }
        return DLockResponseMessage.responseCodeToString(this.response.responseCode);
    }

    public DLockResponseMessage getResponse() {
        return this.response;
    }

    long getLeaseExpireTime() {
        return this.response.leaseExpireTime;
    }

    protected boolean requestLock(boolean interruptible, int lockId) throws InterruptedException {
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        Assert.assertTrue(lockId > -1, "lockId is < 0: " + String.valueOf(this));
        this.request.lockId = lockId;
        if (this.isLockGrantor()) {
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestProcessor processing lock request directly");
            }
            this.request.setSender(this.dm.getDistributionManagerId());
            this.request.processLocally(this.dm);
        } else {
            this.dm.putOutgoing(this.request);
        }
        if (interruptible) {
            try {
                this.waitForReplies();
            }
            catch (ReplyException ex) {
                if (ex.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)ex.getCause();
                }
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestProcessor caught ReplyException", (Throwable)ex);
                }
                return false;
            }
        }
        try {
            this.waitForRepliesUninterruptibly();
        }
        catch (ReplyException ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ex.getCause();
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestProcessor caught ReplyException", (Throwable)ex);
            }
            return false;
        }
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestProcessor {} for {}", (Object)(this.gotLock ? "got lock" : "failed to get lock"), (Object)this.request);
        }
        return this.gotLock;
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    private boolean isLockGrantor() {
        return this.dm.getDistributionManagerId().equals(this.grantor);
    }

    Object getKeyIfFailed() {
        if (this.gotLock || this.response == null) {
            return null;
        }
        return this.response.keyIfFailed;
    }

    protected boolean gotLock() {
        return this.gotLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(DistributionMessage msg) {
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        try {
            DLockResponseMessage reply;
            Assert.assertTrue(msg instanceof DLockResponseMessage, "DLockRequestProcessor is unable to process message of type " + String.valueOf(msg.getClass()));
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "Processing DLockResponseMessage: '{}'", (Object)msg);
            }
            this.response = reply = (DLockResponseMessage)msg;
            if (this.response.getLockId() != this.request.getLockId()) {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Failed to find processor for lockId {} processor ids must have wrapped.", (Object)this.response.getLockId());
                }
                Assert.assertTrue(this.response.getLockId() == this.request.getLockId());
            }
            switch (reply.responseCode) {
                case 0: {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "{} has granted lock for {} in {}", (Object)reply.getSender(), reply.objectName, (Object)reply.serviceName);
                    }
                    this.gotLock = true;
                    return;
                }
                case 1: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.NOT_GRANTOR for {}", (Object)reply.getSender(), (Object)reply.serviceName);
                    return;
                }
                case 6: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.DESTROYED for {}", (Object)reply.getSender(), (Object)reply.serviceName);
                    return;
                }
                case 2: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.TIMEOUT for {} in {}", (Object)reply.getSender(), reply.objectName, (Object)reply.serviceName);
                    return;
                }
                case 5: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.SUSPENDED for {} in {}", (Object)reply.getSender(), reply.objectName, (Object)reply.serviceName);
                    return;
                }
                case 3: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.NOT_HOLDER for {} in {}", (Object)reply.getSender(), reply.objectName, (Object)reply.serviceName);
                    return;
                }
                case 4: {
                    if (!isDebugEnabled_DLS) return;
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockResponseMessage.TRY_LOCK_FAILED for {} in {}", (Object)reply.getSender(), reply.objectName, (Object)reply.serviceName);
                    return;
                }
                default: {
                    throw new InternalGemFireError(String.format("Unknown response code %s", reply.responseCode));
                }
            }
        }
        finally {
            super.process(msg);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "Finished processing DLockResponseMessage: '{}'", (Object)msg);
            }
            ((DLockResponseMessage)msg).processed = true;
        }
    }

    @Override
    protected boolean logMultipleExceptions() {
        return false;
    }

    public static boolean debugReleaseOrphanedGrant() {
        return debugReleaseOrphanedGrant;
    }

    public static void setDebugReleaseOrphanedGrant(boolean value) {
        debugReleaseOrphanedGrant = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWaitToProcessDLockResponse(boolean value) {
        Object object = waitToProcessDLockResponseLock;
        synchronized (object) {
            waitToProcessDLockResponse = value;
            waitToProcessDLockResponseLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitToProcessDLockResponse(DistributionManager dm) {
        Object object = waitToProcessDLockResponseLock;
        synchronized (object) {
            while (waitToProcessDLockResponse) {
                dm.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    logger.info("Waiting to process DLockResponseMessage");
                    waitToProcessDLockResponseLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    public static class DLockRequestMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        protected int processorId;
        protected String serviceName;
        protected Object objectName;
        protected long startTime;
        protected long leaseMillis;
        protected long waitMillis;
        protected boolean reentrant;
        protected boolean tryLock;
        protected int lockId;
        protected int threadId;
        protected long grantorVersion;
        protected int grantorSerialNumber;
        protected int dlsSerialNumber;
        protected transient DLockService svc;
        protected transient DLockGrantor grantor;
        private transient long statStart = -1L;
        volatile transient DistributionManager receivingDM;
        transient DLockResponseMessage response;
        private transient RemoteThread rThread;
        private boolean responded = false;
        private final transient Object rThreadLock = new Object();

        public boolean isLocal() {
            Assert.assertTrue(this.receivingDM != null);
            return this.getSender().equals(this.receivingDM.getId());
        }

        public boolean isTryLock() {
            return this.tryLock;
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public Object getObjectName() {
            return this.objectName;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getLeaseTime() {
            return this.leaseMillis;
        }

        public long getWaitTime() {
            return this.waitMillis;
        }

        public int getLockId() {
            return this.lockId;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public long getGrantorVersion() {
            return this.grantorVersion;
        }

        public int getGrantorSerialNumber() {
            return this.grantorSerialNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteThread getRemoteThread() {
            Object object = this.rThreadLock;
            synchronized (object) {
                if (this.rThread == null) {
                    this.rThread = new RemoteThread(this.getSender(), this.getThreadId());
                }
                return this.rThread;
            }
        }

        boolean isSuspendLockingRequest() {
            return this.getObjectName().equals(DLockService.SUSPEND_LOCKING_TOKEN);
        }

        private long startGrantWait() {
            return DLockService.getDistributedLockStats().startGrantWait();
        }

        protected DLockResponseMessage createResponse() {
            return new DLockResponseMessage();
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            boolean failed = false;
            Throwable replyException = null;
            try {
                this.statStart = this.startGrantWait();
                this.svc = DLockService.getInternalServiceNamed(this.serviceName);
                if (this.svc == null) {
                    failed = false;
                    this.basicProcess(dm, false);
                } else {
                    this.executeBasicProcess(dm);
                }
                failed = false;
            }
            catch (RuntimeException e) {
                replyException = e;
                throw e;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                replyException = e;
                throw e;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                replyException = e;
                throw e;
            }
            finally {
                if (failed) {
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestMessage.process failed for <{}>", (Object)this);
                    }
                    this.response = this.createResponse();
                    this.response.setProcessorId(this.getProcessorId());
                    this.response.setRecipient(this.getSender());
                    this.response.serviceName = this.serviceName;
                    this.response.objectName = this.objectName;
                    this.response.lockId = this.lockId;
                    this.respondWithException(replyException);
                }
            }
        }

        protected void processLocally(DistributionManager dm) {
            this.statStart = this.startGrantWait();
            this.svc = DLockService.getInternalServiceNamed(this.serviceName);
            this.basicProcess(dm, true);
        }

        private void executeBasicProcess(DistributionManager dm) {
            DLockRequestMessage msg = this;
            dm.getExecutors().getWaitingThreadPool().execute(() -> {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "calling waitForGrantor {}", (Object)msg);
                }
                this.basicProcess(dm, true);
            });
        }

        protected void basicProcess(DistributionManager dm, boolean waitForGrantor) {
            block34: {
                boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
                try {
                    this.receivingDM = dm;
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestMessage.basicProcess processing <{}>", (Object)this);
                    }
                    this.response = this.createResponse();
                    this.response.setProcessorId(this.getProcessorId());
                    this.response.setRecipient(this.getSender());
                    this.response.serviceName = this.serviceName;
                    this.response.objectName = this.objectName;
                    this.response.lockId = this.lockId;
                    if (waitForGrantor && this.svc != null) {
                        try {
                            this.grantor = DLockGrantor.waitForGrantor(this.svc);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.grantor = null;
                        }
                    }
                    if (this.svc == null || this.grantor == null) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor this.svc={} this.grantor={}", (Object)this.svc, (Object)this.grantor);
                        }
                        this.respondWithNotGrantor();
                        break block34;
                    }
                    if (this.grantor.isDestroyed()) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor grantor was destroyed {}", (Object)this.grantor);
                        }
                        this.respondWithNotGrantor();
                        break block34;
                    }
                    if (this.grantor.getVersionId() != this.grantorVersion) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor current version is {}; request was for {}", (Object)this.grantor.getVersionId(), (Object)this.grantorVersion);
                        }
                        this.respondWithNotGrantor();
                        break block34;
                    }
                    if (this.svc.getSerialNumber() != this.grantorSerialNumber) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor current serial number is {}; request was for {}", (Object)this.svc.getSerialNumber(), (Object)this.grantorSerialNumber);
                        }
                        this.respondWithNotGrantor();
                        break block34;
                    }
                    this.svc.checkDestroyed();
                    if (!this.svc.isLockGrantor()) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor service !isLockGrantor svc={}", (Object)this.svc);
                        }
                        this.respondWithNotGrantor();
                    }
                    this.grantor.checkDestroyed();
                    if (this.reentrant) {
                        long leaseExpireTime;
                        try {
                            leaseExpireTime = this.grantor.reenterLock(this);
                        }
                        catch (InterruptedException e) {
                            leaseExpireTime = 0L;
                        }
                        if (leaseExpireTime == 0L) {
                            this.respondWithNotHolder();
                        } else {
                            this.respondWithGrant(leaseExpireTime);
                        }
                        break block34;
                    }
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "Handling lock request: <{}>", (Object)this);
                    }
                    if (this.grantor.isDestroyed()) {
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS_VERBOSE, "respondWithNotGrantor grantor was destroyed grantor={}", (Object)this.grantor);
                        }
                        this.respondWithNotGrantor();
                    } else {
                        try {
                            this.grantor.handleLockRequest(this);
                        }
                        catch (InterruptedException | LockGrantorDestroyedException e) {
                            this.respondWithNotGrantor();
                        }
                    }
                }
                catch (LockGrantorDestroyedException e) {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "LockGrantorDestroyedException respondWithNotGrantor svc={}", (Object)this.svc);
                    }
                    this.respondWithNotGrantor();
                }
                catch (LockServiceDestroyedException e) {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "LockServiceDestroyedException respondWithNotGrantor svc={}", (Object)this.svc);
                    }
                    this.respondWithNotGrantor();
                }
                catch (CancelException e) {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "CacheClosedException respondWithNotGrantor svc={} exception = {}", (Object)this.svc, (Object)e);
                    }
                    if (this.isLocal()) {
                        throw e;
                    }
                    this.respondWithNotGrantor();
                }
                catch (RuntimeException e) {
                    logger.warn(LogMarker.DLS_MARKER, "[DLockRequestMessage.process] Caught throwable:", (Throwable)e);
                    this.respondWithException(e);
                }
            }
        }

        synchronized void respondWithNotGrantor() {
            this.response.responseCode = 1;
            this.sendResponse();
        }

        synchronized void respondWithDestroyed() {
            this.response.responseCode = 6;
            this.sendResponse();
        }

        private synchronized void respondWithNotHolder() {
            this.response.responseCode = 3;
            this.sendResponse();
        }

        private void respondWithTimeout() {
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "Request {} timed out; grantor status = {}", (Object)this, (Object)this.grantor.displayStatus(this.rThread, this.objectName));
            }
            this.response.responseCode = 2;
            this.sendResponse();
        }

        synchronized void respondWithTryLockFailed(Object keyIfFailed) {
            this.response.responseCode = 4;
            this.response.keyIfFailed = keyIfFailed;
            this.sendResponse();
        }

        synchronized void respondWithGrant(long leaseExpireTime) {
            this.response.responseCode = 0;
            this.response.leaseExpireTime = leaseExpireTime;
            this.response.dlsSerialNumber = this.dlsSerialNumber;
            this.sendResponse();
        }

        synchronized void respondWithException(Throwable t) {
            try {
                if (this.response.getException() == null) {
                    this.response.setException(new ReplyException(t));
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "While processing <{}>, got exception, returning to sender", (Object)this, (Object)this.response.getException());
                    }
                } else {
                    logger.warn(LogMarker.DLS_VERBOSE, String.format("More than one exception thrown in %s", this), t);
                }
            }
            finally {
                this.sendResponse();
            }
        }

        long getTimeoutTS() {
            if (this.waitMillis == -1L || this.waitMillis == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            long result = this.startTime + this.waitMillis;
            if (result < this.startTime) {
                result = Long.MAX_VALUE;
            }
            return result;
        }

        synchronized boolean checkForTimeout() {
            if (this.waitMillis == -1L || this.waitMillis == Long.MAX_VALUE) {
                return false;
            }
            if (this.tryLock) {
                return false;
            }
            long now = DLockService.getLockTimeStamp(this.receivingDM);
            if (now < this.startTime) {
                now = this.startTime;
            }
            if (this.waitMillis + this.startTime - now <= 0L) {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "DLockRequestProcessor request timed out: waitMillis={} now={} startTime={}", (Object)this.waitMillis, (Object)now, (Object)this.startTime);
                }
                this.respondWithTimeout();
                return true;
            }
            return false;
        }

        void endGrantWaitStatistic() {
            if (this.statStart == -1L) {
                return;
            }
            DistributedLockStats stats = DLockService.getDistributedLockStats();
            switch (this.response.responseCode) {
                case 0: {
                    stats.endGrantWait(this.statStart);
                    break;
                }
                case 1: {
                    stats.endGrantWaitNotGrantor(this.statStart);
                    break;
                }
                case 2: {
                    stats.endGrantWaitTimeout(this.statStart);
                    break;
                }
                case 5: {
                    stats.endGrantWaitSuspended(this.statStart);
                    break;
                }
                case 3: {
                    stats.endGrantWaitNotHolder(this.statStart);
                    break;
                }
                case 4: {
                    stats.endGrantWaitFailed(this.statStart);
                    break;
                }
                case 6: {
                    stats.endGrantWaitDestroyed(this.statStart);
                    break;
                }
                default: {
                    Assert.assertTrue(false, "Unknown responseCode: " + this.response.responseCode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendResponse() {
            block12: {
                try {
                    if (this.responded) {
                        return;
                    }
                    InternalDistributedMember myId = this.receivingDM.getDistributionManagerId();
                    if (this.getSender().equals(myId)) {
                        ReplyProcessor21 processor;
                        if (DLockRequestProcessor.debugReleaseOrphanedGrant()) {
                            DLockRequestProcessor.waitToProcessDLockResponse(this.receivingDM);
                        }
                        if ((processor = this.getReplyProcessor()) == null) {
                            logger.warn(LogMarker.DLS_MARKER, "Failed to find processor for {}", (Object)this.response);
                            if (this.response.responseCode == 0) {
                                logger.info(LogMarker.DLS_MARKER, "Releasing local orphaned grant for {}.", (Object)this);
                                try {
                                    this.grantor.releaseIfLocked(this.objectName, this.getSender(), this.lockId);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    logger.warn("Interrupted while releasing grant.", (Throwable)e);
                                }
                                logger.info("Handled local orphaned grant.");
                            }
                            this.endGrantWaitStatistic();
                            return;
                        }
                        this.response.setSender(this.getSender());
                        this.endGrantWaitStatistic();
                        processor.process(this.response);
                        break block12;
                    }
                    DLockResponseMessage responseMessage = this.response;
                    this.executeGrantToRemote(responseMessage);
                }
                finally {
                    this.responded = true;
                }
            }
        }

        ReplyProcessor21 getReplyProcessor() {
            return ReplyProcessor21.getProcessor(this.processorId);
        }

        void executeGrantToRemote(DLockResponseMessage responseMessage) {
            if (!Thread.currentThread().getName().startsWith("Pooled Waiting Message Processor")) {
                this.receivingDM.getExecutors().getWaitingThreadPool().execute(() -> this.grantToRemote(responseMessage));
            } else {
                this.grantToRemote(responseMessage);
            }
        }

        void grantToRemote(DLockResponseMessage responseMessage) {
            this.receivingDM.putOutgoing(responseMessage);
            this.endGrantWaitStatistic();
        }

        synchronized void handleDepartureOfSender() {
            try {
                if (this.receivingDM.getDistributionManagerIds().contains(this.sender)) {
                    this.respondWithDestroyed();
                }
            }
            finally {
                if (!this.responded) {
                    this.endGrantWaitStatistic();
                    this.responded = true;
                }
            }
        }

        synchronized boolean responded() {
            return this.responded;
        }

        boolean respondedNoSync() {
            return this.responded;
        }

        public int getDSFID() {
            return 83;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeUTF(this.serviceName);
            DataSerializer.writeObject(this.objectName, out);
            out.writeLong(this.startTime);
            out.writeLong(this.leaseMillis);
            out.writeLong(this.waitMillis);
            out.writeBoolean(this.reentrant);
            out.writeBoolean(this.tryLock);
            out.writeInt(this.processorId);
            out.writeInt(this.lockId);
            out.writeInt(this.threadId);
            out.writeLong(this.grantorVersion);
            out.writeInt(this.grantorSerialNumber);
            out.writeInt(this.dlsSerialNumber);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.serviceName = in.readUTF();
            this.objectName = DataSerializer.readObject(in);
            this.startTime = in.readLong();
            this.leaseMillis = in.readLong();
            this.waitMillis = in.readLong();
            this.reentrant = in.readBoolean();
            this.tryLock = in.readBoolean();
            this.processorId = in.readInt();
            this.lockId = in.readInt();
            this.threadId = in.readInt();
            this.grantorVersion = in.readLong();
            this.grantorSerialNumber = in.readInt();
            this.dlsSerialNumber = in.readInt();
        }

        @Override
        public String toString() {
            return "{DLockRequestMessage id=" + this.processorId + " for " + this.serviceName + ":" + this.dlsSerialNumber + " name=" + String.valueOf(this.objectName) + " start=" + this.startTime + " sender=" + String.valueOf(this.getSender()) + " threadId=" + this.threadId + " leaseMillis=" + this.leaseMillis + " waitMillis=" + this.waitMillis + " reentrant=" + this.reentrant + " tryLock=" + this.tryLock + " lockId=" + this.lockId + " grantorVersion=" + this.grantorVersion + " grantorSerialNumber=" + this.grantorSerialNumber + " dlsSerialNumber=" + this.dlsSerialNumber + "}";
        }
    }

    public static class DLockResponseMessage
    extends ReplyMessage {
        public static final int GRANT = 0;
        public static final int NOT_GRANTOR = 1;
        public static final int TIMEOUT = 2;
        public static final int NOT_HOLDER = 3;
        public static final int TRY_LOCK_FAILED = 4;
        public static final int SUSPENDED = 5;
        public static final int DESTROYED = 6;
        protected String serviceName;
        protected Object objectName;
        protected int responseCode = 1;
        protected long leaseExpireTime;
        protected Object keyIfFailed;
        protected int lockId;
        protected int dlsSerialNumber;
        protected boolean processed;

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            if (processor == null) {
                return;
            }
            if (DLockRequestProcessor.debugReleaseOrphanedGrant()) {
                DLockRequestProcessor.waitToProcessDLockResponse(dm);
            }
            if (keeper.retrieve(processor.getProcessorId()) != null) {
                super.process(dm, processor);
            }
            if (!this.processed) {
                if (this.responseCode == 0) {
                    logger.warn("No processor found for DLockResponseMessage: {}", (Object)this);
                    this.releaseOrphanedGrant(dm);
                } else {
                    logger.info("No processor found for DLockResponseMessage: {}", (Object)this);
                }
            }
        }

        protected boolean callReleaseProcessor(DistributionManager dm, InternalDistributedMember grantor) {
            return DLockService.callReleaseProcessor(dm, this.serviceName, grantor, this.objectName, false, this.lockId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void releaseOrphanedGrant(DistributionManager dm) {
            InternalDistributedMember grantor = this.getSender();
            boolean released = false;
            logger.info("Releasing orphaned grant for  {}", (Object)this);
            try {
                while (!released) {
                    dm.getCancelCriterion().checkCancelInProgress(null);
                    try {
                        if (grantor == null) {
                            GrantorInfo gi = DLockService.checkLockGrantorInfo(this.serviceName, dm.getSystem());
                            grantor = gi.getId();
                        }
                        if (grantor == null) {
                            released = true;
                            continue;
                        }
                        released = this.callReleaseProcessor(dm, grantor);
                    }
                    catch (LockGrantorDestroyedException gi) {}
                    continue;
                    catch (IllegalStateException e) {
                        if (dm.getId().equals(grantor) && logger.isDebugEnabled()) {
                            logger.debug("[releaseOrphanedGrant] Local grantor threw IllegalStateException handling {}", (Object)this);
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    finally {
                        grantor = null;
                    }
                }
            }
            finally {
                if (released) {
                    logger.info("Handled orphaned grant with release.");
                } else {
                    logger.info("Handled orphaned grant without release.");
                }
            }
        }

        public int getLockId() {
            return this.lockId;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(int code) {
            this.responseCode = code;
        }

        public static String responseCodeToString(int responseCode) {
            Object response = null;
            switch (responseCode) {
                case 0: {
                    response = "GRANT";
                    break;
                }
                case 1: {
                    response = "NOT_GRANTOR";
                    break;
                }
                case 2: {
                    response = "TIMEOUT";
                    break;
                }
                case 5: {
                    response = "SUSPENDED";
                    break;
                }
                case 3: {
                    response = "NOT_HOLDER";
                    break;
                }
                case 4: {
                    response = "TRY_LOCK_FAILED";
                    break;
                }
                case 6: {
                    response = "DESTROYED";
                    break;
                }
                default: {
                    response = "UNKNOWN:" + responseCode;
                }
            }
            return response;
        }

        @Override
        public int getDSFID() {
            return 84;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeByte(this.responseCode);
            out.writeUTF(this.serviceName);
            DataSerializer.writeObject(this.objectName, out);
            out.writeLong(this.leaseExpireTime);
            DataSerializer.writeObject(this.keyIfFailed, out);
            out.writeInt(this.lockId);
            out.writeInt(this.dlsSerialNumber);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.responseCode = in.readByte();
            this.serviceName = in.readUTF();
            this.objectName = DataSerializer.readObject(in);
            this.leaseExpireTime = in.readLong();
            this.keyIfFailed = DataSerializer.readObject(in);
            this.lockId = in.readInt();
            this.dlsSerialNumber = in.readInt();
        }

        @Override
        public String toString() {
            String response = DLockResponseMessage.responseCodeToString(this.responseCode);
            return "DLockRequestProcessor.DLockResponseMessage responding " + response + "; serviceName=" + this.serviceName + "(version " + this.dlsSerialNumber + "); objectName=" + String.valueOf(this.objectName) + "; responseCode=" + this.responseCode + "; keyIfFailed=" + String.valueOf(this.keyIfFailed) + "; leaseExpireTime=" + this.leaseExpireTime + "; processorId=" + this.processorId + "; lockId=" + this.lockId;
        }
    }
}

