/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SerializationException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;

public class ReplyException
extends GemFireException {
    private static final long serialVersionUID = -4410839793809166071L;
    private static final String REMOTE_MEMBER_TOKEN = "Remote Member";
    private transient InternalDistributedMember sender;

    public ReplyException() {
    }

    public ReplyException(String msg) {
        super(msg);
    }

    public ReplyException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ReplyException(Throwable cause) {
        super(cause);
    }

    public void handleCause() {
        Throwable c = this.getCause();
        if (c == null) {
            throw new InternalGemFireException(String.format("unexpected exception on member %s", this.getSender()), this);
        }
        if (c instanceof RuntimeException) {
            this.fixUpRemoteEx(c);
            throw (RuntimeException)c;
        }
        if (c instanceof Error) {
            this.fixUpRemoteEx(c);
            throw (Error)c;
        }
        if (c instanceof ClassNotFoundException) {
            throw new SerializationException("Class not found", c);
        }
        throw new InternalGemFireException(String.format("unexpected exception on member %s", this.getSender()), c);
    }

    private void fixUpRemoteEx(Throwable t) {
        int i;
        if (this.getSender() == null) {
            return;
        }
        String senderId = this.getSender().toString();
        ReplyException.addSenderInfo(t, senderId);
        StackTraceElement[] remoteStack = t.getStackTrace();
        StackTraceElement[] localStack = Thread.currentThread().getStackTrace();
        int localStartIdx = 0;
        if (localStartIdx < localStack.length && ++localStartIdx < localStack.length) {
            ++localStartIdx;
        }
        StackTraceElement[] newStack = new StackTraceElement[remoteStack.length + localStack.length - localStartIdx];
        for (i = 0; i < remoteStack.length; ++i) {
            newStack[i] = remoteStack[i];
        }
        int j = 2;
        while (i < newStack.length) {
            newStack[i] = localStack[j];
            ++j;
            ++i;
        }
        t.setStackTrace(newStack);
    }

    private static void addSenderInfo(Throwable toModify, String senderId) {
        StackTraceElement[] stackTrace = toModify.getStackTrace();
        StackTraceElement element = null;
        for (int i = 0; i < stackTrace.length; ++i) {
            element = stackTrace[i];
            if (element.getClassName().startsWith(REMOTE_MEMBER_TOKEN)) continue;
            stackTrace[i] = new StackTraceElement("Remote Member '" + senderId + "' in " + element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber());
        }
        toModify.setStackTrace(stackTrace);
        Throwable cause = toModify.getCause();
        if (cause != null) {
            ReplyException.addSenderInfo(cause, senderId);
        }
    }

    public synchronized void setSenderIfNull(InternalDistributedMember sendr) {
        if (this.sender == null) {
            this.sender = sendr;
        }
    }

    public synchronized InternalDistributedMember getSender() {
        return this.sender;
    }

    @Override
    public String getMessage() {
        InternalDistributedMember s = this.getSender();
        String m = super.getMessage();
        return s != null ? "From " + String.valueOf(s) + ": " + m : m;
    }
}

