/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIndexOperation;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.StructFields;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.CompactRangeIndex;
import org.apache.geode.cache.query.internal.index.DummyQRegion;
import org.apache.geode.cache.query.internal.index.FunctionalIndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexConcurrentHashSet;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexStore;
import org.apache.geode.cache.query.internal.index.IndexedExpressionEvaluator;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.index.RangeIndex;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;
import org.apache.logging.log4j.Logger;

public abstract class AbstractIndex
implements IndexProtocol {
    private static final Logger logger = LogService.getLogger();
    static final AtomicIntegerFieldUpdater<RegionEntryToValuesMap> atomicUpdater = AtomicIntegerFieldUpdater.newUpdater(RegionEntryToValuesMap.class, "numValues");
    final InternalCache cache;
    final String indexName;
    final Region region;
    final String indexedExpression;
    final String fromClause;
    final String projectionAttributes;
    final String originalIndexedExpression;
    final String originalFromClause;
    private final String originalProjectionAttributes;
    final String[] canonicalizedDefinitions;
    private boolean isValid;
    protected IndexedExpressionEvaluator evaluator;
    InternalIndexStatistics internalIndexStats;
    protected Index prIndex;
    private Boolean isIndexedPdxKeys = false;
    Boolean isIndexedPdxKeysFlagSet = false;
    boolean indexOnRegionKeys = false;
    boolean indexOnValues = false;
    private final ReadWriteLock removeIndexLock = new ReentrantReadWriteLock();
    volatile boolean isPopulated = false;

    AbstractIndex(InternalCache cache, String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String originalFromClause, String originalIndexedExpression, String[] defintions, IndexStatistics stats) {
        this.cache = cache;
        this.indexName = indexName;
        this.region = region;
        this.indexedExpression = indexedExpression;
        this.fromClause = fromClause;
        this.originalIndexedExpression = originalIndexedExpression;
        this.originalFromClause = originalFromClause;
        this.canonicalizedDefinitions = defintions;
        if (StringUtils.isEmpty((CharSequence)projectionAttributes)) {
            projectionAttributes = "*";
        }
        this.projectionAttributes = projectionAttributes;
        this.originalProjectionAttributes = projectionAttributes;
        this.internalIndexStats = stats != null ? (InternalIndexStatistics)stats : this.createStats(indexName);
    }

    public Map getValueToEntriesMap() {
        return null;
    }

    @Override
    public IndexStatistics getStatistics() {
        return this.internalIndexStats;
    }

    @Override
    public void destroy() {
        this.markValid(false);
        if (this.internalIndexStats != null) {
            this.internalIndexStats.updateNumKeys(0L);
            this.internalIndexStats.close();
        }
    }

    long updateIndexUpdateStats() {
        long result = System.nanoTime();
        this.internalIndexStats.incUpdatesInProgress(1);
        return result;
    }

    void updateIndexUpdateStats(long start) {
        long end = System.nanoTime();
        this.internalIndexStats.incUpdatesInProgress(-1);
        this.internalIndexStats.incUpdateTime(end - start);
    }

    long updateIndexUseStats() {
        return this.updateIndexUseStats(true);
    }

    long updateIndexUseStats(boolean updateStats) {
        long result = 0L;
        if (updateStats) {
            this.internalIndexStats.incUsesInProgress(1);
            result = System.nanoTime();
        }
        return result;
    }

    void updateIndexUseEndStats(long start) {
        this.updateIndexUseEndStats(start, true);
    }

    void updateIndexUseEndStats(long start, boolean updateStats) {
        if (updateStats) {
            long end = System.nanoTime();
            this.internalIndexStats.incUsesInProgress(-1);
            this.internalIndexStats.incNumUses();
            this.internalIndexStats.incUseTime(end - start);
        }
    }

    public IndexedExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key, int operator, Collection results, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr = ((Bucket)((Object)this.region)).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object bucketId : context.getBucketList()) {
                    AbstractIndex bucketIndex = PartitionedIndex.getBucketIndex(pr, this.indexName, (Integer)bucketId);
                    if (bucketIndex == null) continue;
                    bucketIndex.lockedQuery(key, operator, results, null, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(key, operator, results, null, context);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key, int operator, Collection results, CompiledValue iterOp, RuntimeIterator indpndntItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr = ((Bucket)((Object)this.region)).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object bucketId : context.getBucketList()) {
                    AbstractIndex bucketIndex = PartitionedIndex.getBucketIndex(pr, this.indexName, (Integer)bucketId);
                    if (bucketIndex == null) continue;
                    bucketIndex.lockedQuery(key, operator, results, iterOp, indpndntItr, context, projAttrib, intermediateResults, isIntersection);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(key, operator, results, iterOp, indpndntItr, context, projAttrib, intermediateResults, isIntersection);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr = ((Bucket)((Object)this.region)).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object bucketId : context.getBucketList()) {
                    AbstractIndex bucketIndex = PartitionedIndex.getBucketIndex(pr, this.indexName, (Integer)bucketId);
                    if (bucketIndex == null) continue;
                    bucketIndex.lockedQuery(key, operator, results, keysToRemove, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(key, operator, results, keysToRemove, context);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Iterator iterator = keysToRemove.iterator();
        Object temp = iterator.next();
        iterator.remove();
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            long start = this.updateIndexUseStats();
            try {
                PartitionedRegion partitionedRegion = ((Bucket)((Object)this.region)).getPartitionedRegion();
                for (Object bucketId : context.getBucketList()) {
                    AbstractIndex bucketIndex = PartitionedIndex.getBucketIndex(partitionedRegion, this.indexName, (Integer)bucketId);
                    if (bucketIndex == null) continue;
                    bucketIndex.lockedQuery(temp, 20, results, iterator.hasNext() ? keysToRemove : null, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(temp, 20, results, iterator.hasNext() ? keysToRemove : null, context);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null) {
            if (this.region instanceof BucketRegion) {
                PartitionedRegion partitionedRegion = ((Bucket)((Object)this.region)).getPartitionedRegion();
                long start = this.updateIndexUseStats();
                try {
                    for (Object bucketId : context.getBucketList()) {
                        AbstractIndex bucketIndex = PartitionedIndex.getBucketIndex(partitionedRegion, this.indexName, (Integer)bucketId);
                        if (bucketIndex == null) continue;
                        bucketIndex.lockedQuery(lowerBoundKey, lowerBoundOperator, upperBoundKey, upperBoundOperator, results, keysToRemove, context);
                    }
                }
                finally {
                    this.updateIndexUseEndStats(start);
                }
            }
        } else {
            long start = this.updateIndexUseStats();
            try {
                this.lockedQuery(lowerBoundKey, lowerBoundOperator, upperBoundKey, upperBoundOperator, results, keysToRemove, context);
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
    }

    @Override
    public List queryEquijoinCondition(IndexProtocol index, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed(" This function should have never got invoked as its meaningful implementation is present only in RangeIndex class");
        return null;
    }

    @Override
    public String getProjectionAttributes() {
        return this.originalProjectionAttributes;
    }

    @Override
    public String getCanonicalizedProjectionAttributes() {
        return this.projectionAttributes;
    }

    @Override
    public String getIndexedExpression() {
        return this.originalIndexedExpression;
    }

    @Override
    public String getCanonicalizedIndexedExpression() {
        return this.indexedExpression;
    }

    @Override
    public String getFromClause() {
        return this.originalFromClause;
    }

    @Override
    public String getCanonicalizedFromClause() {
        return this.fromClause;
    }

    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean addIndexMapping(RegionEntry entry) throws IMQException {
        this.addMapping(entry);
        return true;
    }

    @Override
    public boolean addAllIndexMappings(Collection<RegionEntry> c) throws IMQException {
        for (RegionEntry regionEntry : c) {
            this.addMapping(regionEntry);
        }
        return true;
    }

    @Override
    public boolean removeIndexMapping(RegionEntry entry, int opCode) throws IMQException {
        this.removeMapping(entry, opCode);
        return true;
    }

    @Override
    public boolean removeAllIndexMappings(Collection<RegionEntry> c) throws IMQException {
        for (RegionEntry regionEntry : c) {
            this.removeMapping(regionEntry, 0);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void markValid(boolean b) {
        this.isValid = b;
    }

    @Override
    public boolean isMatchingWithIndexExpression(CompiledValue condnExpr, String condnExprStr, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        return this.indexedExpression.equals(condnExprStr);
    }

    Object verifyAndGetPdxDomainObject(Object value) {
        if (value instanceof StructImpl) {
            if (((StructImpl)value).isHasPdx() && !((InternalCache)this.region.getCache()).getPdxReadSerializedByAnyGemFireServices()) {
                StructImpl v = (StructImpl)value;
                Object[] fieldValues = v.getPdxFieldValues();
                return new StructImpl((StructTypeImpl)v.getStructType(), fieldValues);
            }
        } else if (value instanceof PdxInstance && !((InternalCache)this.region.getCache()).getPdxReadSerializedByAnyGemFireServices()) {
            return ((PdxInstance)value).getObject();
        }
        return value;
    }

    private void addToResultsWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object value) {
        value = this.verifyAndGetPdxDomainObject(value);
        if (intermediateResults == null) {
            results.add(value);
        } else if (isIntersection) {
            int numOcc = intermediateResults.occurrences(value);
            if (numOcc > 0) {
                results.add(value);
                intermediateResults.remove(value);
            }
        } else {
            results.add(value);
        }
    }

    private void addToStructsWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.verifyAndGetPdxDomainObject(values[i]);
        }
        if (intermediateResults == null) {
            if (results instanceof StructFields) {
                ((StructFields)((Object)results)).addFieldValues(values);
            } else {
                SelectResults selectResults = (SelectResults)results;
                StructImpl structImpl = new StructImpl((StructTypeImpl)selectResults.getCollectionType().getElementType(), values);
                selectResults.add(structImpl);
            }
        } else if (isIntersection) {
            if (results instanceof StructFields) {
                int occurrences = intermediateResults.occurrences(values);
                if (occurrences > 0) {
                    ((StructFields)((Object)results)).addFieldValues(values);
                    ((StructFields)((Object)intermediateResults)).removeFieldValues(values);
                }
            } else {
                SelectResults selectResults = (SelectResults)results;
                StructImpl structImpl = new StructImpl((StructTypeImpl)selectResults.getCollectionType().getElementType(), values);
                if (intermediateResults.remove(structImpl)) {
                    selectResults.add(structImpl);
                }
            }
        } else if (results instanceof StructFields) {
            ((StructFields)((Object)results)).addFieldValues(values);
        } else {
            SelectResults selectResults = (SelectResults)results;
            StructImpl structImpl = new StructImpl((StructTypeImpl)selectResults.getCollectionType().getElementType(), values);
            if (intermediateResults.remove(structImpl)) {
                selectResults.add(structImpl);
            }
        }
    }

    void applyCqOrProjection(List projAttrib, ExecutionContext context, Collection result, Object iterValue, SelectResults intermediateResults, boolean isIntersection, Object key) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (context != null && context.isCqQueryContext()) {
            result.add(new CqEntry(key, iterValue));
        } else {
            this.applyProjection(projAttrib, context, result, iterValue, intermediateResults, isIntersection);
        }
    }

    void applyProjection(List projAttrib, ExecutionContext context, Collection result, Object iterValue, SelectResults intermediateResults, boolean isIntersection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (projAttrib == null) {
            iterValue = this.deserializePdxForLocalDistinctQuery(context, iterValue);
            this.addToResultsWithUnionOrIntersection(result, intermediateResults, isIntersection, iterValue);
        } else {
            boolean isStruct;
            boolean bl = isStruct = result instanceof SelectResults && ((SelectResults)result).getCollectionType().getElementType() != null && ((SelectResults)result).getCollectionType().getElementType().isStructType();
            if (isStruct) {
                int projCount = projAttrib.size();
                Object[] values = new Object[projCount];
                Iterator projIter = projAttrib.iterator();
                int i = 0;
                while (projIter.hasNext()) {
                    Object[] projDef = (Object[])projIter.next();
                    values[i] = this.deserializePdxForLocalDistinctQuery(context, ((CompiledValue)projDef[1]).evaluate(context));
                    ++i;
                }
                this.addToStructsWithUnionOrIntersection(result, intermediateResults, isIntersection, values);
            } else {
                Object[] temp = (Object[])projAttrib.get(0);
                Object val = this.deserializePdxForLocalDistinctQuery(context, ((CompiledValue)temp[1]).evaluate(context));
                this.addToResultsWithUnionOrIntersection(result, intermediateResults, isIntersection, val);
            }
        }
    }

    private Object deserializePdxForLocalDistinctQuery(ExecutionContext context, Object value) throws QueryInvocationTargetException {
        if (!((DefaultQuery)context.getQuery()).isRemoteQuery()) {
            if (context.isDistinct() && value instanceof PdxInstance && !this.region.getCache().getPdxReadSerialized()) {
                try {
                    value = ((PdxInstance)value).getObject();
                }
                catch (Exception ex) {
                    throw new QueryInvocationTargetException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage());
                }
            } else if (value instanceof PdxString) {
                value = value.toString();
            }
        }
        return value;
    }

    private void removeFromResultsWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object value) {
        if (intermediateResults == null) {
            results.remove(value);
        } else if (isIntersection) {
            int numOcc = ((SelectResults)results).occurrences(value);
            if (numOcc > 0) {
                results.remove(value);
                intermediateResults.add(value);
            }
        } else {
            results.remove(value);
        }
    }

    private void removeFromStructsWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object[] values) {
        if (intermediateResults == null) {
            ((StructFields)((Object)results)).removeFieldValues(values);
        } else if (isIntersection) {
            int numOcc = ((SelectResults)results).occurrences(values);
            if (numOcc > 0) {
                ((StructFields)((Object)results)).removeFieldValues(values);
                ((StructFields)((Object)intermediateResults)).addFieldValues(values);
            }
        } else {
            ((StructFields)((Object)results)).removeFieldValues(values);
        }
    }

    private void removeProjection(List projAttrib, ExecutionContext context, Collection result, Object iterValue, SelectResults intermediateResults, boolean isIntersection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (projAttrib == null) {
            this.removeFromResultsWithUnionOrIntersection(result, intermediateResults, isIntersection, iterValue);
        } else if (result instanceof StructFields) {
            int projCount = projAttrib.size();
            Object[] values = new Object[projCount];
            Iterator projIter = projAttrib.iterator();
            int i = 0;
            while (projIter.hasNext()) {
                Object[] projDef = (Object[])projIter.next();
                values[i++] = ((CompiledValue)projDef[1]).evaluate(context);
            }
            this.removeFromStructsWithUnionOrIntersection(result, intermediateResults, isIntersection, values);
        } else {
            Object[] temp = (Object[])projAttrib.get(0);
            Object val = ((CompiledValue)temp[1]).evaluate(context);
            this.removeFromResultsWithUnionOrIntersection(result, intermediateResults, isIntersection, val);
        }
    }

    @Override
    public String[] getCanonicalizedIteratorDefinitions() {
        return this.canonicalizedDefinitions;
    }

    @Override
    public boolean containsEntry(RegionEntry entry) {
        return false;
    }

    abstract void instantiateEvaluator(IndexCreationHelper var1);

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
    }

    public String toString() {
        return "Index [ Name=" + this.getName() + " Type =" + String.valueOf((Object)this.getType()) + " IdxExp=" + this.getIndexedExpression() + " From=" + this.getFromClause() + " Proj=" + this.getProjectionAttributes() + "]";
    }

    public abstract boolean isEmpty();

    protected abstract boolean isCompactRangeIndex();

    protected abstract InternalIndexStatistics createStats(String var1);

    @Override
    public abstract ObjectType getResultSetType();

    abstract void recreateIndexData() throws IMQException;

    abstract void addMapping(RegionEntry var1) throws IMQException;

    abstract void removeMapping(RegionEntry var1, int var2) throws IMQException;

    abstract void addMapping(Object var1, Object var2, RegionEntry var3) throws IMQException;

    abstract void saveMapping(Object var1, Object var2, RegionEntry var3) throws IMQException;

    abstract void lockedQuery(Object var1, int var2, Collection var3, CompiledValue var4, RuntimeIterator var5, ExecutionContext var6, List var7, SelectResults var8, boolean var9) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    abstract void lockedQuery(Object var1, int var2, Object var3, int var4, Collection var5, Set var6, ExecutionContext var7) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    abstract void lockedQuery(Object var1, int var2, Collection var3, Set var4, ExecutionContext var5) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    public Index getPRIndex() {
        return this.prIndex;
    }

    void setPRIndex(Index parIndex) {
        this.prIndex = parIndex;
    }

    boolean verifyLimit(Collection result, int limit) {
        return limit > 0 && result.size() == limit;
    }

    boolean verifyEntryAndIndexValue(RegionEntry re, Object value, ExecutionContext context) {
        Object valueInIndex;
        List valuesInRegion;
        block8: {
            IMQEvaluator evaluator = (IMQEvaluator)this.getEvaluator();
            valuesInRegion = null;
            valueInIndex = null;
            try {
                if (evaluator.isFirstItrOnKey()) {
                    return true;
                }
                if (evaluator.isFirstItrOnEntry()) {
                    valuesInRegion = this.evaluateIndexIteratorsFromRE(re, context);
                    valueInIndex = this.verifyAndGetPdxDomainObject(value);
                } else {
                    RegionEntryContext regionEntryContext = context.getPartitionedRegion() != null ? context.getPartitionedRegion() : (RegionEntryContext)((Object)this.region);
                    Object val = re.getValueInVM(regionEntryContext);
                    if (val instanceof CachedDeserializable) {
                        val = ((CachedDeserializable)val).getDeserializedValue(this.getRegion(), re);
                    }
                    val = this.verifyAndGetPdxDomainObject(val);
                    valueInIndex = this.verifyAndGetPdxDomainObject(value);
                    valuesInRegion = this.evaluateIndexIteratorsFromRE(val, context);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Exception occurred while verifying a Region Entry value during a Query when the Region Entry is under update operation", (Throwable)e);
            }
        }
        if (!valuesInRegion.isEmpty()) {
            for (Object valueInRegion : valuesInRegion) {
                if (!this.compareStructWithNonStruct(valueInRegion, valueInIndex)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean compareStructWithNonStruct(Object valueInRegion, Object valueInIndex) {
        if (valueInRegion instanceof Struct && valueInIndex instanceof Struct) {
            Object[] regFields = ((StructImpl)valueInRegion).getFieldValues();
            List<Object> indFields = Arrays.asList(((StructImpl)valueInIndex).getFieldValues());
            for (Object regField : regFields) {
                if (indFields.contains(regField)) continue;
                return false;
            }
            return true;
        }
        if (valueInRegion instanceof Struct) {
            Object[] fields;
            for (Object field : fields = ((StructImpl)valueInRegion).getFieldValues()) {
                if (!field.equals(valueInIndex)) continue;
                return true;
            }
        } else if (valueInIndex instanceof Struct) {
            Object[] fields;
            for (Object field : fields = ((StructImpl)valueInIndex).getFieldValues()) {
                if (!field.equals(valueInRegion)) continue;
                return true;
            }
        } else {
            return valueInRegion.equals(valueInIndex);
        }
        return false;
    }

    private List evaluateIndexIteratorsFromRE(Object value, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (value instanceof RegionEntry) {
            value = new NonTXEntry((LocalRegion)this.getRegion(), (RegionEntry)value);
        }
        List itrs = this.getAllDependentRuntimeIterators(context);
        return this.evaluateLastColl(value, context, itrs, 0);
    }

    private List evaluateLastColl(Object value, ExecutionContext context, List itrs, int level) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> tuples = new ArrayList<Object>(1);
        RuntimeIterator currItrator = (RuntimeIterator)itrs.get(level);
        currItrator.setCurrent(value);
        if (itrs.size() - 1 == level) {
            if (itrs.size() > 1) {
                Object[] tuple = new Object[itrs.size()];
                for (int i = 0; i < itrs.size(); ++i) {
                    RuntimeIterator iter = (RuntimeIterator)itrs.get(i);
                    tuple[i] = iter.evaluate(context);
                }
                tuples.add(new StructImpl(new StructTypeImpl(), tuple));
            } else {
                tuples.add(currItrator.evaluate(context));
            }
        } else {
            RuntimeIterator nextItr = (RuntimeIterator)itrs.get(level + 1);
            SelectResults nextLevelValues = nextItr.evaluateCollection(context);
            if (nextLevelValues != null) {
                for (Object nextLevelValue : nextLevelValues) {
                    tuples.addAll(this.evaluateLastColl(nextLevelValue, context, itrs, level + 1));
                }
            }
        }
        return tuples;
    }

    RuntimeIterator getRuntimeIteratorForThisIndex(ExecutionContext context) {
        List indItrs = context.getCurrentIterators();
        Region rgn = this.getRegion();
        if (rgn instanceof BucketRegion) {
            rgn = ((Bucket)((Object)rgn)).getPartitionedRegion();
        }
        String regionPath = rgn.getFullPath();
        String definition = this.getCanonicalizedIteratorDefinitions()[0];
        for (RuntimeIterator itr : indItrs) {
            if (!itr.getDefinition().equals(regionPath) && !itr.getDefinition().equals(definition)) continue;
            return itr;
        }
        return null;
    }

    RuntimeIterator getRuntimeIteratorForThisIndex(ExecutionContext context, IndexInfo info) {
        List indItrs = context.getCurrentIterators();
        Region rgn = this.getRegion();
        if (rgn instanceof BucketRegion) {
            rgn = ((Bucket)((Object)rgn)).getPartitionedRegion();
        }
        String regionPath = rgn.getFullPath();
        String definition = this.getCanonicalizedIteratorDefinitions()[0];
        for (RuntimeIterator itr : indItrs) {
            if (!itr.getDefinition().equals(regionPath) && !itr.getDefinition().equals(definition)) continue;
            if (itr.getName() != null) {
                CompiledValue path = info._path();
                String pathName = this.getReceiverNameFromPath(path);
                if (path.getType() != 35 && !itr.getName().equals(pathName)) continue;
                return itr;
            }
            return itr;
        }
        return null;
    }

    private String getReceiverNameFromPath(CompiledValue path) {
        if (path instanceof CompiledID) {
            return ((CompiledID)path).getId();
        }
        if (path instanceof CompiledPath) {
            return this.getReceiverNameFromPath(path.getReceiver());
        }
        if (path instanceof CompiledOperation) {
            return this.getReceiverNameFromPath(path.getReceiver());
        }
        if (path instanceof CompiledIndexOperation) {
            return this.getReceiverNameFromPath(path.getReceiver());
        }
        return "";
    }

    private List getAllDependentRuntimeIterators(ExecutionContext context) {
        List indItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(this.getRuntimeIteratorForThisIndex(context));
        List<String> definitions = Arrays.asList(this.getCanonicalizedIteratorDefinitions());
        ArrayList<RuntimeIterator> itrs = new ArrayList<RuntimeIterator>();
        for (RuntimeIterator itr : indItrs) {
            if (!definitions.contains(itr.getDefinition())) continue;
            itrs.add(itr);
        }
        return itrs;
    }

    void populateListForEquiJoin(List list, Object outerEntries, Object innerEntries, ExecutionContext context, Object key) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Assert.assertTrue(outerEntries != null && innerEntries != null, "OuterEntries or InnerEntries must not be null");
        Object[][] values = new Object[2][];
        Iterator itr = null;
        int j = 0;
        while (j < 2) {
            boolean isRangeIndex = false;
            if (j == 0) {
                if (outerEntries instanceof RegionEntryToValuesMap) {
                    itr = ((RegionEntryToValuesMap)outerEntries).map.entrySet().iterator();
                    isRangeIndex = true;
                } else if (outerEntries instanceof CloseableIterator) {
                    itr = (Iterator)outerEntries;
                }
            } else if (innerEntries instanceof RegionEntryToValuesMap) {
                itr = ((RegionEntryToValuesMap)innerEntries).map.entrySet().iterator();
                isRangeIndex = true;
            } else if (innerEntries instanceof CloseableIterator) {
                itr = (Iterator)innerEntries;
            }
            ArrayList<Object> dummy = new ArrayList<Object>();
            RegionEntry re = null;
            IndexStore.IndexStoreEntry ie = null;
            Object val = null;
            Object entryVal = null;
            IndexInfo[] indexInfo = (IndexInfo[])context.cacheGet("index_info");
            IndexInfo indInfo = indexInfo[j];
            while (itr.hasNext()) {
                if (isRangeIndex) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    val = entry.getValue();
                    entryVal = val instanceof Collection ? (Object)((Iterable)val).iterator().next() : val;
                    re = (RegionEntry)entry.getKey();
                } else {
                    ie = (IndexStore.IndexStoreEntry)itr.next();
                }
                boolean ok = true;
                if (isRangeIndex) {
                    if (re.isUpdateInProgress()) {
                        ok = ((RangeIndex)indInfo._getIndex()).verifyEntryAndIndexValue(re, entryVal, context);
                    }
                } else if (ie.isUpdateInProgress()) {
                    ok = ((CompactRangeIndex)indInfo._getIndex()).verifyInnerAndOuterEntryValues(ie, context, indInfo, key);
                }
                if (!ok) continue;
                if (isRangeIndex) {
                    if (val instanceof Collection) {
                        dummy.addAll((Collection)val);
                        continue;
                    }
                    dummy.add(val);
                    continue;
                }
                if (IndexManager.IS_TEST_EXPANSION) {
                    dummy.addAll(((CompactRangeIndex)indInfo._getIndex()).expandValue(context, key, null, 13, -1, ie.getDeserializedValue()));
                    continue;
                }
                dummy.add(ie.getDeserializedValue());
            }
            Object[] newValues = new Object[dummy.size()];
            dummy.toArray(newValues);
            values[j++] = newValues;
        }
        list.add(values);
    }

    synchronized void setPdxStringFlag(Object key) {
        if (this.isIndexedPdxKeysFlagSet.booleanValue() || key == null || key == IndexManager.NULL || key == QueryService.UNDEFINED) {
            return;
        }
        if (!this.isIndexedPdxKeys.booleanValue() && this.region.getAttributes().getEvictionAttributes().isNoEviction() && key instanceof PdxString && this.region.getAttributes().getCompressor() == null) {
            this.isIndexedPdxKeys = true;
        }
        this.isIndexedPdxKeysFlagSet = true;
    }

    Object getPdxStringForIndexedPdxKeys(Object key) {
        if (this.isIndexedPdxKeys.booleanValue()) {
            if (key instanceof String) {
                return new PdxString((String)key);
            }
        } else if (key instanceof PdxString) {
            return key.toString();
        }
        return key;
    }

    boolean acquireIndexReadLockForRemove() {
        boolean success = this.removeIndexLock.readLock().tryLock();
        if (success) {
            this.internalIndexStats.incReadLockCount(1);
            if (logger.isDebugEnabled()) {
                logger.debug("Acquired read lock on index {}", (Object)this.getName());
            }
        }
        return success;
    }

    public void releaseIndexReadLockForRemove() {
        this.removeIndexLock.readLock().unlock();
        this.internalIndexStats.incReadLockCount(-1);
        if (logger.isDebugEnabled()) {
            logger.debug("Released read lock on index {}", (Object)this.getName());
        }
    }

    public void acquireIndexWriteLockForRemove() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Acquiring write lock on Index {}", (Object)this.getName());
        }
        this.removeIndexLock.writeLock().lock();
        if (isDebugEnabled) {
            logger.debug("Acquired write lock on index {}", (Object)this.getName());
        }
    }

    public void releaseIndexWriteLockForRemove() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Releasing write lock on Index {}", (Object)this.getName());
        }
        this.removeIndexLock.writeLock().unlock();
        if (isDebugEnabled) {
            logger.debug("Released write lock on Index {}", (Object)this.getName());
        }
    }

    public boolean isPopulated() {
        return this.isPopulated;
    }

    public void setPopulated(boolean isPopulated) {
        this.isPopulated = isPopulated;
    }

    boolean isIndexOnPdxKeys() {
        return this.isIndexedPdxKeys;
    }

    protected static abstract class InternalIndexStatistics
    implements IndexStatistics {
        protected InternalIndexStatistics() {
        }

        @Override
        public long getNumUpdates() {
            return 0L;
        }

        @Override
        public long getTotalUpdateTime() {
            return 0L;
        }

        @Override
        public long getTotalUses() {
            return 0L;
        }

        @Override
        public long getNumberOfKeys() {
            return 0L;
        }

        @Override
        public long getNumberOfValues() {
            return 0L;
        }

        @Override
        public long getNumberOfValues(Object key) {
            return 0L;
        }

        @Override
        @Deprecated
        public int getReadLockCount() {
            return (int)this.getReadLockCountLong();
        }

        @Override
        public long getReadLockCountLong() {
            return 0L;
        }

        @Override
        public long getNumberOfMapIndexKeys() {
            return 0L;
        }

        @Override
        @Deprecated
        public int getNumberOfBucketIndexes() {
            return (int)this.getNumberOfBucketIndexesLong();
        }

        @Override
        public long getNumberOfBucketIndexesLong() {
            return 0L;
        }

        public void close() {
        }

        public void incNumValues(int delta) {
        }

        public void incNumUpdates() {
        }

        public void incNumUpdates(int delta) {
        }

        public void incUpdatesInProgress(int delta) {
        }

        public void incUsesInProgress(int delta) {
        }

        public void updateNumKeys(long count) {
        }

        public void incNumKeys(long count) {
        }

        public void incNumMapIndexKeys(long numKeys) {
        }

        public void incUpdateTime(long delta) {
        }

        public void incNumUses() {
        }

        public void incUseTime(long delta) {
        }

        public void incReadLockCount(int delta) {
        }

        public void incNumBucketIndexes(int delta) {
        }
    }

    class IMQEvaluator
    implements IndexedExpressionEvaluator {
        private final InternalCache cache;
        private List fromIterators = null;
        private CompiledValue indexedExpr = null;
        private final String[] canonicalIterNames;
        private ObjectType indexResultSetType = null;
        private Map dependencyGraph = null;
        private boolean isFirstItrOnEntry = false;
        private boolean isFirstItrOnKey = false;
        private List indexInitIterators = null;
        private CompiledValue additionalProj = null;
        private CompiledValue modifiedIndexExpr = null;
        private ObjectType addnlProjType = null;
        private int initEntriesUpdated = 0;
        private boolean hasInitOccurredOnce = false;
        private ExecutionContext initContext = null;
        private int iteratorSize = -1;
        private Region rgn = null;

        IMQEvaluator(IndexCreationHelper helper) {
            this.cache = helper.getCache();
            this.fromIterators = helper.getIterators();
            this.indexedExpr = helper.getCompiledIndexedExpression();
            this.rgn = helper.getRegion();
            this.isFirstItrOnEntry = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionEntry;
            this.isFirstItrOnKey = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionKey;
            this.additionalProj = ((FunctionalIndexCreationHelper)helper).additionalProj;
            Object[] params1 = new Object[]{new QRegion(this.rgn, false)};
            this.initContext = new ExecutionContext(params1, this.cache);
            this.canonicalIterNames = helper.canonicalizedIteratorNames;
            if (this.isFirstItrOnEntry) {
                this.indexInitIterators = this.fromIterators;
            } else {
                this.indexInitIterators = ((FunctionalIndexCreationHelper)helper).indexInitIterators;
                this.modifiedIndexExpr = ((FunctionalIndexCreationHelper)helper).modifiedIndexExpr;
                this.addnlProjType = ((FunctionalIndexCreationHelper)helper).addnlProjType;
            }
            this.iteratorSize = this.indexInitIterators.size();
        }

        @Override
        public String getIndexedExpression() {
            return AbstractIndex.this.getCanonicalizedIndexedExpression();
        }

        @Override
        public String getProjectionAttributes() {
            return AbstractIndex.this.getCanonicalizedProjectionAttributes();
        }

        @Override
        public String getFromClause() {
            return AbstractIndex.this.getCanonicalizedFromClause();
        }

        @Override
        public void expansion(List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) throws IMQException {
        }

        @Override
        public void evaluate(RegionEntry target, boolean add) throws IMQException {
            assert (add);
            DummyQRegion dQRegion = new DummyQRegion(this.rgn);
            dQRegion.setEntry(target);
            Object[] params = new Object[]{dQRegion};
            ExecutionContext context = new ExecutionContext(params, this.cache);
            context.newScope(-2);
            try {
                boolean computeDependency = true;
                if (this.dependencyGraph != null) {
                    context.setDependencyGraph(this.dependencyGraph);
                    computeDependency = false;
                }
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.fromIterators.get(i);
                    if (computeDependency) {
                        iterDef.computeDependencies(context);
                    }
                    RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                    context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    context.bindIterator(rIter);
                }
                if (this.dependencyGraph == null) {
                    this.dependencyGraph = context.getDependencyGraph();
                }
                Support.Assert(this.indexResultSetType != null, "IMQEvaluator::evaluate:The StrcutType should have been initialized during index creation");
                this.doNestedIterations(0, context);
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                context.popScope();
            }
        }

        @Override
        public void initializeIndex(boolean loadEntries) throws IMQException {
            this.initEntriesUpdated = 0;
            try {
                this.initContext.newScope(1);
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.indexInitIterators.get(i);
                    RuntimeIterator rIter = null;
                    if (!this.hasInitOccurredOnce) {
                        iterDef.computeDependencies(this.initContext);
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                        this.initContext.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    }
                    if (rIter == null) {
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                    }
                    this.initContext.bindIterator(rIter);
                }
                this.hasInitOccurredOnce = true;
                if (this.indexResultSetType == null) {
                    this.indexResultSetType = this.createIndexResultSetType();
                }
                if (loadEntries) {
                    this.doNestedIterationsForIndexInit(0, this.initContext.getCurrentIterators());
                }
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                this.initContext.popScope();
            }
        }

        private void doNestedIterationsForIndexInit(int level, List runtimeIterators) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            if (level == 1) {
                ++this.initEntriesUpdated;
            }
            if (level == this.iteratorSize) {
                this.applyProjectionForIndexInit(runtimeIterators);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)runtimeIterators.get(level);
                SelectResults collection = rIter.evaluateCollection(this.initContext);
                if (collection == null) {
                    return;
                }
                for (Object aCollection : collection) {
                    rIter.setCurrent(aCollection);
                    this.doNestedIterationsForIndexInit(level + 1, runtimeIterators);
                }
            }
        }

        private void applyProjectionForIndexInit(List currrentRuntimeIters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indexKey;
            Object indxResultSet;
            if (QueryMonitor.isLowMemory()) {
                throw new IMQException("Index creation canceled due to low memory");
            }
            NonTXEntry temp = this.isFirstItrOnEntry && this.additionalProj != null ? (NonTXEntry)this.additionalProj.evaluate(this.initContext) : (NonTXEntry)((RuntimeIterator)currrentRuntimeIters.get(0)).evaluate(this.initContext);
            RegionEntry re = temp.getRegionEntry();
            if (this.iteratorSize == 1) {
                indxResultSet = this.isFirstItrOnEntry ? (this.additionalProj == null ? temp : ((RuntimeIterator)currrentRuntimeIters.get(0)).evaluate(this.initContext)) : this.additionalProj.evaluate(this.initContext);
            } else {
                int i;
                Object[] tuple = new Object[this.iteratorSize];
                int n = i = this.isFirstItrOnEntry ? 0 : 1;
                while (i < this.iteratorSize) {
                    RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(i);
                    tuple[i] = iter.evaluate(this.initContext);
                    ++i;
                }
                if (!this.isFirstItrOnEntry) {
                    tuple[0] = this.additionalProj.evaluate(this.initContext);
                }
                Support.Assert(this.indexResultSetType instanceof StructTypeImpl, "The Index ResultType should have been an instance of StructTypeImpl rather than ObjectTypeImpl. The indxeResultType is " + String.valueOf(this.indexResultSetType));
                indxResultSet = new StructImpl((StructTypeImpl)this.indexResultSetType, tuple);
            }
            Object object = indexKey = this.isFirstItrOnEntry ? this.indexedExpr.evaluate(this.initContext) : this.modifiedIndexExpr.evaluate(this.initContext);
            if (!AbstractIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                AbstractIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = AbstractIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            AbstractIndex.this.addMapping(indexKey, indxResultSet, re);
        }

        private void doNestedIterations(int level, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List iterList = context.getCurrentIterators();
            if (level == this.iteratorSize) {
                this.applyProjection(context);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
                SelectResults collection = rIter.evaluateCollection(context);
                if (collection == null) {
                    return;
                }
                for (Object aCollection : collection) {
                    rIter.setCurrent(aCollection);
                    this.doNestedIterations(level + 1, context);
                }
            }
        }

        private void applyProjection(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indxResultSet;
            List currrentRuntimeIters = context.getCurrentIterators();
            Object indexKey = this.indexedExpr.evaluate(context);
            if (!AbstractIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                AbstractIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = AbstractIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            if (this.iteratorSize == 1) {
                RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(0);
                indxResultSet = iter.evaluate(context);
            } else {
                Object[] tuple = new Object[this.iteratorSize];
                for (int i = 0; i < this.iteratorSize; ++i) {
                    RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(i);
                    tuple[i] = iter.evaluate(context);
                }
                Support.Assert(this.indexResultSetType instanceof StructTypeImpl, "The Index ResultType should have been an instance of StructTypeImpl rather than ObjectTypeImpl. The indxeResultType is " + String.valueOf(this.indexResultSetType));
                indxResultSet = new StructImpl((StructTypeImpl)this.indexResultSetType, tuple);
            }
            RegionEntry entry = ((DummyQRegion)context.getBindArgument(1)).getEntry();
            AbstractIndex.this.saveMapping(indexKey, indxResultSet, entry);
        }

        private ObjectType createIndexResultSetType() {
            int start;
            List currentIterators = this.initContext.getCurrentIterators();
            int len = currentIterators.size();
            ObjectType[] fieldTypes = new ObjectType[len];
            int n = start = this.isFirstItrOnEntry ? 0 : 1;
            while (start < len) {
                RuntimeIterator iter = (RuntimeIterator)currentIterators.get(start);
                fieldTypes[start] = iter.getElementType();
                ++start;
            }
            if (!this.isFirstItrOnEntry) {
                fieldTypes[0] = this.addnlProjType;
            }
            return len == 1 ? fieldTypes[0] : new StructTypeImpl(this.canonicalIterNames, fieldTypes);
        }

        @Override
        public ObjectType getIndexResultSetType() {
            return this.indexResultSetType;
        }

        boolean isFirstItrOnEntry() {
            return this.isFirstItrOnEntry;
        }

        boolean isFirstItrOnKey() {
            return this.isFirstItrOnKey;
        }

        @Override
        public List getAllDependentIterators() {
            return this.fromIterators;
        }
    }

    class RegionEntryToValuesMap {
        protected Map map;
        private final boolean useList;
        volatile int numValues;

        RegionEntryToValuesMap(boolean useList) {
            this.map = new ConcurrentHashMap(2, 0.75f, 1);
            this.useList = useList;
        }

        RegionEntryToValuesMap(Map map, boolean useList) {
            this.map = map;
            this.useList = useList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RegionEntry entry, Object value) {
            assert (value != null);
            if (value == null) {
                return;
            }
            Object object = this.map.get(entry);
            if (object == null) {
                this.map.put(entry, value);
            } else if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        coll.add(value);
                    }
                } else {
                    coll.add(value);
                }
            } else {
                AbstractCollection coll = this.useList ? new ArrayList(2) : new IndexConcurrentHashSet(2, 0.75f, 1);
                coll.add(object);
                coll.add(value);
                this.map.put(entry, coll);
            }
            atomicUpdater.incrementAndGet(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAll(RegionEntry entry, Collection values) {
            Object object = this.map.get(entry);
            if (object == null) {
                AbstractCollection coll = this.useList ? new ArrayList(values.size()) : new IndexConcurrentHashSet(values.size(), 0.75f, 1);
                coll.addAll(values);
                this.map.put(entry, coll);
                atomicUpdater.addAndGet(this, values.size());
            } else if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        coll.addAll(values);
                    }
                } else {
                    coll.addAll(values);
                }
            } else {
                AbstractCollection coll = this.useList ? new ArrayList(values.size() + 1) : new IndexConcurrentHashSet(values.size() + 1, 0.75f, 1);
                coll.addAll(values);
                coll.add(object);
                this.map.put(entry, coll);
            }
            atomicUpdater.addAndGet(this, values.size());
        }

        public Object get(RegionEntry entry) {
            return this.map.get(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(RegionEntry entry, Object value) {
            Object object = this.map.get(entry);
            if (object == null) {
                return;
            }
            if (object instanceof Collection) {
                boolean removed;
                Collection coll = (Collection)object;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        removed = coll.remove(value);
                    }
                } else {
                    removed = coll.remove(value);
                }
                if (removed) {
                    if (coll.size() == 0) {
                        this.map.remove(entry);
                    }
                    atomicUpdater.decrementAndGet(this);
                }
            } else {
                if (object.equals(value)) {
                    this.map.remove(entry);
                }
                atomicUpdater.decrementAndGet(this);
            }
        }

        public Object remove(RegionEntry entry) {
            Object retVal = this.map.remove(entry);
            if (retVal != null) {
                atomicUpdater.addAndGet(this, retVal instanceof Collection ? -((Collection)retVal).size() : -1);
            }
            return retVal;
        }

        int getNumValues(RegionEntry entry) {
            Object object = this.map.get(entry);
            if (object == null) {
                return 0;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return coll.size();
            }
            return 1;
        }

        public int getNumValues() {
            return atomicUpdater.get(this);
        }

        public int getNumEntries() {
            return this.map.keySet().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addValuesToCollection(Collection result, int limit, ExecutionContext context) {
            for (Map.Entry o : this.map.entrySet()) {
                QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                if (this.verifyLimit(result, limit, context)) {
                    return;
                }
                Map.Entry e = o;
                Object value = e.getValue();
                assert (value != null);
                RegionEntry re = (RegionEntry)e.getKey();
                boolean reUpdateInProgress = re.isUpdateInProgress();
                if (value instanceof Collection) {
                    if (this.useList) {
                        Object v = value;
                        synchronized (v) {
                            for (Object val : (Iterable)value) {
                                if (!reUpdateInProgress || AbstractIndex.this.verifyEntryAndIndexValue(re, val, context)) {
                                    result.add(val);
                                }
                                if (limit == -1 || result.size() != limit) continue;
                                return;
                            }
                            continue;
                        }
                    }
                    for (Object val : (Iterable)value) {
                        if (!reUpdateInProgress || AbstractIndex.this.verifyEntryAndIndexValue(re, val, context)) {
                            result.add(val);
                        }
                        if (limit == -1 || !this.verifyLimit(result, limit, context)) continue;
                        return;
                    }
                    continue;
                }
                if (reUpdateInProgress && !AbstractIndex.this.verifyEntryAndIndexValue(re, value, context)) continue;
                if (context.isCqQueryContext()) {
                    result.add(new CqEntry(((RegionEntry)e.getKey()).getKey(), value));
                    continue;
                }
                result.add(AbstractIndex.this.verifyAndGetPdxDomainObject(value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addValuesToCollection(Collection result, CompiledValue iterOp, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            if (this.verifyLimit(result, limit, context)) {
                return;
            }
            for (Map.Entry o : this.map.entrySet()) {
                QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                Map.Entry e = o;
                Object value = e.getValue();
                RegionEntry entry = (RegionEntry)e.getKey();
                if (value == null) continue;
                boolean reUpdateInProgress = entry.isUpdateInProgress();
                if (value instanceof Collection) {
                    if (this.useList) {
                        Object v = value;
                        synchronized (v) {
                            for (Object o1 : (Iterable)value) {
                                boolean ok = true;
                                if (reUpdateInProgress) {
                                    ok = AbstractIndex.this.verifyEntryAndIndexValue(entry, o1, context);
                                }
                                if (ok && runtimeItr != null) {
                                    runtimeItr.setCurrent(o1);
                                    ok = QueryUtils.applyCondition(iterOp, context);
                                }
                                if (!ok) continue;
                                AbstractIndex.this.applyProjection(projAttrib, context, result, o1, intermediateResults, isIntersection);
                                if (limit == -1 || result.size() != limit) continue;
                                return;
                            }
                            continue;
                        }
                    }
                    for (Object o1 : (Iterable)value) {
                        boolean ok = true;
                        if (reUpdateInProgress) {
                            ok = AbstractIndex.this.verifyEntryAndIndexValue(entry, o1, context);
                        }
                        if (ok && runtimeItr != null) {
                            runtimeItr.setCurrent(o1);
                            ok = QueryUtils.applyCondition(iterOp, context);
                        }
                        if (!ok) continue;
                        AbstractIndex.this.applyProjection(projAttrib, context, result, o1, intermediateResults, isIntersection);
                        if (!this.verifyLimit(result, limit, context)) continue;
                        return;
                    }
                    continue;
                }
                boolean ok = true;
                if (reUpdateInProgress) {
                    ok = AbstractIndex.this.verifyEntryAndIndexValue(entry, value, context);
                }
                if (ok && runtimeItr != null) {
                    runtimeItr.setCurrent(value);
                    ok = QueryUtils.applyCondition(iterOp, context);
                }
                if (!ok) continue;
                if (context.isCqQueryContext()) {
                    result.add(new CqEntry(((RegionEntry)e.getKey()).getKey(), value));
                    continue;
                }
                AbstractIndex.this.applyProjection(projAttrib, context, result, value, intermediateResults, isIntersection);
            }
        }

        private boolean verifyLimit(Collection result, int limit, ExecutionContext context) {
            if (limit > 0) {
                if (!context.isDistinct()) {
                    return result.size() == limit;
                }
                return result.size() == limit;
            }
            return false;
        }

        public boolean containsEntry(RegionEntry entry) {
            return this.map.containsKey(entry);
        }

        public boolean containsValue(Object value) {
            throw new RuntimeException("Not yet implemented");
        }

        public void clear() {
            this.map.clear();
            atomicUpdater.set(this, 0);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public void replace(RegionEntry entry, Object values) {
            int numOldValues = this.getNumValues(entry);
            this.map.put(entry, values);
            atomicUpdater.addAndGet(this, (values instanceof Collection ? ((Collection)values).size() : 1) - numOldValues);
        }
    }
}

