/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledAddition;
import org.apache.geode.cache.query.internal.CompiledAggregateFunction;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledConstruction;
import org.apache.geode.cache.query.internal.CompiledDivision;
import org.apache.geode.cache.query.internal.CompiledFunction;
import org.apache.geode.cache.query.internal.CompiledGroupBySelect;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIn;
import org.apache.geode.cache.query.internal.CompiledIndexOperation;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledLike;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledMod;
import org.apache.geode.cache.query.internal.CompiledMultiplication;
import org.apache.geode.cache.query.internal.CompiledNegation;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledSubtraction;
import org.apache.geode.cache.query.internal.CompiledUnaryMinus;
import org.apache.geode.cache.query.internal.CompiledUndefined;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.Negatable;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.parse.GemFireAST;
import org.apache.geode.cache.query.internal.parse.OQLLexer;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.parse.OQLParser;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.MapTypeImpl;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.MapType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class QCompiler
implements OQLLexerTokenTypes {
    private static final Logger logger = LogService.getLogger();
    private final Stack<Object> stack = new Stack();
    private final Map<String, String> imports = new HashMap<String, String>();
    private final boolean isForIndexCompilation;
    private boolean traceOn;

    public QCompiler() {
        this.isForIndexCompilation = false;
    }

    public QCompiler(boolean isForIndexCompilation) {
        this.isForIndexCompilation = isForIndexCompilation;
    }

    public CompiledValue compileQuery(String oqlSource) {
        try {
            OQLLexer lexer = new OQLLexer(new StringReader(oqlSource));
            OQLParser parser = new OQLParser(lexer);
            parser.setASTNodeClass("org.apache.geode.cache.query.internal.parse.ASTUnsupported");
            parser.queryProgram();
            GemFireAST n = (GemFireAST)parser.getAST();
            n.compile(this);
        }
        catch (Exception ex) {
            throw new QueryInvalidException(String.format("Syntax error in query: %s", ex.getMessage()), ex);
        }
        Assert.assertTrue(this.stackSize() == 1, "stack size = " + this.stackSize());
        return (CompiledValue)this.pop();
    }

    public List<CompiledIteratorDef> compileFromClause(String fromClause) {
        try {
            OQLLexer lexer = new OQLLexer(new StringReader(fromClause));
            OQLParser parser = new OQLParser(lexer);
            parser.setASTNodeClass("org.apache.geode.cache.query.internal.parse.ASTUnsupported");
            parser.loneFromClause();
            GemFireAST n = (GemFireAST)parser.getAST();
            n.compile(this);
        }
        catch (Exception ex) {
            throw new QueryInvalidException(String.format("Syntax error in query: %s", ex.getMessage()), ex);
        }
        Assert.assertTrue(this.stackSize() == 1, "stack size = " + this.stackSize());
        return (List)this.pop();
    }

    public List<CompiledIteratorDef> compileProjectionAttributes(String projectionAttributes) {
        try {
            OQLLexer lexer = new OQLLexer(new StringReader(projectionAttributes));
            OQLParser parser = new OQLParser(lexer);
            parser.setASTNodeClass("org.apache.geode.cache.query.internal.parse.ASTUnsupported");
            parser.loneProjectionAttributes();
            GemFireAST n = (GemFireAST)parser.getAST();
            if (n.getType() == 17) {
                return null;
            }
            n.compile(this);
        }
        catch (Exception ex) {
            throw new QueryInvalidException(String.format("Syntax error in query: %s", ex.getMessage()), ex);
        }
        Assert.assertTrue(this.stackSize() == 1, "stack size = " + this.stackSize() + ";stack=" + String.valueOf(this.stack));
        return (List)this.pop();
    }

    public void compileOrderByClause(int numOfChildren) {
        ArrayList<CompiledSortCriterion> list = new ArrayList<CompiledSortCriterion>();
        for (int i = 0; i < numOfChildren; ++i) {
            list.add(0, (CompiledSortCriterion)this.pop());
        }
        this.push(list);
    }

    public void compileGroupByClause(int numOfChildren) {
        ArrayList<CompiledPath> list = new ArrayList<CompiledPath>();
        for (int i = 0; i < numOfChildren; ++i) {
            list.add(0, (CompiledPath)this.pop());
        }
        this.push(list);
    }

    public void compileSortCriteria(String sortCriterion) {
        CompiledValue obj = (CompiledValue)this.pop();
        boolean criterion = sortCriterion.equals("desc");
        CompiledSortCriterion csc = new CompiledSortCriterion(criterion, obj);
        this.push(csc);
    }

    public void compileLimit(String limitNum) {
        this.push(Integer.valueOf(limitNum));
    }

    public void compileImports(String imports) {
        try {
            OQLLexer lexer = new OQLLexer(new StringReader(imports));
            OQLParser parser = new OQLParser(lexer);
            parser.setASTNodeClass("org.apache.geode.cache.query.internal.parse.ASTUnsupported");
            parser.loneImports();
            GemFireAST n = (GemFireAST)parser.getAST();
            n.compile(this);
        }
        catch (Exception ex) {
            throw new QueryInvalidException(String.format("Syntax error in query: %s", ex.getMessage()), ex);
        }
        Assert.assertTrue(this.stackSize() == 0, "stack size = " + this.stackSize() + ";stack=" + String.valueOf(this.stack));
    }

    private void checkWhereClauseForAggregates(CompiledValue compiledValue) {
        if (compiledValue instanceof CompiledAggregateFunction) {
            throw new QueryInvalidException("Aggregate functions can not be used as part of the WHERE clause.");
        }
        if (compiledValue instanceof CompiledSelect) {
            return;
        }
        for (Object compiledChildren : compiledValue.getChildren()) {
            this.checkWhereClauseForAggregates((CompiledValue)compiledChildren);
        }
    }

    public void select(Map<Integer, Object> queryComponents) {
        Object limitObject = queryComponents.remove(59);
        AbstractCompiledValue limit = limitObject instanceof Integer ? new CompiledLiteral(limitObject) : (CompiledBindArgument)limitObject;
        List orderByAttrs = (List)queryComponents.remove(86);
        List iterators = (List)queryComponents.remove(77);
        List projAttrs = (List)queryComponents.remove(50);
        if (projAttrs == null) {
            queryComponents.remove(17);
            queryComponents.remove(76);
        }
        String distinct = (String)queryComponents.remove(75);
        List hints = (List)queryComponents.remove(85);
        List groupByClause = (List)queryComponents.remove(82);
        CompiledValue where = null;
        if (queryComponents.size() == 1) {
            where = (CompiledValue)queryComponents.values().iterator().next();
            this.checkWhereClauseForAggregates(where);
        } else if (queryComponents.size() > 1) {
            throw new QueryInvalidException("Unexpected/unsupported query clauses found");
        }
        LinkedHashMap<Integer, CompiledAggregateFunction> aggMap = this.identifyAggregateExpressions(projAttrs);
        boolean isCountOnly = this.checkForCountOnly(aggMap, projAttrs, groupByClause);
        if (isCountOnly) {
            projAttrs = null;
        }
        CompiledSelect select = this.createSelect(distinct != null, isCountOnly, where, iterators, projAttrs, orderByAttrs, limit, hints, groupByClause, aggMap);
        this.push(select);
    }

    private boolean checkForCountOnly(Map<Integer, CompiledAggregateFunction> aggregateMap, List<?> projAttribs, List<CompiledValue> groupBy) {
        if (aggregateMap != null && aggregateMap.size() == 1 && projAttribs.size() == 1 && groupBy == null) {
            for (Map.Entry<Integer, CompiledAggregateFunction> entry : aggregateMap.entrySet()) {
                CompiledAggregateFunction caf = entry.getValue();
                if (caf.getFunctionType() != 64 || caf.getParameter() != null) continue;
                return true;
            }
        }
        return false;
    }

    private CompiledSelect createSelect(boolean isDistinct, boolean isCountOnly, CompiledValue where, List<?> iterators, List<?> projAttrs, List<CompiledSortCriterion> orderByAttrs, CompiledValue limit, List<String> hints, List<CompiledValue> groupByClause, LinkedHashMap<Integer, CompiledAggregateFunction> aggMap) {
        if (isCountOnly || groupByClause == null && aggMap == null || aggMap == null && orderByAttrs == null) {
            return new CompiledSelect(isDistinct, isCountOnly, where, iterators, projAttrs, orderByAttrs, limit, hints, groupByClause);
        }
        return new CompiledGroupBySelect(isDistinct, isCountOnly, where, iterators, projAttrs, orderByAttrs, limit, hints, groupByClause, aggMap);
    }

    private LinkedHashMap<Integer, CompiledAggregateFunction> identifyAggregateExpressions(List<Object[]> projAttribs) {
        if (projAttribs != null) {
            LinkedHashMap<Integer, CompiledAggregateFunction> mapping = new LinkedHashMap<Integer, CompiledAggregateFunction>();
            int index = 0;
            for (Object[] o : projAttribs) {
                CompiledValue proj = (CompiledValue)o[1];
                if (proj.getType() == 61) {
                    mapping.put(index, (CompiledAggregateFunction)proj);
                }
                ++index;
            }
            return mapping.size() == 0 ? null : mapping;
        }
        return null;
    }

    public void projection() {
        CompiledID id = (CompiledID)this.pop();
        CompiledValue expr = (CompiledValue)this.pop();
        this.push(new Object[]{id == null ? null : id.getId(), expr});
    }

    public void aggregateFunction(CompiledValue expr, int aggFuncType, boolean distinctOnly) {
        this.push(new CompiledAggregateFunction(expr, aggFuncType, distinctOnly));
    }

    public void iteratorDef() {
        ObjectType type = this.assembleType();
        CompiledID id = TypeUtils.checkCast(this.pop(), CompiledID.class);
        CompiledValue colln = TypeUtils.checkCast(this.pop(), CompiledValue.class);
        if (type == null) {
            type = TypeUtils.OBJECT_TYPE;
        }
        this.push(new CompiledIteratorDef(id == null ? null : id.getId(), type, colln));
    }

    public void undefinedExpr(boolean is_defined) {
        CompiledValue value = (CompiledValue)this.pop();
        this.push(new CompiledUndefined(value, is_defined));
    }

    public void function(int function, int numOfChildren) {
        CompiledValue[] cvArr = new CompiledValue[numOfChildren];
        for (int i = numOfChildren - 1; i >= 0; --i) {
            cvArr[i] = (CompiledValue)this.pop();
        }
        this.push(new CompiledFunction(cvArr, function));
    }

    public void inExpr() {
        CompiledValue collnExpr = TypeUtils.checkCast(this.pop(), CompiledValue.class);
        CompiledValue elm = TypeUtils.checkCast(this.pop(), CompiledValue.class);
        this.push(new CompiledIn(elm, collnExpr));
    }

    public void constructObject(Class<?> clazz) {
        Assert.assertTrue(clazz == ResultsSet.class);
        List argList = TypeUtils.checkCast(this.pop(), List.class);
        this.push(new CompiledConstruction(clazz, argList));
    }

    public void pushId(String id) {
        this.push(new CompiledID(id));
    }

    public void pushRegion(String regionPath) {
        this.push(new CompiledRegion(regionPath));
    }

    public void appendPathComponent(String id) {
        CompiledValue rcvr = (CompiledValue)this.pop();
        this.push(new CompiledPath(rcvr, id));
    }

    public void pushBindArgument(int i) {
        this.push(new CompiledBindArgument(i));
    }

    public void pushLiteral(Object obj) {
        this.push(new CompiledLiteral(obj));
    }

    public void pushNull() {
        this.push(null);
    }

    public void combine(int num) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < num; ++i) {
            list.add(0, this.pop());
        }
        this.push(list);
    }

    public void methodInvocation() {
        List argList = TypeUtils.checkCast(this.pop(), List.class);
        CompiledID methodName = TypeUtils.checkCast(this.pop(), CompiledID.class);
        CompiledValue rcvr = TypeUtils.checkCast(this.pop(), CompiledValue.class);
        this.push(new CompiledOperation(rcvr, methodName.getId(), argList));
    }

    public void indexOp() {
        Object indexParams = this.pop();
        CompiledValue rcvr = TypeUtils.checkCast(this.pop(), CompiledValue.class);
        CompiledValue indexExpr = CompiledValue.MAP_INDEX_ALL_KEYS;
        if (indexParams != null) {
            List indexList = TypeUtils.checkCast(indexParams, List.class);
            if (!this.isForIndexCompilation && indexList.size() != 1) {
                throw new UnsupportedOperationException("Only one index expression supported");
            }
            if (indexList.size() == 1) {
                indexExpr = TypeUtils.checkCast(indexList.get(0), CompiledValue.class);
                if (indexExpr.getType() == 9) {
                    throw new UnsupportedOperationException("Ranges not supported in index operators");
                }
                indexExpr = TypeUtils.checkCast(indexList.get(0), CompiledValue.class);
                this.push(new CompiledIndexOperation(rcvr, indexExpr));
            } else {
                MapIndexOperation mi = new MapIndexOperation(rcvr, indexList);
                this.push(mi);
            }
        } else {
            if (!this.isForIndexCompilation) {
                throw new QueryInvalidException("Syntax error in query: * use incorrect");
            }
            this.push(new CompiledIndexOperation(rcvr, indexExpr));
        }
    }

    CompiledValue createCompiledValueForLikePredicate(CompiledValue var, CompiledValue patternOrBindParam) {
        if (patternOrBindParam.getType() != 48) {
            CompiledLiteral pattern = (CompiledLiteral)patternOrBindParam;
            if (pattern._obj == null) {
                throw new UnsupportedOperationException("Null values are not supported with LIKE predicate.");
            }
        }
        return new CompiledLike(var, patternOrBindParam);
    }

    public void like() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        CompiledValue cv = this.createCompiledValueForLikePredicate(v1, v2);
        this.push(cv);
    }

    public void compare(int opKind) {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledComparison(v1, v2, opKind));
    }

    public void mod() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledMod(v1, v2));
    }

    public void arithmetic(int opKind) {
        switch (opKind) {
            case 14: {
                this.addition();
                break;
            }
            case 15: {
                this.subtraction();
                break;
            }
            case 16: {
                this.division();
                break;
            }
            case 17: {
                this.multiplication();
                break;
            }
            case 27: 
            case 100: {
                this.mod();
            }
        }
    }

    private void addition() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledAddition(v1, v2));
    }

    private void subtraction() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledSubtraction(v1, v2));
    }

    private void division() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledDivision(v1, v2));
    }

    private void multiplication() {
        CompiledValue v2 = (CompiledValue)this.pop();
        CompiledValue v1 = (CompiledValue)this.pop();
        this.push(new CompiledMultiplication(v1, v2));
    }

    public void or(int numTerms) {
        this.junction(numTerms, 89);
    }

    public void and(int numTerms) {
        this.junction(numTerms, 91);
    }

    private void junction(int numTerms, int operator) {
        ArrayList<CompiledValue> operands = new ArrayList<CompiledValue>(numTerms);
        for (int i = 0; i < numTerms; ++i) {
            CompiledValue operand = (CompiledValue)this.pop();
            if (operand instanceof CompiledJunction && ((CompiledJunction)operand).getOperator() == operator) {
                CompiledJunction junction = (CompiledJunction)operand;
                List<CompiledValue> jOperands = junction.getOperands();
                operands.addAll(jOperands);
                continue;
            }
            operands.add(operand);
        }
        this.push(new CompiledJunction(operands.toArray(new CompiledValue[0]), operator));
    }

    public void not() {
        Object obj = this.stack.peek();
        Assert.assertTrue(obj instanceof CompiledValue);
        if (obj instanceof Negatable) {
            ((Negatable)obj).negate();
        } else {
            this.push(new CompiledNegation((CompiledValue)this.pop()));
        }
    }

    public void unaryMinus() {
        Object obj = this.stack.peek();
        Assert.assertTrue(obj instanceof CompiledValue);
        this.push(new CompiledUnaryMinus((CompiledValue)this.pop()));
    }

    public void typecast() {
        AbstractCompiledValue cmpVal = TypeUtils.checkCast(this.pop(), AbstractCompiledValue.class);
        ObjectType objType = this.assembleType();
        cmpVal.setTypecast(objType);
        this.push(cmpVal);
    }

    public ObjectType assembleType() {
        ObjectType objType = TypeUtils.checkCast(this.pop(), ObjectType.class);
        if (objType instanceof CollectionType) {
            ObjectType elementType = this.assembleType();
            if (objType instanceof MapType) {
                ObjectType keyType = this.assembleType();
                return new MapTypeImpl(objType.resolveClass(), keyType, elementType);
            }
            return new CollectionTypeImpl(objType.resolveClass(), elementType);
        }
        return objType;
    }

    public void traceRequest() {
        this.traceOn = true;
    }

    public boolean isTraceRequested() {
        return this.traceOn;
    }

    public void setHint(int numOfChildren) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < numOfChildren; ++i) {
            list.add(0, (String)this.pop());
        }
        this.push(list);
    }

    public void setHintIdentifier(String text) {
        this.push(text);
    }

    public void importName(String qualifiedName, String asName) {
        if (asName == null) {
            int idx = qualifiedName.lastIndexOf(46);
            asName = idx >= 0 ? qualifiedName.substring(idx + 1) : qualifiedName;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("QCompiler.importName: {},{}", (Object)asName, (Object)qualifiedName);
        }
        this.imports.put(asName, qualifiedName);
    }

    public <T> T pop() {
        Object obj = this.stack.pop();
        if (logger.isTraceEnabled()) {
            logger.trace("QCompiler.pop: {}", obj);
        }
        return (T)obj;
    }

    public <T> void push(T obj) {
        if (logger.isTraceEnabled()) {
            logger.trace("QCompiler.push: {}", obj);
        }
        this.stack.push(obj);
    }

    public int stackSize() {
        return this.stack.size();
    }

    public ObjectType resolveType(String typeName) {
        Class resultClass;
        if (typeName == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("QCompiler.resolveType= {}", (Object)Object.class.getName());
            }
            return TypeUtils.OBJECT_TYPE;
        }
        String as = this.imports.get(typeName);
        if (as != null) {
            typeName = as;
        }
        try {
            resultClass = InternalDataSerializer.getCachedClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new QueryInvalidException(String.format("Type not found: %s", typeName), e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("QCompiler.resolveType= {}", (Object)resultClass.getName());
        }
        return new ObjectTypeImpl(resultClass);
    }

    private static class MapIndexOperation
    extends AbstractCompiledValue
    implements MapIndexable {
        private final CompiledValue rcvr;
        private final List<CompiledValue> indexList;

        public MapIndexOperation(CompiledValue rcvr, List<CompiledValue> indexList) {
            this.rcvr = rcvr;
            this.indexList = indexList;
        }

        @Override
        public CompiledValue getReceiverSansIndexArgs() {
            return this.rcvr;
        }

        @Override
        public CompiledValue getMapLookupKey() {
            throw new UnsupportedOperationException("Function invocation not expected");
        }

        @Override
        public List<CompiledValue> getIndexingKeys() {
            return this.indexList;
        }

        @Override
        public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException("Method execution not expected");
        }

        @Override
        public int getType() {
            throw new UnsupportedOperationException("Method execution not expected");
        }
    }
}

