/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.ObjectType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.configuration.RegionType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="region-type", namespace="http://geode.apache.org/schema/cache", propOrder={"regionAttributes", "indexes", "entries", "regionElements", "regions"})
@Experimental
public class RegionConfig
implements Identifiable<String>,
Serializable {
    @XmlElement(name="region-attributes", namespace="http://geode.apache.org/schema/cache")
    protected RegionAttributesType regionAttributes;
    @XmlElement(name="index", namespace="http://geode.apache.org/schema/cache")
    protected List<Index> indexes;
    @XmlElement(name="entry", namespace="http://geode.apache.org/schema/cache")
    protected List<Entry> entries;
    @XmlAnyElement(lax=true)
    protected List<CacheElement> regionElements;
    @XmlElement(name="region", namespace="http://geode.apache.org/schema/cache")
    protected List<RegionConfig> regions;
    @XmlAttribute(name="name", required=true)
    protected String name;
    @XmlAttribute(name="refid")
    protected String type;

    public RegionConfig() {
    }

    public RegionConfig(String name, String refid) {
        this.name = name;
        this.type = refid;
    }

    public RegionAttributesType getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setRegionAttributes(RegionAttributesType regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    public List<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        return this.indexes;
    }

    public List<Entry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        return this.entries;
    }

    public List<CacheElement> getCustomRegionElements() {
        if (this.regionElements == null) {
            this.regionElements = new ArrayList<CacheElement>();
        }
        return this.regionElements;
    }

    public List<RegionConfig> getRegions() {
        if (this.regions == null) {
            this.regions = new ArrayList<RegionConfig>();
        }
        return this.regions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        this.name = value.startsWith("/") ? value.substring(1) : value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(RegionType regionType) {
        if (regionType != null) {
            this.setType(regionType.name());
        }
    }

    public void setType(String regionType) {
        if (regionType != null) {
            this.type = regionType.toUpperCase();
        }
    }

    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Index
    implements Identifiable<String> {
        @XmlAttribute(name="name", required=true)
        protected String name;
        @XmlAttribute(name="expression")
        protected String expression;
        @XmlAttribute(name="from-clause")
        protected String fromClause;
        @XmlAttribute(name="imports")
        protected String imports;
        @XmlAttribute(name="key-index")
        protected Boolean keyIndex;
        @XmlAttribute(name="type")
        protected String type;

        public Index() {
        }

        public Index(Index index) {
            this.name = index.name;
            this.expression = index.expression;
            this.fromClause = index.fromClause;
            this.imports = index.imports;
            this.keyIndex = index.keyIndex;
            this.type = index.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String value) {
            this.expression = value;
        }

        public String getFromClause() {
            return this.fromClause;
        }

        public void setFromClause(String value) {
            this.fromClause = value;
        }

        public String getImports() {
            return this.imports;
        }

        public void setImports(String value) {
            this.imports = value;
        }

        public Boolean isKeyIndex() {
            return this.keyIndex;
        }

        public void setKeyIndex(Boolean value) {
            this.keyIndex = value;
        }

        public String getType() {
            if (this.keyIndex == Boolean.TRUE) {
                return "key";
            }
            if (this.type == null) {
                return "range";
            }
            return this.type;
        }

        public void setType(String type) {
            if ("range".equalsIgnoreCase(type) || "hash".equalsIgnoreCase(type)) {
                this.type = type.toLowerCase();
                this.setKeyIndex(false);
            } else if ("key".equalsIgnoreCase(type)) {
                this.type = null;
                this.setKeyIndex(true);
            } else {
                throw new IllegalArgumentException("Invalid index type " + type);
            }
        }

        @JsonIgnore
        public String getId() {
            return this.getName();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"key", "value"})
    public static class Entry
    implements Serializable {
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType key;
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType value;

        public Entry() {
        }

        public Entry(String key, String value) {
            this.key = new ObjectType(key);
            this.value = new ObjectType(value);
        }

        public Entry(ObjectType key, ObjectType value) {
            this.key = key;
            this.value = value;
        }

        public ObjectType getKey() {
            return this.key;
        }

        public void setKey(ObjectType value) {
            this.key = value;
        }

        public ObjectType getValue() {
            return this.value;
        }

        public void setValue(ObjectType value) {
            this.value = value;
        }
    }
}

