/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.DiskDirsType;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.RegionAttributesDataPolicy;
import org.apache.geode.cache.configuration.RegionAttributesIndexUpdateType;
import org.apache.geode.cache.configuration.RegionAttributesMirrorType;
import org.apache.geode.cache.configuration.RegionAttributesScope;
import org.apache.geode.management.configuration.ClassName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="region-attributes-type", namespace="http://geode.apache.org/schema/cache", propOrder={"keyConstraint", "valueConstraint", "regionTimeToLive", "regionIdleTime", "entryTimeToLive", "entryIdleTime", "diskWriteAttributes", "diskDirs", "partitionAttributes", "membershipAttributes", "subscriptionAttributes", "cacheLoader", "cacheWriter", "cacheListeners", "compressor", "evictionAttributes"})
@Experimental
public class RegionAttributesType
implements Serializable {
    @XmlElement(name="key-constraint", namespace="http://geode.apache.org/schema/cache")
    protected String keyConstraint;
    @XmlElement(name="value-constraint", namespace="http://geode.apache.org/schema/cache")
    protected String valueConstraint;
    @XmlElement(name="region-time-to-live", namespace="http://geode.apache.org/schema/cache")
    protected ExpirationAttributesType regionTimeToLive;
    @XmlElement(name="region-idle-time", namespace="http://geode.apache.org/schema/cache")
    protected ExpirationAttributesType regionIdleTime;
    @XmlElement(name="entry-time-to-live", namespace="http://geode.apache.org/schema/cache")
    protected ExpirationAttributesType entryTimeToLive;
    @XmlElement(name="entry-idle-time", namespace="http://geode.apache.org/schema/cache")
    protected ExpirationAttributesType entryIdleTime;
    @XmlElement(name="disk-write-attributes", namespace="http://geode.apache.org/schema/cache")
    protected DiskWriteAttributes diskWriteAttributes;
    @XmlElement(name="disk-dirs", namespace="http://geode.apache.org/schema/cache")
    protected DiskDirsType diskDirs;
    @XmlElement(name="partition-attributes", namespace="http://geode.apache.org/schema/cache")
    protected PartitionAttributes partitionAttributes;
    @XmlElement(name="membership-attributes", namespace="http://geode.apache.org/schema/cache")
    protected MembershipAttributes membershipAttributes;
    @XmlElement(name="subscription-attributes", namespace="http://geode.apache.org/schema/cache")
    protected SubscriptionAttributes subscriptionAttributes;
    @XmlElement(name="cache-loader", namespace="http://geode.apache.org/schema/cache")
    protected DeclarableType cacheLoader;
    @XmlElement(name="cache-writer", namespace="http://geode.apache.org/schema/cache")
    protected DeclarableType cacheWriter;
    @XmlElement(name="cache-listener", namespace="http://geode.apache.org/schema/cache")
    protected List<DeclarableType> cacheListeners;
    @XmlElement(namespace="http://geode.apache.org/schema/cache")
    protected ClassNameType compressor;
    @XmlElement(name="eviction-attributes", namespace="http://geode.apache.org/schema/cache")
    protected EvictionAttributes evictionAttributes;
    @XmlAttribute(name="concurrency-level")
    protected String concurrencyLevel;
    @XmlAttribute(name="data-policy")
    protected RegionAttributesDataPolicy dataPolicy;
    @XmlAttribute(name="early-ack")
    protected Boolean earlyAck;
    @XmlAttribute(name="enable-async-conflation")
    protected Boolean enableAsyncConflation;
    @XmlAttribute(name="enable-gateway")
    protected Boolean enableGateway;
    @XmlAttribute(name="enable-subscription-conflation")
    protected Boolean enableSubscriptionConflation;
    @XmlAttribute(name="gateway-sender-ids")
    protected String gatewaySenderIds;
    @XmlAttribute(name="async-event-queue-ids")
    protected String asyncEventQueueIds;
    @XmlAttribute(name="hub-id")
    protected String hubId;
    @XmlAttribute(name="id")
    protected String id;
    @XmlAttribute(name="ignore-jta")
    protected Boolean ignoreJta;
    @XmlAttribute(name="index-update-type")
    protected RegionAttributesIndexUpdateType indexUpdateType;
    @XmlAttribute(name="initial-capacity")
    protected String initialCapacity;
    @XmlAttribute(name="is-lock-grantor")
    protected Boolean isLockGrantor;
    @XmlAttribute(name="load-factor")
    protected String loadFactor;
    @XmlAttribute(name="mirror-type")
    protected RegionAttributesMirrorType mirrorType;
    @XmlAttribute(name="multicast-enabled")
    protected Boolean multicastEnabled;
    @XmlAttribute(name="persist-backup")
    protected Boolean persistBackup;
    @XmlAttribute(name="pool-name")
    protected String poolName;
    @XmlAttribute(name="disk-store-name")
    protected String diskStoreName;
    @XmlAttribute(name="disk-synchronous")
    protected Boolean diskSynchronous;
    @XmlAttribute(name="publisher")
    protected Boolean publisher;
    @XmlAttribute(name="refid")
    protected String refid;
    @XmlAttribute(name="scope")
    protected RegionAttributesScope scope;
    @XmlAttribute(name="statistics-enabled")
    protected Boolean statisticsEnabled;
    @XmlAttribute(name="cloning-enabled")
    protected Boolean cloningEnabled;
    @XmlAttribute(name="concurrency-checks-enabled")
    protected Boolean concurrencyChecksEnabled;
    @XmlAttribute(name="off-heap")
    protected Boolean offHeap;

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setKeyConstraint(String value) {
        this.keyConstraint = value;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(String value) {
        this.valueConstraint = value;
    }

    public ExpirationAttributesType getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    public void setRegionTimeToLive(ExpirationAttributesType value) {
        this.regionTimeToLive = value;
    }

    public void updateRegionTimeToLive(Integer timeout, String action, ClassName expiry) {
        this.regionTimeToLive = ExpirationAttributesType.combine(this.regionTimeToLive, ExpirationAttributesType.generate(timeout, action, expiry));
    }

    public ExpirationAttributesType getRegionIdleTime() {
        return this.regionIdleTime;
    }

    public void setRegionIdleTime(ExpirationAttributesType value) {
        this.regionIdleTime = value;
    }

    public void updateRegionIdleTime(Integer timeout, String action, ClassName expiry) {
        this.regionIdleTime = ExpirationAttributesType.combine(this.regionIdleTime, ExpirationAttributesType.generate(timeout, action, expiry));
    }

    public ExpirationAttributesType getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    public void setEntryTimeToLive(ExpirationAttributesType value) {
        this.entryTimeToLive = value;
    }

    public void updateEntryTimeToLive(Integer timeout, String action, ClassName expiry) {
        this.entryTimeToLive = ExpirationAttributesType.combine(this.entryTimeToLive, ExpirationAttributesType.generate(timeout, action, expiry));
    }

    public ExpirationAttributesType getEntryIdleTime() {
        return this.entryIdleTime;
    }

    public void setEntryIdleTime(ExpirationAttributesType value) {
        this.entryIdleTime = value;
    }

    public void updateEntryIdleTime(Integer timeout, String action, ClassName expiry) {
        this.entryIdleTime = ExpirationAttributesType.combine(this.entryIdleTime, ExpirationAttributesType.generate(timeout, action, expiry));
    }

    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.diskWriteAttributes;
    }

    public void setDiskWriteAttributes(DiskWriteAttributes value) {
        this.diskWriteAttributes = value;
    }

    public DiskDirsType getDiskDirs() {
        return this.diskDirs;
    }

    public void setDiskDirs(DiskDirsType value) {
        this.diskDirs = value;
    }

    public PartitionAttributes getPartitionAttributes() {
        return this.partitionAttributes;
    }

    public void setPartitionAttributes(PartitionAttributes value) {
        this.partitionAttributes = value;
    }

    public MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    public void setMembershipAttributes(MembershipAttributes value) {
        this.membershipAttributes = value;
    }

    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    public void setSubscriptionAttributes(SubscriptionAttributes value) {
        this.subscriptionAttributes = value;
    }

    public DeclarableType getCacheLoader() {
        return this.cacheLoader;
    }

    public void setCacheLoader(DeclarableType value) {
        this.cacheLoader = value;
    }

    public DeclarableType getCacheWriter() {
        return this.cacheWriter;
    }

    public void setCacheWriter(DeclarableType value) {
        this.cacheWriter = value;
    }

    public List<DeclarableType> getCacheListeners() {
        if (this.cacheListeners == null) {
            this.cacheListeners = new ArrayList<DeclarableType>();
        }
        return this.cacheListeners;
    }

    public ClassNameType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(ClassNameType value) {
        this.compressor = value;
    }

    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    public void setEvictionAttributes(EvictionAttributes value) {
        this.evictionAttributes = value;
    }

    public String getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setConcurrencyLevel(String value) {
        this.concurrencyLevel = value;
    }

    public RegionAttributesDataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public void setDataPolicy(RegionAttributesDataPolicy value) {
        this.dataPolicy = value;
    }

    public Boolean isEarlyAck() {
        return this.earlyAck;
    }

    public void setEarlyAck(Boolean value) {
        this.earlyAck = value;
    }

    public Boolean isEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    public void setEnableAsyncConflation(Boolean value) {
        this.enableAsyncConflation = value;
    }

    public Boolean isEnableGateway() {
        return this.enableGateway;
    }

    public void setEnableGateway(Boolean value) {
        this.enableGateway = value;
    }

    public Boolean isEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    public void setEnableSubscriptionConflation(Boolean value) {
        this.enableSubscriptionConflation = value;
    }

    public String getGatewaySenderIds() {
        return this.gatewaySenderIds;
    }

    @JsonIgnore
    public Set<String> getGatewaySenderIdsAsSet() {
        if (this.gatewaySenderIds == null) {
            return null;
        }
        return Arrays.stream(this.gatewaySenderIds.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public void setGatewaySenderIds(String value) {
        this.gatewaySenderIds = value;
    }

    public String getAsyncEventQueueIds() {
        return this.asyncEventQueueIds;
    }

    @JsonIgnore
    public Set<String> getAsyncEventQueueIdsAsSet() {
        if (this.asyncEventQueueIds == null) {
            return null;
        }
        return Arrays.stream(this.asyncEventQueueIds.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public void setAsyncEventQueueIds(String value) {
        this.asyncEventQueueIds = value;
    }

    public String getHubId() {
        return this.hubId;
    }

    public void setHubId(String value) {
        this.hubId = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Boolean isIgnoreJta() {
        return this.ignoreJta;
    }

    public void setIgnoreJta(Boolean value) {
        this.ignoreJta = value;
    }

    public RegionAttributesIndexUpdateType getIndexUpdateType() {
        return this.indexUpdateType;
    }

    public void setIndexUpdateType(RegionAttributesIndexUpdateType value) {
        this.indexUpdateType = value;
    }

    public String getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(String value) {
        this.initialCapacity = value;
    }

    public Boolean isIsLockGrantor() {
        return this.isLockGrantor;
    }

    public void setIsLockGrantor(Boolean value) {
        this.isLockGrantor = value;
    }

    public String getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(String value) {
        this.loadFactor = value;
    }

    public RegionAttributesMirrorType getMirrorType() {
        return this.mirrorType;
    }

    public void setMirrorType(RegionAttributesMirrorType value) {
        this.mirrorType = value;
    }

    public Boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public void setMulticastEnabled(Boolean value) {
        this.multicastEnabled = value;
    }

    public Boolean isPersistBackup() {
        return this.persistBackup;
    }

    public void setPersistBackup(Boolean value) {
        this.persistBackup = value;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String value) {
        this.poolName = value;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setDiskStoreName(String value) {
        this.diskStoreName = value;
    }

    public Boolean isDiskSynchronous() {
        return this.diskSynchronous;
    }

    public void setDiskSynchronous(Boolean value) {
        this.diskSynchronous = value;
    }

    public Boolean isPublisher() {
        return this.publisher;
    }

    public void setPublisher(Boolean value) {
        this.publisher = value;
    }

    public String getRefid() {
        return this.refid;
    }

    public void setRefid(String value) {
        this.refid = value;
    }

    public RegionAttributesScope getScope() {
        return this.scope;
    }

    public void setScope(RegionAttributesScope value) {
        this.scope = value;
    }

    public Boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(Boolean value) {
        this.statisticsEnabled = value;
    }

    public Boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCloningEnabled(Boolean value) {
        this.cloningEnabled = value;
    }

    public boolean isConcurrencyChecksEnabled() {
        if (this.concurrencyChecksEnabled == null) {
            return true;
        }
        return this.concurrencyChecksEnabled;
    }

    public void setConcurrencyChecksEnabled(Boolean value) {
        this.concurrencyChecksEnabled = value;
    }

    public Boolean isOffHeap() {
        return this.offHeap;
    }

    public void setOffHeap(Boolean value) {
        this.offHeap = value;
    }

    public void setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow action) {
        if (this.evictionAttributes == null) {
            this.evictionAttributes = new EvictionAttributes();
        }
        EvictionAttributes.LruHeapPercentage lruHeapPercentage = new EvictionAttributes.LruHeapPercentage();
        lruHeapPercentage.setAction(action);
        this.evictionAttributes.setLruHeapPercentage(lruHeapPercentage);
    }

    public void setInterestPolicy(String interestPolicy) {
        if (this.subscriptionAttributes == null) {
            this.subscriptionAttributes = new SubscriptionAttributes();
        }
        this.subscriptionAttributes.setInterestPolicy(interestPolicy);
    }

    public void setRedundantCopy(String copies) {
        if (this.partitionAttributes == null) {
            this.partitionAttributes = new PartitionAttributes();
        }
        this.partitionAttributes.setRedundantCopies(copies);
    }

    public void setLocalMaxMemory(String maxMemory) {
        if (this.partitionAttributes == null) {
            this.partitionAttributes = new PartitionAttributes();
        }
        this.partitionAttributes.setLocalMaxMemory(maxMemory);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"expirationAttributes"})
    public static class ExpirationAttributesType
    implements Serializable {
        @XmlElement(name="expiration-attributes", namespace="http://geode.apache.org/schema/cache", required=true)
        protected ExpirationAttributesDetail expirationAttributes = new ExpirationAttributesDetail();

        public ExpirationAttributesType() {
        }

        public ExpirationAttributesType(Integer timeout, String action, String expiry, Properties iniProps) {
            this.expirationAttributes.setTimeout(Objects.toString(timeout, null));
            if (action != null) {
                this.expirationAttributes.setAction(action);
            }
            if (expiry != null) {
                this.expirationAttributes.setCustomExpiry(new DeclarableType(expiry, iniProps));
            }
        }

        public static ExpirationAttributesType generate(Integer timeout, String action, ClassName expiry) {
            if (timeout == null && action == null && expiry == null) {
                return null;
            }
            if (expiry != null) {
                return new ExpirationAttributesType(timeout, action, expiry.getClassName(), expiry.getInitProperties());
            }
            return new ExpirationAttributesType(timeout, action, null, null);
        }

        public static ExpirationAttributesType combine(ExpirationAttributesType existing, ExpirationAttributesType delta) {
            if (delta == null) {
                return existing;
            }
            if (existing == null) {
                existing = new ExpirationAttributesType();
                existing.setAction("invalidate");
                existing.setTimeout("0");
            }
            if (delta.getTimeout() != null) {
                existing.setTimeout(delta.getTimeout());
            }
            if (delta.getAction() != null) {
                existing.setAction(delta.getAction());
            }
            if (delta.getCustomExpiry() != null) {
                if (delta.getCustomExpiry().equals(DeclarableType.EMPTY)) {
                    existing.setCustomExpiry(null);
                } else {
                    existing.setCustomExpiry(delta.getCustomExpiry());
                }
            }
            return existing;
        }

        public boolean hasTimoutOrAction() {
            return this.getTimeout() != null || this.getAction() != null;
        }

        public boolean hasCustomExpiry() {
            return this.getCustomExpiry() != null;
        }

        public DeclarableType getCustomExpiry() {
            return this.expirationAttributes.getCustomExpiry();
        }

        public void setCustomExpiry(DeclarableType value) {
            this.expirationAttributes.setCustomExpiry(value);
        }

        public String getAction() {
            return this.expirationAttributes.getAction();
        }

        public void setAction(String value) {
            this.expirationAttributes.setAction(value);
        }

        public String getTimeout() {
            return this.expirationAttributes.getTimeout();
        }

        public void setTimeout(String value) {
            this.expirationAttributes.setTimeout(value);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"asynchronousWrites", "synchronousWrites"})
    public static class DiskWriteAttributes
    implements Serializable {
        @XmlElement(name="asynchronous-writes", namespace="http://geode.apache.org/schema/cache")
        protected AsynchronousWrites asynchronousWrites;
        @XmlElement(name="synchronous-writes", namespace="http://geode.apache.org/schema/cache")
        protected Object synchronousWrites;
        @XmlAttribute(name="max-oplog-size")
        protected String maxOplogSize;
        @XmlAttribute(name="roll-oplogs")
        protected String rollOplogs;

        public AsynchronousWrites getAsynchronousWrites() {
            return this.asynchronousWrites;
        }

        public void setAsynchronousWrites(AsynchronousWrites value) {
            this.asynchronousWrites = value;
        }

        public Object getSynchronousWrites() {
            return this.synchronousWrites;
        }

        public void setSynchronousWrites(Object value) {
            this.synchronousWrites = value;
        }

        public String getMaxOplogSize() {
            return this.maxOplogSize;
        }

        public void setMaxOplogSize(String value) {
            this.maxOplogSize = value;
        }

        public String getRollOplogs() {
            return this.rollOplogs;
        }

        public void setRollOplogs(String value) {
            this.rollOplogs = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class AsynchronousWrites {
            @XmlAttribute(name="bytes-threshold", required=true)
            protected String bytesThreshold;
            @XmlAttribute(name="time-interval", required=true)
            protected String timeInterval;

            public String getBytesThreshold() {
                return this.bytesThreshold;
            }

            public void setBytesThreshold(String value) {
                this.bytesThreshold = value;
            }

            public String getTimeInterval() {
                return this.timeInterval;
            }

            public void setTimeInterval(String value) {
                this.timeInterval = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"partitionResolver", "partitionListeners", "fixedPartitionAttributes"})
    public static class PartitionAttributes
    implements Serializable {
        @XmlElement(name="partition-resolver", namespace="http://geode.apache.org/schema/cache")
        protected DeclarableType partitionResolver;
        @XmlElement(name="partition-listener", namespace="http://geode.apache.org/schema/cache")
        protected List<DeclarableType> partitionListeners;
        @XmlElement(name="fixed-partition-attributes", namespace="http://geode.apache.org/schema/cache")
        protected List<FixedPartitionAttributes> fixedPartitionAttributes;
        @XmlAttribute(name="local-max-memory")
        protected String localMaxMemory;
        @XmlAttribute(name="recovery-delay")
        protected String recoveryDelay;
        @XmlAttribute(name="redundant-copies")
        protected String redundantCopies;
        @XmlAttribute(name="startup-recovery-delay")
        protected String startupRecoveryDelay;
        @XmlAttribute(name="total-max-memory")
        protected String totalMaxMemory;
        @XmlAttribute(name="total-num-buckets")
        protected String totalNumBuckets;
        @XmlAttribute(name="colocated-with")
        protected String colocatedWith;

        public static PartitionAttributes generate(String partitionResolver, List<String> partitionListeners, Integer localMaxMemory, Long recoveryDelay, Integer redundantCopies, Long startupRecoveryDelay, Long totalMaxMemory, Integer totalNumBuckets, String colocatedWith) {
            if (partitionResolver == null && (partitionListeners == null || partitionListeners.isEmpty()) && localMaxMemory == null && recoveryDelay == null && redundantCopies == null && startupRecoveryDelay == null && totalMaxMemory == null && totalNumBuckets == null && colocatedWith == null) {
                return null;
            }
            PartitionAttributes partitionAttributes = new PartitionAttributes();
            partitionAttributes.setColocatedWith(colocatedWith);
            partitionAttributes.setLocalMaxMemory(Objects.toString(localMaxMemory, null));
            partitionAttributes.setTotalMaxMemory(Objects.toString(totalMaxMemory, null));
            partitionAttributes.setRecoveryDelay(Objects.toString(recoveryDelay, null));
            partitionAttributes.setRedundantCopies(Objects.toString(redundantCopies, null));
            partitionAttributes.setStartupRecoveryDelay(Objects.toString(startupRecoveryDelay, null));
            partitionAttributes.setTotalNumBuckets(Objects.toString(totalNumBuckets, null));
            if (partitionResolver != null) {
                partitionAttributes.setPartitionResolver(new DeclarableType(partitionResolver));
            }
            if (partitionListeners != null) {
                partitionListeners.stream().map(DeclarableType::new).forEach(partitionAttributes.getPartitionListeners()::add);
            }
            return partitionAttributes;
        }

        public static PartitionAttributes combine(PartitionAttributes existing, PartitionAttributes delta) {
            if (existing == null) {
                return delta;
            }
            if (delta == null) {
                return existing;
            }
            if (delta.getRedundantCopies() != null) {
                existing.setRedundantCopies(delta.getRedundantCopies());
            }
            if (delta.getPartitionListeners() != null) {
                existing.getPartitionListeners().clear();
                existing.getPartitionListeners().addAll(delta.getPartitionListeners());
            }
            if (delta.getColocatedWith() != null) {
                existing.setColocatedWith(delta.getColocatedWith());
            }
            if (delta.getLocalMaxMemory() != null) {
                existing.setLocalMaxMemory(delta.getLocalMaxMemory());
            }
            if (delta.getPartitionResolver() != null) {
                existing.setPartitionResolver(delta.getPartitionResolver());
            }
            if (delta.getRecoveryDelay() != null) {
                existing.setRecoveryDelay(delta.getRecoveryDelay());
            }
            if (delta.getStartupRecoveryDelay() != null) {
                existing.setStartupRecoveryDelay(delta.getStartupRecoveryDelay());
            }
            if (delta.getTotalMaxMemory() != null) {
                existing.setTotalMaxMemory(delta.getTotalMaxMemory());
            }
            if (delta.getTotalNumBuckets() != null) {
                existing.setTotalNumBuckets(delta.getTotalNumBuckets());
            }
            if (delta.getFixedPartitionAttributes() != null) {
                existing.getFixedPartitionAttributes().clear();
                existing.getFixedPartitionAttributes().addAll(delta.getFixedPartitionAttributes());
            }
            return existing;
        }

        public DeclarableType getPartitionResolver() {
            return this.partitionResolver;
        }

        public void setPartitionResolver(DeclarableType value) {
            this.partitionResolver = value;
        }

        public List<DeclarableType> getPartitionListeners() {
            if (this.partitionListeners == null) {
                this.partitionListeners = new ArrayList<DeclarableType>();
            }
            return this.partitionListeners;
        }

        public List<FixedPartitionAttributes> getFixedPartitionAttributes() {
            if (this.fixedPartitionAttributes == null) {
                this.fixedPartitionAttributes = new ArrayList<FixedPartitionAttributes>();
            }
            return this.fixedPartitionAttributes;
        }

        public String getLocalMaxMemory() {
            return this.localMaxMemory;
        }

        public void setLocalMaxMemory(String value) {
            this.localMaxMemory = value;
        }

        public String getRecoveryDelay() {
            return this.recoveryDelay;
        }

        public void setRecoveryDelay(String value) {
            this.recoveryDelay = value;
        }

        public String getRedundantCopies() {
            return this.redundantCopies;
        }

        public void setRedundantCopies(String value) {
            this.redundantCopies = value;
        }

        public String getStartupRecoveryDelay() {
            return this.startupRecoveryDelay;
        }

        public void setStartupRecoveryDelay(String value) {
            this.startupRecoveryDelay = value;
        }

        public String getTotalMaxMemory() {
            return this.totalMaxMemory;
        }

        public void setTotalMaxMemory(String value) {
            this.totalMaxMemory = value;
        }

        public String getTotalNumBuckets() {
            return this.totalNumBuckets;
        }

        public void setTotalNumBuckets(String value) {
            this.totalNumBuckets = value;
        }

        public String getColocatedWith() {
            return this.colocatedWith;
        }

        public void setColocatedWith(String value) {
            this.colocatedWith = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class FixedPartitionAttributes {
            @XmlAttribute(name="partition-name", required=true)
            protected String partitionName;
            @XmlAttribute(name="is-primary")
            protected Boolean isPrimary;
            @XmlAttribute(name="num-buckets")
            protected String numBuckets;

            public String getPartitionName() {
                return this.partitionName;
            }

            public void setPartitionName(String value) {
                this.partitionName = value;
            }

            public Boolean isIsPrimary() {
                return this.isPrimary;
            }

            public void setIsPrimary(Boolean value) {
                this.isPrimary = value;
            }

            public String getNumBuckets() {
                return this.numBuckets;
            }

            public void setNumBuckets(String value) {
                this.numBuckets = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"requiredRoles"})
    public static class MembershipAttributes
    implements Serializable {
        @XmlElement(name="required-role", namespace="http://geode.apache.org/schema/cache")
        protected List<RequiredRole> requiredRoles;
        @XmlAttribute(name="loss-action")
        protected String lossAction;
        @XmlAttribute(name="resumption-action")
        protected String resumptionAction;

        public List<RequiredRole> getRequiredRoles() {
            if (this.requiredRoles == null) {
                this.requiredRoles = new ArrayList<RequiredRole>();
            }
            return this.requiredRoles;
        }

        public String getLossAction() {
            return this.lossAction;
        }

        public void setLossAction(String value) {
            this.lossAction = value;
        }

        public String getResumptionAction() {
            return this.resumptionAction;
        }

        public void setResumptionAction(String value) {
            this.resumptionAction = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class RequiredRole {
            @XmlAttribute(name="name", required=true)
            protected String name;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class SubscriptionAttributes
    implements Serializable {
        @XmlAttribute(name="interest-policy")
        protected String interestPolicy;

        public String getInterestPolicy() {
            return this.interestPolicy;
        }

        public void setInterestPolicy(String value) {
            this.interestPolicy = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"lruEntryCount", "lruHeapPercentage", "lruMemorySize"})
    public static class EvictionAttributes
    implements Serializable {
        @XmlElement(name="lru-entry-count", namespace="http://geode.apache.org/schema/cache")
        protected LruEntryCount lruEntryCount;
        @XmlElement(name="lru-heap-percentage", namespace="http://geode.apache.org/schema/cache")
        protected LruHeapPercentage lruHeapPercentage;
        @XmlElement(name="lru-memory-size", namespace="http://geode.apache.org/schema/cache")
        protected LruMemorySize lruMemorySize;

        public static EvictionAttributes generate(String evictionAction, Integer maxMemory, Integer maxEntryCount, ClassName objectSizer) {
            if (evictionAction == null && maxMemory == null && maxEntryCount == null && objectSizer == null) {
                return null;
            }
            EvictionAttributes evictionAttributes = new EvictionAttributes();
            EnumActionDestroyOverflow action = EnumActionDestroyOverflow.fromValue(evictionAction);
            if (maxMemory == null && maxEntryCount == null) {
                LruHeapPercentage heapPercentage = new LruHeapPercentage();
                heapPercentage.setAction(action);
                if (objectSizer != null) {
                    heapPercentage.setClassName(objectSizer.getClassName());
                    heapPercentage.setParameters(objectSizer.getInitProperties());
                }
                evictionAttributes.setLruHeapPercentage(heapPercentage);
            } else if (maxMemory != null) {
                LruMemorySize memorySize = new LruMemorySize();
                memorySize.setAction(action);
                if (objectSizer != null) {
                    memorySize.setClassName(objectSizer.getClassName());
                    memorySize.setParameters(objectSizer.getInitProperties());
                }
                memorySize.setMaximum(maxMemory.toString());
                evictionAttributes.setLruMemorySize(memorySize);
            } else {
                LruEntryCount entryCount = new LruEntryCount();
                entryCount.setAction(action);
                entryCount.setMaximum(maxEntryCount.toString());
                evictionAttributes.setLruEntryCount(entryCount);
            }
            return evictionAttributes;
        }

        public static EvictionAttributes generate(String evictionAction, Integer maxMemory, Integer maxEntryCount, String objectSizer) {
            if (objectSizer == null) {
                return EvictionAttributes.generate(evictionAction, maxMemory, maxEntryCount, (ClassName)null);
            }
            return EvictionAttributes.generate(evictionAction, maxMemory, maxEntryCount, new ClassName(objectSizer));
        }

        public LruEntryCount getLruEntryCount() {
            return this.lruEntryCount;
        }

        public void setLruEntryCount(LruEntryCount value) {
            this.lruEntryCount = value;
        }

        public LruHeapPercentage getLruHeapPercentage() {
            return this.lruHeapPercentage;
        }

        public void setLruHeapPercentage(LruHeapPercentage value) {
            this.lruHeapPercentage = value;
        }

        public LruMemorySize getLruMemorySize() {
            return this.lruMemorySize;
        }

        public void setLruMemorySize(LruMemorySize value) {
            this.lruMemorySize = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class LruHeapPercentage
        extends DeclarableType {
            @XmlAttribute(name="action")
            protected EnumActionDestroyOverflow action;

            public EnumActionDestroyOverflow getAction() {
                return this.action;
            }

            public void setAction(EnumActionDestroyOverflow value) {
                this.action = value;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class LruMemorySize
        extends LruHeapPercentage {
            @XmlAttribute(name="maximum")
            protected String maximum;

            public String getMaximum() {
                return this.maximum;
            }

            public void setMaximum(String value) {
                this.maximum = value;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class LruEntryCount
        implements Serializable {
            @XmlAttribute(name="action")
            protected EnumActionDestroyOverflow action;
            @XmlAttribute(name="maximum")
            protected String maximum;

            public EnumActionDestroyOverflow getAction() {
                return this.action;
            }

            public void setAction(EnumActionDestroyOverflow value) {
                this.action = value;
            }

            public String getMaximum() {
                return this.maximum;
            }

            public void setMaximum(String value) {
                this.maximum = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="expiration-attributes-type", namespace="http://geode.apache.org/schema/cache", propOrder={"customExpiry"})
    @Experimental
    public static class ExpirationAttributesDetail
    implements Serializable {
        @XmlElement(name="custom-expiry", namespace="http://geode.apache.org/schema/cache")
        protected DeclarableType customExpiry;
        @XmlAttribute(name="action")
        protected String action;
        @XmlAttribute(name="timeout", required=true)
        protected String timeout;
        @Immutable
        private static final List<String> ALLOWED_ACTIONS = Collections.unmodifiableList(Arrays.asList("invalidate", "destroy", "local-invalidate", "local-destroy"));

        public DeclarableType getCustomExpiry() {
            return this.customExpiry;
        }

        public void setCustomExpiry(DeclarableType value) {
            this.customExpiry = value;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String value) {
            if (!ALLOWED_ACTIONS.contains(value)) {
                throw new IllegalArgumentException("invalid expiration action: " + value);
            }
            this.action = value;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String value) {
            this.timeout = value;
        }
    }
}

