/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.client.internal.locator.SerializationHelper;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ClientConnectionRequest
extends ServerLocationRequest {
    private Set<ServerLocation> excludedServers;

    public ClientConnectionRequest() {
    }

    public ClientConnectionRequest(Set<ServerLocation> excludedServers, String serverGroup) {
        super(serverGroup);
        this.excludedServers = excludedServers;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.excludedServers = SerializationHelper.readServerLocationSet(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        SerializationHelper.writeServerLocationSet(this.excludedServers, out);
    }

    public Set getExcludedServers() {
        return this.excludedServers;
    }

    public String toString() {
        return "ClientConnectionRequest{group=" + this.getServerGroup() + ", excluded=" + String.valueOf(this.getExcludedServers()) + "}";
    }

    public int getDSFID() {
        return -53;
    }
}

