/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ServerDenyList {
    private static final Logger logger = LogService.getLogger();
    private final Map<ServerLocation, FailureTracker> failureTrackerMap = new HashMap<ServerLocation, FailureTracker>();
    private final Set<ServerLocation> denylist = new CopyOnWriteArraySet<ServerLocation>();
    private final Set<ServerLocation> unmodifiableDenylist = Collections.unmodifiableSet(this.denylist);
    protected ScheduledExecutorService background;
    private final ListenerBroadcaster broadcaster = new ListenerBroadcaster();
    private static final int THRESHOLD = Integer.getInteger("gemfire.ServerDenyList.THRESHOLD", 3);
    protected final long pingInterval;

    public ServerDenyList(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void start(ScheduledExecutorService background) {
        this.background = background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FailureTracker getFailureTracker(ServerLocation location) {
        FailureTracker failureTracker;
        Map<ServerLocation, FailureTracker> map = this.failureTrackerMap;
        synchronized (map) {
            failureTracker = this.failureTrackerMap.get(location);
            if (failureTracker == null) {
                failureTracker = new FailureTracker(location);
                this.failureTrackerMap.put(location, failureTracker);
            }
        }
        return failureTracker;
    }

    public Set<ServerLocation> getBadServers() {
        return this.unmodifiableDenylist;
    }

    public void addListener(DenyListListener denyListListener) {
        this.broadcaster.listeners.add(denyListListener);
    }

    public void removeListener(DenyListListener denyListListener) {
        this.broadcaster.listeners.remove(denyListListener);
    }

    protected static class ListenerBroadcaster
    implements DenyListListener {
        protected Set<DenyListListener> listeners = new CopyOnWriteArraySet<DenyListListener>();

        protected ListenerBroadcaster() {
        }

        @Override
        public void serverAdded(ServerLocation location) {
            for (DenyListListener listener : this.listeners) {
                listener.serverAdded(location);
            }
        }

        @Override
        public void serverRemoved(ServerLocation location) {
            for (DenyListListener listener : this.listeners) {
                listener.serverRemoved(location);
            }
        }
    }

    public class FailureTracker {
        private final AtomicInteger consecutiveFailures = new AtomicInteger();
        private final ServerLocation location;

        FailureTracker(ServerLocation location) {
            this.location = location;
        }

        public void reset() {
            this.consecutiveFailures.set(0);
        }

        public void addFailure() {
            if (ServerDenyList.this.denylist.contains(this.location)) {
                return;
            }
            long failures = this.consecutiveFailures.incrementAndGet();
            if (failures >= (long)THRESHOLD) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Denylisting server {} for {}ms because it had {} consecutive failures", (Object)this.location, (Object)ServerDenyList.this.pingInterval, (Object)failures);
                }
                ServerDenyList.this.denylist.add(this.location);
                ServerDenyList.this.broadcaster.serverAdded(this.location);
                try {
                    ServerDenyList.this.background.schedule(new ExpireDenyListTask(this.location), ServerDenyList.this.pingInterval, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    public static class DenyListListenerAdapter
    implements DenyListListener {
        @Override
        public void serverAdded(ServerLocation location) {
        }

        @Override
        public void serverRemoved(ServerLocation location) {
        }
    }

    public static interface DenyListListener {
        public void serverAdded(ServerLocation var1);

        public void serverRemoved(ServerLocation var1);
    }

    private class ExpireDenyListTask
    extends PoolImpl.PoolTask {
        private final ServerLocation location;

        ExpireDenyListTask(ServerLocation location) {
            this.location = location;
        }

        @Override
        public void run2() {
            if (logger.isDebugEnabled()) {
                logger.debug("{} is no longer denylisted", (Object)this.location);
            }
            ServerDenyList.this.denylist.remove(this.location);
            ServerDenyList.this.broadcaster.serverRemoved(this.location);
        }
    }
}

